/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.FormattedDate;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mo.logs.MOLogsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetReceivedSmsLogs {
    private final Configuration configuration;

    public GetReceivedSmsLogs(Configuration configuration) {
        this.configuration = configuration;
    }

    public MOLogsResponse execute(String to, FormattedDate receivedSince, FormattedDate receivedUntil, Integer limit, String keyword) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetReceivedSmsLogsService service = (GetReceivedSmsLogsService)restAdapter.create(GetReceivedSmsLogsService.class);
        return service.execute(to, receivedSince, receivedUntil, limit, keyword);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetReceivedSmsLogs.this.configuration != null && GetReceivedSmsLogs.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetReceivedSmsLogs.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetReceivedSmsLogsService {
        @GET(value="/sms/1/inbox/logs")
        public MOLogsResponse execute(@Query(value="to") String var1, @Query(value="receivedSince") FormattedDate var2, @Query(value="receivedUntil") FormattedDate var3, @Query(value="limit") Integer var4, @Query(value="keyword") String var5);
    }
}

