/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.conversion.EndTagResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.POST;
import retrofit.http.Path;

public class LogEndTag {
    private final Configuration configuration;

    public LogEndTag(Configuration configuration) {
        this.configuration = configuration;
    }

    public EndTagResponse execute(String messageId) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        LogEndTagService service = (LogEndTagService)restAdapter.create(LogEndTagService.class);
        return service.execute(messageId);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (LogEndTag.this.configuration != null && LogEndTag.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", LogEndTag.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface LogEndTagService {
        @POST(value="/ct/1/log/end/{messageId}")
        public EndTagResponse execute(@Path(value="messageId") String var1);
    }
}

