/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.campaign.Campaign;
import infobip.api.model.omni.campaign.Destinations;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.PUT;
import retrofit.http.Path;

public class AddDestination {
    private final Configuration configuration;

    public AddDestination(Configuration configuration) {
        this.configuration = configuration;
    }

    public Campaign execute(String campaignKey, Destinations bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        AddDestinationService service = (AddDestinationService)restAdapter.create(AddDestinationService.class);
        return service.execute(campaignKey, bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (AddDestination.this.configuration != null && AddDestination.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", AddDestination.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface AddDestinationService {
        @PUT(value="/omni/2/campaigns/{campaignKey}/destinations")
        public Campaign execute(@Path(value="campaignKey") String var1, @Body Destinations var2);
    }
}

