/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mt.bulks.BulkResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetBulks {
    private final Configuration configuration;

    public GetBulks(Configuration configuration) {
        this.configuration = configuration;
    }

    public BulkResponse execute(String bulkId) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetBulksService service = (GetBulksService)restAdapter.create(GetBulksService.class);
        return service.execute(bulkId);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetBulks.this.configuration != null && GetBulks.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetBulks.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetBulksService {
        @GET(value="/sms/1/bulks")
        public BulkResponse execute(@Query(value="bulkId") String var1);
    }
}

