/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.scenarios.ScenariosResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetScenarios {
    private final Configuration configuration;

    public GetScenarios(Configuration configuration) {
        this.configuration = configuration;
    }

    public ScenariosResponse execute(Boolean isDefault, Integer limit, Integer page) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetScenariosService service = (GetScenariosService)restAdapter.create(GetScenariosService.class);
        return service.execute(isDefault, limit, page);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetScenarios.this.configuration != null && GetScenarios.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetScenarios.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetScenariosService {
        @GET(value="/omni/1/scenarios")
        public ScenariosResponse execute(@Query(value="isDefault") Boolean var1, @Query(value="limit") Integer var2, @Query(value="page") Integer var3);
    }
}

