/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.scenarios.Scenario;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Path;

public class GetSpecificScenario {
    private final Configuration configuration;

    public GetSpecificScenario(Configuration configuration) {
        this.configuration = configuration;
    }

    public Scenario execute(String scenarioKey) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetSpecificScenarioService service = (GetSpecificScenarioService)restAdapter.create(GetSpecificScenarioService.class);
        return service.execute(scenarioKey);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetSpecificScenario.this.configuration != null && GetSpecificScenario.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetSpecificScenario.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetSpecificScenarioService {
        @GET(value="/omni/1/scenarios/{scenarioKey}")
        public Scenario execute(@Path(value="scenarioKey") String var1);
    }
}

