/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.nc.query.NumberContextRequest;
import infobip.api.model.nc.query.NumberContextResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.POST;

public class NumberContextQuery {
    private final Configuration configuration;

    public NumberContextQuery(Configuration configuration) {
        this.configuration = configuration;
    }

    public NumberContextResponse execute(NumberContextRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        NumberContextQueryService service = (NumberContextQueryService)restAdapter.create(NumberContextQueryService.class);
        return service.execute(bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (NumberContextQuery.this.configuration != null && NumberContextQuery.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", NumberContextQuery.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface NumberContextQueryService {
        @POST(value="/number/1/query")
        public NumberContextResponse execute(@Body NumberContextRequest var1);
    }
}

