/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mt.send.preview.PreviewRequest;
import infobip.api.model.sms.mt.send.preview.PreviewResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.POST;

public class PreviewSms {
    private final Configuration configuration;

    public PreviewSms(Configuration configuration) {
        this.configuration = configuration;
    }

    public PreviewResponse execute(PreviewRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        PreviewSmsService service = (PreviewSmsService)restAdapter.create(PreviewSmsService.class);
        return service.execute(bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (PreviewSms.this.configuration != null && PreviewSms.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", PreviewSms.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface PreviewSmsService {
        @POST(value="/sms/1/preview")
        public PreviewResponse execute(@Body PreviewRequest var1);
    }
}

