/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.send.OmniAdvancedRequest;
import infobip.api.model.omni.send.OmniResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.POST;

public class SendAdvancedOmniMessage {
    private final Configuration configuration;

    public SendAdvancedOmniMessage(Configuration configuration) {
        this.configuration = configuration;
    }

    public OmniResponse execute(OmniAdvancedRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        SendAdvancedOmniMessageService service = (SendAdvancedOmniMessageService)restAdapter.create(SendAdvancedOmniMessageService.class);
        return service.execute(bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (SendAdvancedOmniMessage.this.configuration != null && SendAdvancedOmniMessage.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", SendAdvancedOmniMessage.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface SendAdvancedOmniMessageService {
        @POST(value="/omni/1/advanced")
        public OmniResponse execute(@Body OmniAdvancedRequest var1);
    }
}

