/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.send.OmniResponse;
import infobip.api.model.omni.send.OmniSimpleRequest;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.POST;

public class SendSimpleOmniMessage {
    private final Configuration configuration;

    public SendSimpleOmniMessage(Configuration configuration) {
        this.configuration = configuration;
    }

    public OmniResponse execute(OmniSimpleRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        SendSimpleOmniMessageService service = (SendSimpleOmniMessageService)restAdapter.create(SendSimpleOmniMessageService.class);
        return service.execute(bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (SendSimpleOmniMessage.this.configuration != null && SendSimpleOmniMessage.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", SendSimpleOmniMessage.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface SendSimpleOmniMessageService {
        @POST(value="/omni/1/text")
        public OmniResponse execute(@Body OmniSimpleRequest var1);
    }
}

