/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mt.bulks.status.BulkStatusResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetBulkStatus {
    private final Configuration configuration;

    public GetBulkStatus(Configuration configuration) {
        this.configuration = configuration;
    }

    public BulkStatusResponse execute(String bulkId) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetBulkStatusService service = (GetBulkStatusService)restAdapter.create(GetBulkStatusService.class);
        return service.execute(bulkId);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetBulkStatus.this.configuration != null && GetBulkStatus.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetBulkStatus.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetBulkStatusService {
        @GET(value="/sms/1/bulks/status")
        public BulkStatusResponse execute(@Query(value="bulkId") String var1);
    }
}

