/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.campaign.CampaignsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetCampaigns {
    private final Configuration configuration;

    public GetCampaigns(Configuration configuration) {
        this.configuration = configuration;
    }

    public CampaignsResponse execute(Integer limit, Integer page) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetCampaignsService service = (GetCampaignsService)restAdapter.create(GetCampaignsService.class);
        return service.execute(limit, page);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetCampaigns.this.configuration != null && GetCampaigns.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetCampaigns.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetCampaignsService {
        @GET(value="/omni/1/campaigns")
        public CampaignsResponse execute(@Query(value="limit") Integer var1, @Query(value="page") Integer var2);
    }
}

