/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.reports.OMNIReportsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetOMNIReports {
    private final Configuration configuration;

    public GetOMNIReports(Configuration configuration) {
        this.configuration = configuration;
    }

    public OMNIReportsResponse execute(String bulkId, String messageId, Integer limit, String channel) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetOMNIReportsService service = (GetOMNIReportsService)restAdapter.create(GetOMNIReportsService.class);
        return service.execute(bulkId, messageId, limit, channel);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetOMNIReports.this.configuration != null && GetOMNIReports.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetOMNIReports.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetOMNIReportsService {
        @GET(value="/omni/1/reports")
        public OMNIReportsResponse execute(@Query(value="bulkId") String var1, @Query(value="messageId") String var2, @Query(value="limit") Integer var3, @Query(value="channel") String var4);
    }
}

