/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.FormattedDate;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.OmniChannel;
import infobip.api.model.omni.logs.OmniLogsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetOmniLogs {
    private final Configuration configuration;

    public GetOmniLogs(Configuration configuration) {
        this.configuration = configuration;
    }

    public OmniLogsResponse execute(String from, String to, String[] bulkId, String[] messageId, String generalStatus, OmniChannel channel, FormattedDate sentSince, FormattedDate sentUntil, Integer limit, String mcc, String mnc) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetOmniLogsService service = (GetOmniLogsService)restAdapter.create(GetOmniLogsService.class);
        return service.execute(from, to, bulkId, messageId, generalStatus, channel, sentSince, sentUntil, limit, mcc, mnc);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetOmniLogs.this.configuration != null && GetOmniLogs.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetOmniLogs.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetOmniLogsService {
        @GET(value="/omni/1/logs")
        public OmniLogsResponse execute(@Query(value="from") String var1, @Query(value="to") String var2, @Query(value="bulkId") String[] var3, @Query(value="messageId") String[] var4, @Query(value="generalStatus") String var5, @Query(value="channel") OmniChannel var6, @Query(value="sentSince") FormattedDate var7, @Query(value="sentUntil") FormattedDate var8, @Query(value="limit") Integer var9, @Query(value="mcc") String var10, @Query(value="mnc") String var11);
    }
}

