/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mo.reports.MOReportResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetReceivedMessages {
    private final Configuration configuration;

    public GetReceivedMessages(Configuration configuration) {
        this.configuration = configuration;
    }

    public MOReportResponse execute(Integer limit) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetReceivedMessagesService service = (GetReceivedMessagesService)restAdapter.create(GetReceivedMessagesService.class);
        return service.execute(limit);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetReceivedMessages.this.configuration != null && GetReceivedMessages.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetReceivedMessages.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetReceivedMessagesService {
        @GET(value="/sms/1/inbox/reports")
        public MOReportResponse execute(@Query(value="limit") Integer var1);
    }
}

