/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mt.bulks.status.BulkStatusResponse;
import infobip.api.model.sms.mt.bulks.status.UpdateStatusRequest;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.PUT;
import retrofit.http.Query;

public class ManageBulkStatus {
    private final Configuration configuration;

    public ManageBulkStatus(Configuration configuration) {
        this.configuration = configuration;
    }

    public BulkStatusResponse execute(String bulkId, UpdateStatusRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        ManageBulkStatusService service = (ManageBulkStatusService)restAdapter.create(ManageBulkStatusService.class);
        return service.execute(bulkId, bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (ManageBulkStatus.this.configuration != null && ManageBulkStatus.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", ManageBulkStatus.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface ManageBulkStatusService {
        @PUT(value="/sms/1/bulks/status")
        public BulkStatusResponse execute(@Query(value="bulkId") String var1, @Body UpdateStatusRequest var2);
    }
}

