/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.sms.mt.bulks.BulkRequest;
import infobip.api.model.sms.mt.bulks.BulkResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.PUT;
import retrofit.http.Query;

public class RescheduleBulk {
    private final Configuration configuration;

    public RescheduleBulk(Configuration configuration) {
        this.configuration = configuration;
    }

    public BulkResponse execute(String bulkId, BulkRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        RescheduleBulkService service = (RescheduleBulkService)restAdapter.create(RescheduleBulkService.class);
        return service.execute(bulkId, bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (RescheduleBulk.this.configuration != null && RescheduleBulk.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", RescheduleBulk.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface RescheduleBulkService {
        @PUT(value="/sms/1/bulks")
        public BulkResponse execute(@Query(value="bulkId") String var1, @Body BulkRequest var2);
    }
}

