/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.omni.scenarios.Scenario;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.PUT;
import retrofit.http.Path;

public class UpdateScenario {
    private final Configuration configuration;

    public UpdateScenario(Configuration configuration) {
        this.configuration = configuration;
    }

    public Scenario execute(String scenarioKey, Scenario bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        UpdateScenarioService service = (UpdateScenarioService)restAdapter.create(UpdateScenarioService.class);
        return service.execute(scenarioKey, bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (UpdateScenario.this.configuration != null && UpdateScenario.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", UpdateScenario.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface UpdateScenarioService {
        @PUT(value="/omni/1/scenarios/{scenarioKey}")
        public Scenario execute(@Path(value="scenarioKey") String var1, @Body Scenario var2);
    }
}

