/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.TfaApplicationRequest;
import com.infobip.model.TfaApplicationResponse;
import com.infobip.model.TfaCreateMessageRequest;
import com.infobip.model.TfaMessage;
import com.infobip.model.TfaResendPinRequest;
import com.infobip.model.TfaStartAuthenticationRequest;
import com.infobip.model.TfaStartAuthenticationResponse;
import com.infobip.model.TfaUpdateMessageRequest;
import com.infobip.model.TfaVerificationResponse;
import com.infobip.model.TfaVerifyPinRequest;
import com.infobip.model.TfaVerifyPinResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class TfaApi {
    private ApiClient localVarApiClient;

    public TfaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TfaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTfaApplicationCall(TfaApplicationRequest tfaApplicationRequest, ApiCallback _callback) throws ApiException {
        TfaApplicationRequest localVarPostBody = tfaApplicationRequest;
        String localVarPath = "/2fa/2/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTfaApplicationValidateBeforeCall(TfaApplicationRequest tfaApplicationRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createTfaApplicationCall(tfaApplicationRequest, _callback);
        return localVarCall;
    }

    public TfaApplicationResponse createTfaApplication(TfaApplicationRequest tfaApplicationRequest) throws ApiException {
        ApiResponse<TfaApplicationResponse> localVarResp = this.createTfaApplicationWithHttpInfo(tfaApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaApplicationResponse> createTfaApplicationWithHttpInfo(TfaApplicationRequest tfaApplicationRequest) throws ApiException {
        Call localVarCall = this.createTfaApplicationValidateBeforeCall(tfaApplicationRequest, null);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTfaApplicationAsync(TfaApplicationRequest tfaApplicationRequest, ApiCallback<TfaApplicationResponse> _callback) throws ApiException {
        Call localVarCall = this.createTfaApplicationValidateBeforeCall(tfaApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createTfaMessageTemplateCall(String appId, TfaCreateMessageRequest tfaCreateMessageRequest, ApiCallback _callback) throws ApiException {
        TfaCreateMessageRequest localVarPostBody = tfaCreateMessageRequest;
        String localVarPath = "/2fa/2/applications/{appId}/messages".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTfaMessageTemplateValidateBeforeCall(String appId, TfaCreateMessageRequest tfaCreateMessageRequest, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createTfaMessageTemplate(Async)");
        }
        Call localVarCall = this.createTfaMessageTemplateCall(appId, tfaCreateMessageRequest, _callback);
        return localVarCall;
    }

    public TfaMessage createTfaMessageTemplate(String appId, TfaCreateMessageRequest tfaCreateMessageRequest) throws ApiException {
        ApiResponse<TfaMessage> localVarResp = this.createTfaMessageTemplateWithHttpInfo(appId, tfaCreateMessageRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaMessage> createTfaMessageTemplateWithHttpInfo(String appId, TfaCreateMessageRequest tfaCreateMessageRequest) throws ApiException {
        Call localVarCall = this.createTfaMessageTemplateValidateBeforeCall(appId, tfaCreateMessageRequest, null);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTfaMessageTemplateAsync(String appId, TfaCreateMessageRequest tfaCreateMessageRequest, ApiCallback<TfaMessage> _callback) throws ApiException {
        Call localVarCall = this.createTfaMessageTemplateValidateBeforeCall(appId, tfaCreateMessageRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTfaApplicationCall(String appId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2fa/2/applications/{appId}".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTfaApplicationValidateBeforeCall(String appId, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTfaApplication(Async)");
        }
        Call localVarCall = this.getTfaApplicationCall(appId, _callback);
        return localVarCall;
    }

    public TfaApplicationResponse getTfaApplication(String appId) throws ApiException {
        ApiResponse<TfaApplicationResponse> localVarResp = this.getTfaApplicationWithHttpInfo(appId);
        return localVarResp.getData();
    }

    public ApiResponse<TfaApplicationResponse> getTfaApplicationWithHttpInfo(String appId) throws ApiException {
        Call localVarCall = this.getTfaApplicationValidateBeforeCall(appId, null);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTfaApplicationAsync(String appId, ApiCallback<TfaApplicationResponse> _callback) throws ApiException {
        Call localVarCall = this.getTfaApplicationValidateBeforeCall(appId, _callback);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTfaApplicationsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2fa/2/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTfaApplicationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTfaApplicationsCall(_callback);
        return localVarCall;
    }

    public List<TfaApplicationResponse> getTfaApplications() throws ApiException {
        ApiResponse<List<TfaApplicationResponse>> localVarResp = this.getTfaApplicationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<TfaApplicationResponse>> getTfaApplicationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getTfaApplicationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<TfaApplicationResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTfaApplicationsAsync(ApiCallback<List<TfaApplicationResponse>> _callback) throws ApiException {
        Call localVarCall = this.getTfaApplicationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<TfaApplicationResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTfaMessageTemplateCall(String appId, String msgId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2fa/2/applications/{appId}/messages/{msgId}".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString())).replaceAll("\\{msgId\\}", this.localVarApiClient.escapeString(msgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTfaMessageTemplateValidateBeforeCall(String appId, String msgId, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTfaMessageTemplate(Async)");
        }
        if (msgId == null) {
            throw new ApiException("Missing the required parameter 'msgId' when calling getTfaMessageTemplate(Async)");
        }
        Call localVarCall = this.getTfaMessageTemplateCall(appId, msgId, _callback);
        return localVarCall;
    }

    public TfaMessage getTfaMessageTemplate(String appId, String msgId) throws ApiException {
        ApiResponse<TfaMessage> localVarResp = this.getTfaMessageTemplateWithHttpInfo(appId, msgId);
        return localVarResp.getData();
    }

    public ApiResponse<TfaMessage> getTfaMessageTemplateWithHttpInfo(String appId, String msgId) throws ApiException {
        Call localVarCall = this.getTfaMessageTemplateValidateBeforeCall(appId, msgId, null);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTfaMessageTemplateAsync(String appId, String msgId, ApiCallback<TfaMessage> _callback) throws ApiException {
        Call localVarCall = this.getTfaMessageTemplateValidateBeforeCall(appId, msgId, _callback);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTfaMessageTemplatesCall(String appId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2fa/2/applications/{appId}/messages".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTfaMessageTemplatesValidateBeforeCall(String appId, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTfaMessageTemplates(Async)");
        }
        Call localVarCall = this.getTfaMessageTemplatesCall(appId, _callback);
        return localVarCall;
    }

    public List<TfaMessage> getTfaMessageTemplates(String appId) throws ApiException {
        ApiResponse<List<TfaMessage>> localVarResp = this.getTfaMessageTemplatesWithHttpInfo(appId);
        return localVarResp.getData();
    }

    public ApiResponse<List<TfaMessage>> getTfaMessageTemplatesWithHttpInfo(String appId) throws ApiException {
        Call localVarCall = this.getTfaMessageTemplatesValidateBeforeCall(appId, null);
        Type localVarReturnType = new TypeToken<List<TfaMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTfaMessageTemplatesAsync(String appId, ApiCallback<List<TfaMessage>> _callback) throws ApiException {
        Call localVarCall = this.getTfaMessageTemplatesValidateBeforeCall(appId, _callback);
        Type localVarReturnType = new TypeToken<List<TfaMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTfaVerificationStatusCall(String msisdn, String appId, Boolean verified, Boolean sent, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2fa/2/applications/{appId}/verifications".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (msisdn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("msisdn", msisdn));
        }
        if (verified != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("verified", verified));
        }
        if (sent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sent", sent));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTfaVerificationStatusValidateBeforeCall(String msisdn, String appId, Boolean verified, Boolean sent, ApiCallback _callback) throws ApiException {
        if (msisdn == null) {
            throw new ApiException("Missing the required parameter 'msisdn' when calling getTfaVerificationStatus(Async)");
        }
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTfaVerificationStatus(Async)");
        }
        Call localVarCall = this.getTfaVerificationStatusCall(msisdn, appId, verified, sent, _callback);
        return localVarCall;
    }

    public TfaVerificationResponse getTfaVerificationStatus(String msisdn, String appId, Boolean verified, Boolean sent) throws ApiException {
        ApiResponse<TfaVerificationResponse> localVarResp = this.getTfaVerificationStatusWithHttpInfo(msisdn, appId, verified, sent);
        return localVarResp.getData();
    }

    public ApiResponse<TfaVerificationResponse> getTfaVerificationStatusWithHttpInfo(String msisdn, String appId, Boolean verified, Boolean sent) throws ApiException {
        Call localVarCall = this.getTfaVerificationStatusValidateBeforeCall(msisdn, appId, verified, sent, null);
        Type localVarReturnType = new TypeToken<TfaVerificationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTfaVerificationStatusAsync(String msisdn, String appId, Boolean verified, Boolean sent, ApiCallback<TfaVerificationResponse> _callback) throws ApiException {
        Call localVarCall = this.getTfaVerificationStatusValidateBeforeCall(msisdn, appId, verified, sent, _callback);
        Type localVarReturnType = new TypeToken<TfaVerificationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resendTfaPinCodeOverSmsCall(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback _callback) throws ApiException {
        TfaResendPinRequest localVarPostBody = tfaResendPinRequest;
        String localVarPath = "/2fa/2/pin/{pinId}/resend".replaceAll("\\{pinId\\}", this.localVarApiClient.escapeString(pinId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resendTfaPinCodeOverSmsValidateBeforeCall(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback _callback) throws ApiException {
        if (pinId == null) {
            throw new ApiException("Missing the required parameter 'pinId' when calling resendTfaPinCodeOverSms(Async)");
        }
        Call localVarCall = this.resendTfaPinCodeOverSmsCall(pinId, tfaResendPinRequest, _callback);
        return localVarCall;
    }

    public TfaStartAuthenticationResponse resendTfaPinCodeOverSms(String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
        ApiResponse<TfaStartAuthenticationResponse> localVarResp = this.resendTfaPinCodeOverSmsWithHttpInfo(pinId, tfaResendPinRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaStartAuthenticationResponse> resendTfaPinCodeOverSmsWithHttpInfo(String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
        Call localVarCall = this.resendTfaPinCodeOverSmsValidateBeforeCall(pinId, tfaResendPinRequest, null);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resendTfaPinCodeOverSmsAsync(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback<TfaStartAuthenticationResponse> _callback) throws ApiException {
        Call localVarCall = this.resendTfaPinCodeOverSmsValidateBeforeCall(pinId, tfaResendPinRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resendTfaPinCodeOverVoiceCall(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback _callback) throws ApiException {
        TfaResendPinRequest localVarPostBody = tfaResendPinRequest;
        String localVarPath = "/2fa/2/pin/{pinId}/resend/voice".replaceAll("\\{pinId\\}", this.localVarApiClient.escapeString(pinId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resendTfaPinCodeOverVoiceValidateBeforeCall(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback _callback) throws ApiException {
        if (pinId == null) {
            throw new ApiException("Missing the required parameter 'pinId' when calling resendTfaPinCodeOverVoice(Async)");
        }
        Call localVarCall = this.resendTfaPinCodeOverVoiceCall(pinId, tfaResendPinRequest, _callback);
        return localVarCall;
    }

    public TfaStartAuthenticationResponse resendTfaPinCodeOverVoice(String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
        ApiResponse<TfaStartAuthenticationResponse> localVarResp = this.resendTfaPinCodeOverVoiceWithHttpInfo(pinId, tfaResendPinRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaStartAuthenticationResponse> resendTfaPinCodeOverVoiceWithHttpInfo(String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
        Call localVarCall = this.resendTfaPinCodeOverVoiceValidateBeforeCall(pinId, tfaResendPinRequest, null);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resendTfaPinCodeOverVoiceAsync(String pinId, TfaResendPinRequest tfaResendPinRequest, ApiCallback<TfaStartAuthenticationResponse> _callback) throws ApiException {
        Call localVarCall = this.resendTfaPinCodeOverVoiceValidateBeforeCall(pinId, tfaResendPinRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendTfaPinCodeOverSmsCall(Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback _callback) throws ApiException {
        TfaStartAuthenticationRequest localVarPostBody = tfaStartAuthenticationRequest;
        String localVarPath = "/2fa/2/pin";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ncNeeded != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ncNeeded", ncNeeded));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendTfaPinCodeOverSmsValidateBeforeCall(Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverSmsCall(ncNeeded, tfaStartAuthenticationRequest, _callback);
        return localVarCall;
    }

    public TfaStartAuthenticationResponse sendTfaPinCodeOverSms(Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
        ApiResponse<TfaStartAuthenticationResponse> localVarResp = this.sendTfaPinCodeOverSmsWithHttpInfo(ncNeeded, tfaStartAuthenticationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaStartAuthenticationResponse> sendTfaPinCodeOverSmsWithHttpInfo(Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverSmsValidateBeforeCall(ncNeeded, tfaStartAuthenticationRequest, null);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendTfaPinCodeOverSmsAsync(Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback<TfaStartAuthenticationResponse> _callback) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverSmsValidateBeforeCall(ncNeeded, tfaStartAuthenticationRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendTfaPinCodeOverVoiceCall(TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback _callback) throws ApiException {
        TfaStartAuthenticationRequest localVarPostBody = tfaStartAuthenticationRequest;
        String localVarPath = "/2fa/2/pin/voice";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendTfaPinCodeOverVoiceValidateBeforeCall(TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverVoiceCall(tfaStartAuthenticationRequest, _callback);
        return localVarCall;
    }

    public TfaStartAuthenticationResponse sendTfaPinCodeOverVoice(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
        ApiResponse<TfaStartAuthenticationResponse> localVarResp = this.sendTfaPinCodeOverVoiceWithHttpInfo(tfaStartAuthenticationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaStartAuthenticationResponse> sendTfaPinCodeOverVoiceWithHttpInfo(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverVoiceValidateBeforeCall(tfaStartAuthenticationRequest, null);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendTfaPinCodeOverVoiceAsync(TfaStartAuthenticationRequest tfaStartAuthenticationRequest, ApiCallback<TfaStartAuthenticationResponse> _callback) throws ApiException {
        Call localVarCall = this.sendTfaPinCodeOverVoiceValidateBeforeCall(tfaStartAuthenticationRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTfaApplicationCall(String appId, TfaApplicationRequest tfaApplicationRequest, ApiCallback _callback) throws ApiException {
        TfaApplicationRequest localVarPostBody = tfaApplicationRequest;
        String localVarPath = "/2fa/2/applications/{appId}".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTfaApplicationValidateBeforeCall(String appId, TfaApplicationRequest tfaApplicationRequest, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateTfaApplication(Async)");
        }
        Call localVarCall = this.updateTfaApplicationCall(appId, tfaApplicationRequest, _callback);
        return localVarCall;
    }

    public TfaApplicationResponse updateTfaApplication(String appId, TfaApplicationRequest tfaApplicationRequest) throws ApiException {
        ApiResponse<TfaApplicationResponse> localVarResp = this.updateTfaApplicationWithHttpInfo(appId, tfaApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaApplicationResponse> updateTfaApplicationWithHttpInfo(String appId, TfaApplicationRequest tfaApplicationRequest) throws ApiException {
        Call localVarCall = this.updateTfaApplicationValidateBeforeCall(appId, tfaApplicationRequest, null);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTfaApplicationAsync(String appId, TfaApplicationRequest tfaApplicationRequest, ApiCallback<TfaApplicationResponse> _callback) throws ApiException {
        Call localVarCall = this.updateTfaApplicationValidateBeforeCall(appId, tfaApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaApplicationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTfaMessageTemplateCall(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest, ApiCallback _callback) throws ApiException {
        TfaUpdateMessageRequest localVarPostBody = tfaUpdateMessageRequest;
        String localVarPath = "/2fa/2/applications/{appId}/messages/{msgId}".replaceAll("\\{appId\\}", this.localVarApiClient.escapeString(appId.toString())).replaceAll("\\{msgId\\}", this.localVarApiClient.escapeString(msgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTfaMessageTemplateValidateBeforeCall(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest, ApiCallback _callback) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateTfaMessageTemplate(Async)");
        }
        if (msgId == null) {
            throw new ApiException("Missing the required parameter 'msgId' when calling updateTfaMessageTemplate(Async)");
        }
        Call localVarCall = this.updateTfaMessageTemplateCall(appId, msgId, tfaUpdateMessageRequest, _callback);
        return localVarCall;
    }

    public TfaMessage updateTfaMessageTemplate(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest) throws ApiException {
        ApiResponse<TfaMessage> localVarResp = this.updateTfaMessageTemplateWithHttpInfo(appId, msgId, tfaUpdateMessageRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaMessage> updateTfaMessageTemplateWithHttpInfo(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest) throws ApiException {
        Call localVarCall = this.updateTfaMessageTemplateValidateBeforeCall(appId, msgId, tfaUpdateMessageRequest, null);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTfaMessageTemplateAsync(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest, ApiCallback<TfaMessage> _callback) throws ApiException {
        Call localVarCall = this.updateTfaMessageTemplateValidateBeforeCall(appId, msgId, tfaUpdateMessageRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call verifyTfaPhoneNumberCall(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest, ApiCallback _callback) throws ApiException {
        TfaVerifyPinRequest localVarPostBody = tfaVerifyPinRequest;
        String localVarPath = "/2fa/2/pin/{pinId}/verify".replaceAll("\\{pinId\\}", this.localVarApiClient.escapeString(pinId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call verifyTfaPhoneNumberValidateBeforeCall(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest, ApiCallback _callback) throws ApiException {
        if (pinId == null) {
            throw new ApiException("Missing the required parameter 'pinId' when calling verifyTfaPhoneNumber(Async)");
        }
        Call localVarCall = this.verifyTfaPhoneNumberCall(pinId, tfaVerifyPinRequest, _callback);
        return localVarCall;
    }

    public TfaVerifyPinResponse verifyTfaPhoneNumber(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) throws ApiException {
        ApiResponse<TfaVerifyPinResponse> localVarResp = this.verifyTfaPhoneNumberWithHttpInfo(pinId, tfaVerifyPinRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TfaVerifyPinResponse> verifyTfaPhoneNumberWithHttpInfo(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) throws ApiException {
        Call localVarCall = this.verifyTfaPhoneNumberValidateBeforeCall(pinId, tfaVerifyPinRequest, null);
        Type localVarReturnType = new TypeToken<TfaVerifyPinResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call verifyTfaPhoneNumberAsync(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest, ApiCallback<TfaVerifyPinResponse> _callback) throws ApiException {
        Call localVarCall = this.verifyTfaPhoneNumberValidateBeforeCall(pinId, tfaVerifyPinRequest, _callback);
        Type localVarReturnType = new TypeToken<TfaVerifyPinResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

