/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.ApiCallback;
import com.infobip.ApiException;
import com.infobip.ApiKey;
import com.infobip.BaseUrl;
import com.infobip.DeprecationChecker;
import com.infobip.Downloader;
import com.infobip.JSON;
import com.infobip.RequestDefinition;
import com.infobip.RequestFactory;
import com.infobip.ResponseProcessor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class ApiClient {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 60;
    private static final int DEFAULT_WRITE_TIMEOUT_IN_SECONDS = 60;
    private final OkHttpClient httpClient;
    private final JSON json;
    private final RequestFactory requestFactory;
    private final ResponseProcessor responseProcessor;

    private ApiClient(Builder builder) {
        boolean isTimeoutConfigured;
        this.json = builder.json;
        this.requestFactory = new RequestFactory(builder.apiKey, builder.baseUrl, this.json);
        DeprecationChecker deprecationChecker = new DeprecationChecker(Clock.systemUTC());
        this.responseProcessor = new ResponseProcessor(builder.downloader, this.json, deprecationChecker);
        boolean bl = isTimeoutConfigured = builder.connectTimeoutInSeconds > 0 || builder.readTimeoutInSeconds > 0 || builder.writeTimeoutInSeconds > 0;
        if (builder.httpClient == null) {
            int connectTimeout = builder.connectTimeoutInSeconds > 0 ? builder.connectTimeoutInSeconds : 10;
            int readTimeout = builder.readTimeoutInSeconds > 0 ? builder.readTimeoutInSeconds : 60;
            int writeTimeout = builder.writeTimeoutInSeconds > 0 ? builder.writeTimeoutInSeconds : 60;
            this.httpClient = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).build();
        } else if (isTimeoutConfigured) {
            OkHttpClient.Builder providedHttpClientBuilder = builder.httpClient.newBuilder();
            if (builder.connectTimeoutInSeconds > 0) {
                providedHttpClientBuilder.connectTimeout((long)builder.connectTimeoutInSeconds, TimeUnit.SECONDS);
            }
            if (builder.readTimeoutInSeconds > 0) {
                providedHttpClientBuilder.readTimeout((long)builder.readTimeoutInSeconds, TimeUnit.SECONDS);
            }
            if (builder.writeTimeoutInSeconds > 0) {
                providedHttpClientBuilder.writeTimeout((long)builder.writeTimeoutInSeconds, TimeUnit.SECONDS);
            }
            this.httpClient = providedHttpClientBuilder.build();
        } else {
            this.httpClient = builder.httpClient;
        }
    }

    public static Builder forApiKey(ApiKey apiKey) {
        return new Builder(apiKey);
    }

    public ApiKey apiKey() {
        return this.requestFactory.apiKey();
    }

    public BaseUrl baseUrl() {
        return this.requestFactory.baseUrl();
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public int connectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    public int readTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    public int writeTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    public Path tempDirectoryPath() {
        return this.responseProcessor.downloader().tempDirectoryPath();
    }

    public JSON json() {
        return this.json;
    }

    public void execute(RequestDefinition definition) throws ApiException {
        this.execute(definition, null);
    }

    public <T> T execute(RequestDefinition definition, Type returnType) throws ApiException {
        Response response;
        Call call = this.buildCall(definition);
        try {
            response = call.execute();
        }
        catch (IOException exception) {
            throw ApiException.becauseCallExecutionFailed(call.request().method(), call.request().url().encodedPath(), exception);
        }
        return this.responseProcessor.processResponse(response, returnType);
    }

    public Call executeAsync(RequestDefinition definition, ApiCallback<Void> callback) {
        return this.executeAsync(definition, null, callback);
    }

    public <T> Call executeAsync(RequestDefinition definition, final Type returnType, final ApiCallback<T> callback) {
        Objects.requireNonNull(callback, "Provided callback must not be null.");
        Call call = this.buildCall(definition);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                ApiException apiException = ApiException.becauseCallExecutionFailed(call.request().method(), call.request().url().encodedPath(), e);
                callback.onFailure(apiException, 0, null);
            }

            public void onResponse(Call call, Response response) {
                Object result;
                int responseStatusCode = response.code();
                Map responseHeaders = response.headers().toMultimap();
                try {
                    result = ApiClient.this.responseProcessor.processResponse(response, returnType);
                }
                catch (ApiException apiException) {
                    callback.onFailure(apiException, responseStatusCode, responseHeaders);
                    return;
                }
                catch (Exception exception) {
                    ApiException apiException = ApiException.wrapErrorDuringResponseProcessing(ApiException.RequestContext.tryToReadFrom(response), exception);
                    callback.onFailure(apiException, responseStatusCode, responseHeaders);
                    return;
                }
                callback.onSuccess(result, responseStatusCode, responseHeaders);
            }
        });
        return call;
    }

    private Call buildCall(RequestDefinition requestDefinition) {
        return this.httpClient.newCall(this.requestFactory.create(requestDefinition));
    }

    public static class Builder {
        private final ApiKey apiKey;
        private BaseUrl baseUrl = BaseUrl.api();
        private int connectTimeoutInSeconds = 0;
        private int readTimeoutInSeconds = 0;
        private int writeTimeoutInSeconds = 0;
        private Downloader downloader = new Downloader();
        private JSON json = new JSON();
        private OkHttpClient httpClient;

        private Builder(ApiKey apiKey) {
            this.apiKey = Objects.requireNonNull(apiKey, "Provided API key must not be null.");
        }

        public Builder withBaseUrl(BaseUrl baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "Provided base url must not be null.");
            return this;
        }

        public Builder withConnectTimeout(int seconds) {
            if (seconds < 1) {
                throw new IllegalArgumentException("Connect timeout must be greater than 0.");
            }
            this.connectTimeoutInSeconds = seconds;
            return this;
        }

        public Builder withReadTimeout(int seconds) {
            if (seconds < 1) {
                throw new IllegalArgumentException("Read timeout must be greater than 0.");
            }
            this.readTimeoutInSeconds = seconds;
            return this;
        }

        public Builder withWriteTimeout(int seconds) {
            if (seconds < 1) {
                throw new IllegalArgumentException("Write timeout must be greater than 0.");
            }
            this.writeTimeoutInSeconds = seconds;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "Provided HTTP client must not be null.");
            return this;
        }

        public Builder withTempDirectoryPath(Path tempDirectoryPath) {
            this.downloader = new Downloader(tempDirectoryPath);
            return this;
        }

        public Builder withJSON(JSON json) {
            this.json = Objects.requireNonNull(json, "Provided JSON must not be null.");
            return this;
        }

        public ApiClient build() {
            return new ApiClient(this);
        }
    }
}

