/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.ApiExceptionDetails;
import java.util.Objects;
import okhttp3.Response;

public final class ApiException
extends Exception {
    private static final String SUPPORT_EMAIL = "support@infobip.com";
    private static final String OFFICIAL_MESSAGE = "If you are having trouble interpreting the error, contact support@infobip.com or open an issue on our Github repo.Include all details you find relevant. Thank you for using our library!";
    private final int responseStatusCode;
    private final String rawResponseBody;
    private final ApiExceptionDetails details;

    private ApiException(Builder builder) {
        super(builder.message, builder.cause);
        this.responseStatusCode = builder.responseStatusCode;
        this.rawResponseBody = builder.rawResponseBody;
        this.details = builder.details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int responseStatusCode() {
        return this.responseStatusCode;
    }

    public String rawResponseBody() {
        return this.rawResponseBody;
    }

    public ApiExceptionDetails details() {
        return this.details;
    }

    static ApiException becauseApiRequestFailed(RequestContext context, String rawResponseBody, ApiExceptionDetails details) {
        int responseStatusCode = context.getResponseStatusCode();
        String message = String.format("Infobip API returned %d when calling %s %s. Check the response body for details. If you are having trouble interpreting the response, contact %s. Include all details you find relevant. Thank you for using our library!", responseStatusCode, context.getMethod(), context.getEncodedPath(), SUPPORT_EMAIL);
        return ApiException.builder().withMessage(message).withResponseStatusCode(responseStatusCode).withRawResponseBody(rawResponseBody).withDetails(details).build();
    }

    static ApiException becauseOfUnsuccessfulResponseBodyReading(RequestContext context, Throwable cause) {
        int responseStatusCode = context.getResponseStatusCode();
        String message = String.format("There was an error when reading the response body. Infobip API responded with status code %d upon calling %s %s. This can happen due to a response timeout, networking issues or an invalid deserialization definition. Check the exception's root cause for more details. %s", responseStatusCode, context.getMethod(), context.getEncodedPath(), OFFICIAL_MESSAGE);
        return ApiException.builder().withMessage(message).withCause(cause).withResponseStatusCode(responseStatusCode).build();
    }

    static ApiException becauseCallExecutionFailed(String method, String encodedPath, Throwable cause) {
        String message = String.format("There was an error when executing the API call %s %s. This can happen due to a response timeout, networking issues or something similar. Check the exception's root cause for more details. %s", method, encodedPath, OFFICIAL_MESSAGE);
        return ApiException.builder().withMessage(message).withCause(cause).build();
    }

    static ApiException wrapErrorDuringResponseProcessing(RequestContext context, Throwable cause) {
        int responseStatusCode = context.getResponseStatusCode();
        String message = String.format("There was an unexpected error during the response processing. Infobip API responded with status code %d when calling %s %s. Check the exception's root cause for more details. %s", responseStatusCode, context.getMethod(), context.getEncodedPath(), OFFICIAL_MESSAGE);
        return ApiException.builder().withMessage(message).withCause(cause).withResponseStatusCode(responseStatusCode).build();
    }

    static class RequestContext {
        private static final RequestContext EMPTY = new RequestContext(null, null, 0);
        private final String method;
        private final String encodedPath;
        private final int responseStatusCode;

        private RequestContext(String method, String encodedPath, int responseStatusCode) {
            this.method = method;
            this.encodedPath = encodedPath;
            this.responseStatusCode = responseStatusCode;
        }

        static RequestContext tryToReadFrom(Response response) {
            if (response == null) {
                return EMPTY;
            }
            return new RequestContext(response.request().method(), response.request().url().encodedPath(), response.code());
        }

        String getMethod() {
            return this.method;
        }

        String getEncodedPath() {
            return this.encodedPath;
        }

        int getResponseStatusCode() {
            return this.responseStatusCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestContext that = (RequestContext)o;
            return this.responseStatusCode == that.responseStatusCode && Objects.equals(this.method, that.method) && Objects.equals(this.encodedPath, that.encodedPath);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.encodedPath, this.responseStatusCode);
        }

        public String toString() {
            return "RequestContext{method='" + this.method + "', encodedPath='" + this.encodedPath + "', responseStatusCode=" + this.responseStatusCode + "}";
        }
    }

    public static final class Builder {
        private String message;
        private Throwable cause;
        private int responseStatusCode;
        private String rawResponseBody;
        private ApiExceptionDetails details;

        private Builder() {
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder withResponseStatusCode(int responseStatusCode) {
            this.responseStatusCode = responseStatusCode;
            return this;
        }

        public Builder withRawResponseBody(String rawResponseBody) {
            this.rawResponseBody = rawResponseBody;
            return this;
        }

        public Builder withDetails(ApiExceptionDetails details) {
            this.details = details;
            return this;
        }

        public ApiException build() {
            return new ApiException(this);
        }
    }
}

