/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeprecationChecker {
    private static final ZoneOffset HEADER_TIMEZONE = ZoneOffset.UTC;
    private static final ZoneOffset OUTPUT_TIMEZONE = ZoneOffset.UTC;
    private static final DateTimeFormatter HEADER_DATE_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(HEADER_TIMEZONE);
    private static final String DEPRECATION_HEADER = "Deprecation";
    private static final String SUNSET_HEADER = "Sunset";
    private final Clock clock;

    public DeprecationChecker(Clock clock) {
        this.clock = clock;
    }

    void notice(Response response) {
        Objects.requireNonNull(response);
        String sunsetHeader = response.header(SUNSET_HEADER);
        String deprecationHeader = response.header(DEPRECATION_HEADER);
        if (sunsetHeader == null && deprecationHeader == null) {
            return;
        }
        DeprecationNoticeLogger noticeLogger = DeprecationNoticeLogger.forRequest(response.request());
        TemporalAccessor sunsetDate = DeprecationChecker.tryToParseDateFromHeader(sunsetHeader);
        if (sunsetDate != null) {
            OffsetDateTime now = OffsetDateTime.now(this.clock);
            if (OffsetDateTime.from(sunsetDate).isBefore(now)) {
                noticeLogger.gone(sunsetDate);
                return;
            }
            noticeLogger.deprecated(sunsetDate);
            return;
        }
        if (deprecationHeader != null) {
            noticeLogger.deprecated();
        }
    }

    private static TemporalAccessor tryToParseDateFromHeader(String headerThatShouldRepresentDate) {
        if (headerThatShouldRepresentDate == null) {
            return null;
        }
        try {
            return HEADER_DATE_FORMATTER.parse(headerThatShouldRepresentDate);
        }
        catch (DateTimeException ignored) {
            return null;
        }
    }

    private static final class DeprecationNoticeLogger {
        private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationNoticeLogger.class);
        private static final DateTimeFormatter SUNSET_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE.withZone(OUTPUT_TIMEZONE);
        private static final String SUPPORT_EMAIL = "support@infobip.com";
        private final String deprecatedEndpointMethod;
        private final String deprecatedMethodPath;

        private DeprecationNoticeLogger(String deprecatedEndpointMethod, String deprecatedMethodPath) {
            this.deprecatedEndpointMethod = deprecatedEndpointMethod;
            this.deprecatedMethodPath = deprecatedMethodPath;
        }

        private static DeprecationNoticeLogger forRequest(Request request) {
            Objects.requireNonNull(request);
            return new DeprecationNoticeLogger(request.method(), request.url().encodedPath());
        }

        void gone(TemporalAccessor sunsetDate) {
            LOGGER.warn("As of {} UTC, the endpoint {} {} has been discontinued. To continue using our services, please update the library or contact {}.", new Object[]{SUNSET_DATE_FORMATTER.format(sunsetDate), this.deprecatedEndpointMethod, this.deprecatedMethodPath, SUPPORT_EMAIL});
        }

        void deprecated(TemporalAccessor sunsetDate) {
            LOGGER.warn("As of {} UTC, the endpoint {} {} will no longer be available. To avoid disruption, kindly update the library or reach out to {}.", new Object[]{SUNSET_DATE_FORMATTER.format(sunsetDate), this.deprecatedEndpointMethod, this.deprecatedMethodPath, SUPPORT_EMAIL});
        }

        void deprecated() {
            LOGGER.info("The endpoint {} {} is deprecated. Please consider updating the library or reaching out to {} for assistance.", new Object[]{this.deprecatedEndpointMethod, this.deprecatedMethodPath, SUPPORT_EMAIL});
        }
    }
}

