/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class Downloader {
    private static final String DEFAULT_FILE_PREFIX = "infobip-download-";
    private static final Pattern CONTENT_DISPOSITION_FILENAME_PATTERN = Pattern.compile("filename=\"([A-Za-z0-9._-]+)\"");
    private final File tempDirectory;

    Downloader() {
        this.tempDirectory = null;
    }

    Downloader(Path tempDirectoryPath) {
        Objects.requireNonNull(tempDirectoryPath, "Provided temp directory path must not be null.");
        File tempDirectory = tempDirectoryPath.toFile();
        if (!tempDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided temp directory is not an existing directory.");
        }
        if (!tempDirectory.canWrite()) {
            throw new IllegalArgumentException("Provided temp directory is not writable.");
        }
        this.tempDirectory = tempDirectory;
    }

    File downloadFile(Response response) throws IOException {
        Objects.requireNonNull(response);
        try (Response response2 = response;){
            File file = this.prepareDownloadFile(response);
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
                     BufferedSource source = responseBody.source();){
                    sink.writeAll((Source)source);
                }
            }
            File file2 = file;
            return file2;
        }
    }

    Path tempDirectoryPath() {
        return Optional.ofNullable(this.tempDirectory).map(File::toPath).or(() -> Optional.ofNullable(System.getProperty("java.io.tmpdir")).map(x$0 -> Path.of(x$0, new String[0]))).orElseThrow(() -> new RuntimeException("Temp directory path cannot be resolved."));
    }

    private File prepareDownloadFile(Response response) throws IOException {
        String filename = Optional.ofNullable(response.header("Content-Disposition")).filter(contentDisposition -> !contentDisposition.isEmpty()).map(CONTENT_DISPOSITION_FILENAME_PATTERN::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).orElse(null);
        Object prefix = DEFAULT_FILE_PREFIX;
        String suffix = "";
        if (filename != null) {
            int extensionStartPosition = filename.lastIndexOf(".");
            if (extensionStartPosition == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, extensionStartPosition);
                suffix = filename.substring(extensionStartPosition);
            }
        }
        if (this.tempDirectory == null) {
            return Files.createTempFile((String)prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(this.tempDirectory.toPath(), (String)prefix, suffix, new FileAttribute[0]).toFile();
    }
}

