/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.JSONException;

public class InternalException
extends RuntimeException {
    private static final String OFFICIAL_MESSAGE = "An internal error occurred. Contact support@infobip.com or open an issue on our Github repo. Include a minimal reproducible example. Thank you for using our library!";

    private InternalException(String message, Throwable cause) {
        super(String.format("%s Error message: %s.", OFFICIAL_MESSAGE, message), cause);
    }

    private InternalException(String message) {
        this(message, null);
    }

    public static InternalException becauseRequestBodySerializationFailed(JSONException cause) {
        return new InternalException("Request body can't be properly serialized.", cause);
    }

    public static InternalException becauseRequestBodyCanNotBeProcessed() {
        return new InternalException("Request body can't be processed. The issue might be in the content type definition.");
    }

    public static InternalException becauseBodyWasDefinedForMethodThatDoesNotPermitIt() {
        return new InternalException("Request body was defined for a method that doesn't permit it.");
    }
}

