/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.WebRtcCallLink;
import com.infobip.model.WebRtcCallLinkConfig;
import com.infobip.model.WebRtcCallLinkConfigPage;
import com.infobip.model.WebRtcCallLinkConfigRequest;
import com.infobip.model.WebRtcCallLinkPage;
import com.infobip.model.WebRtcCallLinkRequest;
import com.infobip.model.WebRtcCallLinkResponse;
import com.infobip.model.WebRtcImagePage;
import com.infobip.model.WebRtcImageResponse;
import com.infobip.model.WebRtcImageType;
import com.infobip.model.WebRtcSubdomain;
import com.infobip.model.WebRtcSubdomainRequest;
import com.infobip.model.WebRtcSubdomainResponse;
import java.io.File;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class CallLinkApi {
    private final ApiClient apiClient;

    public CallLinkApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition createCallLinkDefinition(WebRtcCallLinkRequest webRtcCallLinkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/call-link/1/links").body(webRtcCallLinkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateCallLinkRequest createCallLink(WebRtcCallLinkRequest webRtcCallLinkRequest) {
        return new CreateCallLinkRequest(webRtcCallLinkRequest);
    }

    private RequestDefinition createConfigDefinition(WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/call-link/1/configs").body(webRtcCallLinkConfigRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateConfigRequest createConfig(WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        return new CreateConfigRequest(webRtcCallLinkConfigRequest);
    }

    private RequestDefinition createSubdomainDefinition(WebRtcSubdomainRequest webRtcSubdomainRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/call-link/1/subdomains").body(webRtcSubdomainRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateSubdomainRequest createSubdomain(WebRtcSubdomainRequest webRtcSubdomainRequest) {
        return new CreateSubdomainRequest(webRtcSubdomainRequest);
    }

    private RequestDefinition deleteCallLinkDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/call-link/1/links/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteCallLinkRequest deleteCallLink(String id) {
        return new DeleteCallLinkRequest(id);
    }

    private RequestDefinition deleteConfigDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/call-link/1/configs/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteConfigRequest deleteConfig(String id) {
        return new DeleteConfigRequest(id);
    }

    private RequestDefinition deleteImageDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/call-link/1/images/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteImageRequest deleteImage(String id) {
        return new DeleteImageRequest(id);
    }

    private RequestDefinition deleteSubdomainDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/call-link/1/subdomains/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteSubdomainRequest deleteSubdomain(String id) {
        return new DeleteSubdomainRequest(id);
    }

    private RequestDefinition getCallLinkDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/links/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetCallLinkRequest getCallLink(String id) {
        return new GetCallLinkRequest(id);
    }

    private RequestDefinition getCallLinksDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/links").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallLinksRequest getCallLinks() {
        return new GetCallLinksRequest();
    }

    private RequestDefinition getConfigDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/configs/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetConfigRequest getConfig(String id) {
        return new GetConfigRequest(id);
    }

    private RequestDefinition getConfigsDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/configs").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetConfigsRequest getConfigs() {
        return new GetConfigsRequest();
    }

    private RequestDefinition getImageDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/images/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetImageRequest getImage(String id) {
        return new GetImageRequest(id);
    }

    private RequestDefinition getImagesDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/images").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetImagesRequest getImages() {
        return new GetImagesRequest();
    }

    private RequestDefinition getSubdomainsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/call-link/1/subdomains").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetSubdomainsRequest getSubdomains() {
        return new GetSubdomainsRequest();
    }

    private RequestDefinition patchConfigDefinition(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PATCH", "/call-link/1/configs/{id}").body(webRtcCallLinkConfigRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public PatchConfigRequest patchConfig(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        return new PatchConfigRequest(id, webRtcCallLinkConfigRequest);
    }

    private RequestDefinition updateConfigDefinition(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/call-link/1/configs/{id}").body(webRtcCallLinkConfigRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public UpdateConfigRequest updateConfig(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
        return new UpdateConfigRequest(id, webRtcCallLinkConfigRequest);
    }

    private RequestDefinition uploadImageDefinition(WebRtcImageType type, File _file) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/call-link/1/images/upload/{type}").requiresAuthentication(true).accept("application/json").contentType("multipart/form-data");
        if (type != null) {
            builder.addPathParameter(new Parameter("type", (Object)type));
        }
        if (_file != null) {
            builder.addFormParameter(new Parameter("file", _file));
        }
        return builder.build();
    }

    public UploadImageRequest uploadImage(WebRtcImageType type, File _file) {
        return new UploadImageRequest(type, _file);
    }

    public class UploadImageRequest {
        private final WebRtcImageType type;
        private final File _file;

        private UploadImageRequest(WebRtcImageType type, File _file) {
            this.type = Objects.requireNonNull(type, "The required parameter 'type' is missing.");
            this._file = Objects.requireNonNull(_file, "The required parameter '_file' is missing.");
        }

        public WebRtcImageResponse execute() throws ApiException {
            RequestDefinition uploadImageDefinition = CallLinkApi.this.uploadImageDefinition(this.type, this._file);
            return (WebRtcImageResponse)CallLinkApi.this.apiClient.execute(uploadImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcImageResponse> callback) {
            RequestDefinition uploadImageDefinition = CallLinkApi.this.uploadImageDefinition(this.type, this._file);
            return CallLinkApi.this.apiClient.executeAsync(uploadImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType(), callback);
        }
    }

    public class UpdateConfigRequest {
        private final String id;
        private final WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest;

        private UpdateConfigRequest(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.webRtcCallLinkConfigRequest = Objects.requireNonNull(webRtcCallLinkConfigRequest, "The required parameter 'webRtcCallLinkConfigRequest' is missing.");
        }

        public WebRtcCallLinkConfig execute() throws ApiException {
            RequestDefinition updateConfigDefinition = CallLinkApi.this.updateConfigDefinition(this.id, this.webRtcCallLinkConfigRequest);
            return (WebRtcCallLinkConfig)CallLinkApi.this.apiClient.execute(updateConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfig> callback) {
            RequestDefinition updateConfigDefinition = CallLinkApi.this.updateConfigDefinition(this.id, this.webRtcCallLinkConfigRequest);
            return CallLinkApi.this.apiClient.executeAsync(updateConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType(), callback);
        }
    }

    public class PatchConfigRequest {
        private final String id;
        private final WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest;

        private PatchConfigRequest(String id, WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.webRtcCallLinkConfigRequest = Objects.requireNonNull(webRtcCallLinkConfigRequest, "The required parameter 'webRtcCallLinkConfigRequest' is missing.");
        }

        public WebRtcCallLinkConfig execute() throws ApiException {
            RequestDefinition patchConfigDefinition = CallLinkApi.this.patchConfigDefinition(this.id, this.webRtcCallLinkConfigRequest);
            return (WebRtcCallLinkConfig)CallLinkApi.this.apiClient.execute(patchConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfig> callback) {
            RequestDefinition patchConfigDefinition = CallLinkApi.this.patchConfigDefinition(this.id, this.webRtcCallLinkConfigRequest);
            return CallLinkApi.this.apiClient.executeAsync(patchConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType(), callback);
        }
    }

    public class GetSubdomainsRequest {
        private GetSubdomainsRequest() {
        }

        public List<WebRtcSubdomainResponse> execute() throws ApiException {
            RequestDefinition getSubdomainsDefinition = CallLinkApi.this.getSubdomainsDefinition();
            return (List)CallLinkApi.this.apiClient.execute(getSubdomainsDefinition, new TypeReference<List<WebRtcSubdomainResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<WebRtcSubdomainResponse>> callback) {
            RequestDefinition getSubdomainsDefinition = CallLinkApi.this.getSubdomainsDefinition();
            return CallLinkApi.this.apiClient.executeAsync(getSubdomainsDefinition, new TypeReference<List<WebRtcSubdomainResponse>>(){}.getType(), callback);
        }
    }

    public class GetImagesRequest {
        private Integer page;
        private Integer size;

        private GetImagesRequest() {
        }

        public GetImagesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetImagesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public WebRtcImagePage execute() throws ApiException {
            RequestDefinition getImagesDefinition = CallLinkApi.this.getImagesDefinition(this.page, this.size);
            return (WebRtcImagePage)CallLinkApi.this.apiClient.execute(getImagesDefinition, new TypeReference<WebRtcImagePage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcImagePage> callback) {
            RequestDefinition getImagesDefinition = CallLinkApi.this.getImagesDefinition(this.page, this.size);
            return CallLinkApi.this.apiClient.executeAsync(getImagesDefinition, new TypeReference<WebRtcImagePage>(){}.getType(), callback);
        }
    }

    public class GetImageRequest {
        private final String id;

        private GetImageRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcImageResponse execute() throws ApiException {
            RequestDefinition getImageDefinition = CallLinkApi.this.getImageDefinition(this.id);
            return (WebRtcImageResponse)CallLinkApi.this.apiClient.execute(getImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcImageResponse> callback) {
            RequestDefinition getImageDefinition = CallLinkApi.this.getImageDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(getImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType(), callback);
        }
    }

    public class GetConfigsRequest {
        private Integer page;
        private Integer size;

        private GetConfigsRequest() {
        }

        public GetConfigsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetConfigsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public WebRtcCallLinkConfigPage execute() throws ApiException {
            RequestDefinition getConfigsDefinition = CallLinkApi.this.getConfigsDefinition(this.page, this.size);
            return (WebRtcCallLinkConfigPage)CallLinkApi.this.apiClient.execute(getConfigsDefinition, new TypeReference<WebRtcCallLinkConfigPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfigPage> callback) {
            RequestDefinition getConfigsDefinition = CallLinkApi.this.getConfigsDefinition(this.page, this.size);
            return CallLinkApi.this.apiClient.executeAsync(getConfigsDefinition, new TypeReference<WebRtcCallLinkConfigPage>(){}.getType(), callback);
        }
    }

    public class GetConfigRequest {
        private final String id;

        private GetConfigRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcCallLinkConfig execute() throws ApiException {
            RequestDefinition getConfigDefinition = CallLinkApi.this.getConfigDefinition(this.id);
            return (WebRtcCallLinkConfig)CallLinkApi.this.apiClient.execute(getConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfig> callback) {
            RequestDefinition getConfigDefinition = CallLinkApi.this.getConfigDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(getConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType(), callback);
        }
    }

    public class GetCallLinksRequest {
        private Integer page;
        private Integer size;

        private GetCallLinksRequest() {
        }

        public GetCallLinksRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallLinksRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public WebRtcCallLinkPage execute() throws ApiException {
            RequestDefinition getCallLinksDefinition = CallLinkApi.this.getCallLinksDefinition(this.page, this.size);
            return (WebRtcCallLinkPage)CallLinkApi.this.apiClient.execute(getCallLinksDefinition, new TypeReference<WebRtcCallLinkPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkPage> callback) {
            RequestDefinition getCallLinksDefinition = CallLinkApi.this.getCallLinksDefinition(this.page, this.size);
            return CallLinkApi.this.apiClient.executeAsync(getCallLinksDefinition, new TypeReference<WebRtcCallLinkPage>(){}.getType(), callback);
        }
    }

    public class GetCallLinkRequest {
        private final String id;

        private GetCallLinkRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcCallLink execute() throws ApiException {
            RequestDefinition getCallLinkDefinition = CallLinkApi.this.getCallLinkDefinition(this.id);
            return (WebRtcCallLink)CallLinkApi.this.apiClient.execute(getCallLinkDefinition, new TypeReference<WebRtcCallLink>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLink> callback) {
            RequestDefinition getCallLinkDefinition = CallLinkApi.this.getCallLinkDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(getCallLinkDefinition, new TypeReference<WebRtcCallLink>(){}.getType(), callback);
        }
    }

    public class DeleteSubdomainRequest {
        private final String id;

        private DeleteSubdomainRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcSubdomain execute() throws ApiException {
            RequestDefinition deleteSubdomainDefinition = CallLinkApi.this.deleteSubdomainDefinition(this.id);
            return (WebRtcSubdomain)CallLinkApi.this.apiClient.execute(deleteSubdomainDefinition, new TypeReference<WebRtcSubdomain>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcSubdomain> callback) {
            RequestDefinition deleteSubdomainDefinition = CallLinkApi.this.deleteSubdomainDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(deleteSubdomainDefinition, new TypeReference<WebRtcSubdomain>(){}.getType(), callback);
        }
    }

    public class DeleteImageRequest {
        private final String id;

        private DeleteImageRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcImageResponse execute() throws ApiException {
            RequestDefinition deleteImageDefinition = CallLinkApi.this.deleteImageDefinition(this.id);
            return (WebRtcImageResponse)CallLinkApi.this.apiClient.execute(deleteImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcImageResponse> callback) {
            RequestDefinition deleteImageDefinition = CallLinkApi.this.deleteImageDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(deleteImageDefinition, new TypeReference<WebRtcImageResponse>(){}.getType(), callback);
        }
    }

    public class DeleteConfigRequest {
        private final String id;

        private DeleteConfigRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcCallLinkConfig execute() throws ApiException {
            RequestDefinition deleteConfigDefinition = CallLinkApi.this.deleteConfigDefinition(this.id);
            return (WebRtcCallLinkConfig)CallLinkApi.this.apiClient.execute(deleteConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfig> callback) {
            RequestDefinition deleteConfigDefinition = CallLinkApi.this.deleteConfigDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(deleteConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType(), callback);
        }
    }

    public class DeleteCallLinkRequest {
        private final String id;

        private DeleteCallLinkRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcCallLink execute() throws ApiException {
            RequestDefinition deleteCallLinkDefinition = CallLinkApi.this.deleteCallLinkDefinition(this.id);
            return (WebRtcCallLink)CallLinkApi.this.apiClient.execute(deleteCallLinkDefinition, new TypeReference<WebRtcCallLink>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLink> callback) {
            RequestDefinition deleteCallLinkDefinition = CallLinkApi.this.deleteCallLinkDefinition(this.id);
            return CallLinkApi.this.apiClient.executeAsync(deleteCallLinkDefinition, new TypeReference<WebRtcCallLink>(){}.getType(), callback);
        }
    }

    public class CreateSubdomainRequest {
        private final WebRtcSubdomainRequest webRtcSubdomainRequest;

        private CreateSubdomainRequest(WebRtcSubdomainRequest webRtcSubdomainRequest) {
            this.webRtcSubdomainRequest = Objects.requireNonNull(webRtcSubdomainRequest, "The required parameter 'webRtcSubdomainRequest' is missing.");
        }

        public WebRtcSubdomain execute() throws ApiException {
            RequestDefinition createSubdomainDefinition = CallLinkApi.this.createSubdomainDefinition(this.webRtcSubdomainRequest);
            return (WebRtcSubdomain)CallLinkApi.this.apiClient.execute(createSubdomainDefinition, new TypeReference<WebRtcSubdomain>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcSubdomain> callback) {
            RequestDefinition createSubdomainDefinition = CallLinkApi.this.createSubdomainDefinition(this.webRtcSubdomainRequest);
            return CallLinkApi.this.apiClient.executeAsync(createSubdomainDefinition, new TypeReference<WebRtcSubdomain>(){}.getType(), callback);
        }
    }

    public class CreateConfigRequest {
        private final WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest;

        private CreateConfigRequest(WebRtcCallLinkConfigRequest webRtcCallLinkConfigRequest) {
            this.webRtcCallLinkConfigRequest = Objects.requireNonNull(webRtcCallLinkConfigRequest, "The required parameter 'webRtcCallLinkConfigRequest' is missing.");
        }

        public WebRtcCallLinkConfig execute() throws ApiException {
            RequestDefinition createConfigDefinition = CallLinkApi.this.createConfigDefinition(this.webRtcCallLinkConfigRequest);
            return (WebRtcCallLinkConfig)CallLinkApi.this.apiClient.execute(createConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkConfig> callback) {
            RequestDefinition createConfigDefinition = CallLinkApi.this.createConfigDefinition(this.webRtcCallLinkConfigRequest);
            return CallLinkApi.this.apiClient.executeAsync(createConfigDefinition, new TypeReference<WebRtcCallLinkConfig>(){}.getType(), callback);
        }
    }

    public class CreateCallLinkRequest {
        private final WebRtcCallLinkRequest webRtcCallLinkRequest;

        private CreateCallLinkRequest(WebRtcCallLinkRequest webRtcCallLinkRequest) {
            this.webRtcCallLinkRequest = Objects.requireNonNull(webRtcCallLinkRequest, "The required parameter 'webRtcCallLinkRequest' is missing.");
        }

        public WebRtcCallLinkResponse execute() throws ApiException {
            RequestDefinition createCallLinkDefinition = CallLinkApi.this.createCallLinkDefinition(this.webRtcCallLinkRequest);
            return (WebRtcCallLinkResponse)CallLinkApi.this.apiClient.execute(createCallLinkDefinition, new TypeReference<WebRtcCallLinkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcCallLinkResponse> callback) {
            RequestDefinition createCallLinkDefinition = CallLinkApi.this.createCallLinkDefinition(this.webRtcCallLinkRequest);
            return CallLinkApi.this.apiClient.executeAsync(createCallLinkDefinition, new TypeReference<WebRtcCallLinkResponse>(){}.getType(), callback);
        }
    }
}

