/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.CallRoutingRouteRequest;
import com.infobip.model.CallRoutingRouteResponse;
import com.infobip.model.CallRoutingRouteResponsePage;
import java.util.Objects;
import okhttp3.Call;

public class CallRoutingApi {
    private final ApiClient apiClient;

    public CallRoutingApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition createCallRouteDefinition(CallRoutingRouteRequest callRoutingRouteRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/callrouting/1/routes").body(callRoutingRouteRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateCallRouteRequest createCallRoute(CallRoutingRouteRequest callRoutingRouteRequest) {
        return new CreateCallRouteRequest(callRoutingRouteRequest);
    }

    private RequestDefinition deleteCallRouteDefinition(String routeId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/callrouting/1/routes/{routeId}").requiresAuthentication(true).accept("application/json");
        if (routeId != null) {
            builder.addPathParameter(new Parameter("routeId", routeId));
        }
        return builder.build();
    }

    public DeleteCallRouteRequest deleteCallRoute(String routeId) {
        return new DeleteCallRouteRequest(routeId);
    }

    private RequestDefinition getCallRouteDefinition(String routeId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/callrouting/1/routes/{routeId}").requiresAuthentication(true).accept("application/json");
        if (routeId != null) {
            builder.addPathParameter(new Parameter("routeId", routeId));
        }
        return builder.build();
    }

    public GetCallRouteRequest getCallRoute(String routeId) {
        return new GetCallRouteRequest(routeId);
    }

    private RequestDefinition getCallRoutesDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/callrouting/1/routes").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallRoutesRequest getCallRoutes() {
        return new GetCallRoutesRequest();
    }

    private RequestDefinition updateCallRouteDefinition(String routeId, CallRoutingRouteRequest callRoutingRouteRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/callrouting/1/routes/{routeId}").body(callRoutingRouteRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (routeId != null) {
            builder.addPathParameter(new Parameter("routeId", routeId));
        }
        return builder.build();
    }

    public UpdateCallRouteRequest updateCallRoute(String routeId, CallRoutingRouteRequest callRoutingRouteRequest) {
        return new UpdateCallRouteRequest(routeId, callRoutingRouteRequest);
    }

    public class UpdateCallRouteRequest {
        private final String routeId;
        private final CallRoutingRouteRequest callRoutingRouteRequest;

        private UpdateCallRouteRequest(String routeId, CallRoutingRouteRequest callRoutingRouteRequest) {
            this.routeId = Objects.requireNonNull(routeId, "The required parameter 'routeId' is missing.");
            this.callRoutingRouteRequest = Objects.requireNonNull(callRoutingRouteRequest, "The required parameter 'callRoutingRouteRequest' is missing.");
        }

        public CallRoutingRouteResponse execute() throws ApiException {
            RequestDefinition updateCallRouteDefinition = CallRoutingApi.this.updateCallRouteDefinition(this.routeId, this.callRoutingRouteRequest);
            return (CallRoutingRouteResponse)CallRoutingApi.this.apiClient.execute(updateCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRoutingRouteResponse> callback) {
            RequestDefinition updateCallRouteDefinition = CallRoutingApi.this.updateCallRouteDefinition(this.routeId, this.callRoutingRouteRequest);
            return CallRoutingApi.this.apiClient.executeAsync(updateCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType(), callback);
        }
    }

    public class GetCallRoutesRequest {
        private Integer page;
        private Integer size;

        private GetCallRoutesRequest() {
        }

        public GetCallRoutesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallRoutesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallRoutingRouteResponsePage execute() throws ApiException {
            RequestDefinition getCallRoutesDefinition = CallRoutingApi.this.getCallRoutesDefinition(this.page, this.size);
            return (CallRoutingRouteResponsePage)CallRoutingApi.this.apiClient.execute(getCallRoutesDefinition, new TypeReference<CallRoutingRouteResponsePage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRoutingRouteResponsePage> callback) {
            RequestDefinition getCallRoutesDefinition = CallRoutingApi.this.getCallRoutesDefinition(this.page, this.size);
            return CallRoutingApi.this.apiClient.executeAsync(getCallRoutesDefinition, new TypeReference<CallRoutingRouteResponsePage>(){}.getType(), callback);
        }
    }

    public class GetCallRouteRequest {
        private final String routeId;

        private GetCallRouteRequest(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "The required parameter 'routeId' is missing.");
        }

        public CallRoutingRouteResponse execute() throws ApiException {
            RequestDefinition getCallRouteDefinition = CallRoutingApi.this.getCallRouteDefinition(this.routeId);
            return (CallRoutingRouteResponse)CallRoutingApi.this.apiClient.execute(getCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRoutingRouteResponse> callback) {
            RequestDefinition getCallRouteDefinition = CallRoutingApi.this.getCallRouteDefinition(this.routeId);
            return CallRoutingApi.this.apiClient.executeAsync(getCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType(), callback);
        }
    }

    public class DeleteCallRouteRequest {
        private final String routeId;

        private DeleteCallRouteRequest(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "The required parameter 'routeId' is missing.");
        }

        public CallRoutingRouteResponse execute() throws ApiException {
            RequestDefinition deleteCallRouteDefinition = CallRoutingApi.this.deleteCallRouteDefinition(this.routeId);
            return (CallRoutingRouteResponse)CallRoutingApi.this.apiClient.execute(deleteCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRoutingRouteResponse> callback) {
            RequestDefinition deleteCallRouteDefinition = CallRoutingApi.this.deleteCallRouteDefinition(this.routeId);
            return CallRoutingApi.this.apiClient.executeAsync(deleteCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType(), callback);
        }
    }

    public class CreateCallRouteRequest {
        private final CallRoutingRouteRequest callRoutingRouteRequest;

        private CreateCallRouteRequest(CallRoutingRouteRequest callRoutingRouteRequest) {
            this.callRoutingRouteRequest = Objects.requireNonNull(callRoutingRouteRequest, "The required parameter 'callRoutingRouteRequest' is missing.");
        }

        public CallRoutingRouteResponse execute() throws ApiException {
            RequestDefinition createCallRouteDefinition = CallRoutingApi.this.createCallRouteDefinition(this.callRoutingRouteRequest);
            return (CallRoutingRouteResponse)CallRoutingApi.this.apiClient.execute(createCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRoutingRouteResponse> callback) {
            RequestDefinition createCallRouteDefinition = CallRoutingApi.this.createCallRouteDefinition(this.callRoutingRouteRequest);
            return CallRoutingApi.this.apiClient.executeAsync(createCallRouteDefinition, new TypeReference<CallRoutingRouteResponse>(){}.getType(), callback);
        }
    }
}

