/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.CallBulkRequest;
import com.infobip.model.CallBulkResponse;
import com.infobip.model.CallBulkStatus;
import com.infobip.model.CallDirection;
import com.infobip.model.CallEndpointType;
import com.infobip.model.CallLog;
import com.infobip.model.CallLogPage;
import com.infobip.model.CallPage;
import com.infobip.model.CallRecording;
import com.infobip.model.CallRecordingPage;
import com.infobip.model.CallRequest;
import com.infobip.model.CallState;
import com.infobip.model.CallsActionResponse;
import com.infobip.model.CallsAddExistingCallRequest;
import com.infobip.model.CallsAddNewCallRequest;
import com.infobip.model.CallsAnswerRequest;
import com.infobip.model.CallsApplicationTransferRequest;
import com.infobip.model.CallsConference;
import com.infobip.model.CallsConferenceAndCall;
import com.infobip.model.CallsConferenceBroadcastWebrtcTextRequest;
import com.infobip.model.CallsConferenceLog;
import com.infobip.model.CallsConferenceLogPage;
import com.infobip.model.CallsConferencePage;
import com.infobip.model.CallsConferencePlayRequest;
import com.infobip.model.CallsConferenceRecording;
import com.infobip.model.CallsConferenceRecordingPage;
import com.infobip.model.CallsConferenceRecordingRequest;
import com.infobip.model.CallsConferenceRequest;
import com.infobip.model.CallsConfigurationCreateRequest;
import com.infobip.model.CallsConfigurationPage;
import com.infobip.model.CallsConfigurationResponse;
import com.infobip.model.CallsConfigurationUpdateRequest;
import com.infobip.model.CallsConnectRequest;
import com.infobip.model.CallsConnectWithNewCallRequest;
import com.infobip.model.CallsCreateSipTrunkResponse;
import com.infobip.model.CallsDialogBroadcastWebrtcTextRequest;
import com.infobip.model.CallsDialogLogPage;
import com.infobip.model.CallsDialogLogResponse;
import com.infobip.model.CallsDialogPage;
import com.infobip.model.CallsDialogPlayRequest;
import com.infobip.model.CallsDialogRecordingPage;
import com.infobip.model.CallsDialogRecordingRequest;
import com.infobip.model.CallsDialogRecordingResponse;
import com.infobip.model.CallsDialogRequest;
import com.infobip.model.CallsDialogResponse;
import com.infobip.model.CallsDialogSayRequest;
import com.infobip.model.CallsDialogState;
import com.infobip.model.CallsDialogWithExistingCallRequest;
import com.infobip.model.CallsDtmfCaptureRequest;
import com.infobip.model.CallsDtmfSendRequest;
import com.infobip.model.CallsExtendedSipTrunkStatusResponse;
import com.infobip.model.CallsFile;
import com.infobip.model.CallsFilePage;
import com.infobip.model.CallsHangupRequest;
import com.infobip.model.CallsMediaStreamConfigPage;
import com.infobip.model.CallsMediaStreamConfigRequest;
import com.infobip.model.CallsMediaStreamConfigResponse;
import com.infobip.model.CallsOnDemandComposition;
import com.infobip.model.CallsPlayRequest;
import com.infobip.model.CallsPreAnswerRequest;
import com.infobip.model.CallsPublicCountry;
import com.infobip.model.CallsPublicRegion;
import com.infobip.model.CallsPublicSipTrunkServiceAddress;
import com.infobip.model.CallsPublicSipTrunkServiceAddressRequest;
import com.infobip.model.CallsRecordingFile;
import com.infobip.model.CallsRecordingLocation;
import com.infobip.model.CallsRecordingStartRequest;
import com.infobip.model.CallsRescheduleRequest;
import com.infobip.model.CallsSayRequest;
import com.infobip.model.CallsSipTrunkPage;
import com.infobip.model.CallsSipTrunkRegistrationCredentials;
import com.infobip.model.CallsSipTrunkRequest;
import com.infobip.model.CallsSipTrunkResponse;
import com.infobip.model.CallsSipTrunkServiceAddressPage;
import com.infobip.model.CallsSipTrunkStatusRequest;
import com.infobip.model.CallsSipTrunkStatusResponse;
import com.infobip.model.CallsSipTrunkUpdateRequest;
import com.infobip.model.CallsSpeechCaptureRequest;
import com.infobip.model.CallsStartMediaStreamRequest;
import com.infobip.model.CallsStartTranscriptionRequest;
import com.infobip.model.CallsStopPlayRequest;
import com.infobip.model.CallsUpdateCallRequest;
import com.infobip.model.CallsUpdateRequest;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class CallsApi {
    private final ApiClient apiClient;

    public CallsApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition addExistingConferenceCallDefinition(String conferenceId, String callId, CallsAddExistingCallRequest callsAddExistingCallRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/calls/1/conferences/{conferenceId}/call/{callId}").body(callsAddExistingCallRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public AddExistingConferenceCallRequest addExistingConferenceCall(String conferenceId, String callId, CallsAddExistingCallRequest callsAddExistingCallRequest) {
        return new AddExistingConferenceCallRequest(conferenceId, callId, callsAddExistingCallRequest);
    }

    private RequestDefinition addNewConferenceCallDefinition(String conferenceId, CallsAddNewCallRequest callsAddNewCallRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/call").body(callsAddNewCallRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public AddNewConferenceCallRequest addNewConferenceCall(String conferenceId, CallsAddNewCallRequest callsAddNewCallRequest) {
        return new AddNewConferenceCallRequest(conferenceId, callsAddNewCallRequest);
    }

    private RequestDefinition answerCallDefinition(String callId, CallsAnswerRequest callsAnswerRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/answer").body(callsAnswerRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public AnswerCallRequest answerCall(String callId, CallsAnswerRequest callsAnswerRequest) {
        return new AnswerCallRequest(callId, callsAnswerRequest);
    }

    private RequestDefinition applicationTransferDefinition(String callId, CallsApplicationTransferRequest callsApplicationTransferRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/application-transfer").body(callsApplicationTransferRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public ApplicationTransferRequest applicationTransfer(String callId, CallsApplicationTransferRequest callsApplicationTransferRequest) {
        return new ApplicationTransferRequest(callId, callsApplicationTransferRequest);
    }

    private RequestDefinition applicationTransferAcceptDefinition(String callId, String transferId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/application-transfer/{transferId}/accept").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        if (transferId != null) {
            builder.addPathParameter(new Parameter("transferId", transferId));
        }
        return builder.build();
    }

    public ApplicationTransferAcceptRequest applicationTransferAccept(String callId, String transferId) {
        return new ApplicationTransferAcceptRequest(callId, transferId);
    }

    private RequestDefinition applicationTransferRejectDefinition(String callId, String transferId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/application-transfer/{transferId}/reject").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        if (transferId != null) {
            builder.addPathParameter(new Parameter("transferId", transferId));
        }
        return builder.build();
    }

    public ApplicationTransferRejectRequest applicationTransferReject(String callId, String transferId) {
        return new ApplicationTransferRejectRequest(callId, transferId);
    }

    private RequestDefinition callCaptureDtmfDefinition(String callId, CallsDtmfCaptureRequest callsDtmfCaptureRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/capture/dtmf").body(callsDtmfCaptureRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallCaptureDtmfRequest callCaptureDtmf(String callId, CallsDtmfCaptureRequest callsDtmfCaptureRequest) {
        return new CallCaptureDtmfRequest(callId, callsDtmfCaptureRequest);
    }

    private RequestDefinition callCaptureSpeechDefinition(String callId, CallsSpeechCaptureRequest callsSpeechCaptureRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/capture/speech").body(callsSpeechCaptureRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallCaptureSpeechRequest callCaptureSpeech(String callId, CallsSpeechCaptureRequest callsSpeechCaptureRequest) {
        return new CallCaptureSpeechRequest(callId, callsSpeechCaptureRequest);
    }

    private RequestDefinition callPlayFileDefinition(String callId, CallsPlayRequest callsPlayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/play").body(callsPlayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallPlayFileRequest callPlayFile(String callId, CallsPlayRequest callsPlayRequest) {
        return new CallPlayFileRequest(callId, callsPlayRequest);
    }

    private RequestDefinition callSayTextDefinition(String callId, CallsSayRequest callsSayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/say").body(callsSayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallSayTextRequest callSayText(String callId, CallsSayRequest callsSayRequest) {
        return new CallSayTextRequest(callId, callsSayRequest);
    }

    private RequestDefinition callSendDtmfDefinition(String callId, CallsDtmfSendRequest callsDtmfSendRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/send-dtmf").body(callsDtmfSendRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallSendDtmfRequest callSendDtmf(String callId, CallsDtmfSendRequest callsDtmfSendRequest) {
        return new CallSendDtmfRequest(callId, callsDtmfSendRequest);
    }

    private RequestDefinition callStartRecordingDefinition(String callId, CallsRecordingStartRequest callsRecordingStartRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/start-recording").body(callsRecordingStartRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallStartRecordingRequest callStartRecording(String callId, CallsRecordingStartRequest callsRecordingStartRequest) {
        return new CallStartRecordingRequest(callId, callsRecordingStartRequest);
    }

    private RequestDefinition callStartTranscriptionDefinition(String callId, CallsStartTranscriptionRequest callsStartTranscriptionRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/start-transcription").body(callsStartTranscriptionRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallStartTranscriptionRequest callStartTranscription(String callId, CallsStartTranscriptionRequest callsStartTranscriptionRequest) {
        return new CallStartTranscriptionRequest(callId, callsStartTranscriptionRequest);
    }

    private RequestDefinition callStopPlayingFileDefinition(String callId, CallsStopPlayRequest callsStopPlayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/stop-play").body(callsStopPlayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallStopPlayingFileRequest callStopPlayingFile(String callId, CallsStopPlayRequest callsStopPlayRequest) {
        return new CallStopPlayingFileRequest(callId, callsStopPlayRequest);
    }

    private RequestDefinition callStopRecordingDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/stop-recording").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallStopRecordingRequest callStopRecording(String callId) {
        return new CallStopRecordingRequest(callId);
    }

    private RequestDefinition callStopTranscriptionDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/stop-transcription").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public CallStopTranscriptionRequest callStopTranscription(String callId) {
        return new CallStopTranscriptionRequest(callId);
    }

    private RequestDefinition cancelBulkDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/bulks/{bulkId}/cancel").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addPathParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public CancelBulkRequest cancelBulk(String bulkId) {
        return new CancelBulkRequest(bulkId);
    }

    private RequestDefinition composeConferenceRecordingDefinition(String conferenceId, CallsOnDemandComposition callsOnDemandComposition, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/recordings/conferences/{conferenceId}/compose").body(callsOnDemandComposition).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public ComposeConferenceRecordingRequest composeConferenceRecording(String conferenceId, CallsOnDemandComposition callsOnDemandComposition) {
        return new ComposeConferenceRecordingRequest(conferenceId, callsOnDemandComposition);
    }

    private RequestDefinition composeDialogRecordingDefinition(String dialogId, CallsOnDemandComposition callsOnDemandComposition, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/recordings/dialogs/{dialogId}/compose").body(callsOnDemandComposition).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public ComposeDialogRecordingRequest composeDialogRecording(String dialogId, CallsOnDemandComposition callsOnDemandComposition) {
        return new ComposeDialogRecordingRequest(dialogId, callsOnDemandComposition);
    }

    private RequestDefinition conferenceBroadcastWebrtcTextDefinition(String conferenceId, CallsConferenceBroadcastWebrtcTextRequest callsConferenceBroadcastWebrtcTextRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/broadcast-webrtc-text").body(callsConferenceBroadcastWebrtcTextRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferenceBroadcastWebrtcTextRequest conferenceBroadcastWebrtcText(String conferenceId, CallsConferenceBroadcastWebrtcTextRequest callsConferenceBroadcastWebrtcTextRequest) {
        return new ConferenceBroadcastWebrtcTextRequest(conferenceId, callsConferenceBroadcastWebrtcTextRequest);
    }

    private RequestDefinition conferencePlayFileDefinition(String conferenceId, CallsConferencePlayRequest callsConferencePlayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/play").body(callsConferencePlayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferencePlayFileRequest conferencePlayFile(String conferenceId, CallsConferencePlayRequest callsConferencePlayRequest) {
        return new ConferencePlayFileRequest(conferenceId, callsConferencePlayRequest);
    }

    private RequestDefinition conferenceSayTextDefinition(String conferenceId, CallsSayRequest callsSayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/say").body(callsSayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferenceSayTextRequest conferenceSayText(String conferenceId, CallsSayRequest callsSayRequest) {
        return new ConferenceSayTextRequest(conferenceId, callsSayRequest);
    }

    private RequestDefinition conferenceStartRecordingDefinition(String conferenceId, CallsConferenceRecordingRequest callsConferenceRecordingRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/start-recording").body(callsConferenceRecordingRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferenceStartRecordingRequest conferenceStartRecording(String conferenceId, CallsConferenceRecordingRequest callsConferenceRecordingRequest) {
        return new ConferenceStartRecordingRequest(conferenceId, callsConferenceRecordingRequest);
    }

    private RequestDefinition conferenceStopPlayingFileDefinition(String conferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/stop-play").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferenceStopPlayingFileRequest conferenceStopPlayingFile(String conferenceId) {
        return new ConferenceStopPlayingFileRequest(conferenceId);
    }

    private RequestDefinition conferenceStopRecordingDefinition(String conferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/stop-recording").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public ConferenceStopRecordingRequest conferenceStopRecording(String conferenceId) {
        return new ConferenceStopRecordingRequest(conferenceId);
    }

    private RequestDefinition connectCallsDefinition(CallsConnectRequest callsConnectRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/connect").body(callsConnectRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public ConnectCallsRequest connectCalls(CallsConnectRequest callsConnectRequest) {
        return new ConnectCallsRequest(callsConnectRequest);
    }

    private RequestDefinition connectWithNewCallDefinition(String callId, CallsConnectWithNewCallRequest callsConnectWithNewCallRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/connect").body(callsConnectWithNewCallRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public ConnectWithNewCallRequest connectWithNewCall(String callId, CallsConnectWithNewCallRequest callsConnectWithNewCallRequest) {
        return new ConnectWithNewCallRequest(callId, callsConnectWithNewCallRequest);
    }

    private RequestDefinition createBulkDefinition(CallBulkRequest callBulkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/bulks").body(callBulkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateBulkRequest createBulk(CallBulkRequest callBulkRequest) {
        return new CreateBulkRequest(callBulkRequest);
    }

    private RequestDefinition createCallDefinition(CallRequest callRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls").body(callRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateCallRequest createCall(CallRequest callRequest) {
        return new CreateCallRequest(callRequest);
    }

    private RequestDefinition createCallsConfigurationDefinition(CallsConfigurationCreateRequest callsConfigurationCreateRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/configurations").body(callsConfigurationCreateRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateCallsConfigurationRequest createCallsConfiguration(CallsConfigurationCreateRequest callsConfigurationCreateRequest) {
        return new CreateCallsConfigurationRequest(callsConfigurationCreateRequest);
    }

    private RequestDefinition createConferenceDefinition(CallsConferenceRequest callsConferenceRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences").body(callsConferenceRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateConferenceRequest createConference(CallsConferenceRequest callsConferenceRequest) {
        return new CreateConferenceRequest(callsConferenceRequest);
    }

    private RequestDefinition createDialogDefinition(CallsDialogRequest callsDialogRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs").body(callsDialogRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateDialogRequest createDialog(CallsDialogRequest callsDialogRequest) {
        return new CreateDialogRequest(callsDialogRequest);
    }

    private RequestDefinition createDialogWithExistingCallsDefinition(String parentCallId, String childCallId, CallsDialogWithExistingCallRequest callsDialogWithExistingCallRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/parent-call/{parentCallId}/child-call/{childCallId}").body(callsDialogWithExistingCallRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (parentCallId != null) {
            builder.addPathParameter(new Parameter("parentCallId", parentCallId));
        }
        if (childCallId != null) {
            builder.addPathParameter(new Parameter("childCallId", childCallId));
        }
        return builder.build();
    }

    public CreateDialogWithExistingCallsRequest createDialogWithExistingCalls(String parentCallId, String childCallId, CallsDialogWithExistingCallRequest callsDialogWithExistingCallRequest) {
        return new CreateDialogWithExistingCallsRequest(parentCallId, childCallId, callsDialogWithExistingCallRequest);
    }

    private RequestDefinition createMediaStreamConfigDefinition(CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/media-stream-configs").body(callsMediaStreamConfigRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateMediaStreamConfigRequest createMediaStreamConfig(CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
        return new CreateMediaStreamConfigRequest(callsMediaStreamConfigRequest);
    }

    private RequestDefinition createSipTrunkDefinition(CallsSipTrunkRequest callsSipTrunkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/sip-trunks").body(callsSipTrunkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateSipTrunkRequest createSipTrunk(CallsSipTrunkRequest callsSipTrunkRequest) {
        return new CreateSipTrunkRequest(callsSipTrunkRequest);
    }

    private RequestDefinition createSipTrunkServiceAddressDefinition(CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/sip-trunks/service-addresses").body(callsPublicSipTrunkServiceAddressRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateSipTrunkServiceAddressRequest createSipTrunkServiceAddress(CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
        return new CreateSipTrunkServiceAddressRequest(callsPublicSipTrunkServiceAddressRequest);
    }

    private RequestDefinition deleteCallRecordingsDefinition(String callId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/recordings/calls/{callId}").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public DeleteCallRecordingsRequest deleteCallRecordings(String callId) {
        return new DeleteCallRecordingsRequest(callId);
    }

    private RequestDefinition deleteCallsConfigurationDefinition(String callsConfigurationId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/configurations/{callsConfigurationId}").requiresAuthentication(true).accept("application/json");
        if (callsConfigurationId != null) {
            builder.addPathParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        return builder.build();
    }

    public DeleteCallsConfigurationRequest deleteCallsConfiguration(String callsConfigurationId) {
        return new DeleteCallsConfigurationRequest(callsConfigurationId);
    }

    private RequestDefinition deleteCallsFileDefinition(String fileId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/files/{fileId}").requiresAuthentication(true).accept("application/json");
        if (fileId != null) {
            builder.addPathParameter(new Parameter("fileId", fileId));
        }
        return builder.build();
    }

    public DeleteCallsFileRequest deleteCallsFile(String fileId) {
        return new DeleteCallsFileRequest(fileId);
    }

    private RequestDefinition deleteConferenceRecordingsDefinition(String conferenceId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/recordings/conferences/{conferenceId}").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public DeleteConferenceRecordingsRequest deleteConferenceRecordings(String conferenceId) {
        return new DeleteConferenceRecordingsRequest(conferenceId);
    }

    private RequestDefinition deleteDialogRecordingsDefinition(String dialogId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/recordings/dialogs/{dialogId}").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public DeleteDialogRecordingsRequest deleteDialogRecordings(String dialogId) {
        return new DeleteDialogRecordingsRequest(dialogId);
    }

    private RequestDefinition deleteMediaStreamConfigDefinition(String mediaStreamConfigId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/media-stream-configs/{mediaStreamConfigId}").requiresAuthentication(true).accept("application/json");
        if (mediaStreamConfigId != null) {
            builder.addPathParameter(new Parameter("mediaStreamConfigId", mediaStreamConfigId));
        }
        return builder.build();
    }

    public DeleteMediaStreamConfigRequest deleteMediaStreamConfig(String mediaStreamConfigId) {
        return new DeleteMediaStreamConfigRequest(mediaStreamConfigId);
    }

    private RequestDefinition deleteRecordingFileDefinition(String fileId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/recordings/files/{fileId}").requiresAuthentication(true).accept("application/json");
        if (fileId != null) {
            builder.addPathParameter(new Parameter("fileId", fileId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public DeleteRecordingFileRequest deleteRecordingFile(String fileId) {
        return new DeleteRecordingFileRequest(fileId);
    }

    private RequestDefinition deleteSipTrunkDefinition(String sipTrunkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/sip-trunks/{sipTrunkId}").requiresAuthentication(true).accept("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public DeleteSipTrunkRequest deleteSipTrunk(String sipTrunkId) {
        return new DeleteSipTrunkRequest(sipTrunkId);
    }

    private RequestDefinition deleteSipTrunkServiceAddressDefinition(String sipTrunkServiceAddressId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/sip-trunks/service-addresses/{sipTrunkServiceAddressId}").requiresAuthentication(true).accept("application/json");
        if (sipTrunkServiceAddressId != null) {
            builder.addPathParameter(new Parameter("sipTrunkServiceAddressId", sipTrunkServiceAddressId));
        }
        return builder.build();
    }

    public DeleteSipTrunkServiceAddressRequest deleteSipTrunkServiceAddress(String sipTrunkServiceAddressId) {
        return new DeleteSipTrunkServiceAddressRequest(sipTrunkServiceAddressId);
    }

    private RequestDefinition dialogBroadcastWebrtcTextDefinition(String dialogId, CallsDialogBroadcastWebrtcTextRequest callsDialogBroadcastWebrtcTextRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/broadcast-webrtc-text").body(callsDialogBroadcastWebrtcTextRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogBroadcastWebrtcTextRequest dialogBroadcastWebrtcText(String dialogId, CallsDialogBroadcastWebrtcTextRequest callsDialogBroadcastWebrtcTextRequest) {
        return new DialogBroadcastWebrtcTextRequest(dialogId, callsDialogBroadcastWebrtcTextRequest);
    }

    private RequestDefinition dialogPlayFileDefinition(String dialogId, CallsDialogPlayRequest callsDialogPlayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/play").body(callsDialogPlayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogPlayFileRequest dialogPlayFile(String dialogId, CallsDialogPlayRequest callsDialogPlayRequest) {
        return new DialogPlayFileRequest(dialogId, callsDialogPlayRequest);
    }

    private RequestDefinition dialogSayTextDefinition(String dialogId, CallsDialogSayRequest callsDialogSayRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/say").body(callsDialogSayRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogSayTextRequest dialogSayText(String dialogId, CallsDialogSayRequest callsDialogSayRequest) {
        return new DialogSayTextRequest(dialogId, callsDialogSayRequest);
    }

    private RequestDefinition dialogStartRecordingDefinition(String dialogId, CallsDialogRecordingRequest callsDialogRecordingRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/start-recording").body(callsDialogRecordingRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogStartRecordingRequest dialogStartRecording(String dialogId, CallsDialogRecordingRequest callsDialogRecordingRequest) {
        return new DialogStartRecordingRequest(dialogId, callsDialogRecordingRequest);
    }

    private RequestDefinition dialogStopPlayingFileDefinition(String dialogId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/stop-play").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogStopPlayingFileRequest dialogStopPlayingFile(String dialogId) {
        return new DialogStopPlayingFileRequest(dialogId);
    }

    private RequestDefinition dialogStopRecordingDefinition(String dialogId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/stop-recording").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public DialogStopRecordingRequest dialogStopRecording(String dialogId) {
        return new DialogStopRecordingRequest(dialogId);
    }

    private RequestDefinition downloadRecordingFileDefinition(String fileId, CallsRecordingLocation location, String range) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/files/{fileId}").requiresAuthentication(true).accept("application/octet-stream");
        if (fileId != null) {
            builder.addPathParameter(new Parameter("fileId", fileId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        if (range != null) {
            builder.addHeaderParameter(new Parameter("Range", range));
        }
        return builder.build();
    }

    public DownloadRecordingFileRequest downloadRecordingFile(String fileId) {
        return new DownloadRecordingFileRequest(fileId);
    }

    private RequestDefinition getBulkStatusDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/bulks/{bulkId}").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addPathParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetBulkStatusRequest getBulkStatus(String bulkId) {
        return new GetBulkStatusRequest(bulkId);
    }

    private RequestDefinition getCallDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/calls/{callId}").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public GetCallRequest getCall(String callId) {
        return new GetCallRequest(callId);
    }

    private RequestDefinition getCallHistoryDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/calls/{callId}/history").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public GetCallHistoryRequest getCallHistory(String callId) {
        return new GetCallHistoryRequest(callId);
    }

    private RequestDefinition getCallRecordingsDefinition(String callId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/calls/{callId}").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public GetCallRecordingsRequest getCallRecordings(String callId) {
        return new GetCallRecordingsRequest(callId);
    }

    private RequestDefinition getCallsDefinition(CallEndpointType type, String callsConfigurationId, String applicationId, String from, String to, CallDirection direction, CallState status, OffsetDateTime startTimeAfter, String conferenceId, String dialogId, String bulkId, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/calls").requiresAuthentication(true).accept("application/json");
        if (type != null) {
            builder.addQueryParameter(new Parameter("type", (Object)type));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (direction != null) {
            builder.addQueryParameter(new Parameter("direction", (Object)direction));
        }
        if (status != null) {
            builder.addQueryParameter(new Parameter("status", (Object)status));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (conferenceId != null) {
            builder.addQueryParameter(new Parameter("conferenceId", conferenceId));
        }
        if (dialogId != null) {
            builder.addQueryParameter(new Parameter("dialogId", dialogId));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallsRequest getCalls() {
        return new GetCallsRequest();
    }

    private RequestDefinition getCallsConfigurationDefinition(String callsConfigurationId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/configurations/{callsConfigurationId}").requiresAuthentication(true).accept("application/json");
        if (callsConfigurationId != null) {
            builder.addPathParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        return builder.build();
    }

    public GetCallsConfigurationRequest getCallsConfiguration(String callsConfigurationId) {
        return new GetCallsConfigurationRequest(callsConfigurationId);
    }

    private RequestDefinition getCallsConfigurationsDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/configurations").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallsConfigurationsRequest getCallsConfigurations() {
        return new GetCallsConfigurationsRequest();
    }

    private RequestDefinition getCallsFileDefinition(String fileId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/files/{fileId}").requiresAuthentication(true).accept("application/json");
        if (fileId != null) {
            builder.addPathParameter(new Parameter("fileId", fileId));
        }
        return builder.build();
    }

    public GetCallsFileRequest getCallsFile(String fileId) {
        return new GetCallsFileRequest(fileId);
    }

    private RequestDefinition getCallsFilesDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/files").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallsFilesRequest getCallsFiles() {
        return new GetCallsFilesRequest();
    }

    private RequestDefinition getCallsHistoryDefinition(CallEndpointType type, String callsConfigurationId, String applicationId, String from, String to, CallDirection direction, CallState status, OffsetDateTime startTimeAfter, String conferenceId, String dialogId, String bulkId, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/calls/history").requiresAuthentication(true).accept("application/json");
        if (type != null) {
            builder.addQueryParameter(new Parameter("type", (Object)type));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (direction != null) {
            builder.addQueryParameter(new Parameter("direction", (Object)direction));
        }
        if (status != null) {
            builder.addQueryParameter(new Parameter("status", (Object)status));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (conferenceId != null) {
            builder.addQueryParameter(new Parameter("conferenceId", conferenceId));
        }
        if (dialogId != null) {
            builder.addQueryParameter(new Parameter("dialogId", dialogId));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallsHistoryRequest getCallsHistory() {
        return new GetCallsHistoryRequest();
    }

    private RequestDefinition getCallsRecordingsDefinition(String callId, String callsConfigurationId, String applicationId, String entityId, String endpointIdentifier, OffsetDateTime startTimeAfter, OffsetDateTime endTimeBefore, CallDirection direction, CallEndpointType endpointType, CallsRecordingLocation location, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/calls").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addQueryParameter(new Parameter("callId", callId));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (endpointIdentifier != null) {
            builder.addQueryParameter(new Parameter("endpointIdentifier", endpointIdentifier));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (endTimeBefore != null) {
            builder.addQueryParameter(new Parameter("endTimeBefore", endTimeBefore));
        }
        if (direction != null) {
            builder.addQueryParameter(new Parameter("direction", (Object)direction));
        }
        if (endpointType != null) {
            builder.addQueryParameter(new Parameter("endpointType", (Object)endpointType));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetCallsRecordingsRequest getCallsRecordings() {
        return new GetCallsRecordingsRequest();
    }

    private RequestDefinition getConferenceDefinition(String conferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/conferences/{conferenceId}").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public GetConferenceRequest getConference(String conferenceId) {
        return new GetConferenceRequest(conferenceId);
    }

    private RequestDefinition getConferenceHistoryDefinition(String conferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/conferences/{conferenceId}/history").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public GetConferenceHistoryRequest getConferenceHistory(String conferenceId) {
        return new GetConferenceHistoryRequest(conferenceId);
    }

    private RequestDefinition getConferenceRecordingsDefinition(String conferenceId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/conferences/{conferenceId}").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public GetConferenceRecordingsRequest getConferenceRecordings(String conferenceId) {
        return new GetConferenceRecordingsRequest(conferenceId);
    }

    private RequestDefinition getConferencesDefinition(String name, String callId, String callsConfigurationId, String applicationId, OffsetDateTime startTimeAfter, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/conferences").requiresAuthentication(true).accept("application/json");
        if (name != null) {
            builder.addQueryParameter(new Parameter("name", name));
        }
        if (callId != null) {
            builder.addQueryParameter(new Parameter("callId", callId));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetConferencesRequest getConferences() {
        return new GetConferencesRequest();
    }

    private RequestDefinition getConferencesHistoryDefinition(String name, String callId, String callsConfigurationId, String applicationId, OffsetDateTime startTimeAfter, OffsetDateTime endTimeBefore, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/conferences/history").requiresAuthentication(true).accept("application/json");
        if (name != null) {
            builder.addQueryParameter(new Parameter("name", name));
        }
        if (callId != null) {
            builder.addQueryParameter(new Parameter("callId", callId));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (endTimeBefore != null) {
            builder.addQueryParameter(new Parameter("endTimeBefore", endTimeBefore));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetConferencesHistoryRequest getConferencesHistory() {
        return new GetConferencesHistoryRequest();
    }

    private RequestDefinition getConferencesRecordingsDefinition(String conferenceId, String callsConfigurationId, String applicationId, String entityId, String conferenceName, String callId, CallEndpointType callEndpointType, String callEndpointIdentifier, OffsetDateTime startTimeAfter, OffsetDateTime endTimeBefore, Boolean composition, CallsRecordingLocation location, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/conferences").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addQueryParameter(new Parameter("conferenceId", conferenceId));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (conferenceName != null) {
            builder.addQueryParameter(new Parameter("conferenceName", conferenceName));
        }
        if (callId != null) {
            builder.addQueryParameter(new Parameter("callId", callId));
        }
        if (callEndpointType != null) {
            builder.addQueryParameter(new Parameter("callEndpointType", (Object)callEndpointType));
        }
        if (callEndpointIdentifier != null) {
            builder.addQueryParameter(new Parameter("callEndpointIdentifier", callEndpointIdentifier));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (endTimeBefore != null) {
            builder.addQueryParameter(new Parameter("endTimeBefore", endTimeBefore));
        }
        if (composition != null) {
            builder.addQueryParameter(new Parameter("composition", composition));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetConferencesRecordingsRequest getConferencesRecordings() {
        return new GetConferencesRecordingsRequest();
    }

    private RequestDefinition getCountriesDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/service-addresses/countries").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetCountriesRequest getCountries() {
        return new GetCountriesRequest();
    }

    private RequestDefinition getDialogDefinition(String dialogId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/dialogs/{dialogId}").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public GetDialogRequest getDialog(String dialogId) {
        return new GetDialogRequest(dialogId);
    }

    private RequestDefinition getDialogHistoryDefinition(String dialogId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/dialogs/{dialogId}/history").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public GetDialogHistoryRequest getDialogHistory(String dialogId) {
        return new GetDialogHistoryRequest(dialogId);
    }

    private RequestDefinition getDialogRecordingsDefinition(String dialogId, CallsRecordingLocation location) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/dialogs/{dialogId}").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        return builder.build();
    }

    public GetDialogRecordingsRequest getDialogRecordings(String dialogId) {
        return new GetDialogRecordingsRequest(dialogId);
    }

    private RequestDefinition getDialogsDefinition(String callsConfigurationId, String applicationId, CallsDialogState state, String parentCallId, String childCallId, OffsetDateTime startTimeAfter, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/dialogs").requiresAuthentication(true).accept("application/json");
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (state != null) {
            builder.addQueryParameter(new Parameter("state", (Object)state));
        }
        if (parentCallId != null) {
            builder.addQueryParameter(new Parameter("parentCallId", parentCallId));
        }
        if (childCallId != null) {
            builder.addQueryParameter(new Parameter("childCallId", childCallId));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetDialogsRequest getDialogs() {
        return new GetDialogsRequest();
    }

    private RequestDefinition getDialogsHistoryDefinition(String callsConfigurationId, String applicationId, CallsDialogState state, String parentCallId, String childCallId, OffsetDateTime startTimeAfter, OffsetDateTime endTimeBefore, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/dialogs/history").requiresAuthentication(true).accept("application/json");
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (state != null) {
            builder.addQueryParameter(new Parameter("state", (Object)state));
        }
        if (parentCallId != null) {
            builder.addQueryParameter(new Parameter("parentCallId", parentCallId));
        }
        if (childCallId != null) {
            builder.addQueryParameter(new Parameter("childCallId", childCallId));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (endTimeBefore != null) {
            builder.addQueryParameter(new Parameter("endTimeBefore", endTimeBefore));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetDialogsHistoryRequest getDialogsHistory() {
        return new GetDialogsHistoryRequest();
    }

    private RequestDefinition getDialogsRecordingsDefinition(String dialogId, String callsConfigurationId, String applicationId, String entityId, String callId, CallEndpointType callEndpointType, String callEndpointIdentifier, OffsetDateTime startTimeAfter, OffsetDateTime endTimeBefore, Boolean composition, CallsRecordingLocation location, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/recordings/dialogs").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addQueryParameter(new Parameter("dialogId", dialogId));
        }
        if (callsConfigurationId != null) {
            builder.addQueryParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (callId != null) {
            builder.addQueryParameter(new Parameter("callId", callId));
        }
        if (callEndpointType != null) {
            builder.addQueryParameter(new Parameter("callEndpointType", (Object)callEndpointType));
        }
        if (callEndpointIdentifier != null) {
            builder.addQueryParameter(new Parameter("callEndpointIdentifier", callEndpointIdentifier));
        }
        if (startTimeAfter != null) {
            builder.addQueryParameter(new Parameter("startTimeAfter", startTimeAfter));
        }
        if (endTimeBefore != null) {
            builder.addQueryParameter(new Parameter("endTimeBefore", endTimeBefore));
        }
        if (composition != null) {
            builder.addQueryParameter(new Parameter("composition", composition));
        }
        if (location != null) {
            builder.addQueryParameter(new Parameter("location", (Object)location));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetDialogsRecordingsRequest getDialogsRecordings() {
        return new GetDialogsRecordingsRequest();
    }

    private RequestDefinition getMediaStreamConfigDefinition(String mediaStreamConfigId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/media-stream-configs/{mediaStreamConfigId}").requiresAuthentication(true).accept("application/json");
        if (mediaStreamConfigId != null) {
            builder.addPathParameter(new Parameter("mediaStreamConfigId", mediaStreamConfigId));
        }
        return builder.build();
    }

    public GetMediaStreamConfigRequest getMediaStreamConfig(String mediaStreamConfigId) {
        return new GetMediaStreamConfigRequest(mediaStreamConfigId);
    }

    private RequestDefinition getMediaStreamConfigsDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/media-stream-configs").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetMediaStreamConfigsRequest getMediaStreamConfigs() {
        return new GetMediaStreamConfigsRequest();
    }

    private RequestDefinition getRegionsDefinition(String countryCode) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/service-addresses/countries/regions").requiresAuthentication(true).accept("application/json");
        if (countryCode != null) {
            builder.addQueryParameter(new Parameter("countryCode", countryCode));
        }
        return builder.build();
    }

    public GetRegionsRequest getRegions(String countryCode) {
        return new GetRegionsRequest(countryCode);
    }

    private RequestDefinition getSipTrunkDefinition(String sipTrunkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/{sipTrunkId}").requiresAuthentication(true).accept("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public GetSipTrunkRequest getSipTrunk(String sipTrunkId) {
        return new GetSipTrunkRequest(sipTrunkId);
    }

    private RequestDefinition getSipTrunkServiceAddressDefinition(String sipTrunkServiceAddressId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/service-addresses/{sipTrunkServiceAddressId}").requiresAuthentication(true).accept("application/json");
        if (sipTrunkServiceAddressId != null) {
            builder.addPathParameter(new Parameter("sipTrunkServiceAddressId", sipTrunkServiceAddressId));
        }
        return builder.build();
    }

    public GetSipTrunkServiceAddressRequest getSipTrunkServiceAddress(String sipTrunkServiceAddressId) {
        return new GetSipTrunkServiceAddressRequest(sipTrunkServiceAddressId);
    }

    private RequestDefinition getSipTrunkServiceAddressesDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/service-addresses").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetSipTrunkServiceAddressesRequest getSipTrunkServiceAddresses() {
        return new GetSipTrunkServiceAddressesRequest();
    }

    private RequestDefinition getSipTrunkStatusDefinition(String sipTrunkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks/{sipTrunkId}/status").requiresAuthentication(true).accept("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public GetSipTrunkStatusRequest getSipTrunkStatus(String sipTrunkId) {
        return new GetSipTrunkStatusRequest(sipTrunkId);
    }

    private RequestDefinition getSipTrunksDefinition(String name, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/calls/1/sip-trunks").requiresAuthentication(true).accept("application/json");
        if (name != null) {
            builder.addQueryParameter(new Parameter("name", name));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetSipTrunksRequest getSipTrunks() {
        return new GetSipTrunksRequest();
    }

    private RequestDefinition hangupCallDefinition(String callId, CallsHangupRequest callsHangupRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/hangup").body(callsHangupRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public HangupCallRequest hangupCall(String callId, CallsHangupRequest callsHangupRequest) {
        return new HangupCallRequest(callId, callsHangupRequest);
    }

    private RequestDefinition hangupConferenceDefinition(String conferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/conferences/{conferenceId}/hangup").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public HangupConferenceRequest hangupConference(String conferenceId) {
        return new HangupConferenceRequest(conferenceId);
    }

    private RequestDefinition hangupDialogDefinition(String dialogId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/dialogs/{dialogId}/hangup").requiresAuthentication(true).accept("application/json");
        if (dialogId != null) {
            builder.addPathParameter(new Parameter("dialogId", dialogId));
        }
        return builder.build();
    }

    public HangupDialogRequest hangupDialog(String dialogId) {
        return new HangupDialogRequest(dialogId);
    }

    private RequestDefinition pauseBulkDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/bulks/{bulkId}/pause").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addPathParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public PauseBulkRequest pauseBulk(String bulkId) {
        return new PauseBulkRequest(bulkId);
    }

    private RequestDefinition preAnswerCallDefinition(String callId, CallsPreAnswerRequest callsPreAnswerRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/pre-answer").body(callsPreAnswerRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public PreAnswerCallRequest preAnswerCall(String callId, CallsPreAnswerRequest callsPreAnswerRequest) {
        return new PreAnswerCallRequest(callId, callsPreAnswerRequest);
    }

    private RequestDefinition removeConferenceCallDefinition(String conferenceId, String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/calls/1/conferences/{conferenceId}/call/{callId}").requiresAuthentication(true).accept("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public RemoveConferenceCallRequest removeConferenceCall(String conferenceId, String callId) {
        return new RemoveConferenceCallRequest(conferenceId, callId);
    }

    private RequestDefinition rescheduleBulkDefinition(String bulkId, CallsRescheduleRequest callsRescheduleRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/bulks/{bulkId}/reschedule").body(callsRescheduleRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addPathParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleBulkRequest rescheduleBulk(String bulkId, CallsRescheduleRequest callsRescheduleRequest) {
        return new RescheduleBulkRequest(bulkId, callsRescheduleRequest);
    }

    private RequestDefinition resetSipTrunkPasswordDefinition(String sipTrunkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/sip-trunks/{sipTrunkId}/reset-password").requiresAuthentication(true).accept("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public ResetSipTrunkPasswordRequest resetSipTrunkPassword(String sipTrunkId) {
        return new ResetSipTrunkPasswordRequest(sipTrunkId);
    }

    private RequestDefinition resumeBulkDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/bulks/{bulkId}/resume").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addPathParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public ResumeBulkRequest resumeBulk(String bulkId) {
        return new ResumeBulkRequest(bulkId);
    }

    private RequestDefinition sendRingingDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/send-ringing").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public SendRingingRequest sendRinging(String callId) {
        return new SendRingingRequest(callId);
    }

    private RequestDefinition setSipTrunkStatusDefinition(String sipTrunkId, CallsSipTrunkStatusRequest callsSipTrunkStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/sip-trunks/{sipTrunkId}/status").body(callsSipTrunkStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public SetSipTrunkStatusRequest setSipTrunkStatus(String sipTrunkId, CallsSipTrunkStatusRequest callsSipTrunkStatusRequest) {
        return new SetSipTrunkStatusRequest(sipTrunkId, callsSipTrunkStatusRequest);
    }

    private RequestDefinition startMediaStreamDefinition(String callId, CallsStartMediaStreamRequest callsStartMediaStreamRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/start-media-stream").body(callsStartMediaStreamRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public StartMediaStreamRequest startMediaStream(String callId, CallsStartMediaStreamRequest callsStartMediaStreamRequest) {
        return new StartMediaStreamRequest(callId, callsStartMediaStreamRequest);
    }

    private RequestDefinition stopMediaStreamDefinition(String callId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/calls/{callId}/stop-media-stream").requiresAuthentication(true).accept("application/json");
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public StopMediaStreamRequest stopMediaStream(String callId) {
        return new StopMediaStreamRequest(callId);
    }

    private RequestDefinition updateCallsConfigurationDefinition(String callsConfigurationId, CallsConfigurationUpdateRequest callsConfigurationUpdateRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/calls/1/configurations/{callsConfigurationId}").body(callsConfigurationUpdateRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (callsConfigurationId != null) {
            builder.addPathParameter(new Parameter("callsConfigurationId", callsConfigurationId));
        }
        return builder.build();
    }

    public UpdateCallsConfigurationRequest updateCallsConfiguration(String callsConfigurationId, CallsConfigurationUpdateRequest callsConfigurationUpdateRequest) {
        return new UpdateCallsConfigurationRequest(callsConfigurationId, callsConfigurationUpdateRequest);
    }

    private RequestDefinition updateConferenceDefinition(String conferenceId, CallsUpdateRequest callsUpdateRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PATCH", "/calls/1/conferences/{conferenceId}").body(callsUpdateRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        return builder.build();
    }

    public UpdateConferenceRequest updateConference(String conferenceId, CallsUpdateRequest callsUpdateRequest) {
        return new UpdateConferenceRequest(conferenceId, callsUpdateRequest);
    }

    private RequestDefinition updateConferenceCallDefinition(String conferenceId, String callId, CallsUpdateCallRequest callsUpdateCallRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PATCH", "/calls/1/conferences/{conferenceId}/call/{callId}").body(callsUpdateCallRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (conferenceId != null) {
            builder.addPathParameter(new Parameter("conferenceId", conferenceId));
        }
        if (callId != null) {
            builder.addPathParameter(new Parameter("callId", callId));
        }
        return builder.build();
    }

    public UpdateConferenceCallRequest updateConferenceCall(String conferenceId, String callId, CallsUpdateCallRequest callsUpdateCallRequest) {
        return new UpdateConferenceCallRequest(conferenceId, callId, callsUpdateCallRequest);
    }

    private RequestDefinition updateMediaStreamConfigDefinition(String mediaStreamConfigId, CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/calls/1/media-stream-configs/{mediaStreamConfigId}").body(callsMediaStreamConfigRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (mediaStreamConfigId != null) {
            builder.addPathParameter(new Parameter("mediaStreamConfigId", mediaStreamConfigId));
        }
        return builder.build();
    }

    public UpdateMediaStreamConfigRequest updateMediaStreamConfig(String mediaStreamConfigId, CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
        return new UpdateMediaStreamConfigRequest(mediaStreamConfigId, callsMediaStreamConfigRequest);
    }

    private RequestDefinition updateSipTrunkDefinition(String sipTrunkId, CallsSipTrunkUpdateRequest callsSipTrunkUpdateRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/calls/1/sip-trunks/{sipTrunkId}").body(callsSipTrunkUpdateRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sipTrunkId != null) {
            builder.addPathParameter(new Parameter("sipTrunkId", sipTrunkId));
        }
        return builder.build();
    }

    public UpdateSipTrunkRequest updateSipTrunk(String sipTrunkId, CallsSipTrunkUpdateRequest callsSipTrunkUpdateRequest) {
        return new UpdateSipTrunkRequest(sipTrunkId, callsSipTrunkUpdateRequest);
    }

    private RequestDefinition updateSipTrunkServiceAddressDefinition(String sipTrunkServiceAddressId, CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/calls/1/sip-trunks/service-addresses/{sipTrunkServiceAddressId}").body(callsPublicSipTrunkServiceAddressRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sipTrunkServiceAddressId != null) {
            builder.addPathParameter(new Parameter("sipTrunkServiceAddressId", sipTrunkServiceAddressId));
        }
        return builder.build();
    }

    public UpdateSipTrunkServiceAddressRequest updateSipTrunkServiceAddress(String sipTrunkServiceAddressId, CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
        return new UpdateSipTrunkServiceAddressRequest(sipTrunkServiceAddressId, callsPublicSipTrunkServiceAddressRequest);
    }

    private RequestDefinition uploadCallsAudioFileDefinition(File _file) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/calls/1/files").requiresAuthentication(true).accept("application/json").contentType("multipart/form-data");
        if (_file != null) {
            builder.addFormParameter(new Parameter("file", _file));
        }
        return builder.build();
    }

    public UploadCallsAudioFileRequest uploadCallsAudioFile(File _file) {
        return new UploadCallsAudioFileRequest(_file);
    }

    public class UploadCallsAudioFileRequest {
        private final File _file;

        private UploadCallsAudioFileRequest(File _file) {
            this._file = Objects.requireNonNull(_file, "The required parameter '_file' is missing.");
        }

        public CallsFile execute() throws ApiException {
            RequestDefinition uploadCallsAudioFileDefinition = CallsApi.this.uploadCallsAudioFileDefinition(this._file);
            return (CallsFile)CallsApi.this.apiClient.execute(uploadCallsAudioFileDefinition, new TypeReference<CallsFile>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsFile> callback) {
            RequestDefinition uploadCallsAudioFileDefinition = CallsApi.this.uploadCallsAudioFileDefinition(this._file);
            return CallsApi.this.apiClient.executeAsync(uploadCallsAudioFileDefinition, new TypeReference<CallsFile>(){}.getType(), callback);
        }
    }

    public class UpdateSipTrunkServiceAddressRequest {
        private final String sipTrunkServiceAddressId;
        private final CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest;

        private UpdateSipTrunkServiceAddressRequest(String sipTrunkServiceAddressId, CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
            this.sipTrunkServiceAddressId = Objects.requireNonNull(sipTrunkServiceAddressId, "The required parameter 'sipTrunkServiceAddressId' is missing.");
            this.callsPublicSipTrunkServiceAddressRequest = Objects.requireNonNull(callsPublicSipTrunkServiceAddressRequest, "The required parameter 'callsPublicSipTrunkServiceAddressRequest' is missing.");
        }

        public CallsPublicSipTrunkServiceAddress execute() throws ApiException {
            RequestDefinition updateSipTrunkServiceAddressDefinition = CallsApi.this.updateSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId, this.callsPublicSipTrunkServiceAddressRequest);
            return (CallsPublicSipTrunkServiceAddress)CallsApi.this.apiClient.execute(updateSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsPublicSipTrunkServiceAddress> callback) {
            RequestDefinition updateSipTrunkServiceAddressDefinition = CallsApi.this.updateSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId, this.callsPublicSipTrunkServiceAddressRequest);
            return CallsApi.this.apiClient.executeAsync(updateSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType(), callback);
        }
    }

    public class UpdateSipTrunkRequest {
        private final String sipTrunkId;
        private final CallsSipTrunkUpdateRequest callsSipTrunkUpdateRequest;

        private UpdateSipTrunkRequest(String sipTrunkId, CallsSipTrunkUpdateRequest callsSipTrunkUpdateRequest) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
            this.callsSipTrunkUpdateRequest = Objects.requireNonNull(callsSipTrunkUpdateRequest, "The required parameter 'callsSipTrunkUpdateRequest' is missing.");
        }

        public CallsSipTrunkResponse execute() throws ApiException {
            RequestDefinition updateSipTrunkDefinition = CallsApi.this.updateSipTrunkDefinition(this.sipTrunkId, this.callsSipTrunkUpdateRequest);
            return (CallsSipTrunkResponse)CallsApi.this.apiClient.execute(updateSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkResponse> callback) {
            RequestDefinition updateSipTrunkDefinition = CallsApi.this.updateSipTrunkDefinition(this.sipTrunkId, this.callsSipTrunkUpdateRequest);
            return CallsApi.this.apiClient.executeAsync(updateSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType(), callback);
        }
    }

    public class UpdateMediaStreamConfigRequest {
        private final String mediaStreamConfigId;
        private final CallsMediaStreamConfigRequest callsMediaStreamConfigRequest;

        private UpdateMediaStreamConfigRequest(String mediaStreamConfigId, CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
            this.mediaStreamConfigId = Objects.requireNonNull(mediaStreamConfigId, "The required parameter 'mediaStreamConfigId' is missing.");
            this.callsMediaStreamConfigRequest = Objects.requireNonNull(callsMediaStreamConfigRequest, "The required parameter 'callsMediaStreamConfigRequest' is missing.");
        }

        public CallsMediaStreamConfigResponse execute() throws ApiException {
            RequestDefinition updateMediaStreamConfigDefinition = CallsApi.this.updateMediaStreamConfigDefinition(this.mediaStreamConfigId, this.callsMediaStreamConfigRequest);
            return (CallsMediaStreamConfigResponse)CallsApi.this.apiClient.execute(updateMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsMediaStreamConfigResponse> callback) {
            RequestDefinition updateMediaStreamConfigDefinition = CallsApi.this.updateMediaStreamConfigDefinition(this.mediaStreamConfigId, this.callsMediaStreamConfigRequest);
            return CallsApi.this.apiClient.executeAsync(updateMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType(), callback);
        }
    }

    public class UpdateConferenceCallRequest {
        private final String conferenceId;
        private final String callId;
        private final CallsUpdateCallRequest callsUpdateCallRequest;

        private UpdateConferenceCallRequest(String conferenceId, String callId, CallsUpdateCallRequest callsUpdateCallRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsUpdateCallRequest = Objects.requireNonNull(callsUpdateCallRequest, "The required parameter 'callsUpdateCallRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition updateConferenceCallDefinition = CallsApi.this.updateConferenceCallDefinition(this.conferenceId, this.callId, this.callsUpdateCallRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(updateConferenceCallDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition updateConferenceCallDefinition = CallsApi.this.updateConferenceCallDefinition(this.conferenceId, this.callId, this.callsUpdateCallRequest);
            return CallsApi.this.apiClient.executeAsync(updateConferenceCallDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class UpdateConferenceRequest {
        private final String conferenceId;
        private final CallsUpdateRequest callsUpdateRequest;

        private UpdateConferenceRequest(String conferenceId, CallsUpdateRequest callsUpdateRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsUpdateRequest = Objects.requireNonNull(callsUpdateRequest, "The required parameter 'callsUpdateRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition updateConferenceDefinition = CallsApi.this.updateConferenceDefinition(this.conferenceId, this.callsUpdateRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(updateConferenceDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition updateConferenceDefinition = CallsApi.this.updateConferenceDefinition(this.conferenceId, this.callsUpdateRequest);
            return CallsApi.this.apiClient.executeAsync(updateConferenceDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class UpdateCallsConfigurationRequest {
        private final String callsConfigurationId;
        private final CallsConfigurationUpdateRequest callsConfigurationUpdateRequest;

        private UpdateCallsConfigurationRequest(String callsConfigurationId, CallsConfigurationUpdateRequest callsConfigurationUpdateRequest) {
            this.callsConfigurationId = Objects.requireNonNull(callsConfigurationId, "The required parameter 'callsConfigurationId' is missing.");
            this.callsConfigurationUpdateRequest = Objects.requireNonNull(callsConfigurationUpdateRequest, "The required parameter 'callsConfigurationUpdateRequest' is missing.");
        }

        public CallsConfigurationResponse execute() throws ApiException {
            RequestDefinition updateCallsConfigurationDefinition = CallsApi.this.updateCallsConfigurationDefinition(this.callsConfigurationId, this.callsConfigurationUpdateRequest);
            return (CallsConfigurationResponse)CallsApi.this.apiClient.execute(updateCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConfigurationResponse> callback) {
            RequestDefinition updateCallsConfigurationDefinition = CallsApi.this.updateCallsConfigurationDefinition(this.callsConfigurationId, this.callsConfigurationUpdateRequest);
            return CallsApi.this.apiClient.executeAsync(updateCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class StopMediaStreamRequest {
        private final String callId;

        private StopMediaStreamRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition stopMediaStreamDefinition = CallsApi.this.stopMediaStreamDefinition(this.callId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(stopMediaStreamDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition stopMediaStreamDefinition = CallsApi.this.stopMediaStreamDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(stopMediaStreamDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class StartMediaStreamRequest {
        private final String callId;
        private final CallsStartMediaStreamRequest callsStartMediaStreamRequest;

        private StartMediaStreamRequest(String callId, CallsStartMediaStreamRequest callsStartMediaStreamRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsStartMediaStreamRequest = Objects.requireNonNull(callsStartMediaStreamRequest, "The required parameter 'callsStartMediaStreamRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition startMediaStreamDefinition = CallsApi.this.startMediaStreamDefinition(this.callId, this.callsStartMediaStreamRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(startMediaStreamDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition startMediaStreamDefinition = CallsApi.this.startMediaStreamDefinition(this.callId, this.callsStartMediaStreamRequest);
            return CallsApi.this.apiClient.executeAsync(startMediaStreamDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class SetSipTrunkStatusRequest {
        private final String sipTrunkId;
        private final CallsSipTrunkStatusRequest callsSipTrunkStatusRequest;

        private SetSipTrunkStatusRequest(String sipTrunkId, CallsSipTrunkStatusRequest callsSipTrunkStatusRequest) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
            this.callsSipTrunkStatusRequest = Objects.requireNonNull(callsSipTrunkStatusRequest, "The required parameter 'callsSipTrunkStatusRequest' is missing.");
        }

        public CallsSipTrunkStatusResponse execute() throws ApiException {
            RequestDefinition setSipTrunkStatusDefinition = CallsApi.this.setSipTrunkStatusDefinition(this.sipTrunkId, this.callsSipTrunkStatusRequest);
            return (CallsSipTrunkStatusResponse)CallsApi.this.apiClient.execute(setSipTrunkStatusDefinition, new TypeReference<CallsSipTrunkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkStatusResponse> callback) {
            RequestDefinition setSipTrunkStatusDefinition = CallsApi.this.setSipTrunkStatusDefinition(this.sipTrunkId, this.callsSipTrunkStatusRequest);
            return CallsApi.this.apiClient.executeAsync(setSipTrunkStatusDefinition, new TypeReference<CallsSipTrunkStatusResponse>(){}.getType(), callback);
        }
    }

    public class SendRingingRequest {
        private final String callId;

        private SendRingingRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition sendRingingDefinition = CallsApi.this.sendRingingDefinition(this.callId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(sendRingingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition sendRingingDefinition = CallsApi.this.sendRingingDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(sendRingingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ResumeBulkRequest {
        private final String bulkId;

        private ResumeBulkRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallBulkStatus execute() throws ApiException {
            RequestDefinition resumeBulkDefinition = CallsApi.this.resumeBulkDefinition(this.bulkId);
            return (CallBulkStatus)CallsApi.this.apiClient.execute(resumeBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkStatus> callback) {
            RequestDefinition resumeBulkDefinition = CallsApi.this.resumeBulkDefinition(this.bulkId);
            return CallsApi.this.apiClient.executeAsync(resumeBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType(), callback);
        }
    }

    public class ResetSipTrunkPasswordRequest {
        private final String sipTrunkId;

        private ResetSipTrunkPasswordRequest(String sipTrunkId) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
        }

        public CallsSipTrunkRegistrationCredentials execute() throws ApiException {
            RequestDefinition resetSipTrunkPasswordDefinition = CallsApi.this.resetSipTrunkPasswordDefinition(this.sipTrunkId);
            return (CallsSipTrunkRegistrationCredentials)CallsApi.this.apiClient.execute(resetSipTrunkPasswordDefinition, new TypeReference<CallsSipTrunkRegistrationCredentials>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkRegistrationCredentials> callback) {
            RequestDefinition resetSipTrunkPasswordDefinition = CallsApi.this.resetSipTrunkPasswordDefinition(this.sipTrunkId);
            return CallsApi.this.apiClient.executeAsync(resetSipTrunkPasswordDefinition, new TypeReference<CallsSipTrunkRegistrationCredentials>(){}.getType(), callback);
        }
    }

    public class RescheduleBulkRequest {
        private final String bulkId;
        private final CallsRescheduleRequest callsRescheduleRequest;

        private RescheduleBulkRequest(String bulkId, CallsRescheduleRequest callsRescheduleRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.callsRescheduleRequest = Objects.requireNonNull(callsRescheduleRequest, "The required parameter 'callsRescheduleRequest' is missing.");
        }

        public CallBulkStatus execute() throws ApiException {
            RequestDefinition rescheduleBulkDefinition = CallsApi.this.rescheduleBulkDefinition(this.bulkId, this.callsRescheduleRequest);
            return (CallBulkStatus)CallsApi.this.apiClient.execute(rescheduleBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkStatus> callback) {
            RequestDefinition rescheduleBulkDefinition = CallsApi.this.rescheduleBulkDefinition(this.bulkId, this.callsRescheduleRequest);
            return CallsApi.this.apiClient.executeAsync(rescheduleBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType(), callback);
        }
    }

    public class RemoveConferenceCallRequest {
        private final String conferenceId;
        private final String callId;

        private RemoveConferenceCallRequest(String conferenceId, String callId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition removeConferenceCallDefinition = CallsApi.this.removeConferenceCallDefinition(this.conferenceId, this.callId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(removeConferenceCallDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition removeConferenceCallDefinition = CallsApi.this.removeConferenceCallDefinition(this.conferenceId, this.callId);
            return CallsApi.this.apiClient.executeAsync(removeConferenceCallDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class PreAnswerCallRequest {
        private final String callId;
        private final CallsPreAnswerRequest callsPreAnswerRequest;

        private PreAnswerCallRequest(String callId, CallsPreAnswerRequest callsPreAnswerRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsPreAnswerRequest = Objects.requireNonNull(callsPreAnswerRequest, "The required parameter 'callsPreAnswerRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition preAnswerCallDefinition = CallsApi.this.preAnswerCallDefinition(this.callId, this.callsPreAnswerRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(preAnswerCallDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition preAnswerCallDefinition = CallsApi.this.preAnswerCallDefinition(this.callId, this.callsPreAnswerRequest);
            return CallsApi.this.apiClient.executeAsync(preAnswerCallDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class PauseBulkRequest {
        private final String bulkId;

        private PauseBulkRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallBulkStatus execute() throws ApiException {
            RequestDefinition pauseBulkDefinition = CallsApi.this.pauseBulkDefinition(this.bulkId);
            return (CallBulkStatus)CallsApi.this.apiClient.execute(pauseBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkStatus> callback) {
            RequestDefinition pauseBulkDefinition = CallsApi.this.pauseBulkDefinition(this.bulkId);
            return CallsApi.this.apiClient.executeAsync(pauseBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType(), callback);
        }
    }

    public class HangupDialogRequest {
        private final String dialogId;

        private HangupDialogRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public CallsDialogResponse execute() throws ApiException {
            RequestDefinition hangupDialogDefinition = CallsApi.this.hangupDialogDefinition(this.dialogId);
            return (CallsDialogResponse)CallsApi.this.apiClient.execute(hangupDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogResponse> callback) {
            RequestDefinition hangupDialogDefinition = CallsApi.this.hangupDialogDefinition(this.dialogId);
            return CallsApi.this.apiClient.executeAsync(hangupDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType(), callback);
        }
    }

    public class HangupConferenceRequest {
        private final String conferenceId;

        private HangupConferenceRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public CallsConference execute() throws ApiException {
            RequestDefinition hangupConferenceDefinition = CallsApi.this.hangupConferenceDefinition(this.conferenceId);
            return (CallsConference)CallsApi.this.apiClient.execute(hangupConferenceDefinition, new TypeReference<CallsConference>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConference> callback) {
            RequestDefinition hangupConferenceDefinition = CallsApi.this.hangupConferenceDefinition(this.conferenceId);
            return CallsApi.this.apiClient.executeAsync(hangupConferenceDefinition, new TypeReference<CallsConference>(){}.getType(), callback);
        }
    }

    public class HangupCallRequest {
        private final String callId;
        private final CallsHangupRequest callsHangupRequest;

        private HangupCallRequest(String callId, CallsHangupRequest callsHangupRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsHangupRequest = Objects.requireNonNull(callsHangupRequest, "The required parameter 'callsHangupRequest' is missing.");
        }

        public com.infobip.model.Call execute() throws ApiException {
            RequestDefinition hangupCallDefinition = CallsApi.this.hangupCallDefinition(this.callId, this.callsHangupRequest);
            return (com.infobip.model.Call)CallsApi.this.apiClient.execute(hangupCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType());
        }

        public Call executeAsync(ApiCallback<com.infobip.model.Call> callback) {
            RequestDefinition hangupCallDefinition = CallsApi.this.hangupCallDefinition(this.callId, this.callsHangupRequest);
            return CallsApi.this.apiClient.executeAsync(hangupCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType(), callback);
        }
    }

    public class GetSipTrunksRequest {
        private String name;
        private Integer page;
        private Integer size;

        private GetSipTrunksRequest() {
        }

        public GetSipTrunksRequest name(String name) {
            this.name = name;
            return this;
        }

        public GetSipTrunksRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetSipTrunksRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsSipTrunkPage execute() throws ApiException {
            RequestDefinition getSipTrunksDefinition = CallsApi.this.getSipTrunksDefinition(this.name, this.page, this.size);
            return (CallsSipTrunkPage)CallsApi.this.apiClient.execute(getSipTrunksDefinition, new TypeReference<CallsSipTrunkPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkPage> callback) {
            RequestDefinition getSipTrunksDefinition = CallsApi.this.getSipTrunksDefinition(this.name, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getSipTrunksDefinition, new TypeReference<CallsSipTrunkPage>(){}.getType(), callback);
        }
    }

    public class GetSipTrunkStatusRequest {
        private final String sipTrunkId;

        private GetSipTrunkStatusRequest(String sipTrunkId) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
        }

        public CallsExtendedSipTrunkStatusResponse execute() throws ApiException {
            RequestDefinition getSipTrunkStatusDefinition = CallsApi.this.getSipTrunkStatusDefinition(this.sipTrunkId);
            return (CallsExtendedSipTrunkStatusResponse)CallsApi.this.apiClient.execute(getSipTrunkStatusDefinition, new TypeReference<CallsExtendedSipTrunkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsExtendedSipTrunkStatusResponse> callback) {
            RequestDefinition getSipTrunkStatusDefinition = CallsApi.this.getSipTrunkStatusDefinition(this.sipTrunkId);
            return CallsApi.this.apiClient.executeAsync(getSipTrunkStatusDefinition, new TypeReference<CallsExtendedSipTrunkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetSipTrunkServiceAddressesRequest {
        private Integer page;
        private Integer size;

        private GetSipTrunkServiceAddressesRequest() {
        }

        public GetSipTrunkServiceAddressesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetSipTrunkServiceAddressesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsSipTrunkServiceAddressPage execute() throws ApiException {
            RequestDefinition getSipTrunkServiceAddressesDefinition = CallsApi.this.getSipTrunkServiceAddressesDefinition(this.page, this.size);
            return (CallsSipTrunkServiceAddressPage)CallsApi.this.apiClient.execute(getSipTrunkServiceAddressesDefinition, new TypeReference<CallsSipTrunkServiceAddressPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkServiceAddressPage> callback) {
            RequestDefinition getSipTrunkServiceAddressesDefinition = CallsApi.this.getSipTrunkServiceAddressesDefinition(this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getSipTrunkServiceAddressesDefinition, new TypeReference<CallsSipTrunkServiceAddressPage>(){}.getType(), callback);
        }
    }

    public class GetSipTrunkServiceAddressRequest {
        private final String sipTrunkServiceAddressId;

        private GetSipTrunkServiceAddressRequest(String sipTrunkServiceAddressId) {
            this.sipTrunkServiceAddressId = Objects.requireNonNull(sipTrunkServiceAddressId, "The required parameter 'sipTrunkServiceAddressId' is missing.");
        }

        public CallsPublicSipTrunkServiceAddress execute() throws ApiException {
            RequestDefinition getSipTrunkServiceAddressDefinition = CallsApi.this.getSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId);
            return (CallsPublicSipTrunkServiceAddress)CallsApi.this.apiClient.execute(getSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsPublicSipTrunkServiceAddress> callback) {
            RequestDefinition getSipTrunkServiceAddressDefinition = CallsApi.this.getSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId);
            return CallsApi.this.apiClient.executeAsync(getSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType(), callback);
        }
    }

    public class GetSipTrunkRequest {
        private final String sipTrunkId;

        private GetSipTrunkRequest(String sipTrunkId) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
        }

        public CallsSipTrunkResponse execute() throws ApiException {
            RequestDefinition getSipTrunkDefinition = CallsApi.this.getSipTrunkDefinition(this.sipTrunkId);
            return (CallsSipTrunkResponse)CallsApi.this.apiClient.execute(getSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkResponse> callback) {
            RequestDefinition getSipTrunkDefinition = CallsApi.this.getSipTrunkDefinition(this.sipTrunkId);
            return CallsApi.this.apiClient.executeAsync(getSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType(), callback);
        }
    }

    public class GetRegionsRequest {
        private final String countryCode;

        private GetRegionsRequest(String countryCode) {
            this.countryCode = Objects.requireNonNull(countryCode, "The required parameter 'countryCode' is missing.");
        }

        public List<CallsPublicRegion> execute() throws ApiException {
            RequestDefinition getRegionsDefinition = CallsApi.this.getRegionsDefinition(this.countryCode);
            return (List)CallsApi.this.apiClient.execute(getRegionsDefinition, new TypeReference<List<CallsPublicRegion>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<CallsPublicRegion>> callback) {
            RequestDefinition getRegionsDefinition = CallsApi.this.getRegionsDefinition(this.countryCode);
            return CallsApi.this.apiClient.executeAsync(getRegionsDefinition, new TypeReference<List<CallsPublicRegion>>(){}.getType(), callback);
        }
    }

    public class GetMediaStreamConfigsRequest {
        private Integer page;
        private Integer size;

        private GetMediaStreamConfigsRequest() {
        }

        public GetMediaStreamConfigsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetMediaStreamConfigsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsMediaStreamConfigPage execute() throws ApiException {
            RequestDefinition getMediaStreamConfigsDefinition = CallsApi.this.getMediaStreamConfigsDefinition(this.page, this.size);
            return (CallsMediaStreamConfigPage)CallsApi.this.apiClient.execute(getMediaStreamConfigsDefinition, new TypeReference<CallsMediaStreamConfigPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsMediaStreamConfigPage> callback) {
            RequestDefinition getMediaStreamConfigsDefinition = CallsApi.this.getMediaStreamConfigsDefinition(this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getMediaStreamConfigsDefinition, new TypeReference<CallsMediaStreamConfigPage>(){}.getType(), callback);
        }
    }

    public class GetMediaStreamConfigRequest {
        private final String mediaStreamConfigId;

        private GetMediaStreamConfigRequest(String mediaStreamConfigId) {
            this.mediaStreamConfigId = Objects.requireNonNull(mediaStreamConfigId, "The required parameter 'mediaStreamConfigId' is missing.");
        }

        public CallsMediaStreamConfigResponse execute() throws ApiException {
            RequestDefinition getMediaStreamConfigDefinition = CallsApi.this.getMediaStreamConfigDefinition(this.mediaStreamConfigId);
            return (CallsMediaStreamConfigResponse)CallsApi.this.apiClient.execute(getMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsMediaStreamConfigResponse> callback) {
            RequestDefinition getMediaStreamConfigDefinition = CallsApi.this.getMediaStreamConfigDefinition(this.mediaStreamConfigId);
            return CallsApi.this.apiClient.executeAsync(getMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType(), callback);
        }
    }

    public class GetDialogsRecordingsRequest {
        private String dialogId;
        private String callsConfigurationId;
        private String applicationId;
        private String entityId;
        private String callId;
        private CallEndpointType callEndpointType;
        private String callEndpointIdentifier;
        private OffsetDateTime startTimeAfter;
        private OffsetDateTime endTimeBefore;
        private Boolean composition;
        private CallsRecordingLocation location;
        private Integer page;
        private Integer size;

        private GetDialogsRecordingsRequest() {
        }

        public GetDialogsRecordingsRequest dialogId(String dialogId) {
            this.dialogId = dialogId;
            return this;
        }

        public GetDialogsRecordingsRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetDialogsRecordingsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetDialogsRecordingsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetDialogsRecordingsRequest callId(String callId) {
            this.callId = callId;
            return this;
        }

        public GetDialogsRecordingsRequest callEndpointType(CallEndpointType callEndpointType) {
            this.callEndpointType = callEndpointType;
            return this;
        }

        public GetDialogsRecordingsRequest callEndpointIdentifier(String callEndpointIdentifier) {
            this.callEndpointIdentifier = callEndpointIdentifier;
            return this;
        }

        public GetDialogsRecordingsRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetDialogsRecordingsRequest endTimeBefore(OffsetDateTime endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public GetDialogsRecordingsRequest composition(Boolean composition) {
            this.composition = composition;
            return this;
        }

        public GetDialogsRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public GetDialogsRecordingsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDialogsRecordingsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsDialogRecordingPage execute() throws ApiException {
            RequestDefinition getDialogsRecordingsDefinition = CallsApi.this.getDialogsRecordingsDefinition(this.dialogId, this.callsConfigurationId, this.applicationId, this.entityId, this.callId, this.callEndpointType, this.callEndpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.composition, this.location, this.page, this.size);
            return (CallsDialogRecordingPage)CallsApi.this.apiClient.execute(getDialogsRecordingsDefinition, new TypeReference<CallsDialogRecordingPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogRecordingPage> callback) {
            RequestDefinition getDialogsRecordingsDefinition = CallsApi.this.getDialogsRecordingsDefinition(this.dialogId, this.callsConfigurationId, this.applicationId, this.entityId, this.callId, this.callEndpointType, this.callEndpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.composition, this.location, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getDialogsRecordingsDefinition, new TypeReference<CallsDialogRecordingPage>(){}.getType(), callback);
        }
    }

    public class GetDialogsHistoryRequest {
        private String callsConfigurationId;
        private String applicationId;
        private CallsDialogState state;
        private String parentCallId;
        private String childCallId;
        private OffsetDateTime startTimeAfter;
        private OffsetDateTime endTimeBefore;
        private Integer page;
        private Integer size;

        private GetDialogsHistoryRequest() {
        }

        public GetDialogsHistoryRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetDialogsHistoryRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetDialogsHistoryRequest state(CallsDialogState state) {
            this.state = state;
            return this;
        }

        public GetDialogsHistoryRequest parentCallId(String parentCallId) {
            this.parentCallId = parentCallId;
            return this;
        }

        public GetDialogsHistoryRequest childCallId(String childCallId) {
            this.childCallId = childCallId;
            return this;
        }

        public GetDialogsHistoryRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetDialogsHistoryRequest endTimeBefore(OffsetDateTime endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public GetDialogsHistoryRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDialogsHistoryRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsDialogLogPage execute() throws ApiException {
            RequestDefinition getDialogsHistoryDefinition = CallsApi.this.getDialogsHistoryDefinition(this.callsConfigurationId, this.applicationId, this.state, this.parentCallId, this.childCallId, this.startTimeAfter, this.endTimeBefore, this.page, this.size);
            return (CallsDialogLogPage)CallsApi.this.apiClient.execute(getDialogsHistoryDefinition, new TypeReference<CallsDialogLogPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogLogPage> callback) {
            RequestDefinition getDialogsHistoryDefinition = CallsApi.this.getDialogsHistoryDefinition(this.callsConfigurationId, this.applicationId, this.state, this.parentCallId, this.childCallId, this.startTimeAfter, this.endTimeBefore, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getDialogsHistoryDefinition, new TypeReference<CallsDialogLogPage>(){}.getType(), callback);
        }
    }

    public class GetDialogsRequest {
        private String callsConfigurationId;
        private String applicationId;
        private CallsDialogState state;
        private String parentCallId;
        private String childCallId;
        private OffsetDateTime startTimeAfter;
        private Integer page;
        private Integer size;

        private GetDialogsRequest() {
        }

        public GetDialogsRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetDialogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetDialogsRequest state(CallsDialogState state) {
            this.state = state;
            return this;
        }

        public GetDialogsRequest parentCallId(String parentCallId) {
            this.parentCallId = parentCallId;
            return this;
        }

        public GetDialogsRequest childCallId(String childCallId) {
            this.childCallId = childCallId;
            return this;
        }

        public GetDialogsRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetDialogsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDialogsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsDialogPage execute() throws ApiException {
            RequestDefinition getDialogsDefinition = CallsApi.this.getDialogsDefinition(this.callsConfigurationId, this.applicationId, this.state, this.parentCallId, this.childCallId, this.startTimeAfter, this.page, this.size);
            return (CallsDialogPage)CallsApi.this.apiClient.execute(getDialogsDefinition, new TypeReference<CallsDialogPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogPage> callback) {
            RequestDefinition getDialogsDefinition = CallsApi.this.getDialogsDefinition(this.callsConfigurationId, this.applicationId, this.state, this.parentCallId, this.childCallId, this.startTimeAfter, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getDialogsDefinition, new TypeReference<CallsDialogPage>(){}.getType(), callback);
        }
    }

    public class GetDialogRecordingsRequest {
        private final String dialogId;
        private CallsRecordingLocation location;

        private GetDialogRecordingsRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public GetDialogRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsDialogRecordingResponse execute() throws ApiException {
            RequestDefinition getDialogRecordingsDefinition = CallsApi.this.getDialogRecordingsDefinition(this.dialogId, this.location);
            return (CallsDialogRecordingResponse)CallsApi.this.apiClient.execute(getDialogRecordingsDefinition, new TypeReference<CallsDialogRecordingResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogRecordingResponse> callback) {
            RequestDefinition getDialogRecordingsDefinition = CallsApi.this.getDialogRecordingsDefinition(this.dialogId, this.location);
            return CallsApi.this.apiClient.executeAsync(getDialogRecordingsDefinition, new TypeReference<CallsDialogRecordingResponse>(){}.getType(), callback);
        }
    }

    public class GetDialogHistoryRequest {
        private final String dialogId;

        private GetDialogHistoryRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public CallsDialogLogResponse execute() throws ApiException {
            RequestDefinition getDialogHistoryDefinition = CallsApi.this.getDialogHistoryDefinition(this.dialogId);
            return (CallsDialogLogResponse)CallsApi.this.apiClient.execute(getDialogHistoryDefinition, new TypeReference<CallsDialogLogResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogLogResponse> callback) {
            RequestDefinition getDialogHistoryDefinition = CallsApi.this.getDialogHistoryDefinition(this.dialogId);
            return CallsApi.this.apiClient.executeAsync(getDialogHistoryDefinition, new TypeReference<CallsDialogLogResponse>(){}.getType(), callback);
        }
    }

    public class GetDialogRequest {
        private final String dialogId;

        private GetDialogRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public CallsDialogResponse execute() throws ApiException {
            RequestDefinition getDialogDefinition = CallsApi.this.getDialogDefinition(this.dialogId);
            return (CallsDialogResponse)CallsApi.this.apiClient.execute(getDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogResponse> callback) {
            RequestDefinition getDialogDefinition = CallsApi.this.getDialogDefinition(this.dialogId);
            return CallsApi.this.apiClient.executeAsync(getDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType(), callback);
        }
    }

    public class GetCountriesRequest {
        private GetCountriesRequest() {
        }

        public List<CallsPublicCountry> execute() throws ApiException {
            RequestDefinition getCountriesDefinition = CallsApi.this.getCountriesDefinition();
            return (List)CallsApi.this.apiClient.execute(getCountriesDefinition, new TypeReference<List<CallsPublicCountry>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<CallsPublicCountry>> callback) {
            RequestDefinition getCountriesDefinition = CallsApi.this.getCountriesDefinition();
            return CallsApi.this.apiClient.executeAsync(getCountriesDefinition, new TypeReference<List<CallsPublicCountry>>(){}.getType(), callback);
        }
    }

    public class GetConferencesRecordingsRequest {
        private String conferenceId;
        private String callsConfigurationId;
        private String applicationId;
        private String entityId;
        private String conferenceName;
        private String callId;
        private CallEndpointType callEndpointType;
        private String callEndpointIdentifier;
        private OffsetDateTime startTimeAfter;
        private OffsetDateTime endTimeBefore;
        private Boolean composition;
        private CallsRecordingLocation location;
        private Integer page;
        private Integer size;

        private GetConferencesRecordingsRequest() {
        }

        public GetConferencesRecordingsRequest conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            return this;
        }

        public GetConferencesRecordingsRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetConferencesRecordingsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetConferencesRecordingsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetConferencesRecordingsRequest conferenceName(String conferenceName) {
            this.conferenceName = conferenceName;
            return this;
        }

        public GetConferencesRecordingsRequest callId(String callId) {
            this.callId = callId;
            return this;
        }

        public GetConferencesRecordingsRequest callEndpointType(CallEndpointType callEndpointType) {
            this.callEndpointType = callEndpointType;
            return this;
        }

        public GetConferencesRecordingsRequest callEndpointIdentifier(String callEndpointIdentifier) {
            this.callEndpointIdentifier = callEndpointIdentifier;
            return this;
        }

        public GetConferencesRecordingsRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetConferencesRecordingsRequest endTimeBefore(OffsetDateTime endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public GetConferencesRecordingsRequest composition(Boolean composition) {
            this.composition = composition;
            return this;
        }

        public GetConferencesRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public GetConferencesRecordingsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetConferencesRecordingsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsConferenceRecordingPage execute() throws ApiException {
            RequestDefinition getConferencesRecordingsDefinition = CallsApi.this.getConferencesRecordingsDefinition(this.conferenceId, this.callsConfigurationId, this.applicationId, this.entityId, this.conferenceName, this.callId, this.callEndpointType, this.callEndpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.composition, this.location, this.page, this.size);
            return (CallsConferenceRecordingPage)CallsApi.this.apiClient.execute(getConferencesRecordingsDefinition, new TypeReference<CallsConferenceRecordingPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceRecordingPage> callback) {
            RequestDefinition getConferencesRecordingsDefinition = CallsApi.this.getConferencesRecordingsDefinition(this.conferenceId, this.callsConfigurationId, this.applicationId, this.entityId, this.conferenceName, this.callId, this.callEndpointType, this.callEndpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.composition, this.location, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getConferencesRecordingsDefinition, new TypeReference<CallsConferenceRecordingPage>(){}.getType(), callback);
        }
    }

    public class GetConferencesHistoryRequest {
        private String name;
        private String callId;
        private String callsConfigurationId;
        private String applicationId;
        private OffsetDateTime startTimeAfter;
        private OffsetDateTime endTimeBefore;
        private Integer page;
        private Integer size;

        private GetConferencesHistoryRequest() {
        }

        public GetConferencesHistoryRequest name(String name) {
            this.name = name;
            return this;
        }

        public GetConferencesHistoryRequest callId(String callId) {
            this.callId = callId;
            return this;
        }

        public GetConferencesHistoryRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetConferencesHistoryRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetConferencesHistoryRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetConferencesHistoryRequest endTimeBefore(OffsetDateTime endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public GetConferencesHistoryRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetConferencesHistoryRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsConferenceLogPage execute() throws ApiException {
            RequestDefinition getConferencesHistoryDefinition = CallsApi.this.getConferencesHistoryDefinition(this.name, this.callId, this.callsConfigurationId, this.applicationId, this.startTimeAfter, this.endTimeBefore, this.page, this.size);
            return (CallsConferenceLogPage)CallsApi.this.apiClient.execute(getConferencesHistoryDefinition, new TypeReference<CallsConferenceLogPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceLogPage> callback) {
            RequestDefinition getConferencesHistoryDefinition = CallsApi.this.getConferencesHistoryDefinition(this.name, this.callId, this.callsConfigurationId, this.applicationId, this.startTimeAfter, this.endTimeBefore, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getConferencesHistoryDefinition, new TypeReference<CallsConferenceLogPage>(){}.getType(), callback);
        }
    }

    public class GetConferencesRequest {
        private String name;
        private String callId;
        private String callsConfigurationId;
        private String applicationId;
        private OffsetDateTime startTimeAfter;
        private Integer page;
        private Integer size;

        private GetConferencesRequest() {
        }

        public GetConferencesRequest name(String name) {
            this.name = name;
            return this;
        }

        public GetConferencesRequest callId(String callId) {
            this.callId = callId;
            return this;
        }

        public GetConferencesRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetConferencesRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetConferencesRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetConferencesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetConferencesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsConferencePage execute() throws ApiException {
            RequestDefinition getConferencesDefinition = CallsApi.this.getConferencesDefinition(this.name, this.callId, this.callsConfigurationId, this.applicationId, this.startTimeAfter, this.page, this.size);
            return (CallsConferencePage)CallsApi.this.apiClient.execute(getConferencesDefinition, new TypeReference<CallsConferencePage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferencePage> callback) {
            RequestDefinition getConferencesDefinition = CallsApi.this.getConferencesDefinition(this.name, this.callId, this.callsConfigurationId, this.applicationId, this.startTimeAfter, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getConferencesDefinition, new TypeReference<CallsConferencePage>(){}.getType(), callback);
        }
    }

    public class GetConferenceRecordingsRequest {
        private final String conferenceId;
        private CallsRecordingLocation location;

        private GetConferenceRecordingsRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public GetConferenceRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsConferenceRecording execute() throws ApiException {
            RequestDefinition getConferenceRecordingsDefinition = CallsApi.this.getConferenceRecordingsDefinition(this.conferenceId, this.location);
            return (CallsConferenceRecording)CallsApi.this.apiClient.execute(getConferenceRecordingsDefinition, new TypeReference<CallsConferenceRecording>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceRecording> callback) {
            RequestDefinition getConferenceRecordingsDefinition = CallsApi.this.getConferenceRecordingsDefinition(this.conferenceId, this.location);
            return CallsApi.this.apiClient.executeAsync(getConferenceRecordingsDefinition, new TypeReference<CallsConferenceRecording>(){}.getType(), callback);
        }
    }

    public class GetConferenceHistoryRequest {
        private final String conferenceId;

        private GetConferenceHistoryRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public CallsConferenceLog execute() throws ApiException {
            RequestDefinition getConferenceHistoryDefinition = CallsApi.this.getConferenceHistoryDefinition(this.conferenceId);
            return (CallsConferenceLog)CallsApi.this.apiClient.execute(getConferenceHistoryDefinition, new TypeReference<CallsConferenceLog>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceLog> callback) {
            RequestDefinition getConferenceHistoryDefinition = CallsApi.this.getConferenceHistoryDefinition(this.conferenceId);
            return CallsApi.this.apiClient.executeAsync(getConferenceHistoryDefinition, new TypeReference<CallsConferenceLog>(){}.getType(), callback);
        }
    }

    public class GetConferenceRequest {
        private final String conferenceId;

        private GetConferenceRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public CallsConference execute() throws ApiException {
            RequestDefinition getConferenceDefinition = CallsApi.this.getConferenceDefinition(this.conferenceId);
            return (CallsConference)CallsApi.this.apiClient.execute(getConferenceDefinition, new TypeReference<CallsConference>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConference> callback) {
            RequestDefinition getConferenceDefinition = CallsApi.this.getConferenceDefinition(this.conferenceId);
            return CallsApi.this.apiClient.executeAsync(getConferenceDefinition, new TypeReference<CallsConference>(){}.getType(), callback);
        }
    }

    public class GetCallsRecordingsRequest {
        private String callId;
        private String callsConfigurationId;
        private String applicationId;
        private String entityId;
        private String endpointIdentifier;
        private OffsetDateTime startTimeAfter;
        private OffsetDateTime endTimeBefore;
        private CallDirection direction;
        private CallEndpointType endpointType;
        private CallsRecordingLocation location;
        private Integer page;
        private Integer size;

        private GetCallsRecordingsRequest() {
        }

        public GetCallsRecordingsRequest callId(String callId) {
            this.callId = callId;
            return this;
        }

        public GetCallsRecordingsRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetCallsRecordingsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetCallsRecordingsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetCallsRecordingsRequest endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public GetCallsRecordingsRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetCallsRecordingsRequest endTimeBefore(OffsetDateTime endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public GetCallsRecordingsRequest direction(CallDirection direction) {
            this.direction = direction;
            return this;
        }

        public GetCallsRecordingsRequest endpointType(CallEndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public GetCallsRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public GetCallsRecordingsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallsRecordingsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallRecordingPage execute() throws ApiException {
            RequestDefinition getCallsRecordingsDefinition = CallsApi.this.getCallsRecordingsDefinition(this.callId, this.callsConfigurationId, this.applicationId, this.entityId, this.endpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.direction, this.endpointType, this.location, this.page, this.size);
            return (CallRecordingPage)CallsApi.this.apiClient.execute(getCallsRecordingsDefinition, new TypeReference<CallRecordingPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRecordingPage> callback) {
            RequestDefinition getCallsRecordingsDefinition = CallsApi.this.getCallsRecordingsDefinition(this.callId, this.callsConfigurationId, this.applicationId, this.entityId, this.endpointIdentifier, this.startTimeAfter, this.endTimeBefore, this.direction, this.endpointType, this.location, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getCallsRecordingsDefinition, new TypeReference<CallRecordingPage>(){}.getType(), callback);
        }
    }

    public class GetCallsHistoryRequest {
        private CallEndpointType type;
        private String callsConfigurationId;
        private String applicationId;
        private String from;
        private String to;
        private CallDirection direction;
        private CallState status;
        private OffsetDateTime startTimeAfter;
        private String conferenceId;
        private String dialogId;
        private String bulkId;
        private Integer page;
        private Integer size;

        private GetCallsHistoryRequest() {
        }

        public GetCallsHistoryRequest type(CallEndpointType type) {
            this.type = type;
            return this;
        }

        public GetCallsHistoryRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetCallsHistoryRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetCallsHistoryRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetCallsHistoryRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetCallsHistoryRequest direction(CallDirection direction) {
            this.direction = direction;
            return this;
        }

        public GetCallsHistoryRequest status(CallState status) {
            this.status = status;
            return this;
        }

        public GetCallsHistoryRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetCallsHistoryRequest conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            return this;
        }

        public GetCallsHistoryRequest dialogId(String dialogId) {
            this.dialogId = dialogId;
            return this;
        }

        public GetCallsHistoryRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetCallsHistoryRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallsHistoryRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallLogPage execute() throws ApiException {
            RequestDefinition getCallsHistoryDefinition = CallsApi.this.getCallsHistoryDefinition(this.type, this.callsConfigurationId, this.applicationId, this.from, this.to, this.direction, this.status, this.startTimeAfter, this.conferenceId, this.dialogId, this.bulkId, this.page, this.size);
            return (CallLogPage)CallsApi.this.apiClient.execute(getCallsHistoryDefinition, new TypeReference<CallLogPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallLogPage> callback) {
            RequestDefinition getCallsHistoryDefinition = CallsApi.this.getCallsHistoryDefinition(this.type, this.callsConfigurationId, this.applicationId, this.from, this.to, this.direction, this.status, this.startTimeAfter, this.conferenceId, this.dialogId, this.bulkId, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getCallsHistoryDefinition, new TypeReference<CallLogPage>(){}.getType(), callback);
        }
    }

    public class GetCallsFilesRequest {
        private Integer page;
        private Integer size;

        private GetCallsFilesRequest() {
        }

        public GetCallsFilesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallsFilesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsFilePage execute() throws ApiException {
            RequestDefinition getCallsFilesDefinition = CallsApi.this.getCallsFilesDefinition(this.page, this.size);
            return (CallsFilePage)CallsApi.this.apiClient.execute(getCallsFilesDefinition, new TypeReference<CallsFilePage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsFilePage> callback) {
            RequestDefinition getCallsFilesDefinition = CallsApi.this.getCallsFilesDefinition(this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getCallsFilesDefinition, new TypeReference<CallsFilePage>(){}.getType(), callback);
        }
    }

    public class GetCallsFileRequest {
        private final String fileId;

        private GetCallsFileRequest(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "The required parameter 'fileId' is missing.");
        }

        public CallsFile execute() throws ApiException {
            RequestDefinition getCallsFileDefinition = CallsApi.this.getCallsFileDefinition(this.fileId);
            return (CallsFile)CallsApi.this.apiClient.execute(getCallsFileDefinition, new TypeReference<CallsFile>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsFile> callback) {
            RequestDefinition getCallsFileDefinition = CallsApi.this.getCallsFileDefinition(this.fileId);
            return CallsApi.this.apiClient.executeAsync(getCallsFileDefinition, new TypeReference<CallsFile>(){}.getType(), callback);
        }
    }

    public class GetCallsConfigurationsRequest {
        private Integer page;
        private Integer size;

        private GetCallsConfigurationsRequest() {
        }

        public GetCallsConfigurationsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallsConfigurationsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallsConfigurationPage execute() throws ApiException {
            RequestDefinition getCallsConfigurationsDefinition = CallsApi.this.getCallsConfigurationsDefinition(this.page, this.size);
            return (CallsConfigurationPage)CallsApi.this.apiClient.execute(getCallsConfigurationsDefinition, new TypeReference<CallsConfigurationPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConfigurationPage> callback) {
            RequestDefinition getCallsConfigurationsDefinition = CallsApi.this.getCallsConfigurationsDefinition(this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getCallsConfigurationsDefinition, new TypeReference<CallsConfigurationPage>(){}.getType(), callback);
        }
    }

    public class GetCallsConfigurationRequest {
        private final String callsConfigurationId;

        private GetCallsConfigurationRequest(String callsConfigurationId) {
            this.callsConfigurationId = Objects.requireNonNull(callsConfigurationId, "The required parameter 'callsConfigurationId' is missing.");
        }

        public CallsConfigurationResponse execute() throws ApiException {
            RequestDefinition getCallsConfigurationDefinition = CallsApi.this.getCallsConfigurationDefinition(this.callsConfigurationId);
            return (CallsConfigurationResponse)CallsApi.this.apiClient.execute(getCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConfigurationResponse> callback) {
            RequestDefinition getCallsConfigurationDefinition = CallsApi.this.getCallsConfigurationDefinition(this.callsConfigurationId);
            return CallsApi.this.apiClient.executeAsync(getCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class GetCallsRequest {
        private CallEndpointType type;
        private String callsConfigurationId;
        private String applicationId;
        private String from;
        private String to;
        private CallDirection direction;
        private CallState status;
        private OffsetDateTime startTimeAfter;
        private String conferenceId;
        private String dialogId;
        private String bulkId;
        private Integer page;
        private Integer size;

        private GetCallsRequest() {
        }

        public GetCallsRequest type(CallEndpointType type) {
            this.type = type;
            return this;
        }

        public GetCallsRequest callsConfigurationId(String callsConfigurationId) {
            this.callsConfigurationId = callsConfigurationId;
            return this;
        }

        public GetCallsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetCallsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetCallsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetCallsRequest direction(CallDirection direction) {
            this.direction = direction;
            return this;
        }

        public GetCallsRequest status(CallState status) {
            this.status = status;
            return this;
        }

        public GetCallsRequest startTimeAfter(OffsetDateTime startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public GetCallsRequest conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            return this;
        }

        public GetCallsRequest dialogId(String dialogId) {
            this.dialogId = dialogId;
            return this;
        }

        public GetCallsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetCallsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCallsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public CallPage execute() throws ApiException {
            RequestDefinition getCallsDefinition = CallsApi.this.getCallsDefinition(this.type, this.callsConfigurationId, this.applicationId, this.from, this.to, this.direction, this.status, this.startTimeAfter, this.conferenceId, this.dialogId, this.bulkId, this.page, this.size);
            return (CallPage)CallsApi.this.apiClient.execute(getCallsDefinition, new TypeReference<CallPage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallPage> callback) {
            RequestDefinition getCallsDefinition = CallsApi.this.getCallsDefinition(this.type, this.callsConfigurationId, this.applicationId, this.from, this.to, this.direction, this.status, this.startTimeAfter, this.conferenceId, this.dialogId, this.bulkId, this.page, this.size);
            return CallsApi.this.apiClient.executeAsync(getCallsDefinition, new TypeReference<CallPage>(){}.getType(), callback);
        }
    }

    public class GetCallRecordingsRequest {
        private final String callId;
        private CallsRecordingLocation location;

        private GetCallRecordingsRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public GetCallRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallRecording execute() throws ApiException {
            RequestDefinition getCallRecordingsDefinition = CallsApi.this.getCallRecordingsDefinition(this.callId, this.location);
            return (CallRecording)CallsApi.this.apiClient.execute(getCallRecordingsDefinition, new TypeReference<CallRecording>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRecording> callback) {
            RequestDefinition getCallRecordingsDefinition = CallsApi.this.getCallRecordingsDefinition(this.callId, this.location);
            return CallsApi.this.apiClient.executeAsync(getCallRecordingsDefinition, new TypeReference<CallRecording>(){}.getType(), callback);
        }
    }

    public class GetCallHistoryRequest {
        private final String callId;

        private GetCallHistoryRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallLog execute() throws ApiException {
            RequestDefinition getCallHistoryDefinition = CallsApi.this.getCallHistoryDefinition(this.callId);
            return (CallLog)CallsApi.this.apiClient.execute(getCallHistoryDefinition, new TypeReference<CallLog>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallLog> callback) {
            RequestDefinition getCallHistoryDefinition = CallsApi.this.getCallHistoryDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(getCallHistoryDefinition, new TypeReference<CallLog>(){}.getType(), callback);
        }
    }

    public class GetCallRequest {
        private final String callId;

        private GetCallRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public com.infobip.model.Call execute() throws ApiException {
            RequestDefinition getCallDefinition = CallsApi.this.getCallDefinition(this.callId);
            return (com.infobip.model.Call)CallsApi.this.apiClient.execute(getCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType());
        }

        public Call executeAsync(ApiCallback<com.infobip.model.Call> callback) {
            RequestDefinition getCallDefinition = CallsApi.this.getCallDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(getCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType(), callback);
        }
    }

    public class GetBulkStatusRequest {
        private final String bulkId;

        private GetBulkStatusRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallBulkStatus execute() throws ApiException {
            RequestDefinition getBulkStatusDefinition = CallsApi.this.getBulkStatusDefinition(this.bulkId);
            return (CallBulkStatus)CallsApi.this.apiClient.execute(getBulkStatusDefinition, new TypeReference<CallBulkStatus>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkStatus> callback) {
            RequestDefinition getBulkStatusDefinition = CallsApi.this.getBulkStatusDefinition(this.bulkId);
            return CallsApi.this.apiClient.executeAsync(getBulkStatusDefinition, new TypeReference<CallBulkStatus>(){}.getType(), callback);
        }
    }

    public class DownloadRecordingFileRequest {
        private final String fileId;
        private CallsRecordingLocation location;
        private String range;

        private DownloadRecordingFileRequest(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "The required parameter 'fileId' is missing.");
        }

        public DownloadRecordingFileRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public DownloadRecordingFileRequest range(String range) {
            this.range = range;
            return this;
        }

        public File execute() throws ApiException {
            RequestDefinition downloadRecordingFileDefinition = CallsApi.this.downloadRecordingFileDefinition(this.fileId, this.location, this.range);
            return (File)CallsApi.this.apiClient.execute(downloadRecordingFileDefinition, new TypeReference<File>(){}.getType());
        }

        public Call executeAsync(ApiCallback<File> callback) {
            RequestDefinition downloadRecordingFileDefinition = CallsApi.this.downloadRecordingFileDefinition(this.fileId, this.location, this.range);
            return CallsApi.this.apiClient.executeAsync(downloadRecordingFileDefinition, new TypeReference<File>(){}.getType(), callback);
        }
    }

    public class DialogStopRecordingRequest {
        private final String dialogId;

        private DialogStopRecordingRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogStopRecordingDefinition = CallsApi.this.dialogStopRecordingDefinition(this.dialogId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogStopRecordingDefinition = CallsApi.this.dialogStopRecordingDefinition(this.dialogId);
            return CallsApi.this.apiClient.executeAsync(dialogStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DialogStopPlayingFileRequest {
        private final String dialogId;

        private DialogStopPlayingFileRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogStopPlayingFileDefinition = CallsApi.this.dialogStopPlayingFileDefinition(this.dialogId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogStopPlayingFileDefinition = CallsApi.this.dialogStopPlayingFileDefinition(this.dialogId);
            return CallsApi.this.apiClient.executeAsync(dialogStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DialogStartRecordingRequest {
        private final String dialogId;
        private final CallsDialogRecordingRequest callsDialogRecordingRequest;

        private DialogStartRecordingRequest(String dialogId, CallsDialogRecordingRequest callsDialogRecordingRequest) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
            this.callsDialogRecordingRequest = Objects.requireNonNull(callsDialogRecordingRequest, "The required parameter 'callsDialogRecordingRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogStartRecordingDefinition = CallsApi.this.dialogStartRecordingDefinition(this.dialogId, this.callsDialogRecordingRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogStartRecordingDefinition = CallsApi.this.dialogStartRecordingDefinition(this.dialogId, this.callsDialogRecordingRequest);
            return CallsApi.this.apiClient.executeAsync(dialogStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DialogSayTextRequest {
        private final String dialogId;
        private final CallsDialogSayRequest callsDialogSayRequest;

        private DialogSayTextRequest(String dialogId, CallsDialogSayRequest callsDialogSayRequest) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
            this.callsDialogSayRequest = Objects.requireNonNull(callsDialogSayRequest, "The required parameter 'callsDialogSayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogSayTextDefinition = CallsApi.this.dialogSayTextDefinition(this.dialogId, this.callsDialogSayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogSayTextDefinition = CallsApi.this.dialogSayTextDefinition(this.dialogId, this.callsDialogSayRequest);
            return CallsApi.this.apiClient.executeAsync(dialogSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DialogPlayFileRequest {
        private final String dialogId;
        private final CallsDialogPlayRequest callsDialogPlayRequest;

        private DialogPlayFileRequest(String dialogId, CallsDialogPlayRequest callsDialogPlayRequest) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
            this.callsDialogPlayRequest = Objects.requireNonNull(callsDialogPlayRequest, "The required parameter 'callsDialogPlayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogPlayFileDefinition = CallsApi.this.dialogPlayFileDefinition(this.dialogId, this.callsDialogPlayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogPlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogPlayFileDefinition = CallsApi.this.dialogPlayFileDefinition(this.dialogId, this.callsDialogPlayRequest);
            return CallsApi.this.apiClient.executeAsync(dialogPlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DialogBroadcastWebrtcTextRequest {
        private final String dialogId;
        private final CallsDialogBroadcastWebrtcTextRequest callsDialogBroadcastWebrtcTextRequest;

        private DialogBroadcastWebrtcTextRequest(String dialogId, CallsDialogBroadcastWebrtcTextRequest callsDialogBroadcastWebrtcTextRequest) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
            this.callsDialogBroadcastWebrtcTextRequest = Objects.requireNonNull(callsDialogBroadcastWebrtcTextRequest, "The required parameter 'callsDialogBroadcastWebrtcTextRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition dialogBroadcastWebrtcTextDefinition = CallsApi.this.dialogBroadcastWebrtcTextDefinition(this.dialogId, this.callsDialogBroadcastWebrtcTextRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(dialogBroadcastWebrtcTextDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition dialogBroadcastWebrtcTextDefinition = CallsApi.this.dialogBroadcastWebrtcTextDefinition(this.dialogId, this.callsDialogBroadcastWebrtcTextRequest);
            return CallsApi.this.apiClient.executeAsync(dialogBroadcastWebrtcTextDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class DeleteSipTrunkServiceAddressRequest {
        private final String sipTrunkServiceAddressId;

        private DeleteSipTrunkServiceAddressRequest(String sipTrunkServiceAddressId) {
            this.sipTrunkServiceAddressId = Objects.requireNonNull(sipTrunkServiceAddressId, "The required parameter 'sipTrunkServiceAddressId' is missing.");
        }

        public CallsPublicSipTrunkServiceAddress execute() throws ApiException {
            RequestDefinition deleteSipTrunkServiceAddressDefinition = CallsApi.this.deleteSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId);
            return (CallsPublicSipTrunkServiceAddress)CallsApi.this.apiClient.execute(deleteSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsPublicSipTrunkServiceAddress> callback) {
            RequestDefinition deleteSipTrunkServiceAddressDefinition = CallsApi.this.deleteSipTrunkServiceAddressDefinition(this.sipTrunkServiceAddressId);
            return CallsApi.this.apiClient.executeAsync(deleteSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType(), callback);
        }
    }

    public class DeleteSipTrunkRequest {
        private final String sipTrunkId;

        private DeleteSipTrunkRequest(String sipTrunkId) {
            this.sipTrunkId = Objects.requireNonNull(sipTrunkId, "The required parameter 'sipTrunkId' is missing.");
        }

        public CallsSipTrunkResponse execute() throws ApiException {
            RequestDefinition deleteSipTrunkDefinition = CallsApi.this.deleteSipTrunkDefinition(this.sipTrunkId);
            return (CallsSipTrunkResponse)CallsApi.this.apiClient.execute(deleteSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsSipTrunkResponse> callback) {
            RequestDefinition deleteSipTrunkDefinition = CallsApi.this.deleteSipTrunkDefinition(this.sipTrunkId);
            return CallsApi.this.apiClient.executeAsync(deleteSipTrunkDefinition, new TypeReference<CallsSipTrunkResponse>(){}.getType(), callback);
        }
    }

    public class DeleteRecordingFileRequest {
        private final String fileId;
        private CallsRecordingLocation location;

        private DeleteRecordingFileRequest(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "The required parameter 'fileId' is missing.");
        }

        public DeleteRecordingFileRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsRecordingFile execute() throws ApiException {
            RequestDefinition deleteRecordingFileDefinition = CallsApi.this.deleteRecordingFileDefinition(this.fileId, this.location);
            return (CallsRecordingFile)CallsApi.this.apiClient.execute(deleteRecordingFileDefinition, new TypeReference<CallsRecordingFile>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsRecordingFile> callback) {
            RequestDefinition deleteRecordingFileDefinition = CallsApi.this.deleteRecordingFileDefinition(this.fileId, this.location);
            return CallsApi.this.apiClient.executeAsync(deleteRecordingFileDefinition, new TypeReference<CallsRecordingFile>(){}.getType(), callback);
        }
    }

    public class DeleteMediaStreamConfigRequest {
        private final String mediaStreamConfigId;

        private DeleteMediaStreamConfigRequest(String mediaStreamConfigId) {
            this.mediaStreamConfigId = Objects.requireNonNull(mediaStreamConfigId, "The required parameter 'mediaStreamConfigId' is missing.");
        }

        public CallsMediaStreamConfigResponse execute() throws ApiException {
            RequestDefinition deleteMediaStreamConfigDefinition = CallsApi.this.deleteMediaStreamConfigDefinition(this.mediaStreamConfigId);
            return (CallsMediaStreamConfigResponse)CallsApi.this.apiClient.execute(deleteMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsMediaStreamConfigResponse> callback) {
            RequestDefinition deleteMediaStreamConfigDefinition = CallsApi.this.deleteMediaStreamConfigDefinition(this.mediaStreamConfigId);
            return CallsApi.this.apiClient.executeAsync(deleteMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType(), callback);
        }
    }

    public class DeleteDialogRecordingsRequest {
        private final String dialogId;
        private CallsRecordingLocation location;

        private DeleteDialogRecordingsRequest(String dialogId) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
        }

        public DeleteDialogRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsDialogRecordingResponse execute() throws ApiException {
            RequestDefinition deleteDialogRecordingsDefinition = CallsApi.this.deleteDialogRecordingsDefinition(this.dialogId, this.location);
            return (CallsDialogRecordingResponse)CallsApi.this.apiClient.execute(deleteDialogRecordingsDefinition, new TypeReference<CallsDialogRecordingResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogRecordingResponse> callback) {
            RequestDefinition deleteDialogRecordingsDefinition = CallsApi.this.deleteDialogRecordingsDefinition(this.dialogId, this.location);
            return CallsApi.this.apiClient.executeAsync(deleteDialogRecordingsDefinition, new TypeReference<CallsDialogRecordingResponse>(){}.getType(), callback);
        }
    }

    public class DeleteConferenceRecordingsRequest {
        private final String conferenceId;
        private CallsRecordingLocation location;

        private DeleteConferenceRecordingsRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public DeleteConferenceRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsConferenceRecording execute() throws ApiException {
            RequestDefinition deleteConferenceRecordingsDefinition = CallsApi.this.deleteConferenceRecordingsDefinition(this.conferenceId, this.location);
            return (CallsConferenceRecording)CallsApi.this.apiClient.execute(deleteConferenceRecordingsDefinition, new TypeReference<CallsConferenceRecording>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceRecording> callback) {
            RequestDefinition deleteConferenceRecordingsDefinition = CallsApi.this.deleteConferenceRecordingsDefinition(this.conferenceId, this.location);
            return CallsApi.this.apiClient.executeAsync(deleteConferenceRecordingsDefinition, new TypeReference<CallsConferenceRecording>(){}.getType(), callback);
        }
    }

    public class DeleteCallsFileRequest {
        private final String fileId;

        private DeleteCallsFileRequest(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "The required parameter 'fileId' is missing.");
        }

        public CallsFile execute() throws ApiException {
            RequestDefinition deleteCallsFileDefinition = CallsApi.this.deleteCallsFileDefinition(this.fileId);
            return (CallsFile)CallsApi.this.apiClient.execute(deleteCallsFileDefinition, new TypeReference<CallsFile>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsFile> callback) {
            RequestDefinition deleteCallsFileDefinition = CallsApi.this.deleteCallsFileDefinition(this.fileId);
            return CallsApi.this.apiClient.executeAsync(deleteCallsFileDefinition, new TypeReference<CallsFile>(){}.getType(), callback);
        }
    }

    public class DeleteCallsConfigurationRequest {
        private final String callsConfigurationId;

        private DeleteCallsConfigurationRequest(String callsConfigurationId) {
            this.callsConfigurationId = Objects.requireNonNull(callsConfigurationId, "The required parameter 'callsConfigurationId' is missing.");
        }

        public CallsConfigurationResponse execute() throws ApiException {
            RequestDefinition deleteCallsConfigurationDefinition = CallsApi.this.deleteCallsConfigurationDefinition(this.callsConfigurationId);
            return (CallsConfigurationResponse)CallsApi.this.apiClient.execute(deleteCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConfigurationResponse> callback) {
            RequestDefinition deleteCallsConfigurationDefinition = CallsApi.this.deleteCallsConfigurationDefinition(this.callsConfigurationId);
            return CallsApi.this.apiClient.executeAsync(deleteCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class DeleteCallRecordingsRequest {
        private final String callId;
        private CallsRecordingLocation location;

        private DeleteCallRecordingsRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public DeleteCallRecordingsRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallRecording execute() throws ApiException {
            RequestDefinition deleteCallRecordingsDefinition = CallsApi.this.deleteCallRecordingsDefinition(this.callId, this.location);
            return (CallRecording)CallsApi.this.apiClient.execute(deleteCallRecordingsDefinition, new TypeReference<CallRecording>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallRecording> callback) {
            RequestDefinition deleteCallRecordingsDefinition = CallsApi.this.deleteCallRecordingsDefinition(this.callId, this.location);
            return CallsApi.this.apiClient.executeAsync(deleteCallRecordingsDefinition, new TypeReference<CallRecording>(){}.getType(), callback);
        }
    }

    public class CreateSipTrunkServiceAddressRequest {
        private final CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest;

        private CreateSipTrunkServiceAddressRequest(CallsPublicSipTrunkServiceAddressRequest callsPublicSipTrunkServiceAddressRequest) {
            this.callsPublicSipTrunkServiceAddressRequest = Objects.requireNonNull(callsPublicSipTrunkServiceAddressRequest, "The required parameter 'callsPublicSipTrunkServiceAddressRequest' is missing.");
        }

        public CallsPublicSipTrunkServiceAddress execute() throws ApiException {
            RequestDefinition createSipTrunkServiceAddressDefinition = CallsApi.this.createSipTrunkServiceAddressDefinition(this.callsPublicSipTrunkServiceAddressRequest);
            return (CallsPublicSipTrunkServiceAddress)CallsApi.this.apiClient.execute(createSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsPublicSipTrunkServiceAddress> callback) {
            RequestDefinition createSipTrunkServiceAddressDefinition = CallsApi.this.createSipTrunkServiceAddressDefinition(this.callsPublicSipTrunkServiceAddressRequest);
            return CallsApi.this.apiClient.executeAsync(createSipTrunkServiceAddressDefinition, new TypeReference<CallsPublicSipTrunkServiceAddress>(){}.getType(), callback);
        }
    }

    public class CreateSipTrunkRequest {
        private final CallsSipTrunkRequest callsSipTrunkRequest;

        private CreateSipTrunkRequest(CallsSipTrunkRequest callsSipTrunkRequest) {
            this.callsSipTrunkRequest = Objects.requireNonNull(callsSipTrunkRequest, "The required parameter 'callsSipTrunkRequest' is missing.");
        }

        public CallsCreateSipTrunkResponse execute() throws ApiException {
            RequestDefinition createSipTrunkDefinition = CallsApi.this.createSipTrunkDefinition(this.callsSipTrunkRequest);
            return (CallsCreateSipTrunkResponse)CallsApi.this.apiClient.execute(createSipTrunkDefinition, new TypeReference<CallsCreateSipTrunkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsCreateSipTrunkResponse> callback) {
            RequestDefinition createSipTrunkDefinition = CallsApi.this.createSipTrunkDefinition(this.callsSipTrunkRequest);
            return CallsApi.this.apiClient.executeAsync(createSipTrunkDefinition, new TypeReference<CallsCreateSipTrunkResponse>(){}.getType(), callback);
        }
    }

    public class CreateMediaStreamConfigRequest {
        private final CallsMediaStreamConfigRequest callsMediaStreamConfigRequest;

        private CreateMediaStreamConfigRequest(CallsMediaStreamConfigRequest callsMediaStreamConfigRequest) {
            this.callsMediaStreamConfigRequest = Objects.requireNonNull(callsMediaStreamConfigRequest, "The required parameter 'callsMediaStreamConfigRequest' is missing.");
        }

        public CallsMediaStreamConfigResponse execute() throws ApiException {
            RequestDefinition createMediaStreamConfigDefinition = CallsApi.this.createMediaStreamConfigDefinition(this.callsMediaStreamConfigRequest);
            return (CallsMediaStreamConfigResponse)CallsApi.this.apiClient.execute(createMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsMediaStreamConfigResponse> callback) {
            RequestDefinition createMediaStreamConfigDefinition = CallsApi.this.createMediaStreamConfigDefinition(this.callsMediaStreamConfigRequest);
            return CallsApi.this.apiClient.executeAsync(createMediaStreamConfigDefinition, new TypeReference<CallsMediaStreamConfigResponse>(){}.getType(), callback);
        }
    }

    public class CreateDialogWithExistingCallsRequest {
        private final String parentCallId;
        private final String childCallId;
        private final CallsDialogWithExistingCallRequest callsDialogWithExistingCallRequest;

        private CreateDialogWithExistingCallsRequest(String parentCallId, String childCallId, CallsDialogWithExistingCallRequest callsDialogWithExistingCallRequest) {
            this.parentCallId = Objects.requireNonNull(parentCallId, "The required parameter 'parentCallId' is missing.");
            this.childCallId = Objects.requireNonNull(childCallId, "The required parameter 'childCallId' is missing.");
            this.callsDialogWithExistingCallRequest = Objects.requireNonNull(callsDialogWithExistingCallRequest, "The required parameter 'callsDialogWithExistingCallRequest' is missing.");
        }

        public CallsDialogResponse execute() throws ApiException {
            RequestDefinition createDialogWithExistingCallsDefinition = CallsApi.this.createDialogWithExistingCallsDefinition(this.parentCallId, this.childCallId, this.callsDialogWithExistingCallRequest);
            return (CallsDialogResponse)CallsApi.this.apiClient.execute(createDialogWithExistingCallsDefinition, new TypeReference<CallsDialogResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogResponse> callback) {
            RequestDefinition createDialogWithExistingCallsDefinition = CallsApi.this.createDialogWithExistingCallsDefinition(this.parentCallId, this.childCallId, this.callsDialogWithExistingCallRequest);
            return CallsApi.this.apiClient.executeAsync(createDialogWithExistingCallsDefinition, new TypeReference<CallsDialogResponse>(){}.getType(), callback);
        }
    }

    public class CreateDialogRequest {
        private final CallsDialogRequest callsDialogRequest;

        private CreateDialogRequest(CallsDialogRequest callsDialogRequest) {
            this.callsDialogRequest = Objects.requireNonNull(callsDialogRequest, "The required parameter 'callsDialogRequest' is missing.");
        }

        public CallsDialogResponse execute() throws ApiException {
            RequestDefinition createDialogDefinition = CallsApi.this.createDialogDefinition(this.callsDialogRequest);
            return (CallsDialogResponse)CallsApi.this.apiClient.execute(createDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsDialogResponse> callback) {
            RequestDefinition createDialogDefinition = CallsApi.this.createDialogDefinition(this.callsDialogRequest);
            return CallsApi.this.apiClient.executeAsync(createDialogDefinition, new TypeReference<CallsDialogResponse>(){}.getType(), callback);
        }
    }

    public class CreateConferenceRequest {
        private final CallsConferenceRequest callsConferenceRequest;

        private CreateConferenceRequest(CallsConferenceRequest callsConferenceRequest) {
            this.callsConferenceRequest = Objects.requireNonNull(callsConferenceRequest, "The required parameter 'callsConferenceRequest' is missing.");
        }

        public CallsConference execute() throws ApiException {
            RequestDefinition createConferenceDefinition = CallsApi.this.createConferenceDefinition(this.callsConferenceRequest);
            return (CallsConference)CallsApi.this.apiClient.execute(createConferenceDefinition, new TypeReference<CallsConference>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConference> callback) {
            RequestDefinition createConferenceDefinition = CallsApi.this.createConferenceDefinition(this.callsConferenceRequest);
            return CallsApi.this.apiClient.executeAsync(createConferenceDefinition, new TypeReference<CallsConference>(){}.getType(), callback);
        }
    }

    public class CreateCallsConfigurationRequest {
        private final CallsConfigurationCreateRequest callsConfigurationCreateRequest;

        private CreateCallsConfigurationRequest(CallsConfigurationCreateRequest callsConfigurationCreateRequest) {
            this.callsConfigurationCreateRequest = Objects.requireNonNull(callsConfigurationCreateRequest, "The required parameter 'callsConfigurationCreateRequest' is missing.");
        }

        public CallsConfigurationResponse execute() throws ApiException {
            RequestDefinition createCallsConfigurationDefinition = CallsApi.this.createCallsConfigurationDefinition(this.callsConfigurationCreateRequest);
            return (CallsConfigurationResponse)CallsApi.this.apiClient.execute(createCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConfigurationResponse> callback) {
            RequestDefinition createCallsConfigurationDefinition = CallsApi.this.createCallsConfigurationDefinition(this.callsConfigurationCreateRequest);
            return CallsApi.this.apiClient.executeAsync(createCallsConfigurationDefinition, new TypeReference<CallsConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class CreateCallRequest {
        private final CallRequest callRequest;

        private CreateCallRequest(CallRequest callRequest) {
            this.callRequest = Objects.requireNonNull(callRequest, "The required parameter 'callRequest' is missing.");
        }

        public com.infobip.model.Call execute() throws ApiException {
            RequestDefinition createCallDefinition = CallsApi.this.createCallDefinition(this.callRequest);
            return (com.infobip.model.Call)CallsApi.this.apiClient.execute(createCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType());
        }

        public Call executeAsync(ApiCallback<com.infobip.model.Call> callback) {
            RequestDefinition createCallDefinition = CallsApi.this.createCallDefinition(this.callRequest);
            return CallsApi.this.apiClient.executeAsync(createCallDefinition, new TypeReference<com.infobip.model.Call>(){}.getType(), callback);
        }
    }

    public class CreateBulkRequest {
        private final CallBulkRequest callBulkRequest;

        private CreateBulkRequest(CallBulkRequest callBulkRequest) {
            this.callBulkRequest = Objects.requireNonNull(callBulkRequest, "The required parameter 'callBulkRequest' is missing.");
        }

        public CallBulkResponse execute() throws ApiException {
            RequestDefinition createBulkDefinition = CallsApi.this.createBulkDefinition(this.callBulkRequest);
            return (CallBulkResponse)CallsApi.this.apiClient.execute(createBulkDefinition, new TypeReference<CallBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkResponse> callback) {
            RequestDefinition createBulkDefinition = CallsApi.this.createBulkDefinition(this.callBulkRequest);
            return CallsApi.this.apiClient.executeAsync(createBulkDefinition, new TypeReference<CallBulkResponse>(){}.getType(), callback);
        }
    }

    public class ConnectWithNewCallRequest {
        private final String callId;
        private final CallsConnectWithNewCallRequest callsConnectWithNewCallRequest;

        private ConnectWithNewCallRequest(String callId, CallsConnectWithNewCallRequest callsConnectWithNewCallRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsConnectWithNewCallRequest = Objects.requireNonNull(callsConnectWithNewCallRequest, "The required parameter 'callsConnectWithNewCallRequest' is missing.");
        }

        public CallsConferenceAndCall execute() throws ApiException {
            RequestDefinition connectWithNewCallDefinition = CallsApi.this.connectWithNewCallDefinition(this.callId, this.callsConnectWithNewCallRequest);
            return (CallsConferenceAndCall)CallsApi.this.apiClient.execute(connectWithNewCallDefinition, new TypeReference<CallsConferenceAndCall>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceAndCall> callback) {
            RequestDefinition connectWithNewCallDefinition = CallsApi.this.connectWithNewCallDefinition(this.callId, this.callsConnectWithNewCallRequest);
            return CallsApi.this.apiClient.executeAsync(connectWithNewCallDefinition, new TypeReference<CallsConferenceAndCall>(){}.getType(), callback);
        }
    }

    public class ConnectCallsRequest {
        private final CallsConnectRequest callsConnectRequest;

        private ConnectCallsRequest(CallsConnectRequest callsConnectRequest) {
            this.callsConnectRequest = Objects.requireNonNull(callsConnectRequest, "The required parameter 'callsConnectRequest' is missing.");
        }

        public CallsConference execute() throws ApiException {
            RequestDefinition connectCallsDefinition = CallsApi.this.connectCallsDefinition(this.callsConnectRequest);
            return (CallsConference)CallsApi.this.apiClient.execute(connectCallsDefinition, new TypeReference<CallsConference>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConference> callback) {
            RequestDefinition connectCallsDefinition = CallsApi.this.connectCallsDefinition(this.callsConnectRequest);
            return CallsApi.this.apiClient.executeAsync(connectCallsDefinition, new TypeReference<CallsConference>(){}.getType(), callback);
        }
    }

    public class ConferenceStopRecordingRequest {
        private final String conferenceId;

        private ConferenceStopRecordingRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferenceStopRecordingDefinition = CallsApi.this.conferenceStopRecordingDefinition(this.conferenceId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferenceStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferenceStopRecordingDefinition = CallsApi.this.conferenceStopRecordingDefinition(this.conferenceId);
            return CallsApi.this.apiClient.executeAsync(conferenceStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ConferenceStopPlayingFileRequest {
        private final String conferenceId;

        private ConferenceStopPlayingFileRequest(String conferenceId) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferenceStopPlayingFileDefinition = CallsApi.this.conferenceStopPlayingFileDefinition(this.conferenceId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferenceStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferenceStopPlayingFileDefinition = CallsApi.this.conferenceStopPlayingFileDefinition(this.conferenceId);
            return CallsApi.this.apiClient.executeAsync(conferenceStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ConferenceStartRecordingRequest {
        private final String conferenceId;
        private final CallsConferenceRecordingRequest callsConferenceRecordingRequest;

        private ConferenceStartRecordingRequest(String conferenceId, CallsConferenceRecordingRequest callsConferenceRecordingRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsConferenceRecordingRequest = Objects.requireNonNull(callsConferenceRecordingRequest, "The required parameter 'callsConferenceRecordingRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferenceStartRecordingDefinition = CallsApi.this.conferenceStartRecordingDefinition(this.conferenceId, this.callsConferenceRecordingRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferenceStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferenceStartRecordingDefinition = CallsApi.this.conferenceStartRecordingDefinition(this.conferenceId, this.callsConferenceRecordingRequest);
            return CallsApi.this.apiClient.executeAsync(conferenceStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ConferenceSayTextRequest {
        private final String conferenceId;
        private final CallsSayRequest callsSayRequest;

        private ConferenceSayTextRequest(String conferenceId, CallsSayRequest callsSayRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsSayRequest = Objects.requireNonNull(callsSayRequest, "The required parameter 'callsSayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferenceSayTextDefinition = CallsApi.this.conferenceSayTextDefinition(this.conferenceId, this.callsSayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferenceSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferenceSayTextDefinition = CallsApi.this.conferenceSayTextDefinition(this.conferenceId, this.callsSayRequest);
            return CallsApi.this.apiClient.executeAsync(conferenceSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ConferencePlayFileRequest {
        private final String conferenceId;
        private final CallsConferencePlayRequest callsConferencePlayRequest;

        private ConferencePlayFileRequest(String conferenceId, CallsConferencePlayRequest callsConferencePlayRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsConferencePlayRequest = Objects.requireNonNull(callsConferencePlayRequest, "The required parameter 'callsConferencePlayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferencePlayFileDefinition = CallsApi.this.conferencePlayFileDefinition(this.conferenceId, this.callsConferencePlayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferencePlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferencePlayFileDefinition = CallsApi.this.conferencePlayFileDefinition(this.conferenceId, this.callsConferencePlayRequest);
            return CallsApi.this.apiClient.executeAsync(conferencePlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ConferenceBroadcastWebrtcTextRequest {
        private final String conferenceId;
        private final CallsConferenceBroadcastWebrtcTextRequest callsConferenceBroadcastWebrtcTextRequest;

        private ConferenceBroadcastWebrtcTextRequest(String conferenceId, CallsConferenceBroadcastWebrtcTextRequest callsConferenceBroadcastWebrtcTextRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsConferenceBroadcastWebrtcTextRequest = Objects.requireNonNull(callsConferenceBroadcastWebrtcTextRequest, "The required parameter 'callsConferenceBroadcastWebrtcTextRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition conferenceBroadcastWebrtcTextDefinition = CallsApi.this.conferenceBroadcastWebrtcTextDefinition(this.conferenceId, this.callsConferenceBroadcastWebrtcTextRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(conferenceBroadcastWebrtcTextDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition conferenceBroadcastWebrtcTextDefinition = CallsApi.this.conferenceBroadcastWebrtcTextDefinition(this.conferenceId, this.callsConferenceBroadcastWebrtcTextRequest);
            return CallsApi.this.apiClient.executeAsync(conferenceBroadcastWebrtcTextDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ComposeDialogRecordingRequest {
        private final String dialogId;
        private final CallsOnDemandComposition callsOnDemandComposition;
        private CallsRecordingLocation location;

        private ComposeDialogRecordingRequest(String dialogId, CallsOnDemandComposition callsOnDemandComposition) {
            this.dialogId = Objects.requireNonNull(dialogId, "The required parameter 'dialogId' is missing.");
            this.callsOnDemandComposition = Objects.requireNonNull(callsOnDemandComposition, "The required parameter 'callsOnDemandComposition' is missing.");
        }

        public ComposeDialogRecordingRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition composeDialogRecordingDefinition = CallsApi.this.composeDialogRecordingDefinition(this.dialogId, this.callsOnDemandComposition, this.location);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(composeDialogRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition composeDialogRecordingDefinition = CallsApi.this.composeDialogRecordingDefinition(this.dialogId, this.callsOnDemandComposition, this.location);
            return CallsApi.this.apiClient.executeAsync(composeDialogRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ComposeConferenceRecordingRequest {
        private final String conferenceId;
        private final CallsOnDemandComposition callsOnDemandComposition;
        private CallsRecordingLocation location;

        private ComposeConferenceRecordingRequest(String conferenceId, CallsOnDemandComposition callsOnDemandComposition) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsOnDemandComposition = Objects.requireNonNull(callsOnDemandComposition, "The required parameter 'callsOnDemandComposition' is missing.");
        }

        public ComposeConferenceRecordingRequest location(CallsRecordingLocation location) {
            this.location = location;
            return this;
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition composeConferenceRecordingDefinition = CallsApi.this.composeConferenceRecordingDefinition(this.conferenceId, this.callsOnDemandComposition, this.location);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(composeConferenceRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition composeConferenceRecordingDefinition = CallsApi.this.composeConferenceRecordingDefinition(this.conferenceId, this.callsOnDemandComposition, this.location);
            return CallsApi.this.apiClient.executeAsync(composeConferenceRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CancelBulkRequest {
        private final String bulkId;

        private CancelBulkRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallBulkStatus execute() throws ApiException {
            RequestDefinition cancelBulkDefinition = CallsApi.this.cancelBulkDefinition(this.bulkId);
            return (CallBulkStatus)CallsApi.this.apiClient.execute(cancelBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallBulkStatus> callback) {
            RequestDefinition cancelBulkDefinition = CallsApi.this.cancelBulkDefinition(this.bulkId);
            return CallsApi.this.apiClient.executeAsync(cancelBulkDefinition, new TypeReference<CallBulkStatus>(){}.getType(), callback);
        }
    }

    public class CallStopTranscriptionRequest {
        private final String callId;

        private CallStopTranscriptionRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callStopTranscriptionDefinition = CallsApi.this.callStopTranscriptionDefinition(this.callId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callStopTranscriptionDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callStopTranscriptionDefinition = CallsApi.this.callStopTranscriptionDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(callStopTranscriptionDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallStopRecordingRequest {
        private final String callId;

        private CallStopRecordingRequest(String callId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callStopRecordingDefinition = CallsApi.this.callStopRecordingDefinition(this.callId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callStopRecordingDefinition = CallsApi.this.callStopRecordingDefinition(this.callId);
            return CallsApi.this.apiClient.executeAsync(callStopRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallStopPlayingFileRequest {
        private final String callId;
        private final CallsStopPlayRequest callsStopPlayRequest;

        private CallStopPlayingFileRequest(String callId, CallsStopPlayRequest callsStopPlayRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsStopPlayRequest = Objects.requireNonNull(callsStopPlayRequest, "The required parameter 'callsStopPlayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callStopPlayingFileDefinition = CallsApi.this.callStopPlayingFileDefinition(this.callId, this.callsStopPlayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callStopPlayingFileDefinition = CallsApi.this.callStopPlayingFileDefinition(this.callId, this.callsStopPlayRequest);
            return CallsApi.this.apiClient.executeAsync(callStopPlayingFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallStartTranscriptionRequest {
        private final String callId;
        private final CallsStartTranscriptionRequest callsStartTranscriptionRequest;

        private CallStartTranscriptionRequest(String callId, CallsStartTranscriptionRequest callsStartTranscriptionRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsStartTranscriptionRequest = Objects.requireNonNull(callsStartTranscriptionRequest, "The required parameter 'callsStartTranscriptionRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callStartTranscriptionDefinition = CallsApi.this.callStartTranscriptionDefinition(this.callId, this.callsStartTranscriptionRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callStartTranscriptionDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callStartTranscriptionDefinition = CallsApi.this.callStartTranscriptionDefinition(this.callId, this.callsStartTranscriptionRequest);
            return CallsApi.this.apiClient.executeAsync(callStartTranscriptionDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallStartRecordingRequest {
        private final String callId;
        private final CallsRecordingStartRequest callsRecordingStartRequest;

        private CallStartRecordingRequest(String callId, CallsRecordingStartRequest callsRecordingStartRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsRecordingStartRequest = Objects.requireNonNull(callsRecordingStartRequest, "The required parameter 'callsRecordingStartRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callStartRecordingDefinition = CallsApi.this.callStartRecordingDefinition(this.callId, this.callsRecordingStartRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callStartRecordingDefinition = CallsApi.this.callStartRecordingDefinition(this.callId, this.callsRecordingStartRequest);
            return CallsApi.this.apiClient.executeAsync(callStartRecordingDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallSendDtmfRequest {
        private final String callId;
        private final CallsDtmfSendRequest callsDtmfSendRequest;

        private CallSendDtmfRequest(String callId, CallsDtmfSendRequest callsDtmfSendRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsDtmfSendRequest = Objects.requireNonNull(callsDtmfSendRequest, "The required parameter 'callsDtmfSendRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callSendDtmfDefinition = CallsApi.this.callSendDtmfDefinition(this.callId, this.callsDtmfSendRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callSendDtmfDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callSendDtmfDefinition = CallsApi.this.callSendDtmfDefinition(this.callId, this.callsDtmfSendRequest);
            return CallsApi.this.apiClient.executeAsync(callSendDtmfDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallSayTextRequest {
        private final String callId;
        private final CallsSayRequest callsSayRequest;

        private CallSayTextRequest(String callId, CallsSayRequest callsSayRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsSayRequest = Objects.requireNonNull(callsSayRequest, "The required parameter 'callsSayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callSayTextDefinition = CallsApi.this.callSayTextDefinition(this.callId, this.callsSayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callSayTextDefinition = CallsApi.this.callSayTextDefinition(this.callId, this.callsSayRequest);
            return CallsApi.this.apiClient.executeAsync(callSayTextDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallPlayFileRequest {
        private final String callId;
        private final CallsPlayRequest callsPlayRequest;

        private CallPlayFileRequest(String callId, CallsPlayRequest callsPlayRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsPlayRequest = Objects.requireNonNull(callsPlayRequest, "The required parameter 'callsPlayRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callPlayFileDefinition = CallsApi.this.callPlayFileDefinition(this.callId, this.callsPlayRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callPlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callPlayFileDefinition = CallsApi.this.callPlayFileDefinition(this.callId, this.callsPlayRequest);
            return CallsApi.this.apiClient.executeAsync(callPlayFileDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallCaptureSpeechRequest {
        private final String callId;
        private final CallsSpeechCaptureRequest callsSpeechCaptureRequest;

        private CallCaptureSpeechRequest(String callId, CallsSpeechCaptureRequest callsSpeechCaptureRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsSpeechCaptureRequest = Objects.requireNonNull(callsSpeechCaptureRequest, "The required parameter 'callsSpeechCaptureRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callCaptureSpeechDefinition = CallsApi.this.callCaptureSpeechDefinition(this.callId, this.callsSpeechCaptureRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callCaptureSpeechDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callCaptureSpeechDefinition = CallsApi.this.callCaptureSpeechDefinition(this.callId, this.callsSpeechCaptureRequest);
            return CallsApi.this.apiClient.executeAsync(callCaptureSpeechDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class CallCaptureDtmfRequest {
        private final String callId;
        private final CallsDtmfCaptureRequest callsDtmfCaptureRequest;

        private CallCaptureDtmfRequest(String callId, CallsDtmfCaptureRequest callsDtmfCaptureRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsDtmfCaptureRequest = Objects.requireNonNull(callsDtmfCaptureRequest, "The required parameter 'callsDtmfCaptureRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition callCaptureDtmfDefinition = CallsApi.this.callCaptureDtmfDefinition(this.callId, this.callsDtmfCaptureRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(callCaptureDtmfDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition callCaptureDtmfDefinition = CallsApi.this.callCaptureDtmfDefinition(this.callId, this.callsDtmfCaptureRequest);
            return CallsApi.this.apiClient.executeAsync(callCaptureDtmfDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ApplicationTransferRejectRequest {
        private final String callId;
        private final String transferId;

        private ApplicationTransferRejectRequest(String callId, String transferId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.transferId = Objects.requireNonNull(transferId, "The required parameter 'transferId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition applicationTransferRejectDefinition = CallsApi.this.applicationTransferRejectDefinition(this.callId, this.transferId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(applicationTransferRejectDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition applicationTransferRejectDefinition = CallsApi.this.applicationTransferRejectDefinition(this.callId, this.transferId);
            return CallsApi.this.apiClient.executeAsync(applicationTransferRejectDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ApplicationTransferAcceptRequest {
        private final String callId;
        private final String transferId;

        private ApplicationTransferAcceptRequest(String callId, String transferId) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.transferId = Objects.requireNonNull(transferId, "The required parameter 'transferId' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition applicationTransferAcceptDefinition = CallsApi.this.applicationTransferAcceptDefinition(this.callId, this.transferId);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(applicationTransferAcceptDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition applicationTransferAcceptDefinition = CallsApi.this.applicationTransferAcceptDefinition(this.callId, this.transferId);
            return CallsApi.this.apiClient.executeAsync(applicationTransferAcceptDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class ApplicationTransferRequest {
        private final String callId;
        private final CallsApplicationTransferRequest callsApplicationTransferRequest;

        private ApplicationTransferRequest(String callId, CallsApplicationTransferRequest callsApplicationTransferRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsApplicationTransferRequest = Objects.requireNonNull(callsApplicationTransferRequest, "The required parameter 'callsApplicationTransferRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition applicationTransferDefinition = CallsApi.this.applicationTransferDefinition(this.callId, this.callsApplicationTransferRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(applicationTransferDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition applicationTransferDefinition = CallsApi.this.applicationTransferDefinition(this.callId, this.callsApplicationTransferRequest);
            return CallsApi.this.apiClient.executeAsync(applicationTransferDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class AnswerCallRequest {
        private final String callId;
        private final CallsAnswerRequest callsAnswerRequest;

        private AnswerCallRequest(String callId, CallsAnswerRequest callsAnswerRequest) {
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsAnswerRequest = Objects.requireNonNull(callsAnswerRequest, "The required parameter 'callsAnswerRequest' is missing.");
        }

        public CallsActionResponse execute() throws ApiException {
            RequestDefinition answerCallDefinition = CallsApi.this.answerCallDefinition(this.callId, this.callsAnswerRequest);
            return (CallsActionResponse)CallsApi.this.apiClient.execute(answerCallDefinition, new TypeReference<CallsActionResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsActionResponse> callback) {
            RequestDefinition answerCallDefinition = CallsApi.this.answerCallDefinition(this.callId, this.callsAnswerRequest);
            return CallsApi.this.apiClient.executeAsync(answerCallDefinition, new TypeReference<CallsActionResponse>(){}.getType(), callback);
        }
    }

    public class AddNewConferenceCallRequest {
        private final String conferenceId;
        private final CallsAddNewCallRequest callsAddNewCallRequest;

        private AddNewConferenceCallRequest(String conferenceId, CallsAddNewCallRequest callsAddNewCallRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callsAddNewCallRequest = Objects.requireNonNull(callsAddNewCallRequest, "The required parameter 'callsAddNewCallRequest' is missing.");
        }

        public CallsConferenceAndCall execute() throws ApiException {
            RequestDefinition addNewConferenceCallDefinition = CallsApi.this.addNewConferenceCallDefinition(this.conferenceId, this.callsAddNewCallRequest);
            return (CallsConferenceAndCall)CallsApi.this.apiClient.execute(addNewConferenceCallDefinition, new TypeReference<CallsConferenceAndCall>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConferenceAndCall> callback) {
            RequestDefinition addNewConferenceCallDefinition = CallsApi.this.addNewConferenceCallDefinition(this.conferenceId, this.callsAddNewCallRequest);
            return CallsApi.this.apiClient.executeAsync(addNewConferenceCallDefinition, new TypeReference<CallsConferenceAndCall>(){}.getType(), callback);
        }
    }

    public class AddExistingConferenceCallRequest {
        private final String conferenceId;
        private final String callId;
        private final CallsAddExistingCallRequest callsAddExistingCallRequest;

        private AddExistingConferenceCallRequest(String conferenceId, String callId, CallsAddExistingCallRequest callsAddExistingCallRequest) {
            this.conferenceId = Objects.requireNonNull(conferenceId, "The required parameter 'conferenceId' is missing.");
            this.callId = Objects.requireNonNull(callId, "The required parameter 'callId' is missing.");
            this.callsAddExistingCallRequest = Objects.requireNonNull(callsAddExistingCallRequest, "The required parameter 'callsAddExistingCallRequest' is missing.");
        }

        public CallsConference execute() throws ApiException {
            RequestDefinition addExistingConferenceCallDefinition = CallsApi.this.addExistingConferenceCallDefinition(this.conferenceId, this.callId, this.callsAddExistingCallRequest);
            return (CallsConference)CallsApi.this.apiClient.execute(addExistingConferenceCallDefinition, new TypeReference<CallsConference>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsConference> callback) {
            RequestDefinition addExistingConferenceCallDefinition = CallsApi.this.addExistingConferenceCallDefinition(this.conferenceId, this.callId, this.callsAddExistingCallRequest);
            return CallsApi.this.apiClient.executeAsync(addExistingConferenceCallDefinition, new TypeReference<CallsConference>(){}.getType(), callback);
        }
    }
}

