/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.EmailAddDomainRequest;
import com.infobip.model.EmailAddSuppressionRequest;
import com.infobip.model.EmailAllDomainsResponse;
import com.infobip.model.EmailBulkRescheduleRequest;
import com.infobip.model.EmailBulkRescheduleResponse;
import com.infobip.model.EmailBulkScheduleResponse;
import com.infobip.model.EmailBulkStatusResponse;
import com.infobip.model.EmailBulkUpdateStatusRequest;
import com.infobip.model.EmailBulkUpdateStatusResponse;
import com.infobip.model.EmailDeleteSuppressionRequest;
import com.infobip.model.EmailDomainInfoPageResponse;
import com.infobip.model.EmailDomainIpPoolAssignApiRequest;
import com.infobip.model.EmailDomainIpPoolUpdateApiRequest;
import com.infobip.model.EmailDomainResponse;
import com.infobip.model.EmailIpDetailResponse;
import com.infobip.model.EmailIpDomainResponse;
import com.infobip.model.EmailIpPoolAssignIpApiRequest;
import com.infobip.model.EmailIpPoolCreateApiRequest;
import com.infobip.model.EmailIpPoolDetailResponse;
import com.infobip.model.EmailIpPoolResponse;
import com.infobip.model.EmailLogsResponse;
import com.infobip.model.EmailReportsResult;
import com.infobip.model.EmailSendResponse;
import com.infobip.model.EmailSuppressionInfoPageResponse;
import com.infobip.model.EmailSuppressionType;
import com.infobip.model.EmailTrackingEventRequest;
import com.infobip.model.EmailValidationRequest;
import com.infobip.model.EmailValidationResponse;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class EmailApi {
    private final ApiClient apiClient;

    public EmailApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition addDomainDefinition(EmailAddDomainRequest emailAddDomainRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/domains").body(emailAddDomainRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public AddDomainRequest addDomain(EmailAddDomainRequest emailAddDomainRequest) {
        return new AddDomainRequest(emailAddDomainRequest);
    }

    private RequestDefinition addSuppressionsDefinition(EmailAddSuppressionRequest emailAddSuppressionRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/suppressions").body(emailAddSuppressionRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public AddSuppressionsRequest addSuppressions(EmailAddSuppressionRequest emailAddSuppressionRequest) {
        return new AddSuppressionsRequest(emailAddSuppressionRequest);
    }

    private RequestDefinition assignIpToPoolDefinition(String poolId, EmailIpPoolAssignIpApiRequest emailIpPoolAssignIpApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/ip-management/pools/{poolId}/ips").body(emailIpPoolAssignIpApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public AssignIpToPoolRequest assignIpToPool(String poolId, EmailIpPoolAssignIpApiRequest emailIpPoolAssignIpApiRequest) {
        return new AssignIpToPoolRequest(poolId, emailIpPoolAssignIpApiRequest);
    }

    private RequestDefinition assignPoolToDomainDefinition(Long domainId, EmailDomainIpPoolAssignApiRequest emailDomainIpPoolAssignApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/ip-management/domains/{domainId}/pools").body(emailDomainIpPoolAssignApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (domainId != null) {
            builder.addPathParameter(new Parameter("domainId", domainId));
        }
        return builder.build();
    }

    public AssignPoolToDomainRequest assignPoolToDomain(Long domainId, EmailDomainIpPoolAssignApiRequest emailDomainIpPoolAssignApiRequest) {
        return new AssignPoolToDomainRequest(domainId, emailDomainIpPoolAssignApiRequest);
    }

    private RequestDefinition createIpPoolDefinition(EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/ip-management/pools").body(emailIpPoolCreateApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateIpPoolRequest createIpPool(EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
        return new CreateIpPoolRequest(emailIpPoolCreateApiRequest);
    }

    private RequestDefinition deleteDomainDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/domains/{domainName}").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public DeleteDomainRequest deleteDomain(String domainName) {
        return new DeleteDomainRequest(domainName);
    }

    private RequestDefinition deleteIpPoolDefinition(String poolId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/ip-management/pools/{poolId}").requiresAuthentication(true).accept("application/json");
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public DeleteIpPoolRequest deleteIpPool(String poolId) {
        return new DeleteIpPoolRequest(poolId);
    }

    private RequestDefinition deleteSuppressionsDefinition(EmailDeleteSuppressionRequest emailDeleteSuppressionRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/suppressions").body(emailDeleteSuppressionRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public DeleteSuppressionsRequest deleteSuppressions(EmailDeleteSuppressionRequest emailDeleteSuppressionRequest) {
        return new DeleteSuppressionsRequest(emailDeleteSuppressionRequest);
    }

    private RequestDefinition getAllDomainsDefinition(Integer size, Integer page) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/domains").requiresAuthentication(true).accept("application/json");
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        return builder.build();
    }

    public GetAllDomainsRequest getAllDomains() {
        return new GetAllDomainsRequest();
    }

    private RequestDefinition getAllIpsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ip-management/ips").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetAllIpsRequest getAllIps() {
        return new GetAllIpsRequest();
    }

    private RequestDefinition getDomainDetailsDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/domains/{domainName}").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public GetDomainDetailsRequest getDomainDetails(String domainName) {
        return new GetDomainDetailsRequest(domainName);
    }

    private RequestDefinition getDomainsDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/suppressions/domains").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetDomainsRequest getDomains() {
        return new GetDomainsRequest();
    }

    private RequestDefinition getEmailDeliveryReportsDefinition(String bulkId, String messageId, String campaignReferenceId, Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (campaignReferenceId != null) {
            builder.addQueryParameter(new Parameter("campaignReferenceId", campaignReferenceId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetEmailDeliveryReportsRequest getEmailDeliveryReports() {
        return new GetEmailDeliveryReportsRequest();
    }

    private RequestDefinition getEmailLogsDefinition(String messageId, String from, String to, String bulkId, String campaignReferenceId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/logs").requiresAuthentication(true).accept("application/json");
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (campaignReferenceId != null) {
            builder.addQueryParameter(new Parameter("campaignReferenceId", campaignReferenceId));
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetEmailLogsRequest getEmailLogs() {
        return new GetEmailLogsRequest();
    }

    private RequestDefinition getIpDetailsDefinition(String ipId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ip-management/ips/{ipId}").requiresAuthentication(true).accept("application/json");
        if (ipId != null) {
            builder.addPathParameter(new Parameter("ipId", ipId));
        }
        return builder.build();
    }

    public GetIpDetailsRequest getIpDetails(String ipId) {
        return new GetIpDetailsRequest(ipId);
    }

    private RequestDefinition getIpDomainDefinition(Long domainId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ip-management/domains/{domainId}").requiresAuthentication(true).accept("application/json");
        if (domainId != null) {
            builder.addPathParameter(new Parameter("domainId", domainId));
        }
        return builder.build();
    }

    public GetIpDomainRequest getIpDomain(Long domainId) {
        return new GetIpDomainRequest(domainId);
    }

    private RequestDefinition getIpPoolDefinition(String poolId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ip-management/pools/{poolId}").requiresAuthentication(true).accept("application/json");
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public GetIpPoolRequest getIpPool(String poolId) {
        return new GetIpPoolRequest(poolId);
    }

    private RequestDefinition getIpPoolsDefinition(String name) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ip-management/pools").requiresAuthentication(true).accept("application/json");
        if (name != null) {
            builder.addQueryParameter(new Parameter("name", name));
        }
        return builder.build();
    }

    public GetIpPoolsRequest getIpPools() {
        return new GetIpPoolsRequest();
    }

    private RequestDefinition getScheduledEmailStatusesDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/bulks/status").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledEmailStatusesRequest getScheduledEmailStatuses(String bulkId) {
        return new GetScheduledEmailStatusesRequest(bulkId);
    }

    private RequestDefinition getScheduledEmailsDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/bulks").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledEmailsRequest getScheduledEmails(String bulkId) {
        return new GetScheduledEmailsRequest(bulkId);
    }

    private RequestDefinition getSuppressionsDefinition(String domainName, EmailSuppressionType type, String emailAddress, String recipientDomain, OffsetDateTime createdDateFrom, OffsetDateTime createdDateTo, Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/suppressions").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addQueryParameter(new Parameter("domainName", domainName));
        }
        if (type != null) {
            builder.addQueryParameter(new Parameter("type", (Object)type));
        }
        if (emailAddress != null) {
            builder.addQueryParameter(new Parameter("emailAddress", emailAddress));
        }
        if (recipientDomain != null) {
            builder.addQueryParameter(new Parameter("recipientDomain", recipientDomain));
        }
        if (createdDateFrom != null) {
            builder.addQueryParameter(new Parameter("createdDateFrom", createdDateFrom));
        }
        if (createdDateTo != null) {
            builder.addQueryParameter(new Parameter("createdDateTo", createdDateTo));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetSuppressionsRequest getSuppressions(String domainName, EmailSuppressionType type) {
        return new GetSuppressionsRequest(domainName, type);
    }

    private RequestDefinition removeIpFromPoolDefinition(String poolId, String ipId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/ip-management/pools/{poolId}/ips/{ipId}").requiresAuthentication(true).accept("application/json");
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        if (ipId != null) {
            builder.addPathParameter(new Parameter("ipId", ipId));
        }
        return builder.build();
    }

    public RemoveIpFromPoolRequest removeIpFromPool(String poolId, String ipId) {
        return new RemoveIpFromPoolRequest(poolId, ipId);
    }

    private RequestDefinition removeIpPoolFromDomainDefinition(Long domainId, String poolId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/ip-management/domains/{domainId}/pools/{poolId}").requiresAuthentication(true).accept("application/json");
        if (domainId != null) {
            builder.addPathParameter(new Parameter("domainId", domainId));
        }
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public RemoveIpPoolFromDomainRequest removeIpPoolFromDomain(Long domainId, String poolId) {
        return new RemoveIpPoolFromDomainRequest(domainId, poolId);
    }

    private RequestDefinition rescheduleEmailsDefinition(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/bulks").body(emailBulkRescheduleRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleEmailsRequest rescheduleEmails(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
        return new RescheduleEmailsRequest(bulkId, emailBulkRescheduleRequest);
    }

    private RequestDefinition sendEmailDefinition(List<String> to, String from, List<String> cc, List<String> bcc, String subject, String text, String html, String ampHtml, Long templateId, List<File> attachment, List<File> inlineImage, Boolean intermediateReport, String notifyUrl, String notifyContentType, String callbackData, Boolean track, Boolean trackClicks, Boolean trackOpens, String trackingPixelPosition, String trackingUrl, String bulkId, String messageId, String campaignReferenceId, String replyTo, String defaultPlaceholders, Boolean preserveRecipients, OffsetDateTime sendAt, String landingPagePlaceholders, String landingPageId, String templateLanguageVersion, String clientPriority, String applicationId, String entityId, String headers, String ipPoolId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/3/send").requiresAuthentication(true).accept("application/json").contentType("multipart/form-data");
        if (from != null) {
            builder.addFormParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addFormParameter(new Parameter("to", to));
        }
        if (cc != null) {
            builder.addFormParameter(new Parameter("cc", cc));
        }
        if (bcc != null) {
            builder.addFormParameter(new Parameter("bcc", bcc));
        }
        if (subject != null) {
            builder.addFormParameter(new Parameter("subject", subject));
        }
        if (text != null) {
            builder.addFormParameter(new Parameter("text", text));
        }
        if (html != null) {
            builder.addFormParameter(new Parameter("html", html));
        }
        if (ampHtml != null) {
            builder.addFormParameter(new Parameter("ampHtml", ampHtml));
        }
        if (templateId != null) {
            builder.addFormParameter(new Parameter("templateId", templateId));
        }
        if (attachment != null) {
            builder.addFormParameter(new Parameter("attachment", attachment));
        }
        if (inlineImage != null) {
            builder.addFormParameter(new Parameter("inlineImage", inlineImage));
        }
        if (intermediateReport != null) {
            builder.addFormParameter(new Parameter("intermediateReport", intermediateReport));
        }
        if (notifyUrl != null) {
            builder.addFormParameter(new Parameter("notifyUrl", notifyUrl));
        }
        if (notifyContentType != null) {
            builder.addFormParameter(new Parameter("notifyContentType", notifyContentType));
        }
        if (callbackData != null) {
            builder.addFormParameter(new Parameter("callbackData", callbackData));
        }
        if (track != null) {
            builder.addFormParameter(new Parameter("track", track));
        }
        if (trackClicks != null) {
            builder.addFormParameter(new Parameter("trackClicks", trackClicks));
        }
        if (trackOpens != null) {
            builder.addFormParameter(new Parameter("trackOpens", trackOpens));
        }
        if (trackingPixelPosition != null) {
            builder.addFormParameter(new Parameter("trackingPixelPosition", trackingPixelPosition));
        }
        if (trackingUrl != null) {
            builder.addFormParameter(new Parameter("trackingUrl", trackingUrl));
        }
        if (bulkId != null) {
            builder.addFormParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addFormParameter(new Parameter("messageId", messageId));
        }
        if (campaignReferenceId != null) {
            builder.addFormParameter(new Parameter("campaignReferenceId", campaignReferenceId));
        }
        if (replyTo != null) {
            builder.addFormParameter(new Parameter("replyTo", replyTo));
        }
        if (defaultPlaceholders != null) {
            builder.addFormParameter(new Parameter("defaultPlaceholders", defaultPlaceholders));
        }
        if (preserveRecipients != null) {
            builder.addFormParameter(new Parameter("preserveRecipients", preserveRecipients));
        }
        if (sendAt != null) {
            builder.addFormParameter(new Parameter("sendAt", sendAt));
        }
        if (landingPagePlaceholders != null) {
            builder.addFormParameter(new Parameter("landingPagePlaceholders", landingPagePlaceholders));
        }
        if (landingPageId != null) {
            builder.addFormParameter(new Parameter("landingPageId", landingPageId));
        }
        if (templateLanguageVersion != null) {
            builder.addFormParameter(new Parameter("templateLanguageVersion", templateLanguageVersion));
        }
        if (clientPriority != null) {
            builder.addFormParameter(new Parameter("clientPriority", clientPriority));
        }
        if (applicationId != null) {
            builder.addFormParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addFormParameter(new Parameter("entityId", entityId));
        }
        if (headers != null) {
            builder.addFormParameter(new Parameter("headers", headers));
        }
        if (ipPoolId != null) {
            builder.addFormParameter(new Parameter("ipPoolId", ipPoolId));
        }
        return builder.build();
    }

    public SendEmailRequest sendEmail(List<String> to) {
        return new SendEmailRequest(to);
    }

    private RequestDefinition updateDomainPoolPriorityDefinition(Long domainId, String poolId, EmailDomainIpPoolUpdateApiRequest emailDomainIpPoolUpdateApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/ip-management/domains/{domainId}/pools/{poolId}").body(emailDomainIpPoolUpdateApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (domainId != null) {
            builder.addPathParameter(new Parameter("domainId", domainId));
        }
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public UpdateDomainPoolPriorityRequest updateDomainPoolPriority(Long domainId, String poolId, EmailDomainIpPoolUpdateApiRequest emailDomainIpPoolUpdateApiRequest) {
        return new UpdateDomainPoolPriorityRequest(domainId, poolId, emailDomainIpPoolUpdateApiRequest);
    }

    private RequestDefinition updateIpPoolDefinition(String poolId, EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/ip-management/pools/{poolId}").body(emailIpPoolCreateApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (poolId != null) {
            builder.addPathParameter(new Parameter("poolId", poolId));
        }
        return builder.build();
    }

    public UpdateIpPoolRequest updateIpPool(String poolId, EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
        return new UpdateIpPoolRequest(poolId, emailIpPoolCreateApiRequest);
    }

    private RequestDefinition updateScheduledEmailStatusesDefinition(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/bulks/status").body(emailBulkUpdateStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public UpdateScheduledEmailStatusesRequest updateScheduledEmailStatuses(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
        return new UpdateScheduledEmailStatusesRequest(bulkId, emailBulkUpdateStatusRequest);
    }

    private RequestDefinition updateTrackingEventsDefinition(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/domains/{domainName}/tracking").body(emailTrackingEventRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public UpdateTrackingEventsRequest updateTrackingEvents(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
        return new UpdateTrackingEventsRequest(domainName, emailTrackingEventRequest);
    }

    private RequestDefinition validateEmailAddressesDefinition(EmailValidationRequest emailValidationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/2/validation").body(emailValidationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public ValidateEmailAddressesRequest validateEmailAddresses(EmailValidationRequest emailValidationRequest) {
        return new ValidateEmailAddressesRequest(emailValidationRequest);
    }

    private RequestDefinition verifyDomainDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/domains/{domainName}/verify").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public VerifyDomainRequest verifyDomain(String domainName) {
        return new VerifyDomainRequest(domainName);
    }

    public class VerifyDomainRequest {
        private final String domainName;

        private VerifyDomainRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition verifyDomainDefinition = EmailApi.this.verifyDomainDefinition(this.domainName);
            EmailApi.this.apiClient.execute(verifyDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition verifyDomainDefinition = EmailApi.this.verifyDomainDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(verifyDomainDefinition, callback);
        }
    }

    public class ValidateEmailAddressesRequest {
        private final EmailValidationRequest emailValidationRequest;

        private ValidateEmailAddressesRequest(EmailValidationRequest emailValidationRequest) {
            this.emailValidationRequest = Objects.requireNonNull(emailValidationRequest, "The required parameter 'emailValidationRequest' is missing.");
        }

        public EmailValidationResponse execute() throws ApiException {
            RequestDefinition validateEmailAddressesDefinition = EmailApi.this.validateEmailAddressesDefinition(this.emailValidationRequest);
            return (EmailValidationResponse)EmailApi.this.apiClient.execute(validateEmailAddressesDefinition, new TypeReference<EmailValidationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailValidationResponse> callback) {
            RequestDefinition validateEmailAddressesDefinition = EmailApi.this.validateEmailAddressesDefinition(this.emailValidationRequest);
            return EmailApi.this.apiClient.executeAsync(validateEmailAddressesDefinition, new TypeReference<EmailValidationResponse>(){}.getType(), callback);
        }
    }

    public class UpdateTrackingEventsRequest {
        private final String domainName;
        private final EmailTrackingEventRequest emailTrackingEventRequest;

        private UpdateTrackingEventsRequest(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
            this.emailTrackingEventRequest = Objects.requireNonNull(emailTrackingEventRequest, "The required parameter 'emailTrackingEventRequest' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition updateTrackingEventsDefinition = EmailApi.this.updateTrackingEventsDefinition(this.domainName, this.emailTrackingEventRequest);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(updateTrackingEventsDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition updateTrackingEventsDefinition = EmailApi.this.updateTrackingEventsDefinition(this.domainName, this.emailTrackingEventRequest);
            return EmailApi.this.apiClient.executeAsync(updateTrackingEventsDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }

    public class UpdateScheduledEmailStatusesRequest {
        private final String bulkId;
        private final EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest;

        private UpdateScheduledEmailStatusesRequest(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.emailBulkUpdateStatusRequest = Objects.requireNonNull(emailBulkUpdateStatusRequest, "The required parameter 'emailBulkUpdateStatusRequest' is missing.");
        }

        public EmailBulkUpdateStatusResponse execute() throws ApiException {
            RequestDefinition updateScheduledEmailStatusesDefinition = EmailApi.this.updateScheduledEmailStatusesDefinition(this.bulkId, this.emailBulkUpdateStatusRequest);
            return (EmailBulkUpdateStatusResponse)EmailApi.this.apiClient.execute(updateScheduledEmailStatusesDefinition, new TypeReference<EmailBulkUpdateStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkUpdateStatusResponse> callback) {
            RequestDefinition updateScheduledEmailStatusesDefinition = EmailApi.this.updateScheduledEmailStatusesDefinition(this.bulkId, this.emailBulkUpdateStatusRequest);
            return EmailApi.this.apiClient.executeAsync(updateScheduledEmailStatusesDefinition, new TypeReference<EmailBulkUpdateStatusResponse>(){}.getType(), callback);
        }
    }

    public class UpdateIpPoolRequest {
        private final String poolId;
        private final EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest;

        private UpdateIpPoolRequest(String poolId, EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
            this.emailIpPoolCreateApiRequest = Objects.requireNonNull(emailIpPoolCreateApiRequest, "The required parameter 'emailIpPoolCreateApiRequest' is missing.");
        }

        public EmailIpPoolResponse execute() throws ApiException {
            RequestDefinition updateIpPoolDefinition = EmailApi.this.updateIpPoolDefinition(this.poolId, this.emailIpPoolCreateApiRequest);
            return (EmailIpPoolResponse)EmailApi.this.apiClient.execute(updateIpPoolDefinition, new TypeReference<EmailIpPoolResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailIpPoolResponse> callback) {
            RequestDefinition updateIpPoolDefinition = EmailApi.this.updateIpPoolDefinition(this.poolId, this.emailIpPoolCreateApiRequest);
            return EmailApi.this.apiClient.executeAsync(updateIpPoolDefinition, new TypeReference<EmailIpPoolResponse>(){}.getType(), callback);
        }
    }

    public class UpdateDomainPoolPriorityRequest {
        private final Long domainId;
        private final String poolId;
        private final EmailDomainIpPoolUpdateApiRequest emailDomainIpPoolUpdateApiRequest;

        private UpdateDomainPoolPriorityRequest(Long domainId, String poolId, EmailDomainIpPoolUpdateApiRequest emailDomainIpPoolUpdateApiRequest) {
            this.domainId = Objects.requireNonNull(domainId, "The required parameter 'domainId' is missing.");
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
            this.emailDomainIpPoolUpdateApiRequest = Objects.requireNonNull(emailDomainIpPoolUpdateApiRequest, "The required parameter 'emailDomainIpPoolUpdateApiRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition updateDomainPoolPriorityDefinition = EmailApi.this.updateDomainPoolPriorityDefinition(this.domainId, this.poolId, this.emailDomainIpPoolUpdateApiRequest);
            EmailApi.this.apiClient.execute(updateDomainPoolPriorityDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition updateDomainPoolPriorityDefinition = EmailApi.this.updateDomainPoolPriorityDefinition(this.domainId, this.poolId, this.emailDomainIpPoolUpdateApiRequest);
            return EmailApi.this.apiClient.executeAsync(updateDomainPoolPriorityDefinition, callback);
        }
    }

    public class SendEmailRequest {
        private final List<String> to;
        private String from;
        private List<String> cc;
        private List<String> bcc;
        private String subject;
        private String text;
        private String html;
        private String ampHtml;
        private Long templateId;
        private List<File> attachment;
        private List<File> inlineImage;
        private Boolean intermediateReport;
        private String notifyUrl;
        private String notifyContentType;
        private String callbackData;
        private Boolean track;
        private Boolean trackClicks;
        private Boolean trackOpens;
        private String trackingPixelPosition;
        private String trackingUrl;
        private String bulkId;
        private String messageId;
        private String campaignReferenceId;
        private String replyTo;
        private String defaultPlaceholders;
        private Boolean preserveRecipients;
        private OffsetDateTime sendAt;
        private String landingPagePlaceholders;
        private String landingPageId;
        private String templateLanguageVersion;
        private String clientPriority;
        private String applicationId;
        private String entityId;
        private String headers;
        private String ipPoolId;

        private SendEmailRequest(List<String> to) {
            this.to = Objects.requireNonNull(to, "The required parameter 'to' is missing.");
        }

        public SendEmailRequest from(String from) {
            this.from = from;
            return this;
        }

        public SendEmailRequest cc(List<String> cc) {
            this.cc = cc;
            return this;
        }

        public SendEmailRequest bcc(List<String> bcc) {
            this.bcc = bcc;
            return this;
        }

        public SendEmailRequest subject(String subject) {
            this.subject = subject;
            return this;
        }

        public SendEmailRequest text(String text) {
            this.text = text;
            return this;
        }

        public SendEmailRequest html(String html) {
            this.html = html;
            return this;
        }

        public SendEmailRequest ampHtml(String ampHtml) {
            this.ampHtml = ampHtml;
            return this;
        }

        public SendEmailRequest templateId(Long templateId) {
            this.templateId = templateId;
            return this;
        }

        public SendEmailRequest attachment(List<File> attachment) {
            this.attachment = attachment;
            return this;
        }

        public SendEmailRequest inlineImage(List<File> inlineImage) {
            this.inlineImage = inlineImage;
            return this;
        }

        public SendEmailRequest intermediateReport(Boolean intermediateReport) {
            this.intermediateReport = intermediateReport;
            return this;
        }

        public SendEmailRequest notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public SendEmailRequest notifyContentType(String notifyContentType) {
            this.notifyContentType = notifyContentType;
            return this;
        }

        public SendEmailRequest callbackData(String callbackData) {
            this.callbackData = callbackData;
            return this;
        }

        public SendEmailRequest track(Boolean track) {
            this.track = track;
            return this;
        }

        public SendEmailRequest trackClicks(Boolean trackClicks) {
            this.trackClicks = trackClicks;
            return this;
        }

        public SendEmailRequest trackOpens(Boolean trackOpens) {
            this.trackOpens = trackOpens;
            return this;
        }

        public SendEmailRequest trackingPixelPosition(String trackingPixelPosition) {
            this.trackingPixelPosition = trackingPixelPosition;
            return this;
        }

        public SendEmailRequest trackingUrl(String trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public SendEmailRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public SendEmailRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public SendEmailRequest campaignReferenceId(String campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public SendEmailRequest replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendEmailRequest defaultPlaceholders(String defaultPlaceholders) {
            this.defaultPlaceholders = defaultPlaceholders;
            return this;
        }

        public SendEmailRequest preserveRecipients(Boolean preserveRecipients) {
            this.preserveRecipients = preserveRecipients;
            return this;
        }

        public SendEmailRequest sendAt(OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return this;
        }

        public SendEmailRequest landingPagePlaceholders(String landingPagePlaceholders) {
            this.landingPagePlaceholders = landingPagePlaceholders;
            return this;
        }

        public SendEmailRequest landingPageId(String landingPageId) {
            this.landingPageId = landingPageId;
            return this;
        }

        public SendEmailRequest templateLanguageVersion(String templateLanguageVersion) {
            this.templateLanguageVersion = templateLanguageVersion;
            return this;
        }

        public SendEmailRequest clientPriority(String clientPriority) {
            this.clientPriority = clientPriority;
            return this;
        }

        public SendEmailRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public SendEmailRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public SendEmailRequest headers(String headers) {
            this.headers = headers;
            return this;
        }

        public SendEmailRequest ipPoolId(String ipPoolId) {
            this.ipPoolId = ipPoolId;
            return this;
        }

        public EmailSendResponse execute() throws ApiException {
            RequestDefinition sendEmailDefinition = EmailApi.this.sendEmailDefinition(this.to, this.from, this.cc, this.bcc, this.subject, this.text, this.html, this.ampHtml, this.templateId, this.attachment, this.inlineImage, this.intermediateReport, this.notifyUrl, this.notifyContentType, this.callbackData, this.track, this.trackClicks, this.trackOpens, this.trackingPixelPosition, this.trackingUrl, this.bulkId, this.messageId, this.campaignReferenceId, this.replyTo, this.defaultPlaceholders, this.preserveRecipients, this.sendAt, this.landingPagePlaceholders, this.landingPageId, this.templateLanguageVersion, this.clientPriority, this.applicationId, this.entityId, this.headers, this.ipPoolId);
            return (EmailSendResponse)EmailApi.this.apiClient.execute(sendEmailDefinition, new TypeReference<EmailSendResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailSendResponse> callback) {
            RequestDefinition sendEmailDefinition = EmailApi.this.sendEmailDefinition(this.to, this.from, this.cc, this.bcc, this.subject, this.text, this.html, this.ampHtml, this.templateId, this.attachment, this.inlineImage, this.intermediateReport, this.notifyUrl, this.notifyContentType, this.callbackData, this.track, this.trackClicks, this.trackOpens, this.trackingPixelPosition, this.trackingUrl, this.bulkId, this.messageId, this.campaignReferenceId, this.replyTo, this.defaultPlaceholders, this.preserveRecipients, this.sendAt, this.landingPagePlaceholders, this.landingPageId, this.templateLanguageVersion, this.clientPriority, this.applicationId, this.entityId, this.headers, this.ipPoolId);
            return EmailApi.this.apiClient.executeAsync(sendEmailDefinition, new TypeReference<EmailSendResponse>(){}.getType(), callback);
        }
    }

    public class RescheduleEmailsRequest {
        private final String bulkId;
        private final EmailBulkRescheduleRequest emailBulkRescheduleRequest;

        private RescheduleEmailsRequest(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.emailBulkRescheduleRequest = Objects.requireNonNull(emailBulkRescheduleRequest, "The required parameter 'emailBulkRescheduleRequest' is missing.");
        }

        public EmailBulkRescheduleResponse execute() throws ApiException {
            RequestDefinition rescheduleEmailsDefinition = EmailApi.this.rescheduleEmailsDefinition(this.bulkId, this.emailBulkRescheduleRequest);
            return (EmailBulkRescheduleResponse)EmailApi.this.apiClient.execute(rescheduleEmailsDefinition, new TypeReference<EmailBulkRescheduleResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkRescheduleResponse> callback) {
            RequestDefinition rescheduleEmailsDefinition = EmailApi.this.rescheduleEmailsDefinition(this.bulkId, this.emailBulkRescheduleRequest);
            return EmailApi.this.apiClient.executeAsync(rescheduleEmailsDefinition, new TypeReference<EmailBulkRescheduleResponse>(){}.getType(), callback);
        }
    }

    public class RemoveIpPoolFromDomainRequest {
        private final Long domainId;
        private final String poolId;

        private RemoveIpPoolFromDomainRequest(Long domainId, String poolId) {
            this.domainId = Objects.requireNonNull(domainId, "The required parameter 'domainId' is missing.");
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition removeIpPoolFromDomainDefinition = EmailApi.this.removeIpPoolFromDomainDefinition(this.domainId, this.poolId);
            EmailApi.this.apiClient.execute(removeIpPoolFromDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition removeIpPoolFromDomainDefinition = EmailApi.this.removeIpPoolFromDomainDefinition(this.domainId, this.poolId);
            return EmailApi.this.apiClient.executeAsync(removeIpPoolFromDomainDefinition, callback);
        }
    }

    public class RemoveIpFromPoolRequest {
        private final String poolId;
        private final String ipId;

        private RemoveIpFromPoolRequest(String poolId, String ipId) {
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
            this.ipId = Objects.requireNonNull(ipId, "The required parameter 'ipId' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition removeIpFromPoolDefinition = EmailApi.this.removeIpFromPoolDefinition(this.poolId, this.ipId);
            EmailApi.this.apiClient.execute(removeIpFromPoolDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition removeIpFromPoolDefinition = EmailApi.this.removeIpFromPoolDefinition(this.poolId, this.ipId);
            return EmailApi.this.apiClient.executeAsync(removeIpFromPoolDefinition, callback);
        }
    }

    public class GetSuppressionsRequest {
        private final String domainName;
        private final EmailSuppressionType type;
        private String emailAddress;
        private String recipientDomain;
        private OffsetDateTime createdDateFrom;
        private OffsetDateTime createdDateTo;
        private Integer page;
        private Integer size;

        private GetSuppressionsRequest(String domainName, EmailSuppressionType type) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
            this.type = Objects.requireNonNull(type, "The required parameter 'type' is missing.");
        }

        public GetSuppressionsRequest emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public GetSuppressionsRequest recipientDomain(String recipientDomain) {
            this.recipientDomain = recipientDomain;
            return this;
        }

        public GetSuppressionsRequest createdDateFrom(OffsetDateTime createdDateFrom) {
            this.createdDateFrom = createdDateFrom;
            return this;
        }

        public GetSuppressionsRequest createdDateTo(OffsetDateTime createdDateTo) {
            this.createdDateTo = createdDateTo;
            return this;
        }

        public GetSuppressionsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetSuppressionsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public EmailSuppressionInfoPageResponse execute() throws ApiException {
            RequestDefinition getSuppressionsDefinition = EmailApi.this.getSuppressionsDefinition(this.domainName, this.type, this.emailAddress, this.recipientDomain, this.createdDateFrom, this.createdDateTo, this.page, this.size);
            return (EmailSuppressionInfoPageResponse)EmailApi.this.apiClient.execute(getSuppressionsDefinition, new TypeReference<EmailSuppressionInfoPageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailSuppressionInfoPageResponse> callback) {
            RequestDefinition getSuppressionsDefinition = EmailApi.this.getSuppressionsDefinition(this.domainName, this.type, this.emailAddress, this.recipientDomain, this.createdDateFrom, this.createdDateTo, this.page, this.size);
            return EmailApi.this.apiClient.executeAsync(getSuppressionsDefinition, new TypeReference<EmailSuppressionInfoPageResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledEmailsRequest {
        private final String bulkId;

        private GetScheduledEmailsRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public EmailBulkScheduleResponse execute() throws ApiException {
            RequestDefinition getScheduledEmailsDefinition = EmailApi.this.getScheduledEmailsDefinition(this.bulkId);
            return (EmailBulkScheduleResponse)EmailApi.this.apiClient.execute(getScheduledEmailsDefinition, new TypeReference<EmailBulkScheduleResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkScheduleResponse> callback) {
            RequestDefinition getScheduledEmailsDefinition = EmailApi.this.getScheduledEmailsDefinition(this.bulkId);
            return EmailApi.this.apiClient.executeAsync(getScheduledEmailsDefinition, new TypeReference<EmailBulkScheduleResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledEmailStatusesRequest {
        private final String bulkId;

        private GetScheduledEmailStatusesRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public EmailBulkStatusResponse execute() throws ApiException {
            RequestDefinition getScheduledEmailStatusesDefinition = EmailApi.this.getScheduledEmailStatusesDefinition(this.bulkId);
            return (EmailBulkStatusResponse)EmailApi.this.apiClient.execute(getScheduledEmailStatusesDefinition, new TypeReference<EmailBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkStatusResponse> callback) {
            RequestDefinition getScheduledEmailStatusesDefinition = EmailApi.this.getScheduledEmailStatusesDefinition(this.bulkId);
            return EmailApi.this.apiClient.executeAsync(getScheduledEmailStatusesDefinition, new TypeReference<EmailBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetIpPoolsRequest {
        private String name;

        private GetIpPoolsRequest() {
        }

        public GetIpPoolsRequest name(String name) {
            this.name = name;
            return this;
        }

        public List<EmailIpPoolDetailResponse> execute() throws ApiException {
            RequestDefinition getIpPoolsDefinition = EmailApi.this.getIpPoolsDefinition(this.name);
            return (List)EmailApi.this.apiClient.execute(getIpPoolsDefinition, new TypeReference<List<EmailIpPoolDetailResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<EmailIpPoolDetailResponse>> callback) {
            RequestDefinition getIpPoolsDefinition = EmailApi.this.getIpPoolsDefinition(this.name);
            return EmailApi.this.apiClient.executeAsync(getIpPoolsDefinition, new TypeReference<List<EmailIpPoolDetailResponse>>(){}.getType(), callback);
        }
    }

    public class GetIpPoolRequest {
        private final String poolId;

        private GetIpPoolRequest(String poolId) {
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
        }

        public EmailIpPoolDetailResponse execute() throws ApiException {
            RequestDefinition getIpPoolDefinition = EmailApi.this.getIpPoolDefinition(this.poolId);
            return (EmailIpPoolDetailResponse)EmailApi.this.apiClient.execute(getIpPoolDefinition, new TypeReference<EmailIpPoolDetailResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailIpPoolDetailResponse> callback) {
            RequestDefinition getIpPoolDefinition = EmailApi.this.getIpPoolDefinition(this.poolId);
            return EmailApi.this.apiClient.executeAsync(getIpPoolDefinition, new TypeReference<EmailIpPoolDetailResponse>(){}.getType(), callback);
        }
    }

    public class GetIpDomainRequest {
        private final Long domainId;

        private GetIpDomainRequest(Long domainId) {
            this.domainId = Objects.requireNonNull(domainId, "The required parameter 'domainId' is missing.");
        }

        public EmailIpDomainResponse execute() throws ApiException {
            RequestDefinition getIpDomainDefinition = EmailApi.this.getIpDomainDefinition(this.domainId);
            return (EmailIpDomainResponse)EmailApi.this.apiClient.execute(getIpDomainDefinition, new TypeReference<EmailIpDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailIpDomainResponse> callback) {
            RequestDefinition getIpDomainDefinition = EmailApi.this.getIpDomainDefinition(this.domainId);
            return EmailApi.this.apiClient.executeAsync(getIpDomainDefinition, new TypeReference<EmailIpDomainResponse>(){}.getType(), callback);
        }
    }

    public class GetIpDetailsRequest {
        private final String ipId;

        private GetIpDetailsRequest(String ipId) {
            this.ipId = Objects.requireNonNull(ipId, "The required parameter 'ipId' is missing.");
        }

        public EmailIpDetailResponse execute() throws ApiException {
            RequestDefinition getIpDetailsDefinition = EmailApi.this.getIpDetailsDefinition(this.ipId);
            return (EmailIpDetailResponse)EmailApi.this.apiClient.execute(getIpDetailsDefinition, new TypeReference<EmailIpDetailResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailIpDetailResponse> callback) {
            RequestDefinition getIpDetailsDefinition = EmailApi.this.getIpDetailsDefinition(this.ipId);
            return EmailApi.this.apiClient.executeAsync(getIpDetailsDefinition, new TypeReference<EmailIpDetailResponse>(){}.getType(), callback);
        }
    }

    public class GetEmailLogsRequest {
        private String messageId;
        private String from;
        private String to;
        private String bulkId;
        private String campaignReferenceId;
        private String generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetEmailLogsRequest() {
        }

        public GetEmailLogsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetEmailLogsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetEmailLogsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetEmailLogsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetEmailLogsRequest campaignReferenceId(String campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public GetEmailLogsRequest generalStatus(String generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetEmailLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetEmailLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetEmailLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetEmailLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetEmailLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EmailLogsResponse execute() throws ApiException {
            RequestDefinition getEmailLogsDefinition = EmailApi.this.getEmailLogsDefinition(this.messageId, this.from, this.to, this.bulkId, this.campaignReferenceId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.applicationId, this.entityId);
            return (EmailLogsResponse)EmailApi.this.apiClient.execute(getEmailLogsDefinition, new TypeReference<EmailLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailLogsResponse> callback) {
            RequestDefinition getEmailLogsDefinition = EmailApi.this.getEmailLogsDefinition(this.messageId, this.from, this.to, this.bulkId, this.campaignReferenceId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.applicationId, this.entityId);
            return EmailApi.this.apiClient.executeAsync(getEmailLogsDefinition, new TypeReference<EmailLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetEmailDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private String campaignReferenceId;
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetEmailDeliveryReportsRequest() {
        }

        public GetEmailDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetEmailDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetEmailDeliveryReportsRequest campaignReferenceId(String campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public GetEmailDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetEmailDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetEmailDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EmailReportsResult execute() throws ApiException {
            RequestDefinition getEmailDeliveryReportsDefinition = EmailApi.this.getEmailDeliveryReportsDefinition(this.bulkId, this.messageId, this.campaignReferenceId, this.limit, this.applicationId, this.entityId);
            return (EmailReportsResult)EmailApi.this.apiClient.execute(getEmailDeliveryReportsDefinition, new TypeReference<EmailReportsResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailReportsResult> callback) {
            RequestDefinition getEmailDeliveryReportsDefinition = EmailApi.this.getEmailDeliveryReportsDefinition(this.bulkId, this.messageId, this.campaignReferenceId, this.limit, this.applicationId, this.entityId);
            return EmailApi.this.apiClient.executeAsync(getEmailDeliveryReportsDefinition, new TypeReference<EmailReportsResult>(){}.getType(), callback);
        }
    }

    public class GetDomainsRequest {
        private Integer page;
        private Integer size;

        private GetDomainsRequest() {
        }

        public GetDomainsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDomainsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public EmailDomainInfoPageResponse execute() throws ApiException {
            RequestDefinition getDomainsDefinition = EmailApi.this.getDomainsDefinition(this.page, this.size);
            return (EmailDomainInfoPageResponse)EmailApi.this.apiClient.execute(getDomainsDefinition, new TypeReference<EmailDomainInfoPageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainInfoPageResponse> callback) {
            RequestDefinition getDomainsDefinition = EmailApi.this.getDomainsDefinition(this.page, this.size);
            return EmailApi.this.apiClient.executeAsync(getDomainsDefinition, new TypeReference<EmailDomainInfoPageResponse>(){}.getType(), callback);
        }
    }

    public class GetDomainDetailsRequest {
        private final String domainName;

        private GetDomainDetailsRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition getDomainDetailsDefinition = EmailApi.this.getDomainDetailsDefinition(this.domainName);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(getDomainDetailsDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition getDomainDetailsDefinition = EmailApi.this.getDomainDetailsDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(getDomainDetailsDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }

    public class GetAllIpsRequest {
        private GetAllIpsRequest() {
        }

        public List<EmailIpDetailResponse> execute() throws ApiException {
            RequestDefinition getAllIpsDefinition = EmailApi.this.getAllIpsDefinition();
            return (List)EmailApi.this.apiClient.execute(getAllIpsDefinition, new TypeReference<List<EmailIpDetailResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<EmailIpDetailResponse>> callback) {
            RequestDefinition getAllIpsDefinition = EmailApi.this.getAllIpsDefinition();
            return EmailApi.this.apiClient.executeAsync(getAllIpsDefinition, new TypeReference<List<EmailIpDetailResponse>>(){}.getType(), callback);
        }
    }

    public class GetAllDomainsRequest {
        private Integer size;
        private Integer page;

        private GetAllDomainsRequest() {
        }

        public GetAllDomainsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public GetAllDomainsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public EmailAllDomainsResponse execute() throws ApiException {
            RequestDefinition getAllDomainsDefinition = EmailApi.this.getAllDomainsDefinition(this.size, this.page);
            return (EmailAllDomainsResponse)EmailApi.this.apiClient.execute(getAllDomainsDefinition, new TypeReference<EmailAllDomainsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailAllDomainsResponse> callback) {
            RequestDefinition getAllDomainsDefinition = EmailApi.this.getAllDomainsDefinition(this.size, this.page);
            return EmailApi.this.apiClient.executeAsync(getAllDomainsDefinition, new TypeReference<EmailAllDomainsResponse>(){}.getType(), callback);
        }
    }

    public class DeleteSuppressionsRequest {
        private final EmailDeleteSuppressionRequest emailDeleteSuppressionRequest;

        private DeleteSuppressionsRequest(EmailDeleteSuppressionRequest emailDeleteSuppressionRequest) {
            this.emailDeleteSuppressionRequest = Objects.requireNonNull(emailDeleteSuppressionRequest, "The required parameter 'emailDeleteSuppressionRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteSuppressionsDefinition = EmailApi.this.deleteSuppressionsDefinition(this.emailDeleteSuppressionRequest);
            EmailApi.this.apiClient.execute(deleteSuppressionsDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteSuppressionsDefinition = EmailApi.this.deleteSuppressionsDefinition(this.emailDeleteSuppressionRequest);
            return EmailApi.this.apiClient.executeAsync(deleteSuppressionsDefinition, callback);
        }
    }

    public class DeleteIpPoolRequest {
        private final String poolId;

        private DeleteIpPoolRequest(String poolId) {
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteIpPoolDefinition = EmailApi.this.deleteIpPoolDefinition(this.poolId);
            EmailApi.this.apiClient.execute(deleteIpPoolDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteIpPoolDefinition = EmailApi.this.deleteIpPoolDefinition(this.poolId);
            return EmailApi.this.apiClient.executeAsync(deleteIpPoolDefinition, callback);
        }
    }

    public class DeleteDomainRequest {
        private final String domainName;

        private DeleteDomainRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteDomainDefinition = EmailApi.this.deleteDomainDefinition(this.domainName);
            EmailApi.this.apiClient.execute(deleteDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteDomainDefinition = EmailApi.this.deleteDomainDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(deleteDomainDefinition, callback);
        }
    }

    public class CreateIpPoolRequest {
        private final EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest;

        private CreateIpPoolRequest(EmailIpPoolCreateApiRequest emailIpPoolCreateApiRequest) {
            this.emailIpPoolCreateApiRequest = Objects.requireNonNull(emailIpPoolCreateApiRequest, "The required parameter 'emailIpPoolCreateApiRequest' is missing.");
        }

        public EmailIpPoolResponse execute() throws ApiException {
            RequestDefinition createIpPoolDefinition = EmailApi.this.createIpPoolDefinition(this.emailIpPoolCreateApiRequest);
            return (EmailIpPoolResponse)EmailApi.this.apiClient.execute(createIpPoolDefinition, new TypeReference<EmailIpPoolResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailIpPoolResponse> callback) {
            RequestDefinition createIpPoolDefinition = EmailApi.this.createIpPoolDefinition(this.emailIpPoolCreateApiRequest);
            return EmailApi.this.apiClient.executeAsync(createIpPoolDefinition, new TypeReference<EmailIpPoolResponse>(){}.getType(), callback);
        }
    }

    public class AssignPoolToDomainRequest {
        private final Long domainId;
        private final EmailDomainIpPoolAssignApiRequest emailDomainIpPoolAssignApiRequest;

        private AssignPoolToDomainRequest(Long domainId, EmailDomainIpPoolAssignApiRequest emailDomainIpPoolAssignApiRequest) {
            this.domainId = Objects.requireNonNull(domainId, "The required parameter 'domainId' is missing.");
            this.emailDomainIpPoolAssignApiRequest = Objects.requireNonNull(emailDomainIpPoolAssignApiRequest, "The required parameter 'emailDomainIpPoolAssignApiRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition assignPoolToDomainDefinition = EmailApi.this.assignPoolToDomainDefinition(this.domainId, this.emailDomainIpPoolAssignApiRequest);
            EmailApi.this.apiClient.execute(assignPoolToDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition assignPoolToDomainDefinition = EmailApi.this.assignPoolToDomainDefinition(this.domainId, this.emailDomainIpPoolAssignApiRequest);
            return EmailApi.this.apiClient.executeAsync(assignPoolToDomainDefinition, callback);
        }
    }

    public class AssignIpToPoolRequest {
        private final String poolId;
        private final EmailIpPoolAssignIpApiRequest emailIpPoolAssignIpApiRequest;

        private AssignIpToPoolRequest(String poolId, EmailIpPoolAssignIpApiRequest emailIpPoolAssignIpApiRequest) {
            this.poolId = Objects.requireNonNull(poolId, "The required parameter 'poolId' is missing.");
            this.emailIpPoolAssignIpApiRequest = Objects.requireNonNull(emailIpPoolAssignIpApiRequest, "The required parameter 'emailIpPoolAssignIpApiRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition assignIpToPoolDefinition = EmailApi.this.assignIpToPoolDefinition(this.poolId, this.emailIpPoolAssignIpApiRequest);
            EmailApi.this.apiClient.execute(assignIpToPoolDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition assignIpToPoolDefinition = EmailApi.this.assignIpToPoolDefinition(this.poolId, this.emailIpPoolAssignIpApiRequest);
            return EmailApi.this.apiClient.executeAsync(assignIpToPoolDefinition, callback);
        }
    }

    public class AddSuppressionsRequest {
        private final EmailAddSuppressionRequest emailAddSuppressionRequest;

        private AddSuppressionsRequest(EmailAddSuppressionRequest emailAddSuppressionRequest) {
            this.emailAddSuppressionRequest = Objects.requireNonNull(emailAddSuppressionRequest, "The required parameter 'emailAddSuppressionRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition addSuppressionsDefinition = EmailApi.this.addSuppressionsDefinition(this.emailAddSuppressionRequest);
            EmailApi.this.apiClient.execute(addSuppressionsDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition addSuppressionsDefinition = EmailApi.this.addSuppressionsDefinition(this.emailAddSuppressionRequest);
            return EmailApi.this.apiClient.executeAsync(addSuppressionsDefinition, callback);
        }
    }

    public class AddDomainRequest {
        private final EmailAddDomainRequest emailAddDomainRequest;

        private AddDomainRequest(EmailAddDomainRequest emailAddDomainRequest) {
            this.emailAddDomainRequest = Objects.requireNonNull(emailAddDomainRequest, "The required parameter 'emailAddDomainRequest' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition addDomainDefinition = EmailApi.this.addDomainDefinition(this.emailAddDomainRequest);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(addDomainDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition addDomainDefinition = EmailApi.this.addDomainDefinition(this.emailAddDomainRequest);
            return EmailApi.this.apiClient.executeAsync(addDomainDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }
}

