/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.MessageGeneralStatus;
import com.infobip.model.MessageResponse;
import com.infobip.model.MmsInboundReportResponse;
import com.infobip.model.MmsLogsResponse;
import com.infobip.model.MmsReportResponse;
import com.infobip.model.MmsRequest;
import com.infobip.model.MmsUploadBinaryResult;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class MmsApi {
    private final ApiClient apiClient;

    public MmsApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getInboundMmsMessagesDefinition(Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/1/inbox/reports").requiresAuthentication(true).accept("application/json");
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetInboundMmsMessagesRequest getInboundMmsMessages() {
        return new GetInboundMmsMessagesRequest();
    }

    private RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition(String bulkId, String messageId, Integer limit, String entityId, String applicationId, String campaignReferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/2/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (campaignReferenceId != null) {
            builder.addQueryParameter(new Parameter("campaignReferenceId", campaignReferenceId));
        }
        return builder.build();
    }

    public GetOutboundMmsMessageDeliveryReportsRequest getOutboundMmsMessageDeliveryReports() {
        return new GetOutboundMmsMessageDeliveryReportsRequest();
    }

    private RequestDefinition getOutboundMmsMessageLogsDefinition(String mcc, String mnc, String sender, String destination, List<String> bulkId, List<String> messageId, MessageGeneralStatus generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String entityId, String applicationId, List<String> campaignReferenceId, Boolean useCursor, String cursor) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/2/logs").requiresAuthentication(true).accept("application/json");
        if (mcc != null) {
            builder.addQueryParameter(new Parameter("mcc", mcc));
        }
        if (mnc != null) {
            builder.addQueryParameter(new Parameter("mnc", mnc));
        }
        if (sender != null) {
            builder.addQueryParameter(new Parameter("sender", sender));
        }
        if (destination != null) {
            builder.addQueryParameter(new Parameter("destination", destination));
        }
        if (bulkId != null) {
            for (String parameterItem : bulkId) {
                builder.addQueryParameter(new Parameter("bulkId", parameterItem));
            }
        }
        if (messageId != null) {
            for (String parameterItem : messageId) {
                builder.addQueryParameter(new Parameter("messageId", parameterItem));
            }
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", (Object)generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (campaignReferenceId != null) {
            for (String parameterItem : campaignReferenceId) {
                builder.addQueryParameter(new Parameter("campaignReferenceId", parameterItem));
            }
        }
        if (useCursor != null) {
            builder.addQueryParameter(new Parameter("useCursor", useCursor));
        }
        if (cursor != null) {
            builder.addQueryParameter(new Parameter("cursor", cursor));
        }
        return builder.build();
    }

    public GetOutboundMmsMessageLogsRequest getOutboundMmsMessageLogs() {
        return new GetOutboundMmsMessageLogsRequest();
    }

    private RequestDefinition sendMmsMessagesDefinition(MmsRequest mmsRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/mms/2/messages").body(mmsRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMmsMessagesRequest sendMmsMessages(MmsRequest mmsRequest) {
        return new SendMmsMessagesRequest(mmsRequest);
    }

    private RequestDefinition uploadBinaryDefinition(String xContentId, String xMediaType, File body, Long xValidityPeriodMinutes) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/mms/1/content").body(body).requiresAuthentication(true).accept("application/json").contentType("application/octet-stream");
        if (xContentId != null) {
            builder.addHeaderParameter(new Parameter("X-Content-Id", xContentId));
        }
        if (xMediaType != null) {
            builder.addHeaderParameter(new Parameter("X-Media-Type", xMediaType));
        }
        if (xValidityPeriodMinutes != null) {
            builder.addHeaderParameter(new Parameter("X-Validity-Period-Minutes", xValidityPeriodMinutes));
        }
        return builder.build();
    }

    public UploadBinaryRequest uploadBinary(String xContentId, String xMediaType, File body) {
        return new UploadBinaryRequest(xContentId, xMediaType, body);
    }

    public class UploadBinaryRequest {
        private final String xContentId;
        private final String xMediaType;
        private final File body;
        private Long xValidityPeriodMinutes;

        private UploadBinaryRequest(String xContentId, String xMediaType, File body) {
            this.xContentId = Objects.requireNonNull(xContentId, "The required parameter 'xContentId' is missing.");
            this.xMediaType = Objects.requireNonNull(xMediaType, "The required parameter 'xMediaType' is missing.");
            this.body = Objects.requireNonNull(body, "The required parameter 'body' is missing.");
        }

        public UploadBinaryRequest xValidityPeriodMinutes(Long xValidityPeriodMinutes) {
            this.xValidityPeriodMinutes = xValidityPeriodMinutes;
            return this;
        }

        public MmsUploadBinaryResult execute() throws ApiException {
            RequestDefinition uploadBinaryDefinition = MmsApi.this.uploadBinaryDefinition(this.xContentId, this.xMediaType, this.body, this.xValidityPeriodMinutes);
            return (MmsUploadBinaryResult)MmsApi.this.apiClient.execute(uploadBinaryDefinition, new TypeReference<MmsUploadBinaryResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsUploadBinaryResult> callback) {
            RequestDefinition uploadBinaryDefinition = MmsApi.this.uploadBinaryDefinition(this.xContentId, this.xMediaType, this.body, this.xValidityPeriodMinutes);
            return MmsApi.this.apiClient.executeAsync(uploadBinaryDefinition, new TypeReference<MmsUploadBinaryResult>(){}.getType(), callback);
        }
    }

    public class SendMmsMessagesRequest {
        private final MmsRequest mmsRequest;

        private SendMmsMessagesRequest(MmsRequest mmsRequest) {
            this.mmsRequest = Objects.requireNonNull(mmsRequest, "The required parameter 'mmsRequest' is missing.");
        }

        public MessageResponse execute() throws ApiException {
            RequestDefinition sendMmsMessagesDefinition = MmsApi.this.sendMmsMessagesDefinition(this.mmsRequest);
            return (MessageResponse)MmsApi.this.apiClient.execute(sendMmsMessagesDefinition, new TypeReference<MessageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessageResponse> callback) {
            RequestDefinition sendMmsMessagesDefinition = MmsApi.this.sendMmsMessagesDefinition(this.mmsRequest);
            return MmsApi.this.apiClient.executeAsync(sendMmsMessagesDefinition, new TypeReference<MessageResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundMmsMessageLogsRequest {
        private String mcc;
        private String mnc;
        private String sender;
        private String destination;
        private List<String> bulkId;
        private List<String> messageId;
        private MessageGeneralStatus generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String entityId;
        private String applicationId;
        private List<String> campaignReferenceId;
        private Boolean useCursor;
        private String cursor;

        private GetOutboundMmsMessageLogsRequest() {
        }

        public GetOutboundMmsMessageLogsRequest mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest sender(String sender) {
            this.sender = sender;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest bulkId(List<String> bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest messageId(List<String> messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest generalStatus(MessageGeneralStatus generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest campaignReferenceId(List<String> campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest useCursor(Boolean useCursor) {
            this.useCursor = useCursor;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public MmsLogsResponse execute() throws ApiException {
            RequestDefinition getOutboundMmsMessageLogsDefinition = MmsApi.this.getOutboundMmsMessageLogsDefinition(this.mcc, this.mnc, this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId, this.campaignReferenceId, this.useCursor, this.cursor);
            return (MmsLogsResponse)MmsApi.this.apiClient.execute(getOutboundMmsMessageLogsDefinition, new TypeReference<MmsLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsLogsResponse> callback) {
            RequestDefinition getOutboundMmsMessageLogsDefinition = MmsApi.this.getOutboundMmsMessageLogsDefinition(this.mcc, this.mnc, this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId, this.campaignReferenceId, this.useCursor, this.cursor);
            return MmsApi.this.apiClient.executeAsync(getOutboundMmsMessageLogsDefinition, new TypeReference<MmsLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundMmsMessageDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;
        private String entityId;
        private String applicationId;
        private String campaignReferenceId;

        private GetOutboundMmsMessageDeliveryReportsRequest() {
        }

        public GetOutboundMmsMessageDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest campaignReferenceId(String campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public MmsReportResponse execute() throws ApiException {
            RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition = MmsApi.this.getOutboundMmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId, this.campaignReferenceId);
            return (MmsReportResponse)MmsApi.this.apiClient.execute(getOutboundMmsMessageDeliveryReportsDefinition, new TypeReference<MmsReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsReportResponse> callback) {
            RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition = MmsApi.this.getOutboundMmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId, this.campaignReferenceId);
            return MmsApi.this.apiClient.executeAsync(getOutboundMmsMessageDeliveryReportsDefinition, new TypeReference<MmsReportResponse>(){}.getType(), callback);
        }
    }

    public class GetInboundMmsMessagesRequest {
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetInboundMmsMessagesRequest() {
        }

        public GetInboundMmsMessagesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetInboundMmsMessagesRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetInboundMmsMessagesRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public MmsInboundReportResponse execute() throws ApiException {
            RequestDefinition getInboundMmsMessagesDefinition = MmsApi.this.getInboundMmsMessagesDefinition(this.limit, this.applicationId, this.entityId);
            return (MmsInboundReportResponse)MmsApi.this.apiClient.execute(getInboundMmsMessagesDefinition, new TypeReference<MmsInboundReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsInboundReportResponse> callback) {
            RequestDefinition getInboundMmsMessagesDefinition = MmsApi.this.getInboundMmsMessagesDefinition(this.limit, this.applicationId, this.entityId);
            return MmsApi.this.apiClient.executeAsync(getInboundMmsMessagesDefinition, new TypeReference<MmsInboundReportResponse>(){}.getType(), callback);
        }
    }
}

