/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.TfaApplicationRequest;
import com.infobip.model.TfaApplicationResponse;
import com.infobip.model.TfaCreateEmailMessageRequest;
import com.infobip.model.TfaCreateMessageRequest;
import com.infobip.model.TfaEmailMessage;
import com.infobip.model.TfaMessage;
import com.infobip.model.TfaResendPinRequest;
import com.infobip.model.TfaResendPinRequestViaEmail;
import com.infobip.model.TfaStartAuthenticationRequest;
import com.infobip.model.TfaStartAuthenticationResponse;
import com.infobip.model.TfaStartEmailAuthenticationRequest;
import com.infobip.model.TfaStartEmailAuthenticationResponse;
import com.infobip.model.TfaUpdateEmailMessageRequest;
import com.infobip.model.TfaUpdateMessageRequest;
import com.infobip.model.TfaVerificationResponse;
import com.infobip.model.TfaVerifyPinRequest;
import com.infobip.model.TfaVerifyPinResponse;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class TfaApi {
    private final ApiClient apiClient;

    public TfaApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition createTfaApplicationDefinition(TfaApplicationRequest tfaApplicationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/applications").body(tfaApplicationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateTfaApplicationRequest createTfaApplication(TfaApplicationRequest tfaApplicationRequest) {
        return new CreateTfaApplicationRequest(tfaApplicationRequest);
    }

    private RequestDefinition createTfaEmailMessageTemplateDefinition(String appId, TfaCreateEmailMessageRequest tfaCreateEmailMessageRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/applications/{appId}/email/messages").body(tfaCreateEmailMessageRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        return builder.build();
    }

    public CreateTfaEmailMessageTemplateRequest createTfaEmailMessageTemplate(String appId, TfaCreateEmailMessageRequest tfaCreateEmailMessageRequest) {
        return new CreateTfaEmailMessageTemplateRequest(appId, tfaCreateEmailMessageRequest);
    }

    private RequestDefinition createTfaMessageTemplateDefinition(String appId, TfaCreateMessageRequest tfaCreateMessageRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/applications/{appId}/messages").body(tfaCreateMessageRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        return builder.build();
    }

    public CreateTfaMessageTemplateRequest createTfaMessageTemplate(String appId, TfaCreateMessageRequest tfaCreateMessageRequest) {
        return new CreateTfaMessageTemplateRequest(appId, tfaCreateMessageRequest);
    }

    private RequestDefinition getTfaApplicationDefinition(String appId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/2fa/2/applications/{appId}").requiresAuthentication(true).accept("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        return builder.build();
    }

    public GetTfaApplicationRequest getTfaApplication(String appId) {
        return new GetTfaApplicationRequest(appId);
    }

    private RequestDefinition getTfaApplicationsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/2fa/2/applications").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetTfaApplicationsRequest getTfaApplications() {
        return new GetTfaApplicationsRequest();
    }

    private RequestDefinition getTfaMessageTemplateDefinition(String appId, String msgId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/2fa/2/applications/{appId}/messages/{msgId}").requiresAuthentication(true).accept("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        if (msgId != null) {
            builder.addPathParameter(new Parameter("msgId", msgId));
        }
        return builder.build();
    }

    public GetTfaMessageTemplateRequest getTfaMessageTemplate(String appId, String msgId) {
        return new GetTfaMessageTemplateRequest(appId, msgId);
    }

    private RequestDefinition getTfaMessageTemplatesDefinition(String appId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/2fa/2/applications/{appId}/messages").requiresAuthentication(true).accept("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        return builder.build();
    }

    public GetTfaMessageTemplatesRequest getTfaMessageTemplates(String appId) {
        return new GetTfaMessageTemplatesRequest(appId);
    }

    private RequestDefinition getTfaVerificationStatusDefinition(String msisdn, String appId, Boolean verified, Boolean sent) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/2fa/2/applications/{appId}/verifications").requiresAuthentication(true).accept("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        if (msisdn != null) {
            builder.addQueryParameter(new Parameter("msisdn", msisdn));
        }
        if (verified != null) {
            builder.addQueryParameter(new Parameter("verified", verified));
        }
        if (sent != null) {
            builder.addQueryParameter(new Parameter("sent", sent));
        }
        return builder.build();
    }

    public GetTfaVerificationStatusRequest getTfaVerificationStatus(String msisdn, String appId) {
        return new GetTfaVerificationStatusRequest(msisdn, appId);
    }

    private RequestDefinition resend2faPinCodeOverEmailDefinition(String pinId, TfaResendPinRequestViaEmail tfaResendPinRequestViaEmail) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/{pinId}/resend/email").body(tfaResendPinRequestViaEmail).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (pinId != null) {
            builder.addPathParameter(new Parameter("pinId", pinId));
        }
        return builder.build();
    }

    public Resend2faPinCodeOverEmailRequest resend2faPinCodeOverEmail(String pinId, TfaResendPinRequestViaEmail tfaResendPinRequestViaEmail) {
        return new Resend2faPinCodeOverEmailRequest(pinId, tfaResendPinRequestViaEmail);
    }

    private RequestDefinition resendTfaPinCodeOverSmsDefinition(String pinId, TfaResendPinRequest tfaResendPinRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/{pinId}/resend").body(tfaResendPinRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (pinId != null) {
            builder.addPathParameter(new Parameter("pinId", pinId));
        }
        return builder.build();
    }

    public ResendTfaPinCodeOverSmsRequest resendTfaPinCodeOverSms(String pinId, TfaResendPinRequest tfaResendPinRequest) {
        return new ResendTfaPinCodeOverSmsRequest(pinId, tfaResendPinRequest);
    }

    private RequestDefinition resendTfaPinCodeOverVoiceDefinition(String pinId, TfaResendPinRequest tfaResendPinRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/{pinId}/resend/voice").body(tfaResendPinRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (pinId != null) {
            builder.addPathParameter(new Parameter("pinId", pinId));
        }
        return builder.build();
    }

    public ResendTfaPinCodeOverVoiceRequest resendTfaPinCodeOverVoice(String pinId, TfaResendPinRequest tfaResendPinRequest) {
        return new ResendTfaPinCodeOverVoiceRequest(pinId, tfaResendPinRequest);
    }

    private RequestDefinition send2faPinCodeOverEmailDefinition(TfaStartEmailAuthenticationRequest tfaStartEmailAuthenticationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/email").body(tfaStartEmailAuthenticationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public Send2faPinCodeOverEmailRequest send2faPinCodeOverEmail(TfaStartEmailAuthenticationRequest tfaStartEmailAuthenticationRequest) {
        return new Send2faPinCodeOverEmailRequest(tfaStartEmailAuthenticationRequest);
    }

    private RequestDefinition sendTfaPinCodeOverSmsDefinition(TfaStartAuthenticationRequest tfaStartAuthenticationRequest, Boolean ncNeeded) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin").body(tfaStartAuthenticationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (ncNeeded != null) {
            builder.addQueryParameter(new Parameter("ncNeeded", ncNeeded));
        }
        return builder.build();
    }

    public SendTfaPinCodeOverSmsRequest sendTfaPinCodeOverSms(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) {
        return new SendTfaPinCodeOverSmsRequest(tfaStartAuthenticationRequest);
    }

    private RequestDefinition sendTfaPinCodeOverVoiceDefinition(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/voice").body(tfaStartAuthenticationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendTfaPinCodeOverVoiceRequest sendTfaPinCodeOverVoice(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) {
        return new SendTfaPinCodeOverVoiceRequest(tfaStartAuthenticationRequest);
    }

    private RequestDefinition updateTfaApplicationDefinition(String appId, TfaApplicationRequest tfaApplicationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/2fa/2/applications/{appId}").body(tfaApplicationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        return builder.build();
    }

    public UpdateTfaApplicationRequest updateTfaApplication(String appId, TfaApplicationRequest tfaApplicationRequest) {
        return new UpdateTfaApplicationRequest(appId, tfaApplicationRequest);
    }

    private RequestDefinition updateTfaEmailMessageTemplateDefinition(String appId, String msgId, TfaUpdateEmailMessageRequest tfaUpdateEmailMessageRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/2fa/2/applications/{appId}/email/messages/{msgId}").body(tfaUpdateEmailMessageRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        if (msgId != null) {
            builder.addPathParameter(new Parameter("msgId", msgId));
        }
        return builder.build();
    }

    public UpdateTfaEmailMessageTemplateRequest updateTfaEmailMessageTemplate(String appId, String msgId, TfaUpdateEmailMessageRequest tfaUpdateEmailMessageRequest) {
        return new UpdateTfaEmailMessageTemplateRequest(appId, msgId, tfaUpdateEmailMessageRequest);
    }

    private RequestDefinition updateTfaMessageTemplateDefinition(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/2fa/2/applications/{appId}/messages/{msgId}").body(tfaUpdateMessageRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (appId != null) {
            builder.addPathParameter(new Parameter("appId", appId));
        }
        if (msgId != null) {
            builder.addPathParameter(new Parameter("msgId", msgId));
        }
        return builder.build();
    }

    public UpdateTfaMessageTemplateRequest updateTfaMessageTemplate(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest) {
        return new UpdateTfaMessageTemplateRequest(appId, msgId, tfaUpdateMessageRequest);
    }

    private RequestDefinition verifyTfaPhoneNumberDefinition(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/2fa/2/pin/{pinId}/verify").body(tfaVerifyPinRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (pinId != null) {
            builder.addPathParameter(new Parameter("pinId", pinId));
        }
        return builder.build();
    }

    public VerifyTfaPhoneNumberRequest verifyTfaPhoneNumber(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) {
        return new VerifyTfaPhoneNumberRequest(pinId, tfaVerifyPinRequest);
    }

    public class VerifyTfaPhoneNumberRequest {
        private final String pinId;
        private final TfaVerifyPinRequest tfaVerifyPinRequest;

        private VerifyTfaPhoneNumberRequest(String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) {
            this.pinId = Objects.requireNonNull(pinId, "The required parameter 'pinId' is missing.");
            this.tfaVerifyPinRequest = Objects.requireNonNull(tfaVerifyPinRequest, "The required parameter 'tfaVerifyPinRequest' is missing.");
        }

        public TfaVerifyPinResponse execute() throws ApiException {
            RequestDefinition verifyTfaPhoneNumberDefinition = TfaApi.this.verifyTfaPhoneNumberDefinition(this.pinId, this.tfaVerifyPinRequest);
            return (TfaVerifyPinResponse)TfaApi.this.apiClient.execute(verifyTfaPhoneNumberDefinition, new TypeReference<TfaVerifyPinResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaVerifyPinResponse> callback) {
            RequestDefinition verifyTfaPhoneNumberDefinition = TfaApi.this.verifyTfaPhoneNumberDefinition(this.pinId, this.tfaVerifyPinRequest);
            return TfaApi.this.apiClient.executeAsync(verifyTfaPhoneNumberDefinition, new TypeReference<TfaVerifyPinResponse>(){}.getType(), callback);
        }
    }

    public class UpdateTfaMessageTemplateRequest {
        private final String appId;
        private final String msgId;
        private final TfaUpdateMessageRequest tfaUpdateMessageRequest;

        private UpdateTfaMessageTemplateRequest(String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.msgId = Objects.requireNonNull(msgId, "The required parameter 'msgId' is missing.");
            this.tfaUpdateMessageRequest = Objects.requireNonNull(tfaUpdateMessageRequest, "The required parameter 'tfaUpdateMessageRequest' is missing.");
        }

        public TfaMessage execute() throws ApiException {
            RequestDefinition updateTfaMessageTemplateDefinition = TfaApi.this.updateTfaMessageTemplateDefinition(this.appId, this.msgId, this.tfaUpdateMessageRequest);
            return (TfaMessage)TfaApi.this.apiClient.execute(updateTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaMessage> callback) {
            RequestDefinition updateTfaMessageTemplateDefinition = TfaApi.this.updateTfaMessageTemplateDefinition(this.appId, this.msgId, this.tfaUpdateMessageRequest);
            return TfaApi.this.apiClient.executeAsync(updateTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType(), callback);
        }
    }

    public class UpdateTfaEmailMessageTemplateRequest {
        private final String appId;
        private final String msgId;
        private final TfaUpdateEmailMessageRequest tfaUpdateEmailMessageRequest;

        private UpdateTfaEmailMessageTemplateRequest(String appId, String msgId, TfaUpdateEmailMessageRequest tfaUpdateEmailMessageRequest) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.msgId = Objects.requireNonNull(msgId, "The required parameter 'msgId' is missing.");
            this.tfaUpdateEmailMessageRequest = Objects.requireNonNull(tfaUpdateEmailMessageRequest, "The required parameter 'tfaUpdateEmailMessageRequest' is missing.");
        }

        public TfaEmailMessage execute() throws ApiException {
            RequestDefinition updateTfaEmailMessageTemplateDefinition = TfaApi.this.updateTfaEmailMessageTemplateDefinition(this.appId, this.msgId, this.tfaUpdateEmailMessageRequest);
            return (TfaEmailMessage)TfaApi.this.apiClient.execute(updateTfaEmailMessageTemplateDefinition, new TypeReference<TfaEmailMessage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaEmailMessage> callback) {
            RequestDefinition updateTfaEmailMessageTemplateDefinition = TfaApi.this.updateTfaEmailMessageTemplateDefinition(this.appId, this.msgId, this.tfaUpdateEmailMessageRequest);
            return TfaApi.this.apiClient.executeAsync(updateTfaEmailMessageTemplateDefinition, new TypeReference<TfaEmailMessage>(){}.getType(), callback);
        }
    }

    public class UpdateTfaApplicationRequest {
        private final String appId;
        private final TfaApplicationRequest tfaApplicationRequest;

        private UpdateTfaApplicationRequest(String appId, TfaApplicationRequest tfaApplicationRequest) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.tfaApplicationRequest = Objects.requireNonNull(tfaApplicationRequest, "The required parameter 'tfaApplicationRequest' is missing.");
        }

        public TfaApplicationResponse execute() throws ApiException {
            RequestDefinition updateTfaApplicationDefinition = TfaApi.this.updateTfaApplicationDefinition(this.appId, this.tfaApplicationRequest);
            return (TfaApplicationResponse)TfaApi.this.apiClient.execute(updateTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaApplicationResponse> callback) {
            RequestDefinition updateTfaApplicationDefinition = TfaApi.this.updateTfaApplicationDefinition(this.appId, this.tfaApplicationRequest);
            return TfaApi.this.apiClient.executeAsync(updateTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType(), callback);
        }
    }

    public class SendTfaPinCodeOverVoiceRequest {
        private final TfaStartAuthenticationRequest tfaStartAuthenticationRequest;

        private SendTfaPinCodeOverVoiceRequest(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) {
            this.tfaStartAuthenticationRequest = Objects.requireNonNull(tfaStartAuthenticationRequest, "The required parameter 'tfaStartAuthenticationRequest' is missing.");
        }

        public TfaStartAuthenticationResponse execute() throws ApiException {
            RequestDefinition sendTfaPinCodeOverVoiceDefinition = TfaApi.this.sendTfaPinCodeOverVoiceDefinition(this.tfaStartAuthenticationRequest);
            return (TfaStartAuthenticationResponse)TfaApi.this.apiClient.execute(sendTfaPinCodeOverVoiceDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartAuthenticationResponse> callback) {
            RequestDefinition sendTfaPinCodeOverVoiceDefinition = TfaApi.this.sendTfaPinCodeOverVoiceDefinition(this.tfaStartAuthenticationRequest);
            return TfaApi.this.apiClient.executeAsync(sendTfaPinCodeOverVoiceDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class SendTfaPinCodeOverSmsRequest {
        private final TfaStartAuthenticationRequest tfaStartAuthenticationRequest;
        private Boolean ncNeeded;

        private SendTfaPinCodeOverSmsRequest(TfaStartAuthenticationRequest tfaStartAuthenticationRequest) {
            this.tfaStartAuthenticationRequest = Objects.requireNonNull(tfaStartAuthenticationRequest, "The required parameter 'tfaStartAuthenticationRequest' is missing.");
        }

        public SendTfaPinCodeOverSmsRequest ncNeeded(Boolean ncNeeded) {
            this.ncNeeded = ncNeeded;
            return this;
        }

        public TfaStartAuthenticationResponse execute() throws ApiException {
            RequestDefinition sendTfaPinCodeOverSmsDefinition = TfaApi.this.sendTfaPinCodeOverSmsDefinition(this.tfaStartAuthenticationRequest, this.ncNeeded);
            return (TfaStartAuthenticationResponse)TfaApi.this.apiClient.execute(sendTfaPinCodeOverSmsDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartAuthenticationResponse> callback) {
            RequestDefinition sendTfaPinCodeOverSmsDefinition = TfaApi.this.sendTfaPinCodeOverSmsDefinition(this.tfaStartAuthenticationRequest, this.ncNeeded);
            return TfaApi.this.apiClient.executeAsync(sendTfaPinCodeOverSmsDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class Send2faPinCodeOverEmailRequest {
        private final TfaStartEmailAuthenticationRequest tfaStartEmailAuthenticationRequest;

        private Send2faPinCodeOverEmailRequest(TfaStartEmailAuthenticationRequest tfaStartEmailAuthenticationRequest) {
            this.tfaStartEmailAuthenticationRequest = Objects.requireNonNull(tfaStartEmailAuthenticationRequest, "The required parameter 'tfaStartEmailAuthenticationRequest' is missing.");
        }

        public TfaStartEmailAuthenticationResponse execute() throws ApiException {
            RequestDefinition send2faPinCodeOverEmailDefinition = TfaApi.this.send2faPinCodeOverEmailDefinition(this.tfaStartEmailAuthenticationRequest);
            return (TfaStartEmailAuthenticationResponse)TfaApi.this.apiClient.execute(send2faPinCodeOverEmailDefinition, new TypeReference<TfaStartEmailAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartEmailAuthenticationResponse> callback) {
            RequestDefinition send2faPinCodeOverEmailDefinition = TfaApi.this.send2faPinCodeOverEmailDefinition(this.tfaStartEmailAuthenticationRequest);
            return TfaApi.this.apiClient.executeAsync(send2faPinCodeOverEmailDefinition, new TypeReference<TfaStartEmailAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class ResendTfaPinCodeOverVoiceRequest {
        private final String pinId;
        private final TfaResendPinRequest tfaResendPinRequest;

        private ResendTfaPinCodeOverVoiceRequest(String pinId, TfaResendPinRequest tfaResendPinRequest) {
            this.pinId = Objects.requireNonNull(pinId, "The required parameter 'pinId' is missing.");
            this.tfaResendPinRequest = Objects.requireNonNull(tfaResendPinRequest, "The required parameter 'tfaResendPinRequest' is missing.");
        }

        public TfaStartAuthenticationResponse execute() throws ApiException {
            RequestDefinition resendTfaPinCodeOverVoiceDefinition = TfaApi.this.resendTfaPinCodeOverVoiceDefinition(this.pinId, this.tfaResendPinRequest);
            return (TfaStartAuthenticationResponse)TfaApi.this.apiClient.execute(resendTfaPinCodeOverVoiceDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartAuthenticationResponse> callback) {
            RequestDefinition resendTfaPinCodeOverVoiceDefinition = TfaApi.this.resendTfaPinCodeOverVoiceDefinition(this.pinId, this.tfaResendPinRequest);
            return TfaApi.this.apiClient.executeAsync(resendTfaPinCodeOverVoiceDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class ResendTfaPinCodeOverSmsRequest {
        private final String pinId;
        private final TfaResendPinRequest tfaResendPinRequest;

        private ResendTfaPinCodeOverSmsRequest(String pinId, TfaResendPinRequest tfaResendPinRequest) {
            this.pinId = Objects.requireNonNull(pinId, "The required parameter 'pinId' is missing.");
            this.tfaResendPinRequest = Objects.requireNonNull(tfaResendPinRequest, "The required parameter 'tfaResendPinRequest' is missing.");
        }

        public TfaStartAuthenticationResponse execute() throws ApiException {
            RequestDefinition resendTfaPinCodeOverSmsDefinition = TfaApi.this.resendTfaPinCodeOverSmsDefinition(this.pinId, this.tfaResendPinRequest);
            return (TfaStartAuthenticationResponse)TfaApi.this.apiClient.execute(resendTfaPinCodeOverSmsDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartAuthenticationResponse> callback) {
            RequestDefinition resendTfaPinCodeOverSmsDefinition = TfaApi.this.resendTfaPinCodeOverSmsDefinition(this.pinId, this.tfaResendPinRequest);
            return TfaApi.this.apiClient.executeAsync(resendTfaPinCodeOverSmsDefinition, new TypeReference<TfaStartAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class Resend2faPinCodeOverEmailRequest {
        private final String pinId;
        private final TfaResendPinRequestViaEmail tfaResendPinRequestViaEmail;

        private Resend2faPinCodeOverEmailRequest(String pinId, TfaResendPinRequestViaEmail tfaResendPinRequestViaEmail) {
            this.pinId = Objects.requireNonNull(pinId, "The required parameter 'pinId' is missing.");
            this.tfaResendPinRequestViaEmail = Objects.requireNonNull(tfaResendPinRequestViaEmail, "The required parameter 'tfaResendPinRequestViaEmail' is missing.");
        }

        public TfaStartEmailAuthenticationResponse execute() throws ApiException {
            RequestDefinition resend2faPinCodeOverEmailDefinition = TfaApi.this.resend2faPinCodeOverEmailDefinition(this.pinId, this.tfaResendPinRequestViaEmail);
            return (TfaStartEmailAuthenticationResponse)TfaApi.this.apiClient.execute(resend2faPinCodeOverEmailDefinition, new TypeReference<TfaStartEmailAuthenticationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaStartEmailAuthenticationResponse> callback) {
            RequestDefinition resend2faPinCodeOverEmailDefinition = TfaApi.this.resend2faPinCodeOverEmailDefinition(this.pinId, this.tfaResendPinRequestViaEmail);
            return TfaApi.this.apiClient.executeAsync(resend2faPinCodeOverEmailDefinition, new TypeReference<TfaStartEmailAuthenticationResponse>(){}.getType(), callback);
        }
    }

    public class GetTfaVerificationStatusRequest {
        private final String msisdn;
        private final String appId;
        private Boolean verified;
        private Boolean sent;

        private GetTfaVerificationStatusRequest(String msisdn, String appId) {
            this.msisdn = Objects.requireNonNull(msisdn, "The required parameter 'msisdn' is missing.");
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
        }

        public GetTfaVerificationStatusRequest verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        public GetTfaVerificationStatusRequest sent(Boolean sent) {
            this.sent = sent;
            return this;
        }

        public TfaVerificationResponse execute() throws ApiException {
            RequestDefinition getTfaVerificationStatusDefinition = TfaApi.this.getTfaVerificationStatusDefinition(this.msisdn, this.appId, this.verified, this.sent);
            return (TfaVerificationResponse)TfaApi.this.apiClient.execute(getTfaVerificationStatusDefinition, new TypeReference<TfaVerificationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaVerificationResponse> callback) {
            RequestDefinition getTfaVerificationStatusDefinition = TfaApi.this.getTfaVerificationStatusDefinition(this.msisdn, this.appId, this.verified, this.sent);
            return TfaApi.this.apiClient.executeAsync(getTfaVerificationStatusDefinition, new TypeReference<TfaVerificationResponse>(){}.getType(), callback);
        }
    }

    public class GetTfaMessageTemplatesRequest {
        private final String appId;

        private GetTfaMessageTemplatesRequest(String appId) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
        }

        public List<TfaMessage> execute() throws ApiException {
            RequestDefinition getTfaMessageTemplatesDefinition = TfaApi.this.getTfaMessageTemplatesDefinition(this.appId);
            return (List)TfaApi.this.apiClient.execute(getTfaMessageTemplatesDefinition, new TypeReference<List<TfaMessage>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<TfaMessage>> callback) {
            RequestDefinition getTfaMessageTemplatesDefinition = TfaApi.this.getTfaMessageTemplatesDefinition(this.appId);
            return TfaApi.this.apiClient.executeAsync(getTfaMessageTemplatesDefinition, new TypeReference<List<TfaMessage>>(){}.getType(), callback);
        }
    }

    public class GetTfaMessageTemplateRequest {
        private final String appId;
        private final String msgId;

        private GetTfaMessageTemplateRequest(String appId, String msgId) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.msgId = Objects.requireNonNull(msgId, "The required parameter 'msgId' is missing.");
        }

        public TfaMessage execute() throws ApiException {
            RequestDefinition getTfaMessageTemplateDefinition = TfaApi.this.getTfaMessageTemplateDefinition(this.appId, this.msgId);
            return (TfaMessage)TfaApi.this.apiClient.execute(getTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaMessage> callback) {
            RequestDefinition getTfaMessageTemplateDefinition = TfaApi.this.getTfaMessageTemplateDefinition(this.appId, this.msgId);
            return TfaApi.this.apiClient.executeAsync(getTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType(), callback);
        }
    }

    public class GetTfaApplicationsRequest {
        private GetTfaApplicationsRequest() {
        }

        public List<TfaApplicationResponse> execute() throws ApiException {
            RequestDefinition getTfaApplicationsDefinition = TfaApi.this.getTfaApplicationsDefinition();
            return (List)TfaApi.this.apiClient.execute(getTfaApplicationsDefinition, new TypeReference<List<TfaApplicationResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<TfaApplicationResponse>> callback) {
            RequestDefinition getTfaApplicationsDefinition = TfaApi.this.getTfaApplicationsDefinition();
            return TfaApi.this.apiClient.executeAsync(getTfaApplicationsDefinition, new TypeReference<List<TfaApplicationResponse>>(){}.getType(), callback);
        }
    }

    public class GetTfaApplicationRequest {
        private final String appId;

        private GetTfaApplicationRequest(String appId) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
        }

        public TfaApplicationResponse execute() throws ApiException {
            RequestDefinition getTfaApplicationDefinition = TfaApi.this.getTfaApplicationDefinition(this.appId);
            return (TfaApplicationResponse)TfaApi.this.apiClient.execute(getTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaApplicationResponse> callback) {
            RequestDefinition getTfaApplicationDefinition = TfaApi.this.getTfaApplicationDefinition(this.appId);
            return TfaApi.this.apiClient.executeAsync(getTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType(), callback);
        }
    }

    public class CreateTfaMessageTemplateRequest {
        private final String appId;
        private final TfaCreateMessageRequest tfaCreateMessageRequest;

        private CreateTfaMessageTemplateRequest(String appId, TfaCreateMessageRequest tfaCreateMessageRequest) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.tfaCreateMessageRequest = Objects.requireNonNull(tfaCreateMessageRequest, "The required parameter 'tfaCreateMessageRequest' is missing.");
        }

        public TfaMessage execute() throws ApiException {
            RequestDefinition createTfaMessageTemplateDefinition = TfaApi.this.createTfaMessageTemplateDefinition(this.appId, this.tfaCreateMessageRequest);
            return (TfaMessage)TfaApi.this.apiClient.execute(createTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaMessage> callback) {
            RequestDefinition createTfaMessageTemplateDefinition = TfaApi.this.createTfaMessageTemplateDefinition(this.appId, this.tfaCreateMessageRequest);
            return TfaApi.this.apiClient.executeAsync(createTfaMessageTemplateDefinition, new TypeReference<TfaMessage>(){}.getType(), callback);
        }
    }

    public class CreateTfaEmailMessageTemplateRequest {
        private final String appId;
        private final TfaCreateEmailMessageRequest tfaCreateEmailMessageRequest;

        private CreateTfaEmailMessageTemplateRequest(String appId, TfaCreateEmailMessageRequest tfaCreateEmailMessageRequest) {
            this.appId = Objects.requireNonNull(appId, "The required parameter 'appId' is missing.");
            this.tfaCreateEmailMessageRequest = Objects.requireNonNull(tfaCreateEmailMessageRequest, "The required parameter 'tfaCreateEmailMessageRequest' is missing.");
        }

        public TfaEmailMessage execute() throws ApiException {
            RequestDefinition createTfaEmailMessageTemplateDefinition = TfaApi.this.createTfaEmailMessageTemplateDefinition(this.appId, this.tfaCreateEmailMessageRequest);
            return (TfaEmailMessage)TfaApi.this.apiClient.execute(createTfaEmailMessageTemplateDefinition, new TypeReference<TfaEmailMessage>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaEmailMessage> callback) {
            RequestDefinition createTfaEmailMessageTemplateDefinition = TfaApi.this.createTfaEmailMessageTemplateDefinition(this.appId, this.tfaCreateEmailMessageRequest);
            return TfaApi.this.apiClient.executeAsync(createTfaEmailMessageTemplateDefinition, new TypeReference<TfaEmailMessage>(){}.getType(), callback);
        }
    }

    public class CreateTfaApplicationRequest {
        private final TfaApplicationRequest tfaApplicationRequest;

        private CreateTfaApplicationRequest(TfaApplicationRequest tfaApplicationRequest) {
            this.tfaApplicationRequest = Objects.requireNonNull(tfaApplicationRequest, "The required parameter 'tfaApplicationRequest' is missing.");
        }

        public TfaApplicationResponse execute() throws ApiException {
            RequestDefinition createTfaApplicationDefinition = TfaApi.this.createTfaApplicationDefinition(this.tfaApplicationRequest);
            return (TfaApplicationResponse)TfaApi.this.apiClient.execute(createTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<TfaApplicationResponse> callback) {
            RequestDefinition createTfaApplicationDefinition = TfaApi.this.createTfaApplicationDefinition(this.tfaApplicationRequest);
            return TfaApi.this.apiClient.executeAsync(createTfaApplicationDefinition, new TypeReference<TfaApplicationResponse>(){}.getType(), callback);
        }
    }
}

