/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infobip.model.HmacAlgorithm;
import com.infobip.model.SecurityConfig;
import java.util.Objects;

public class HmacSecurityConfig
extends SecurityConfig {
    private String secretKey;
    private HmacAlgorithm algorithm;

    public HmacSecurityConfig() {
        super("HMAC");
    }

    public HmacSecurityConfig secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public HmacSecurityConfig algorithm(HmacAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="algorithm")
    public HmacAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(HmacAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HmacSecurityConfig hmacSecurityConfig = (HmacSecurityConfig)o;
        return Objects.equals(this.secretKey, hmacSecurityConfig.secretKey) && Objects.equals((Object)this.algorithm, (Object)hmacSecurityConfig.algorithm) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.secretKey, this.algorithm, super.hashCode()});
    }

    @Override
    public String toString() {
        String newLine = System.lineSeparator();
        return "class HmacSecurityConfig {" + newLine + "    " + this.toIndentedString(super.toString()) + newLine + "    secretKey: " + this.toIndentedString(this.secretKey) + newLine + "    algorithm: " + this.toIndentedString((Object)this.algorithm) + newLine + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        String lineSeparator = System.lineSeparator();
        String lineSeparatorFollowedByIndentation = lineSeparator + "    ";
        return o.toString().replace(lineSeparator, lineSeparatorFollowedByIndentation);
    }
}

