/*
 * Decompiled with CFR 0.152.
 */
package com.intellisrc.web;

import com.intellisrc.core.Config;
import com.intellisrc.core.Log;
import com.intellisrc.core.Millis;
import com.intellisrc.etc.Cache;
import com.intellisrc.etc.JSON;
import com.intellisrc.etc.Mime;
import com.intellisrc.etc.YAML;
import com.intellisrc.groovy.FileStaticExt;
import com.intellisrc.net.LocalHost;
import com.intellisrc.web.WebServiceBase;
import com.intellisrc.web.protocols.HttpProtocol;
import com.intellisrc.web.protocols.Protocol;
import com.intellisrc.web.service.Compression;
import com.intellisrc.web.service.HttpHeader;
import com.intellisrc.web.service.MatchFilterResult;
import com.intellisrc.web.service.Request;
import com.intellisrc.web.service.RequestHandle;
import com.intellisrc.web.service.Response;
import com.intellisrc.web.service.ServerSentEvent;
import com.intellisrc.web.service.Service;
import com.intellisrc.web.service.ServiceOutput;
import com.intellisrc.web.service.Serviciable;
import com.intellisrc.web.service.ServiciableAuth;
import com.intellisrc.web.service.ServiciableMultiple;
import com.intellisrc.web.service.ServiciableSingle;
import com.intellisrc.web.service.ServiciableWebSocket;
import com.intellisrc.web.service.UploadFile;
import com.intellisrc.web.service.WebError;
import com.intellisrc.web.service.WebException;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Part;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.beans.Transient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExceptionNoStack;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;

public class WebService
extends WebServiceBase {
    private static String defaultCharset;
    private static boolean forceFile;
    public int threads;
    public int minThreads;
    public int eTagMaxKB;
    public int cacheTime;
    public int cacheMaxSizeKB;
    public int cacheTotalMaxSizeMB;
    public boolean compress;
    public boolean embedded;
    private boolean trustForwardHeaders;
    private boolean checkSNIHostname;
    private boolean sniRequired;
    public String allowOrigin;
    public List<String> indexFiles;
    public Protocol protocol;
    public FilePolicy filePolicy;
    public PathPolicy pathPolicy;
    public RequestPolicy requestPolicy;
    public WebError.WebErrorTemplate errorTemplate;
    public final Cache<ServiceOutput> cache;
    protected List<StaticPath> staticPaths;
    protected Server jettyServer;
    protected ServletContextHandler contextHandler;
    protected RequestHandle requestHandle;
    protected boolean multiThread;
    protected List<Serviciable> services;
    protected final ConcurrentLinkedQueue<Service> definitions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public WebService() {
        List list;
        List list2;
        Cache cache;
        WebError.WebErrorTemplate webErrorTemplate;
        Protocol protocol;
        List list3;
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.threads = n6 = 20;
        this.minThreads = n5 = 2;
        this.eTagMaxKB = n4 = 1024;
        this.cacheTime = n3 = Cache.DISABLED;
        this.cacheMaxSizeKB = n2 = 256;
        this.cacheTotalMaxSizeMB = n = 0;
        this.compress = bl5 = true;
        this.embedded = bl4 = false;
        this.trustForwardHeaders = bl3 = true;
        this.checkSNIHostname = bl2 = true;
        this.sniRequired = bl = false;
        this.allowOrigin = string = "";
        this.indexFiles = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"index.html", "index.htm"});
        this.protocol = protocol = Protocol.HTTP;
        _closure1 _closure12 = new _closure1(this, this);
        this.filePolicy = IndyInterface.bootstrap("cast", "()", 0, _closure12);
        _closure2 _closure22 = new _closure2(this, this);
        this.pathPolicy = IndyInterface.bootstrap("cast", "()", 0, _closure22);
        _closure3 _closure32 = new _closure3(this, this);
        this.requestPolicy = IndyInterface.bootstrap("cast", "()", 0, _closure32);
        this.errorTemplate = webErrorTemplate = WebError.getDefaultErrorTemplate();
        Cache cache2 = new Cache();
        int n7 = Cache.FOREVER;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n7, WebService.class, (GroovyObject)cache2, (String)"timeout");
        this.cache = cache = cache2;
        this.staticPaths = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.services = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.definitions = concurrentLinkedQueue;
    }

    protected void init() {
        if (!this.initialized) {
            boolean bl = true;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, WebService.class, (GroovyObject)this, (String)"initialized");
            try {
                ServletContextHandler servletContextHandler;
                RequestHandle requestHandle;
                Server server;
                boolean bl2;
                if (DefaultTypeTransformation.booleanUnbox((Object)this.ssl) && !this.isSecure()) {
                    Log.w((String)"KeyStore is invalid. Not using SSL.", (Object[])new Object[0]);
                    Object var2_2 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var2_2, WebService.class, (GroovyObject)this, (String)"ssl");
                }
                HttpProtocol httpProtocol = this.protocol.get(this);
                boolean bl3 = this.checkSNIHostname;
                httpProtocol.setCheckSNIHostname(bl3);
                boolean bl4 = this.trustForwardHeaders;
                httpProtocol.setTrustForwardHeaders(bl4);
                boolean bl5 = this.sniRequired;
                httpProtocol.setSniRequired(bl5);
                if (this.minThreads > this.threads) {
                    int n;
                    this.minThreads = n = this.threads;
                }
                this.multiThread = bl2 = this.threads > 0;
                this.jettyServer = server = this.multiThread ? new Server((ThreadPool)new QueuedThreadPool(this.threads, this.minThreads, this.timeout)) : new Server();
                this.jettyServer.addConnector(httpProtocol.getConnector());
                this.requestHandle = requestHandle = new RequestHandle(this);
                this.contextHandler = servletContextHandler = new ServletContextHandler(ServletContextHandler.SESSIONS);
                HandlerList handlers = new HandlerList();
                handlers.setHandlers((Handler[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{this.requestHandle, this.contextHandler}).toArray(), Handler[].class));
                this.jettyServer.setHandler((Handler)handlers);
                Log.i((String)"Using protocol: %s, %s", (Object[])new Object[]{this.protocol, this.isSecure() ? "with SSL" : "unencrypted"});
            }
            catch (Exception e) {
                Log.e((String)"Unable to initialize web service", (Object[])new Object[]{e});
            }
        }
    }

    public WebService start(StartCallback onStart) {
        return this.start(false, onStart);
    }

    public WebService start(boolean background, StartCallback onStart) {
        block12: {
            this.init();
            try {
                if (LocalHost.isPortAvailable((int)this.port, (InetAddress)this.address)) {
                    Log.i((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.port, this.threads}, new String[]{"Starting server in port ", " with pool size of ", ""}))), (Object[])new Object[0]);
                    public final class _start_closure4
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _start_closure4(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public Boolean doCall(Serviciable serviciable) {
                            block11: {
                                block15: {
                                    block16: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block10: {
                                                        serviciable = new Reference((Object)serviciable);
                                                        prepared = 0;
                                                        var4_4 = (Serviciable)serviciable.get();
                                                        if (!ScriptBytecodeAdapter.isCase((Object)var4_4, ServiciableMultiple.class)) break block10;
                                                        serviciables = (ServiciableMultiple)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServiciableMultiple.class);
                                                        prepared = (int)DefaultGroovyMethods.every(serviciables.getServices(), (Closure)new _start_closure4._closure37((Object)this, this.getThisObject(), serviciable));
                                                        break block11;
                                                    }
                                                    if (!ScriptBytecodeAdapter.isCase((Object)var4_4, ServiciableSingle.class)) break block12;
                                                    sp = ((ServiciableSingle)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServiciableSingle.class)).getService();
                                                    prepared = (int)DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)((WebService)this.getThisObject()), (String)"setupService", (Object)new Object[]{(Serviciable)serviciable.get(), sp}));
                                                    break block11;
                                                }
                                                if (!ScriptBytecodeAdapter.isCase((Object)var4_4, ServerSentEvent.class)) break block13;
                                                sse = (ServerSentEvent)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServerSentEvent.class);
                                                Log.v((String)"Adding SSE Service at path: [%s]", (Object[])new Object[]{sse.getPath()});
                                                sseContext = new ServletContextHandler(ServletContextHandler.SESSIONS);
                                                sseContext.setContextPath("/");
                                                holder = new ServletHolder((Servlet)sse.getServlet());
                                                var10_10 = 0;
                                                holder.setInitOrder(var10_10);
                                                sseContext.addServlet(holder, sse.getPath());
                                                var11_11 = new HandlerList(new Handler[]{IndyInterface.bootstrap("cast", "()", 0, this.getProperty("requestHandle")), sseContext, IndyInterface.bootstrap("cast", "()", 0, this.getProperty("contextHandler"))});
                                                ((Server)this.getProperty("jettyServer")).setHandler((Handler)var11_11);
                                                v0 = (WebService)this.getThisObject();
                                                v1 = new Object[2];
                                                v1[0] = (Serviciable)serviciable.get();
                                                var12_12 = new Service();
                                                var13_13 = HttpMethod.GET;
                                                var12_12.setMethod(var13_13);
                                                var14_14 = true;
                                                var12_12.setReserved(var14_14);
                                                v1[1] = var12_12;
                                                prepared = (int)DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)v0, (String)"setupService", (Object)v1));
                                                break block11;
                                            }
                                            if (!ScriptBytecodeAdapter.isCase((Object)var4_4, ServiciableWebSocket.class)) break block14;
                                            websocket = (ServiciableWebSocket)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServiciableWebSocket.class);
                                            Log.v((String)"Adding WebSocket Service at path: [%s]", (Object[])new Object[]{websocket.getPath()});
                                            holder = new ServletHolder((Servlet)websocket.getWebSocketService());
                                            var17_17 = 0;
                                            holder.setInitOrder(var17_17);
                                            ((ServletContextHandler)this.getProperty("contextHandler")).addServlet(holder, websocket.getPath());
                                            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)IndyInterface.bootstrap("cast", "()", 0, this.getProperty("contextHandler")), null);
                                            v2 = (WebService)this.getThisObject();
                                            v3 = new Object[2];
                                            v3[0] = (Serviciable)serviciable.get();
                                            var18_18 = new Service();
                                            var19_19 = HttpMethod.CONNECT;
                                            var18_18.setMethod(var19_19);
                                            var20_20 = true;
                                            var18_18.setReserved(var20_20);
                                            v3[1] = var18_18;
                                            if (!DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)v2, (String)"setupService", (Object)v3))) ** GOTO lbl-1000
                                            v4 = (WebService)this.getThisObject();
                                            v5 = new Object[2];
                                            v5[0] = (Serviciable)serviciable.get();
                                            var21_21 = new Service();
                                            var22_22 = HttpMethod.GET;
                                            var21_21.setMethod(var22_22);
                                            var23_23 = true;
                                            var21_21.setReserved(var23_23);
                                            v5[1] = var21_21;
                                            if (DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)v4, (String)"setupService", (Object)v5))) {
                                                v6 = 1;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v6 = 0;
                                            }
                                            prepared = v6;
                                            break block11;
                                        }
                                        if (!ScriptBytecodeAdapter.isCase((Object)var4_4, ServiciableAuth.class)) break block15;
                                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("log"))) break block16;
                                        auth = (ServiciableAuth)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServiciableAuth.class);
                                        if (!auth.isAuthLog()) ** GOTO lbl-1000
                                        v7 = auth.getAuthLogFile();
                                        if ((v7 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v7)) == false) {
                                            v8 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v8 = false;
                                        }
                                        if (v8) {
                                            var25_25 = FileStaticExt.get(null, (Object[])new Object[]{this.getProperty("logDir"), "auth.log"});
                                            auth.setAuthLogFile(var25_25);
                                        }
                                        if (!auth.isFailedLog()) ** GOTO lbl-1000
                                        v9 = auth.getAuthFailedLogFile();
                                        if ((v9 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v9)) == false) {
                                            v10 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v10 = false;
                                        }
                                        if (v10) {
                                            var26_26 = FileStaticExt.get(null, (Object[])new Object[]{this.getProperty("logDir"), "auth.fail.log"});
                                            auth.setAuthFailedLogFile(var26_26);
                                        }
                                    }
                                    prepared = 1;
                                    break block11;
                                }
                                throw (Throwable)new Exception((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((Serviciable)serviciable.get()).getClass().getSimpleName()}, new String[]{"Interface not implemented: ", ""})));
                            }
                            if (prepared == 0) {
                                Log.w((String)"Failed to prepare one or more services", (Object[])new Object[0]);
                            }
                            if (ScriptBytecodeAdapter.isCase((Object)(var27_27 = (Serviciable)serviciable.get()), ServiciableAuth.class)) {
                                auth = new Reference((Object)((ServiciableAuth)IndyInterface.bootstrap("invoke", "asType", 0, (Serviciable)serviciable.get(), ServiciableAuth.class)));
                                InvokerHelper.invokeMethodSafe((Object)((WebService)this.getThisObject()), (String)"setupService", (Object)new Object[]{(Serviciable)serviciable.get(), Service.new(HttpMethod.POST, StringGroovyMethods.plus((String)((ServiciableAuth)auth.get()).getPath(), (CharSequence)((ServiciableAuth)auth.get()).getLoginPath()), (Object)new _start_closure4._closure38((Object)this, this.getThisObject(), auth), ((ServiciableAuth)auth.get()).getAcceptType())});
                                return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethodSafe((Object)((WebService)this.getThisObject()), (String)"setupService", (Object)new Object[]{(Serviciable)serviciable.get(), Service.new(HttpMethod.GET, StringGroovyMethods.plus((String)((ServiciableAuth)auth.get()).getPath(), (CharSequence)((ServiciableAuth)auth.get()).getLogoutPath()), (Object)new _start_closure4._closure39((Object)this, this.getThisObject(), auth), ((ServiciableAuth)auth.get()).getAcceptType())}));
                            }
                            return null;
                        }

                        @Generated
                        public Boolean call(Serviciable serviciable) {
                            Reference serviciable2 = new Reference((Object)serviciable);
                            return this.doCall((Serviciable)serviciable2.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _start_closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    DefaultGroovyMethods.each(this.services, (Closure)new _start_closure4(this, this));
                    boolean bl = true;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, WebService.class, (GroovyObject)this, (String)"running");
                    this.jettyServer.start();
                    Object var4_4 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var4_4, WebService.class, (GroovyObject)this, (String)"ssl");
                    StartCallback startCallback = onStart;
                    if ((startCallback == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, startCallback)) != false) {
                        onStart.call(this);
                    }
                    if (background) {
                        DefaultGroovyStaticMethods.sleep(null, (long)Millis.getSECOND());
                    } else if (this.multiThread) {
                        this.jettyServer.join();
                    } else {
                        while (this.isRunning()) {
                            DefaultGroovyStaticMethods.sleep(null, (long)Millis.getSECOND());
                        }
                    }
                    break block12;
                }
                Log.w((String)"Port %d is already in use", (Object[])new Object[]{this.port});
            }
            catch (WebException we) {
                Log.w((String)"Not handled: Web service error: %s", (Object[])new Object[]{we});
            }
            catch (Throwable e) {
                Log.e((String)"Unable to start WebService", (Object[])new Object[]{e});
            }
        }
        return this;
    }

    public WebService setStaticPath(String path, int expirationSec, int cacheMaxSizeKB, boolean embedded) {
        return this.setStaticPath(new StaticPath(path, embedded, expirationSec, cacheMaxSizeKB));
    }

    public WebService setStaticPath(StaticPath path) {
        DefaultGroovyMethods.leftShift(this.staticPaths, (Object)path);
        return this;
    }

    protected boolean setupService(Serviciable serviciable, Service sp) {
        if (serviciable.getAllowOrigin() != null && sp.getAllowOrigin() == null) {
            String string = serviciable.getAllowOrigin();
            sp.setAllowOrigin(string);
        }
        String string = serviciable.getAcceptType();
        sp.setAcceptType(string);
        String string2 = sp.getAcceptType();
        if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) == false) {
            String string3 = "*/*";
            sp.setAcceptType(string3);
        }
        String string4 = serviciable.getAcceptCharset();
        sp.setAcceptCharset(string4);
        String string5 = WebService.addRoot(serviciable.getPath(), sp.getPath());
        sp.setPath(string5);
        Service.Allow allow = sp.getAllow();
        if ((allow == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, allow)) == false && DefaultTypeTransformation.booleanUnbox((Object)serviciable.getAllow())) {
            Service.Allow allow2 = serviciable.getAllow();
            sp.setAllow(allow2);
        }
        Service.Allow allow3 = sp.getAllow();
        if ((allow3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, allow3)) == false) {
            public final class _setupService_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setupService_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Boolean doCall(Object it) {
                    return true;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setupService_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Service.Allow allow4 = (Service.Allow)((Object)IndyInterface.bootstrap("invoke", "asType", 0, new _setupService_closure5(this, this), Service.Allow.class));
            sp.setAllow(allow4);
        }
        String string6 = sp.getNotAllowedRedirect();
        if ((string6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string6)) == false && DefaultTypeTransformation.booleanUnbox((Object)serviciable.getNotAllowedRedirect())) {
            String string7 = serviciable.getNotAllowedRedirect();
            sp.setNotAllowedRedirect(string7);
        }
        Service.BeforeRequest beforeRequest = sp.getBeforeRequest();
        if ((beforeRequest == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, beforeRequest)) == false && DefaultTypeTransformation.booleanUnbox((Object)serviciable.getBeforeRequest())) {
            Service.BeforeRequest beforeRequest2 = serviciable.getBeforeRequest();
            sp.setBeforeRequest(beforeRequest2);
        }
        Service.BeforeResponse beforeResponse = sp.getBeforeResponse();
        if ((beforeResponse == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, beforeResponse)) == false && DefaultTypeTransformation.booleanUnbox((Object)serviciable.getBeforeResponse())) {
            Service.BeforeResponse beforeResponse2 = serviciable.getBeforeResponse();
            sp.setBeforeResponse(beforeResponse2);
        }
        Service.ServiceError serviceError = sp.getOnError();
        if ((serviceError == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, serviceError)) == false && DefaultTypeTransformation.booleanUnbox((Object)serviciable.getOnError())) {
            Service.ServiceError serviceError2 = serviciable.getOnError();
            sp.setOnError(serviceError2);
        }
        Log.v((String)"Adding Service: [%s] with method %s", (Object[])new Object[]{sp.getPath(), sp.getMethod().toString()});
        return this.addService(sp);
    }

    protected static ServiceOutput handleContentType(Object res, String contentType, String charSet, boolean forceBinary, Compression compress) {
        if (res instanceof ServiceOutput) {
            return IndyInterface.bootstrap("cast", "()", 0, res);
        }
        ServiceOutput serviceOutput = new ServiceOutput();
        String string = contentType;
        String string2 = string != null ? string.toLowerCase() : null;
        String string3 = IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : "";
        serviceOutput.setContentType(string3);
        String string4 = charSet;
        serviceOutput.setCharSet(string4);
        Object object = res;
        serviceOutput.setContent(object);
        Compression compression = compress;
        serviceOutput.setCompression(compression);
        ServiceOutput output = serviceOutput;
        if (res instanceof Collection) {
            List list = DefaultGroovyMethods.toList((Iterable)((Object)IndyInterface.bootstrap("cast", "()", 0, res)));
            output.setContent(list);
        }
        if (res instanceof Number) {
            String string5 = res.toString();
            output.setContent(string5);
        }
        String string6 = output.getContentType();
        if ((string6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string6)) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)output.getContentType(), (Object)Mime.getSSE())) {
                ServiceOutput.Type type = ServiceOutput.Type.STREAM;
                output.setType(type);
            } else {
                ServiceOutput.Type type = ServiceOutput.Type.fromString(output.getContentType());
                output.setType(type);
                String string7 = StringGroovyMethods.plus((String)"download.", (CharSequence)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.last((List)StringGroovyMethods.tokenize((CharSequence)output.getContentType(), (CharSequence)"/")))));
                output.setFileName(string7);
            }
        } else {
            Object object2 = output.getContent();
            if (ScriptBytecodeAdapter.isCase((Object)object2, String.class)) {
                String resStr = output.getType().toString();
                ServiceOutput.Type type = ServiceOutput.Type.TEXT;
                output.setType(type);
                Boolean bl = true;
                if (ScriptBytecodeAdapter.isCase((Object)bl, (Object)resStr.contains("<html"))) {
                    String string8 = Mime.getHTML();
                    output.setContentType(string8);
                    String string9 = "download.html";
                    output.setFileName(string9);
                } else if (ScriptBytecodeAdapter.isCase((Object)bl, (Object)resStr.contains("<?xml"))) {
                    String string10 = Mime.getXML();
                    output.setContentType(string10);
                    String string11 = "download.xml";
                    output.setFileName(string11);
                } else if (ScriptBytecodeAdapter.isCase((Object)bl, (Object)resStr.contains("<svg"))) {
                    String string12 = Mime.getSVG();
                    output.setContentType(string12);
                    String string13 = "download.svg";
                    output.setFileName(string13);
                } else {
                    String string14 = Mime.getType((InputStream)new ByteArrayInputStream(resStr.getBytes()));
                    String string15 = IndyInterface.bootstrap("cast", "()", 0, string14) != false ? string14 : Mime.getTXT();
                    output.setContentType(string15);
                    if (ScriptBytecodeAdapter.compareEqual((Object)output.getContentType(), (Object)Mime.getTXT())) {
                        String string16 = "download.txt";
                        output.setFileName(string16);
                    } else {
                        String string17 = StringGroovyMethods.plus((String)"download.", (CharSequence)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.last((List)StringGroovyMethods.tokenize((CharSequence)output.getContentType(), (CharSequence)"/")))));
                        output.setFileName(string17);
                    }
                }
            } else if (ScriptBytecodeAdapter.isCase((Object)object2, File.class)) {
                File file = (File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), File.class));
                if (file.exists()) {
                    String string18 = Mime.getType((File)file);
                    output.setContentType(string18);
                    ServiceOutput.Type type = ServiceOutput.Type.fromString(output.getContentType());
                    output.setType(type);
                    String string19 = file.getName();
                    output.setFileName(string19);
                } else {
                    int n = HttpStatus.NOT_FOUND_404;
                    output.setResponseCode(n);
                }
            } else if (ScriptBytecodeAdapter.isCase((Object)object2, BufferedImage.class)) {
                BufferedImage img = (BufferedImage)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), BufferedImage.class));
                boolean hasAlpha = img.getColorModel().hasAlpha();
                String ext = hasAlpha ? "png" : "jpg";
                ServiceOutput.Type type = ServiceOutput.Type.IMAGE;
                output.setType(type);
                String string20 = Mime.getType((String)ext);
                output.setContentType(string20);
                GStringImpl gStringImpl = new GStringImpl(new Object[]{ext}, new String[]{"download.", ""});
                output.setFileName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, gStringImpl)));
            } else if (ScriptBytecodeAdapter.isCase((Object)object2, List.class) || ScriptBytecodeAdapter.isCase((Object)object2, Map.class)) {
                ServiceOutput.Type type = ServiceOutput.Type.JSON;
                output.setType(type);
                String string21 = Mime.getJSON();
                output.setContentType(string21);
                String string22 = "download.json";
                output.setFileName(string22);
            } else {
                if (ScriptBytecodeAdapter.isCase((Object)object2, URL.class)) {
                    URL url = (URL)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), URL.class));
                    HttpURLConnection conn = (HttpURLConnection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, url.openConnection(), HttpURLConnection.class));
                    conn.setRequestMethod("GET");
                    conn.connect();
                    String string23 = conn.getContentType();
                    String string24 = IndyInterface.bootstrap("cast", "()", 0, string23) != false ? string23 : Mime.getType((URL)url);
                    output.setContentType(string24);
                    Object object3 = conn.getContent();
                    output.setContent(object3);
                    int n = conn.getResponseCode();
                    output.setResponseCode(n);
                    ServiceOutput.Type type = ServiceOutput.Type.fromString(output.getContentType());
                    output.setType(type);
                    String string25 = url.getFile();
                    output.setFileName(string25);
                    return output;
                }
                ServiceOutput.Type type = ServiceOutput.Type.BINARY;
                output.setType(type);
                String string26 = "";
                output.setContentType(string26);
                String string27 = "download.bin";
                output.setFileName(string27);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)output.getResponseCode()) && output.getResponseCode() >= HttpStatus.BAD_REQUEST_400) {
            Object var57_57 = null;
            output.setContent(var57_57);
            int n = 0;
            output.setSize(n);
            Compression compression2 = Compression.NONE;
            output.setCompression(compression2);
        } else {
            Object object4;
            if (forceBinary) {
                ServiceOutput.Type type = ServiceOutput.Type.BINARY;
                output.setType(type);
            }
            if (ScriptBytecodeAdapter.isCase((Object)(object4 = output.getContent()), String.class)) {
                String string28 = DefaultGroovyMethods.toString((Object)output.getContent());
                output.setContent(string28);
                int n = ((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), String.class))).getBytes().length;
                output.setSize(n);
            } else if (ScriptBytecodeAdapter.isCase((Object)object4, File.class)) {
                File file = (File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), File.class));
                byte[] byArray = ResourceGroovyMethods.getBytes((File)file);
                output.setContent(byArray);
                int n = (int)ResourceGroovyMethods.size((File)file);
                output.setSize(n);
                String string29 = Long.valueOf(file.lastModified()).toString();
                output.setEtag(string29);
            } else if (ScriptBytecodeAdapter.isCase((Object)object4, byte[].class)) {
                int n = ((byte[])IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), byte[].class)).length;
                output.setSize(n);
            }
            ServiceOutput.Type type = output.getType();
            if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)ServiceOutput.Type.TEXT))) {
                if (!(output.getSize() != 0)) {
                    String string30 = DefaultGroovyMethods.toString((Object)output.getContent());
                    output.setContent(string30);
                    int n = ((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), String.class))).getBytes().length;
                    output.setSize(n);
                }
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)ServiceOutput.Type.JSON))) {
                Object object5 = output.getContent();
                if (ScriptBytecodeAdapter.isCase((Object)object5, Collection.class) || ScriptBytecodeAdapter.isCase((Object)object5, Map.class)) {
                    String string31 = JSON.encode((Object)output.getContent());
                    output.setContent(string31);
                    int n = StringGroovyMethods.size((CharSequence)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), String.class))));
                    output.setSize(n);
                }
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)ServiceOutput.Type.YAML))) {
                Object object6 = output.getContent();
                if (ScriptBytecodeAdapter.isCase((Object)object6, Collection.class) || ScriptBytecodeAdapter.isCase((Object)object6, Map.class)) {
                    String string32 = YAML.encode((Object)output.getContent());
                    output.setContent(string32);
                    int n = StringGroovyMethods.size((CharSequence)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), String.class))));
                    output.setSize(n);
                }
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)ServiceOutput.Type.IMAGE))) {
                String string33 = "";
                output.setCharSet(string33);
                Object object7 = output.getContent();
                if (ScriptBytecodeAdapter.isCase((Object)object7, BufferedImage.class)) {
                    BufferedImage img = (BufferedImage)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), BufferedImage.class));
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    CallSite iw = IndyInterface.bootstrap("cast", "()", 0, ImageIO.getImageWritersByMIMEType(output.getContentType()).next());
                    CallSite callSite = iw;
                    if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
                        ((ImageWriter)((Object)iw)).setOutput(ImageIO.createImageOutputStream(os));
                        ((ImageWriter)((Object)iw)).write(img);
                        byte[] byArray = os.toByteArray();
                        output.setContent(byArray);
                    }
                    os.close();
                }
                ServiceOutput.Type type2 = ServiceOutput.Type.BINARY;
                output.setType(type2);
                int n = ((byte[])IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), byte[].class)).length;
                output.setSize(n);
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)ServiceOutput.Type.BINARY))) {
                String string34 = "";
                output.setCharSet(string34);
                Object object8 = output.getContent();
                if (ScriptBytecodeAdapter.isCase((Object)object8, String.class)) {
                    byte[] byArray = DefaultGroovyMethods.toString((Object)output.getContent()).getBytes();
                    output.setContent(byArray);
                } else if (ScriptBytecodeAdapter.isCase((Object)object8, BufferedImage.class)) {
                    BufferedImage img = (BufferedImage)((Object)IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), BufferedImage.class));
                    byte[] byArray = ((DataBufferByte)((Object)IndyInterface.bootstrap("cast", "()", 0, img.getRaster().getDataBuffer()))).getData();
                    output.setContent(byArray);
                } else {
                    byte[] byArray = (byte[])IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), byte[].class);
                    output.setContent(byArray);
                }
                int n = ((byte[])IndyInterface.bootstrap("invoke", "asType", 0, output.getContent(), byte[].class)).length;
                output.setSize(n);
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)output.getCompression()), (Object)((Object)Compression.NONE)) && Mime.isCompressed((String)output.getContentType())) {
            Compression compression3 = Compression.NONE;
            output.setCompression(compression3);
        }
        return output;
    }

    public static String getCacheKey(Request request) {
        String query = request.getQueryString();
        String string = query;
        return StringGroovyMethods.plus((String)request.uri(), (CharSequence)((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false ? StringGroovyMethods.plus((String)"?", (CharSequence)query) : ""));
    }

    public ServiceOutput processService(Service sp, Request request, Response response) {
        Reference sp2 = new Reference((Object)sp);
        Object output = null;
        Object outHeaders = this.getGlobalHeaders();
        outHeaders.putAll(response.getHeaders());
        outHeaders.putAll(((Service)sp2.get()).getHeaders());
        List<Compression> clientSupportedEncodings = request.getAcceptedEncodings();
        if (((Service)sp2.get()).getAllow().check(request)) {
            block58: {
                File tempDir = FileStaticExt.getTempDir(null);
                request.attribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(tempDir.getAbsolutePath()));
                boolean hasParts = false;
                try {
                    hasParts = !request.getParts().isEmpty();
                }
                catch (Exception ignored) {
                }
                if (hasParts) {
                    if (tempDir.canWrite()) {
                        Reference uploadFiles = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                        if (request.getContentLength() > 0) {
                            public final class _processService_closure6
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference uploadFiles;
                                private /* synthetic */ Reference sp;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _processService_closure6(Object _outerInstance, Object _thisObject, Reference uploadFiles, Reference sp) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    Reference reference2;
                                    this.uploadFiles = reference2 = uploadFiles;
                                    this.sp = reference = sp;
                                }

                                public List<UploadFile> doCall(Part part) {
                                    String string = part.getContentType();
                                    if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
                                        if (part.getSize() != 0L) {
                                            Path path = Files.createTempFile("upload", ".file", new FileAttribute[0]);
                                            Files.copy(part.getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
                                            UploadFile file = new UploadFile(path.toString(), part.getSubmittedFileName(), part.getName());
                                            List list = DefaultGroovyMethods.leftShift((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.uploadFiles.get())), (Object)file);
                                            try {
                                                return list;
                                            }
                                            catch (Exception e) {
                                                WebService.handleException((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sp.get())), HttpStatus.INTERNAL_SERVER_ERROR_500, String.format("Unable to upload file: %s", part.getSubmittedFileName()), e);
                                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, null);
                                                return callSite;
                                            }
                                        }
                                        if (WebService.isForceFile()) {
                                            WebService.handleException((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sp.get())), HttpStatus.LENGTH_REQUIRED_411, String.format("File: %s was empty", part.getSubmittedFileName()));
                                            return IndyInterface.bootstrap("cast", "()", 0, null);
                                        }
                                    }
                                    return null;
                                }

                                @Generated
                                public List<UploadFile> call(Part part) {
                                    return this.doCall(part);
                                }

                                @Generated
                                public ArrayList getUploadFiles() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.uploadFiles.get());
                                }

                                @Generated
                                public Service getSp() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.sp.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _processService_closure6.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            DefaultGroovyMethods.each((Collection)request.getParts(), (Closure)new _processService_closure6(this, this, uploadFiles, sp2));
                            try {
                                Object res = WebService.callAction(((Service)sp2.get()).getAction(), request, response, (ArrayList)uploadFiles.get(), true);
                                boolean forceBinary = outHeaders.containsKey(HttpHeader.CONTENT_TRANSFER_ENCODING) && ScriptBytecodeAdapter.compareEqual((Object)DefaultGroovyMethods.getAt((Map)outHeaders, (Object)HttpHeader.CONTENT_TRANSFER_ENCODING), (Object)"binary");
                                String string = ((Service)sp2.get()).getContentType();
                                output = WebService.handleContentType(res, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : response.type(), ((Service)sp2.get()).getCharSet(), forceBinary, WebService.getCompression(clientSupportedEncodings, ((Service)sp2.get()).getCompress(this.compress)));
                                if (DefaultTypeTransformation.booleanUnbox((Object)((ServiceOutput)output).getResponseCode()) && ((ServiceOutput)output).getResponseCode() >= HttpStatus.BAD_REQUEST_400) {
                                    WebService.handleException((Service)sp2.get(), ((ServiceOutput)output).getResponseCode(), String.format("Directory is not writable: %s", tempDir.getAbsolutePath()));
                                }
                            }
                            catch (Exception e) {
                                WebService.handleException((Service)sp2.get(), HttpStatus.INTERNAL_SERVER_ERROR_500, "Upload failed", e);
                            }
                            public final class _processService_closure7
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _processService_closure7(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Boolean doCall(Object it) {
                                    if (((UploadFile)it).exists()) {
                                        return ((UploadFile)it).delete();
                                    }
                                    return null;
                                }

                                @Generated
                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Generated
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Boolean doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _processService_closure7.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            DefaultGroovyMethods.each((List)((ArrayList)uploadFiles.get()), (Closure)new _processService_closure7(this, this));
                        } else {
                            WebService.handleException((Service)sp2.get(), HttpStatus.LENGTH_REQUIRED_411, "Upload file was empty");
                        }
                    } else {
                        WebService.handleException((Service)sp2.get(), HttpStatus.INTERNAL_SERVER_ERROR_500, "Temporally directory %s is not writable");
                    }
                } else {
                    try {
                        Object res = WebService.callAction(((Service)sp2.get()).getAction(), request, response);
                        if (res != null) {
                            boolean forceBinary = outHeaders.containsKey(HttpHeader.CONTENT_TRANSFER_ENCODING) && ScriptBytecodeAdapter.compareEqual((Object)DefaultGroovyMethods.getAt(outHeaders, (Object)HttpHeader.CONTENT_TRANSFER_ENCODING), (Object)"binary");
                            String string = ((Service)sp2.get()).getContentType();
                            output = WebService.handleContentType(res, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : response.type(), ((Service)sp2.get()).getCharSet(), forceBinary, WebService.getCompression(clientSupportedEncodings, ((Service)sp2.get()).getCompress(this.compress)));
                            if (DefaultTypeTransformation.booleanUnbox((Object)((ServiceOutput)output).getResponseCode()) && ((ServiceOutput)output).getResponseCode() >= HttpStatus.BAD_REQUEST_400) {
                                WebService.handleException((Service)sp2.get(), ((ServiceOutput)output).getResponseCode(), "Exception in Service");
                            }
                            break block58;
                        }
                        WebService.handleException((Service)sp2.get(), HttpStatus.NOT_FOUND_404, String.format("Not Found : %s", request.uri()));
                    }
                    catch (Exception e) {
                        WebService.handleException((Service)sp2.get(), HttpStatus.INTERNAL_SERVER_ERROR_500, "Service action failed", e);
                    }
                }
            }
            if (output != null) {
                ((ServiceOutput)output).importHeaders((Map<String, String>)outHeaders);
                outHeaders = IndyInterface.bootstrap("cast", "()", 0, null);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)((ServiceOutput)output).getType()), (Object)((Object)ServiceOutput.Type.STREAM))) {
                    String etag;
                    block59: {
                        Service.ETag eTag;
                        if (((Service)sp2.get()).isDownload() || ScriptBytecodeAdapter.compareEqual((Object)((ServiceOutput)output).getContentType(), (Object)Mime.getBIN())) {
                            String string = ((Service)sp2.get()).getDownloadFileName();
                            String string2 = IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : ((ServiceOutput)output).getFileName();
                            ((ServiceOutput)output).setDownloadName(string2);
                        }
                        String string = (eTag = ((Service)sp2.get()).getEtag()) != null ? eTag.calc(((ServiceOutput)output).getContent()) : null;
                        String string3 = IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : ((ServiceOutput)output).getEtag();
                        ((ServiceOutput)output).setEtag(string3);
                        etag = string3;
                        String string4 = etag;
                        if ((string4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string4)) == false && DefaultTypeTransformation.booleanUnbox((Object)((ServiceOutput)output).getSize())) {
                            try {
                                if (ScriptBytecodeAdapter.compareEqual((Object)((Object)((ServiceOutput)output).getType()), (Object)((Object)ServiceOutput.Type.BINARY))) {
                                    if (((ServiceOutput)output).getSize() > 1024 * this.eTagMaxKB) {
                                        Log.v((String)"Unable to generate ETag for: %s, output is Binary, you can add 'etag' property in Service or increment 'eTagMaxKB' property to dismiss this message", (Object[])new Object[]{request.uri()});
                                    } else {
                                        etag = EncodingGroovyMethods.md5((byte[])((byte[])IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)output).getContent(), byte[].class)));
                                    }
                                } else {
                                    etag = EncodingGroovyMethods.md5((CharSequence)DefaultGroovyMethods.toString((Object)((ServiceOutput)output).getContent()));
                                }
                                String string5 = etag;
                                if ((string5 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string5)) != false) {
                                    String string6 = etag;
                                    ((ServiceOutput)output).setEtag(string6);
                                    break block59;
                                }
                                Log.v((String)"Unable to generate ETag for: %s, unknown reason", (Object[])new Object[]{request.uri()});
                            }
                            catch (Exception e) {
                                Log.v((String)"Unable to set ETag for: %s, failed : %s", (Object[])new Object[]{request.uri(), e});
                            }
                        }
                    }
                    String prevTag = request.headers(HttpHeader.IF_NONE_MATCH);
                    if (ScriptBytecodeAdapter.compareEqual((Object)prevTag, (Object)etag)) {
                        ((ServiceOutput)output).setNotModified();
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)output) && DefaultTypeTransformation.booleanUnbox((Object)((ServiceOutput)output).getSize()) && ((Service)sp2.get()).getCompress(this.compress)) {
                    if (((ServiceOutput)output).getSize() > ((Service)sp2.get()).getMinCompressBytes()) {
                        Compression compression = WebService.getCompression(clientSupportedEncodings, true);
                        response.setCompression(compression);
                        byte[] bytes = new byte[]{};
                        Object object = ((ServiceOutput)output).getContent();
                        if (ScriptBytecodeAdapter.isCase((Object)object, String.class)) {
                            bytes = DefaultGroovyMethods.toString((Object)((ServiceOutput)output).getContent()).getBytes();
                        } else if (ScriptBytecodeAdapter.isCase((Object)object, File.class)) {
                            bytes = ResourceGroovyMethods.getBytes((File)((File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)output).getContent(), File.class))));
                        } else if (ScriptBytecodeAdapter.isCase((Object)object, OutputStream.class)) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            baos.writeTo((OutputStream)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)output).getContent(), OutputStream.class)));
                            bytes = baos.toByteArray();
                        } else if (ScriptBytecodeAdapter.isCase((Object)object, byte[].class)) {
                            bytes = (byte[])IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)output).getContent(), byte[].class);
                        } else {
                            Compression compression2 = Compression.NONE;
                            ((ServiceOutput)output).setCompression(compression2);
                        }
                        if (DefaultGroovyMethods.size((byte[])bytes) > 0 && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)((ServiceOutput)output).getCompression()), (Object)((Object)Compression.NONE))) {
                            Object object2 = response.getCompression().compress(bytes);
                            ((ServiceOutput)output).setContent(object2);
                            int n = DefaultGroovyMethods.size((byte[])((byte[])IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)output).getContent(), byte[].class)));
                            ((ServiceOutput)output).setSize(n);
                        }
                    } else if (((ServiceOutput)output).getSize() != 0) {
                        Compression compression = Compression.NONE;
                        ((ServiceOutput)output).setCompression(compression);
                        Log.v((String)"Content was not compressed as it is smaller than 'minCompressBytes': %d < %d", (Object[])new Object[]{((ServiceOutput)output).getSize(), ((Service)sp2.get()).getMinCompressBytes()});
                    }
                }
            } else {
                WebService.handleException((Service)sp2.get(), HttpStatus.NOT_FOUND_404, String.format("Not found: %s", request.uri()));
            }
        } else {
            Log.w((String)"Forbidden: %s", (Object[])new Object[]{request.uri()});
            this.logWarn(request, HttpStatus.FORBIDDEN_403);
            String string = ((Service)sp2.get()).getNotAllowedRedirect();
            if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
                try {
                    response.redirect(((Service)sp2.get()).getNotAllowedRedirect());
                }
                catch (IllegalStateException ignore) {
                }
                output = IndyInterface.bootstrap("cast", "()", 0, null);
            } else {
                throw (Throwable)new WebException(HttpStatus.FORBIDDEN_403);
            }
        }
        return output;
    }

    protected void prepareResponse(ServiceOutput output, Response response) {
        Reference response2 = new Reference((Object)response);
        public final class _prepareResponse_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _prepareResponse_closure8(Object _outerInstance, Object _thisObject, Reference response) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                ((Response)((Object)IndyInterface.bootstrap("cast", "()", 0, this.response.get()))).header((String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)it).getKey())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)it).getValue())));
                return null;
            }

            @Generated
            public Response getResponse() {
                return IndyInterface.bootstrap("cast", "()", 0, this.response.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _prepareResponse_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each(output.getHeaders(), (Closure)new _prepareResponse_closure8(this, this, response2));
        String string = output.getContentType();
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            String string2 = output.getCharSet();
            ((Response)((Object)response2.get())).type(StringGroovyMethods.plus((String)output.getContentType(), (CharSequence)((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false ? StringGroovyMethods.plus((String)"; charset=", (CharSequence)output.getCharSet()) : "")));
        }
        if (output.getResponseCode() != 0) {
            ((Response)((Object)response2.get())).status(output.getResponseCode());
        }
        if (!output.getDownloadName().isEmpty()) {
            ((Response)((Object)response2.get())).header(HttpHeader.CONTENT_DISPOSITION, StringGroovyMethods.plus((String)"attachment; filename=", (CharSequence)output.getDownloadName()));
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)output.getType()), (Object)((Object)ServiceOutput.Type.BINARY))) {
                ((Response)((Object)response2.get())).header(HttpHeader.CONTENT_TRANSFER_ENCODING, "binary");
            }
        }
        String string3 = output.getEtag();
        if ((string3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string3)) != false) {
            ((Response)((Object)response2.get())).header(HttpHeader.ETAG, output.getEtag());
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)output.getCompression()), (Object)((Object)Compression.NONE))) {
            ((Response)((Object)response2.get())).header(HttpHeader.CONTENT_ENCODING, output.getCompression().toString());
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)output.getType()), (Object)((Object)ServiceOutput.Type.STREAM))) {
            ((Response)((Object)response2.get())).header(HttpHeader.CONNECTION, "keep-alive");
            ((Response)((Object)response2.get())).header(HttpHeader.CACHE_CONTROL, "no-cache");
            ((Response)((Object)response2.get())).header(HttpHeader.TRANSFER_ENCODING, "chunked");
        } else if (output.getSize() > 0) {
            ((Response)((Object)response2.get())).header(HttpHeader.CONTENT_LENGTH, DefaultGroovyMethods.sprintf((Object)this, (String)"%d", (Object)output.getSize()));
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)output.getType()), (Object)((Object)ServiceOutput.Type.BINARY))) {
                ((Response)((Object)response2.get())).header(HttpHeader.ACCEPT_RANGES, "bytes");
            }
        } else if (output.getResponseCode() != HttpStatus.NOT_MODIFIED_304 && output.getResponseCode() != HttpStatus.NOT_FOUND_404) {
            ((Response)((Object)response2.get())).status(HttpStatus.NO_CONTENT_204);
        }
        if (!(((Response)((Object)response2.get())).getStatus() != 0)) {
            ((Response)((Object)response2.get())).status(HttpStatus.OK_200);
        }
    }

    protected static Compression getCompression(Collection<Compression> client, boolean compress) {
        Object object;
        if (compress) {
            public final class _getCompression_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCompression_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Boolean doCall(Object it) {
                    return Compression.getAvailable().contains(it);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCompression_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Object object2 = DefaultGroovyMethods.find(client, (Closure)new _getCompression_closure9(WebService.class, WebService.class));
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, object2);
            object = IndyInterface.bootstrap("cast", "()", 0, object2) != false ? callSite : Compression.NONE;
        } else {
            object = Compression.NONE;
        }
        return object;
    }

    protected static Object callAction(Object action, Request request, Response response, List<UploadFile> upload, boolean forceUpload) {
        Reference returned = new Reference(null);
        if (action instanceof Service.Action) {
            returned.set(((Service.Action)action).run());
        } else if (action instanceof Service.ActionRequest) {
            returned.set(((Service.ActionRequest)action).run(request));
        } else if (action instanceof Service.ActionResponse) {
            returned.set(((Service.ActionResponse)action).run(request, response));
        } else if (action instanceof Service.Upload) {
            returned.set(((Service.Upload)action).run((UploadFile)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.first(upload)))));
        } else if (action instanceof Service.UploadRequest) {
            returned.set(((Service.UploadRequest)action).run((UploadFile)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.first(upload))), request));
        } else if (action instanceof Service.UploadResponse) {
            returned.set(((Service.UploadResponse)action).run((UploadFile)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.first(upload))), request, response));
        } else if (action instanceof Service.Uploads) {
            returned.set(((Service.Uploads)action).run(upload));
        } else if (action instanceof Service.UploadsRequest) {
            returned.set(((Service.UploadsRequest)action).run(upload, request));
        } else if (action instanceof Service.UploadsResponse) {
            returned.set(((Service.UploadsResponse)action).run(upload, request, response));
        } else if (action instanceof Closure) {
            if (DefaultTypeTransformation.booleanUnbox(upload) || forceUpload) {
                Boolean bl = true;
                public final class _callAction_closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure10(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure11(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure12
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure12(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure13(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure14(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure15(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure16
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure16(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure16.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure17
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure17(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure17.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure18(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure19
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure19(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure19.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure20(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure21(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure22
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure22(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure23(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                if (!(ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure10(WebService.class, WebService.class, returned), new Object[]{upload, request, response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure11(WebService.class, WebService.class, returned), new Object[]{DefaultGroovyMethods.first(upload), request, response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure12(WebService.class, WebService.class, returned), new Object[]{request, response, upload})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure13(WebService.class, WebService.class, returned), new Object[]{request, response, DefaultGroovyMethods.first(upload)})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure14(WebService.class, WebService.class, returned), new Object[]{upload, request})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure15(WebService.class, WebService.class, returned), new Object[]{DefaultGroovyMethods.first(upload), request})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure16(WebService.class, WebService.class, returned), new Object[]{upload, response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure17(WebService.class, WebService.class, returned), new Object[]{DefaultGroovyMethods.first(upload), response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure18(WebService.class, WebService.class, returned), new Object[]{request, upload})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure19(WebService.class, WebService.class, returned), new Object[]{request, DefaultGroovyMethods.first(upload)})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure20(WebService.class, WebService.class, returned), new Object[]{response, upload})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure21(WebService.class, WebService.class, returned), new Object[]{response, DefaultGroovyMethods.first(upload)})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure22(WebService.class, WebService.class, returned), upload)) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure23(WebService.class, WebService.class, returned), DefaultGroovyMethods.first(upload))))) {
                    Log.w((String)"Unknown parameters expected in Service.Action as Closure. Request must be before Response and at least File must be specified.", (Object[])new Object[0]);
                }
            } else {
                Boolean bl = true;
                public final class _callAction_closure24
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure24(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure25
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure25(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure26(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _callAction_closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference returned;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _callAction_closure27(Object _outerInstance, Object _thisObject, Reference returned) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.returned = reference = returned;
                    }

                    public Object doCall(Object it) {
                        Object object = it;
                        this.returned.set(object);
                        return object;
                    }

                    @Generated
                    public Object getReturned() {
                        return this.returned.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _callAction_closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                if (!(ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure24(WebService.class, WebService.class, returned), new Object[]{request, response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure25(WebService.class, WebService.class, returned), new Object[]{request})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure26(WebService.class, WebService.class, returned), new Object[]{response})) || ScriptBytecodeAdapter.isCase((Object)bl, (Object)WebService.tryCall((Closure)IndyInterface.bootstrap("cast", "()", 0, action), new _callAction_closure27(WebService.class, WebService.class, returned), new Object[0])))) {
                    Log.w((String)"Unknown parameters expected in Service.Action as Closure. Request must be before Response", (Object[])new Object[0]);
                }
            }
        }
        return returned.get();
    }

    protected static boolean tryCall(Closure action, Closure returnValue, Object ... params) {
        Boolean bl;
        int np;
        boolean called;
        block13: {
            int ap;
            block12: {
                block11: {
                    block10: {
                        called = true;
                        np = action.getMaximumNumberOfParameters();
                        ap = DefaultGroovyMethods.size((Object[])params);
                        bl = true;
                        if (!ScriptBytecodeAdapter.isCase((Object)bl, (Object)(np == 3 && ap == 3 ? 1 : 0))) break block10;
                        returnValue.call(action.call(new Object[]{BytecodeInterface8.objectArrayGet((Object[])params, (int)0), BytecodeInterface8.objectArrayGet((Object[])params, (int)1), BytecodeInterface8.objectArrayGet((Object[])params, (int)2)}));
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)bl, (Object)(np == 2 && ap == 2 ? 1 : 0))) break block11;
                    returnValue.call(action.call(new Object[]{BytecodeInterface8.objectArrayGet((Object[])params, (int)0), BytecodeInterface8.objectArrayGet((Object[])params, (int)1)}));
                }
                if (!ScriptBytecodeAdapter.isCase((Object)bl, (Object)(np == 1 && ap == 1 ? 1 : 0))) break block12;
                returnValue.call(action.call(BytecodeInterface8.objectArrayGet((Object[])params, (int)0)));
            }
            if (!ScriptBytecodeAdapter.isCase((Object)bl, (Object)(np == 0 && ap == 0 ? 1 : 0))) break block13;
            returnValue.call(action.call());
        }
        try {
            if (ScriptBytecodeAdapter.isCase((Object)bl, (Object)(np > 3 ? 1 : 0))) {
                Log.w((String)"Action has more than 3 parameters", (Object[])new Object[0]);
            }
            called = false;
        }
        catch (MissingMethodException e) {
            if (e instanceof MissingMethodExceptionNoStack) {
                Log.e((String)"MissingMethodException inside action. ", (Object[])new Object[]{e});
            }
            called = false;
        }
        return called;
    }

    public WebService add(Serviciable srv) {
        this.addService(srv);
        return this;
    }

    public WebService add(Service srv) {
        Reference srv2 = new Reference((Object)srv);
        this.addService(new ServiciableSingle(this, srv2){
            public /* synthetic */ Reference srv;
            final /* synthetic */ WebService this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                WebService webService;
                this.this$0 = webService = p0;
                this.srv = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
                Serviciable.Trait.Helper.$init$(this);
            }

            @Override
            public Service getService() {
                return IndyInterface.bootstrap("cast", "()", 0, this.srv.get());
            }

            @Override
            @Traits.TraitBridge(desc="()Ljava/lang/String;", traitClass=Serviciable.class)
            public String getAcceptCharset() {
                return Serviciable.Trait.Helper.getAcceptCharset(this);
            }

            @Generated
            public /* synthetic */ String com_intellisrc_web_service_Serviciabletrait$super$getAcceptCharset() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getAcceptCharset", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getAcceptCharset"));
            }

            @Override
            @Traits.TraitBridge(desc="()Ljava/lang/String;", traitClass=Serviciable.class)
            public String getAcceptType() {
                return Serviciable.Trait.Helper.getAcceptType(this);
            }

            @Generated
            public /* synthetic */ String com_intellisrc_web_service_Serviciabletrait$super$getAcceptType() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getAcceptType", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getAcceptType"));
            }

            @Override
            @Traits.TraitBridge(desc="()Lcom/intellisrc/web/service/Service$Allow;", traitClass=Serviciable.class)
            public Service.Allow getAllow() {
                return Serviciable.Trait.Helper.getAllow(this);
            }

            @Generated
            public /* synthetic */ Service.Allow com_intellisrc_web_service_Serviciabletrait$super$getAllow() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getAllow", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getAllow"));
            }

            @Override
            @Traits.TraitBridge(desc="()Ljava/lang/String;", traitClass=Serviciable.class)
            public String getAllowOrigin() {
                return Serviciable.Trait.Helper.getAllowOrigin(this);
            }

            @Generated
            public /* synthetic */ String com_intellisrc_web_service_Serviciabletrait$super$getAllowOrigin() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getAllowOrigin", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getAllowOrigin"));
            }

            @Override
            @Traits.TraitBridge(desc="()Lcom/intellisrc/web/service/Service$BeforeRequest;", traitClass=Serviciable.class)
            public Service.BeforeRequest getBeforeRequest() {
                return Serviciable.Trait.Helper.getBeforeRequest(this);
            }

            @Generated
            public /* synthetic */ Service.BeforeRequest com_intellisrc_web_service_Serviciabletrait$super$getBeforeRequest() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getBeforeRequest", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getBeforeRequest"));
            }

            @Override
            @Traits.TraitBridge(desc="()Lcom/intellisrc/web/service/Service$BeforeResponse;", traitClass=Serviciable.class)
            public Service.BeforeResponse getBeforeResponse() {
                return Serviciable.Trait.Helper.getBeforeResponse(this);
            }

            @Generated
            public /* synthetic */ Service.BeforeResponse com_intellisrc_web_service_Serviciabletrait$super$getBeforeResponse() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getBeforeResponse", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getBeforeResponse"));
            }

            @Override
            @Traits.TraitBridge(desc="()Ljava/lang/String;", traitClass=Serviciable.class)
            public String getNotAllowedRedirect() {
                return Serviciable.Trait.Helper.getNotAllowedRedirect(this);
            }

            @Generated
            public /* synthetic */ String com_intellisrc_web_service_Serviciabletrait$super$getNotAllowedRedirect() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getNotAllowedRedirect", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getNotAllowedRedirect"));
            }

            @Override
            @Traits.TraitBridge(desc="()Lcom/intellisrc/web/service/Service$ServiceError;", traitClass=Serviciable.class)
            public Service.ServiceError getOnError() {
                return Serviciable.Trait.Helper.getOnError(this);
            }

            @Generated
            public /* synthetic */ Service.ServiceError com_intellisrc_web_service_Serviciabletrait$super$getOnError() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getOnError", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getOnError"));
            }

            @Override
            @Traits.TraitBridge(desc="()Ljava/lang/String;", traitClass=Serviciable.class)
            public String getPath() {
                return Serviciable.Trait.Helper.getPath(this);
            }

            @Generated
            public /* synthetic */ String com_intellisrc_web_service_Serviciabletrait$super$getPath() {
                if (this instanceof GeneratedGroovyProxy) {
                    return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethod((Object)IndyInterface.bootstrap("cast", "()", 0, this).getProxyTarget(), (String)"getPath", (Object)new Object[0]));
                }
                return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuper0(1.class, (GroovyObject)this, (String)"getPath"));
            }

            static {
                Serviciable.Trait.Helper.$static$init$(1.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                try {
                    return this.this$0.this$dist$invoke$2(name, args);
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
                }
            }

            /*
             * Unable to fully structure code
             */
            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[] == false)) ** GOTO lbl8
                var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                return var2_2;
lbl8:
                // 1 sources

                if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
                var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
                return var3_3;
lbl14:
                // 1 sources

                var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                try {
                    return var4_4;
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)new MissingMethodException(notFound.getMethod(), 1.class, notFound.getArguments());
                }
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                try {
                    this.this$0.this$dist$set$2(name, value);
                    return;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
                }
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                try {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)new MissingPropertyException(notFound.getProperty(), 1.class, notFound.getCause());
                }
            }

            public /* synthetic */ Object propertyMissing(String name) {
                try {
                    return this.this$0.this$dist$get$2(name);
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
                }
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                Object object = ScriptBytecodeAdapter.getProperty(1.class, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                try {
                    return object;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)new MissingPropertyException(notFound.getProperty(), 1.class, notFound.getCause());
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        });
        return this;
    }

    public void addService(Serviciable srv) {
        this.init();
        if (!this.isRunning()) {
            if (srv instanceof ServiciableWebSocket) {
                this.services.add(0, srv);
            } else {
                Serviciable serviciable = srv;
                if ((serviciable == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, serviciable)) != false) {
                    DefaultGroovyMethods.leftShift(this.services, (Object)srv);
                } else {
                    Log.e((String)"Invalid instance added as service: %s", (Object[])new Object[]{srv});
                }
            }
        } else {
            Log.w((String)"WebService is already running. You can not add more services", (Object[])new Object[0]);
        }
    }

    public void setResources(Object path) {
        if (!this.isRunning()) {
            if (path instanceof File) {
                this.setStaticPath(((File)path).getAbsolutePath(), this.cacheTime, this.cacheMaxSizeKB, false);
            } else if (path instanceof String) {
                this.setStaticPath((String)((Object)IndyInterface.bootstrap("cast", "()", 0, path)), this.cacheTime, this.cacheMaxSizeKB, this.embedded);
            } else if (path instanceof Collection) {
                public final class _setResources_closure28
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _setResources_closure28(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public WebService doCall(Object it) {
                        return ((WebService)this.getThisObject()).setStaticPath(DefaultGroovyMethods.toString((Object)it), DefaultTypeTransformation.intUnbox((Object)this.getProperty("cacheTime")), DefaultTypeTransformation.intUnbox((Object)this.getProperty("cacheMaxSizeKB")), DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("embedded")));
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public WebService doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _setResources_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                DefaultGroovyMethods.each((Collection)((Object)IndyInterface.bootstrap("cast", "()", 0, path)), (Closure)new _setResources_closure28(this, this));
            } else {
                Log.w((String)"Value passed to resources is not a File, String or List: %s", (Object[])new Object[]{DefaultGroovyMethods.toString((Object)path)});
            }
        } else {
            Log.w((String)"WebService is already running. You can not change the resource path", (Object[])new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean doFilter(ServletRequest servletRequest, ServletResponse servletResponse) {
        block38: {
            block37: {
                block35: {
                    block36: {
                        commited = false;
                        reserved = false;
                        request = new Reference((Object)((Request)IndyInterface.bootstrap("invoke", "asType", 0, servletRequest, Request.class)));
                        response = new Reference((Object)((Response)IndyInterface.bootstrap("invoke", "asType", 0, servletResponse, Response.class)));
                        out = new Reference(null);
                        (ServiceOutput)out.get();
                        v0 = ((Request)request.get()).getMethod();
                        if ((v0 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v0)) == false != false || HttpMethod.fromString((String)((Request)request.get()).getMethod().trim().toUpperCase()) == null != false) {
                            Log.w((String)"Method not allowed: %s", (Object[])new Object[]{((Request)request.get()).getMethod()});
                            this.logWarn((Request)request.get(), HttpStatus.METHOD_NOT_ALLOWED_405);
                            throw (Throwable)new WebException(HttpStatus.METHOD_NOT_ALLOWED_405);
                        }
                        onStore = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, new _doFilter_closure29(this, this, response)));
                        onHit = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, new _doFilter_closure30(this, this, response)));
                        if (!this.requestPolicy.allow((Request)request.get())) break block35;
                        cacheKey = new Reference((Object)WebService.getCacheKey((Request)request.get()));
                        out.set((Object)IndyInterface.bootstrap("cast", "()", 0, this.cache.get((String)cacheKey.get())));
                        v1 = (ServiceOutput)out.get();
                        if ((v1 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v1)) != false) {
                            ((Cache.CacheAccess)onHit.get()).call((String)cacheKey.get());
                        }
                        v2 = (ServiceOutput)out.get();
                        if ((v2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v2)) == false) {
                            uri = new Reference((Object)((Request)request.get()).getRequestURI());
                            if (DefaultTypeTransformation.booleanUnbox((Object)((String)uri.get())) != false && ((String)uri.get()).isEmpty() == false != false) {
                                if (this.staticPaths.isEmpty() == false) {
                                    DefaultGroovyMethods.any(this.staticPaths, (Closure)new _doFilter_closure31(this, this, uri, response, request, out, cacheKey, onHit, onStore));
                                }
                            } else {
                                Log.w((String)"Invalid request (empty)", (Object[])new Object[0]);
                                this.logWarn((Request)request.get(), HttpStatus.BAD_REQUEST_400);
                                throw (Throwable)new WebException(HttpStatus.BAD_REQUEST_400);
                            }
                        }
                        v3 = (ServiceOutput)out.get();
                        if ((v3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v3)) == false) {
                            mfr = this.matchURI(((Request)request.get()).getRequestURI(), HttpMethod.fromString((String)((Request)request.get()).getMethod().trim().toUpperCase()), ((Request)request.get()).headers(HttpHeader.ACCEPT), ((Request)request.get()).headers(HttpHeader.ACCEPT_CHARSET));
                            if (mfr.getRoute().isPresent()) {
                                ((Request)request.get()).setPathParameters(mfr.getParams());
                                sp = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, mfr.getRoute().get()));
                                v4 = ((Service)sp.get()).getBeforeRequest();
                                if ((v4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v4)) != false) {
                                    ((Service)sp.get()).getBeforeRequest().run((Request)request.get());
                                }
                                if (((Service)sp.get()).isReserved()) {
                                    reserved = true;
                                } else if (((Service)sp.get()).getCacheTime() != 0) {
                                    addToCache = DefaultTypeTransformation.booleanUnbox((Object)((Service)sp.get()).getCacheTime()) != false && this.isCacheFull() == false != false;
                                    noCache = new Reference((Object)new _doFilter_closure32(this, this, sp, request, response));
                                    out.set((Object)(addToCache != false ? IndyInterface.bootstrap("cast", "()", 0, this.cache.get((String)cacheKey.get(), (Cache.NotFound)IndyInterface.bootstrap("cast", "()", 0, new _doFilter_closure33(this, this, noCache)), (Cache.CacheAccess)onHit.get(), (Cache.CacheAccess)onStore.get(), ((Service)sp.get()).getCacheTime())) : IndyInterface.bootstrap("cast", "()", 0, ((Closure)noCache.get()).call())));
                                } else {
                                    out.set((Object)this.processService((Service)sp.get(), (Request)request.get(), (Response)response.get()));
                                }
                                v5 = ((Service)sp.get()).getBeforeResponse();
                                if ((v5 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v5)) != false) {
                                    ((Service)sp.get()).getBeforeResponse().run((Response)response.get());
                                }
                            }
                        }
                        v6 = (ServiceOutput)out.get();
                        if ((v6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v6)) == false) break block36;
                        this.prepareResponse((ServiceOutput)out.get(), (Response)response.get());
                        if (!ScriptBytecodeAdapter.compareEqual((Object)((ServiceOutput)out.get()).getType(), (Object)ServiceOutput.Type.STREAM)) ** GOTO lbl113
                        ((Response)response.get()).update();
                        var16_16 = ((ServiceOutput)out.get()).getContent();
                        if (ScriptBytecodeAdapter.isCase((Object)var16_16, String.class)) {
                            text = DefaultGroovyMethods.toString((Object)((ServiceOutput)out.get()).getContent());
                            var18_18 = text.length();
                            ((Response)response.get()).setContentLength(var18_18);
                            ((Response)response.get()).getWriter().write(text);
                            ((Response)response.get()).getWriter().flush();
                        } else if (ScriptBytecodeAdapter.isCase((Object)var16_16, byte[].class)) {
                            content = (byte[])IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)out.get()).getContent(), byte[].class);
                            var20_20 = ((ServiceOutput)out.get()).getSize();
                            var21_21 = var20_20 != 0 != false ? var20_20 : content.length;
                            ((Response)response.get()).setContentLength(var21_21);
                            ((Response)response.get()).getOutputStream().write(content);
                            ((Response)response.get()).getOutputStream().flush();
                        } else {
                            Log.w((String)"SSE Stream should be String or byte[]: %s", (Object[])new Object[]{((Request)request.get()).uri()});
                            throw (Throwable)new WebException(HttpStatus.INTERNAL_SERVER_ERROR_500, "Invalid type");
lbl113:
                            // 1 sources

                            if (((Response)response.get()).isCommitted() == false) {
                                var22_22 = ((ServiceOutput)out.get()).getContent();
                                if (ScriptBytecodeAdapter.isCase((Object)var22_22, String.class)) {
                                    text = ((ServiceOutput)out.get()).toString();
                                    if (text.isEmpty() == false) {
                                        var24_24 = ((ServiceOutput)out.get()).getSize();
                                        ((Response)response.get()).setContentLength(var24_24);
                                        ((Response)response.get()).getWriter().write(text);
                                        ((Response)response.get()).getWriter().flush();
                                        ((Response)response.get()).getWriter().close();
                                        commited = true;
                                    }
                                } else if (ScriptBytecodeAdapter.isCase((Object)var22_22, ByteBuffer.class) || ScriptBytecodeAdapter.isCase((Object)var22_22, byte[].class)) {
                                    content = ((ServiceOutput)out.get()).getContent() instanceof ByteBuffer != false ? ((ByteBuffer)IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)out.get()).getContent(), ByteBuffer.class)).array() : (byte[])IndyInterface.bootstrap("invoke", "asType", 0, ((ServiceOutput)out.get()).getContent(), byte[].class);
                                    if (content.length != 0) {
                                        var26_26 = ((ServiceOutput)out.get()).getSize();
                                        var27_27 = var26_26 != 0 != false ? var26_26 : content.length;
                                        ((Response)response.get()).setContentLength(var27_27);
                                        ((Response)response.get()).getOutputStream().write(content);
                                        ((Response)response.get()).getOutputStream().flush();
                                        ((Response)response.get()).getOutputStream().close();
                                        commited = true;
                                    }
                                } else if (ScriptBytecodeAdapter.isCase((Object)var22_22, InputStream.class)) {
                                    ((InputStream)IndyInterface.bootstrap("invoke", "asType", 0, (ServiceOutput)out.get(), InputStream.class)).transferTo((OutputStream)((Response)response.get()).getOutputStream());
                                    ((Response)response.get()).getOutputStream().flush();
                                    ((Response)response.get()).getOutputStream().close();
                                    commited = true;
                                }
                            }
                        }
                        break block37;
                    }
                    if (reserved == false != false && ((Response)response.get()).isRedirected() == false != false) {
                        Log.v((String)"No output found: %s", (Object[])new Object[]{((Request)request.get()).uri()});
                        this.logNotFound((Request)request.get());
                        throw (Throwable)new WebException(HttpStatus.NOT_FOUND_404);
                    }
                    break block37;
                }
                Log.w((String)"Unauthorized: %s", (Object[])new Object[]{((Request)request.get()).uri()});
                this.logWarn((Request)request.get(), HttpStatus.UNAUTHORIZED_401);
                throw (Throwable)new WebException(HttpStatus.UNAUTHORIZED_401);
            }
            if (!(reserved == false != false && ((Response)response.get()).isRedirected() == false != false)) break block38;
            if (((Response)response.get()).getStatus() != 0 == false != false || ((Response)response.get()).getStatus() == HttpStatus.NOT_FOUND_404 != false) {
                Log.v((String)"The requested path was not found: %s", (Object[])new Object[]{((Request)request.get()).uri()});
                this.logNotFound((Request)request.get());
                throw (Throwable)new WebException(HttpStatus.NOT_FOUND_404);
            }
            if (!(((Response)response.get()).getStatus() != HttpStatus.NOT_MODIFIED_304)) ** GOTO lbl-1000
            v7 = ((Response)response.get()).type();
            if ((v7 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v7)) == false) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            if (v8) {
                Log.w((String)"Response without content type: %s", (Object[])new Object[]{((Request)request.get()).uri()});
                this.logWarn((Request)request.get(), HttpStatus.INTERNAL_SERVER_ERROR_500);
                throw (Throwable)new WebException(HttpStatus.INTERNAL_SERVER_ERROR_500);
            }
            if (((Response)response.get()).getStatus() >= 400) {
                Log.v((String)"Server status code was: %d : %s", (Object[])new Object[]{((Response)response.get()).getStatus(), ((Request)request.get()).uri()});
                this.logWarn((Request)request.get(), ((Response)response.get()).getStatus());
                throw (Throwable)new WebException(((Response)response.get()).getStatus(), HttpStatus.getCode((int)((Response)response.get()).getStatus()).getMessage());
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)((ServiceOutput)out.get()).getType(), (Object)ServiceOutput.Type.STREAM)) {
                while (true) {
                    DefaultGroovyStaticMethods.sleep(null, (long)Millis.getSECOND());
                }
            }
            if (commited == false != false && ((Response)response.get()).isCommitted() == false != false) {
                ((Response)response.get()).getWriter().close();
            }
        }
        this.logAccess((Request)request.get());
        return commited != false || ((Response)response.get()).isCommitted() != false;
    }

    public Map<String, String> getGlobalHeaders() {
        TreeMap<String, String> global = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String string = this.allowOrigin;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            global.put(HttpHeader.ACCEPT_CONTROL_ALLOW_ORIGIN, this.allowOrigin);
        }
        return global;
    }

    public Server getServer() {
        return this.jettyServer;
    }

    public boolean clearCache(String match) {
        return this.cache.clear(match);
    }

    public boolean clearCache(Pattern match) {
        return this.cache.clear(match);
    }

    public boolean clearCache() {
        Log.v((String)"All cache cleared", (Object[])new Object[0]);
        return this.cache.clear();
    }

    public void stop() {
        Log.i((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.port}, new String[]{"Stopping server running at port: ", ""}))), (Object[])new Object[0]);
        if (this.jettyServer.isStarted() && this.jettyServer.isRunning()) {
            this.jettyServer.stop();
        }
        boolean bl = false;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, WebService.class, (GroovyObject)this, (String)"running");
    }

    public boolean addService(Service service) {
        Reference service2 = new Reference((Object)service);
        public final class _addService_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference service;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addService_closure34(Object _outerInstance, Object _thisObject, Reference service) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.service = reference = service;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Service)it).getPath(), (Object)((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getPath()) && ScriptBytecodeAdapter.compareEqual((Object)((Service)it).getMethod(), (Object)((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getMethod()) && ScriptBytecodeAdapter.compareEqual((Object)((Service)it).getAcceptType(), (Object)((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getAcceptType()) || ((MatchFilterResult)InvokerHelper.invokeMethodSafe((Object)((WebService)this.getThisObject()), (String)"matchURI", (Object)new Object[]{((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getPath(), ((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getMethod(), ((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getAcceptType(), ((Service)((Object)IndyInterface.bootstrap("cast", "()", 0, this.service.get()))).getAcceptCharset()})).getRoute().isPresent();
            }

            @Generated
            public Service getService() {
                return IndyInterface.bootstrap("cast", "()", 0, this.service.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addService_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        boolean duplicated = DefaultGroovyMethods.any(this.definitions, (Closure)new _addService_closure34(this, this, service2));
        if (duplicated) {
            Log.w((String)"Warning, duplicated path [%s] and method [%s] and acceptType [%s] found.", (Object[])new Object[]{((Service)service2.get()).getPath(), ((Service)service2.get()).getMethod().toString(), ((Service)service2.get()).getAcceptType()});
            return false;
        }
        return this.definitions.add((Service)service2.get());
    }

    public static void handleException(Service sp, int code, String text, Exception e) {
        if (e instanceof WebException) {
            throw (Throwable)e;
        }
        boolean handled = false;
        Service.ServiceError serviceError = sp.getOnError();
        if ((serviceError == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, serviceError)) != false) {
            Exception exception;
            handled = sp.getOnError().call(code, IndyInterface.bootstrap("cast", "()", 0, exception = e) != false ? exception : new Exception(text));
        }
        if (!handled) {
            Boolean bl = true;
            if (ScriptBytecodeAdapter.isCase((Object)bl, (Object)(code >= HttpStatus.BAD_REQUEST_400 ? 1 : 0))) {
                Exception exception = e;
                if ((exception == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, exception)) != false) {
                    Log.e((String)"Exception in service: ", (Object[])new Object[]{e});
                }
                throw (Throwable)new WebException(code, text, e);
            }
            Log.v((String)text, (Object[])new Object[0]);
        }
    }

    protected static String addRoot(String rootPath, String servicePath) {
        Object fullPath = null;
        if (servicePath.startsWith("~/")) {
            fullPath = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"~/", (CharSequence)((String)rootPath).replaceAll("^/", "").replaceAll("/$", "")), (CharSequence)servicePath.replaceAll("^~/", ""));
        } else {
            boolean startsWithParam = !servicePath.isEmpty() && ScriptBytecodeAdapter.createList((Object[])new Object[]{":", "*"}).contains(StringGroovyMethods.getAt((String)servicePath, (int)0));
            boolean rootEndsWithSlash = ((String)rootPath).endsWith("/");
            boolean serviceStartsWithSlash = servicePath.startsWith("/");
            if (rootEndsWithSlash && serviceStartsWithSlash) {
                servicePath = servicePath.replaceAll("^/", "");
            }
            if (startsWithParam && !rootEndsWithSlash) {
                rootPath = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{rootPath}, new String[]{"", "/"}));
            }
            fullPath = StringGroovyMethods.plus((String)rootPath, (CharSequence)servicePath);
        }
        if (!((String)fullPath).startsWith("/") && !((String)fullPath).startsWith("~/")) {
            fullPath = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{fullPath}, new String[]{"/", ""}));
        }
        return fullPath;
    }

    /*
     * WARNING - void declaration
     */
    protected MatchFilterResult matchURI(String path, HttpMethod method, String acceptType, String acceptCharset) {
        void var3_3;
        void var2_2;
        Reference path2 = new Reference((Object)path);
        Reference method2 = new Reference((Object)var2_2);
        Reference acceptType2 = new Reference((Object)var3_3);
        Reference acceptCharset2 = new Reference((Object)acceptCharset);
        Reference params = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0])));
        public final class _matchURI_closure35
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference method;
            private /* synthetic */ Reference acceptType;
            private /* synthetic */ Reference acceptCharset;
            private /* synthetic */ Reference path;
            private /* synthetic */ Reference params;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _matchURI_closure35(Object _outerInstance, Object _thisObject, Reference method, Reference acceptType, Reference acceptCharset, Reference path, Reference params) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.method = reference5 = method;
                this.acceptType = reference4 = acceptType;
                this.acceptCharset = reference3 = acceptCharset;
                this.path = reference2 = path;
                this.params = reference = params;
            }

            /*
             * Unable to fully structure code
             */
            public Boolean doCall(Service srv) {
                found = false;
                if (!(ScriptBytecodeAdapter.compareEqual((Object)srv.getMethod(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.method.get())) != false && (ScriptBytecodeAdapter.compareEqual((Object)srv.getAcceptType(), (Object)"*/*") != false || DefaultGroovyMethods.collect((Iterable)StringGroovyMethods.tokenize((CharSequence)IndyInterface.bootstrap("cast", "()", 0, this.acceptType.get()), (CharSequence)","), (Closure)new _matchURI_closure35._closure49((Object)this, this.getThisObject())).contains(srv.getAcceptType()) != false) != false)) ** GOTO lbl-1000
                v0 = srv.getAcceptCharset();
                if ((v0 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v0)) == false != false || ScriptBytecodeAdapter.compareEqual((Object)srv.getAcceptCharset(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.acceptCharset.get())) != false) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) {
                    fullPath = srv.getPath();
                    if ((fullPath.startsWith("/") != false || fullPath.startsWith("~") != false) == false) {
                        fullPath = StringGroovyMethods.plus((String)"/", (CharSequence)fullPath);
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)fullPath, (Object)IndyInterface.bootstrap("cast", "()", 0, this.path.get())) != false || (fullPath.endsWith("/?") != false && ScriptBytecodeAdapter.compareEqual((Object)fullPath.replaceAll("/\\?$", ""), (Object)IndyInterface.bootstrap("cast", "()", 0, this.path.get()).replaceAll("/$", "")) != false) != false) {
                        found = true;
                    } else {
                        pattern = null;
                        if (fullPath.contains("/:") != false || fullPath.contains("*") != false) {
                            pattern = Pattern.compile(StringGroovyMethods.plus((String)fullPath.replaceAll("\\*", "(?<splat>.*)").replaceAll("/:([^/]*)", "/(?<$1>[^/]*)").replaceAll("\\$$", ""), (CharSequence)"$"), Pattern.CASE_INSENSITIVE);
                        } else if (fullPath.startsWith("~/")) {
                            pattern = Service.toPattern(fullPath);
                        }
                        if (pattern != null) {
                            toMatch = srv.isStrictPath() != false ? IndyInterface.bootstrap("cast", "()", 0, this.path.get()) : (pattern.toString().startsWith("/") != false ? IndyInterface.bootstrap("cast", "()", 0, this.path.get()) : IndyInterface.bootstrap("cast", "()", 0, this.path.get()).replaceFirst("^/", ""));
                            matcher = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)toMatch, (Object)pattern));
                            if (matcher.find()) {
                                found = true;
                                if (StringGroovyMethods.hasGroup((Matcher)matcher)) {
                                    groupMatcher = Pattern.compile("\\(\\?<(\\w+)>").matcher(pattern.toString());
                                    while (groupMatcher.find()) {
                                        groupName = groupMatcher.group(1);
                                        v2 = groupName;
                                        if ((v2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v2)) == false) continue;
                                        var9_9 = matcher.group(groupName).toString();
                                        ScriptBytecodeAdapter.invokeMethodN(_matchURI_closure35.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.params.get()), (String)"putAt", (Object[])new Object[]{groupName, var9_9});
                                    }
                                }
                            }
                        }
                    }
                }
                return found;
            }

            @Generated
            public Boolean call(Service srv) {
                return this.doCall(srv);
            }

            @Generated
            public HttpMethod getMethod() {
                return IndyInterface.bootstrap("cast", "()", 0, this.method.get());
            }

            @Generated
            public String getAcceptType() {
                return IndyInterface.bootstrap("cast", "()", 0, this.acceptType.get());
            }

            @Generated
            public String getAcceptCharset() {
                return IndyInterface.bootstrap("cast", "()", 0, this.acceptCharset.get());
            }

            @Generated
            public String getPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.path.get());
            }

            @Generated
            public LinkedHashMap getParams() {
                return IndyInterface.bootstrap("cast", "()", 0, this.params.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _matchURI_closure35.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite match = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find(this.definitions, (Closure)new _matchURI_closure35(this, this, method2, acceptType2, acceptCharset2, path2, params)));
        return new MatchFilterResult(Optional.ofNullable(match), (LinkedHashMap)params.get());
    }

    public long getCacheSize() {
        public final class _getCacheSize_closure36
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getCacheSize_closure36(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object it) {
                return ((ServiceOutput)it).getSize();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Integer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCacheSize_closure36.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.sum((Iterable)this.cache.values(), (Closure)new _getCacheSize_closure36(this, this)), Long.class));
    }

    public boolean isCacheFull() {
        return this.cacheTotalMaxSizeMB > 0 && this.getCacheSize() > (long)(this.cacheTotalMaxSizeMB * 1024);
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && this.jettyServer.isRunning();
    }

    @Override
    public boolean isStarted() {
        return super.isRunning() && this.jettyServer.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.initialized && this.jettyServer.isStarting();
    }

    @Override
    public boolean isStopping() {
        return !super.isRunning() && this.jettyServer.isStopping();
    }

    @Override
    public boolean isStopped() {
        return !super.isRunning() && !this.jettyServer.isRunning();
    }

    @Override
    public boolean isFailed() {
        return this.initialized && !super.isRunning() || this.jettyServer.isFailed();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(WebService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(WebService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(WebService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, WebService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(WebService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ boolean pfaccess$0(WebService $that) {
        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.getField(WebService.class, WebService.class, (String)"forceFile"));
    }

    @Generated
    public WebService start(boolean background) {
        return this.start(background, null);
    }

    @Generated
    public WebService start() {
        return this.start(false, null);
    }

    @Generated
    protected static Object callAction(Object action, Request request, Response response, List<UploadFile> upload) {
        return WebService.callAction(action, request, response, upload, false);
    }

    @Generated
    protected static Object callAction(Object action, Request request, Response response) {
        return WebService.callAction(action, request, response, null, false);
    }

    @Generated
    public static void handleException(Service sp, int code, String text) {
        WebService.handleException(sp, code, text, null);
    }

    @Generated
    public static void handleException(Service sp, int code) {
        WebService.handleException(sp, code, "", null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != WebService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        boolean bl;
        String string;
        defaultCharset = string = Config.any.get("web.charset", "UTF-8");
        forceFile = bl = Config.any.get("web.upload.force", false);
    }

    @Generated
    public static String getDefaultCharset() {
        return defaultCharset;
    }

    @Generated
    public static void setDefaultCharset(String string) {
        defaultCharset = string;
    }

    @Generated
    public static boolean getForceFile() {
        return forceFile;
    }

    @Generated
    public static boolean isForceFile() {
        return forceFile;
    }

    @Generated
    public static void setForceFile(boolean bl) {
        forceFile = bl;
    }

    @Generated
    public boolean getTrustForwardHeaders() {
        return this.trustForwardHeaders;
    }

    @Generated
    public boolean isTrustForwardHeaders() {
        return this.trustForwardHeaders;
    }

    @Generated
    public void setTrustForwardHeaders(boolean bl) {
        this.trustForwardHeaders = bl;
    }

    @Generated
    public boolean getCheckSNIHostname() {
        return this.checkSNIHostname;
    }

    @Generated
    public boolean isCheckSNIHostname() {
        return this.checkSNIHostname;
    }

    @Generated
    public void setCheckSNIHostname(boolean bl) {
        this.checkSNIHostname = bl;
    }

    @Generated
    public boolean getSniRequired() {
        return this.sniRequired;
    }

    @Generated
    public boolean isSniRequired() {
        return this.sniRequired;
    }

    @Generated
    public void setSniRequired(boolean bl) {
        this.sniRequired = bl;
    }

    public static interface FilePolicy {
        public boolean allow(File var1);
    }

    public static interface PathPolicy {
        public boolean allow(String var1);
    }

    public static interface RequestPolicy {
        public boolean allow(Request var1);
    }

    public static class StaticPath
    implements GroovyObject {
        private String path;
        private boolean embedded;
        private int expireSeconds;
        private int cacheMaxSizeKB;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public StaticPath(String path, boolean embedded, int expireSeconds, int cacheMaxSizeKB) {
            int n;
            int n2;
            boolean bl;
            String string;
            MetaClass metaClass;
            int n3;
            int n4;
            boolean bl2;
            Object var5_5 = null;
            this.path = IndyInterface.bootstrap("cast", "()", 0, var5_5);
            this.embedded = bl2 = false;
            this.expireSeconds = n4 = 0;
            this.cacheMaxSizeKB = n3 = 0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.path = string = path;
            this.embedded = bl = embedded;
            this.expireSeconds = n2 = expireSeconds;
            this.cacheMaxSizeKB = n = cacheMaxSizeKB;
        }

        @Generated
        public StaticPath(String path, boolean embedded, int expireSeconds) {
            this(path, embedded, expireSeconds, 0);
        }

        @Generated
        public StaticPath(String path, boolean embedded) {
            this(path, embedded, 0, 0);
        }

        @Generated
        public StaticPath(String path) {
            this(path, false, 0, 0);
        }

        @Generated
        public StaticPath() {
            this(null, false, 0, 0);
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(StaticPath.class, WebService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), StaticPath.class, notFound.getArguments());
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), StaticPath.class, notFound.getCause());
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(StaticPath.class, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(StaticPath.class, WebService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), StaticPath.class, notFound.getCause());
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StaticPath.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public boolean getEmbedded() {
            return this.embedded;
        }

        @Generated
        public boolean isEmbedded() {
            return this.embedded;
        }

        @Generated
        public void setEmbedded(boolean bl) {
            this.embedded = bl;
        }

        @Generated
        public int getExpireSeconds() {
            return this.expireSeconds;
        }

        @Generated
        public void setExpireSeconds(int n) {
            this.expireSeconds = n;
        }

        @Generated
        public int getCacheMaxSizeKB() {
            return this.cacheMaxSizeKB;
        }

        @Generated
        public void setCacheMaxSizeKB(int n) {
            this.cacheMaxSizeKB = n;
        }
    }

    public static interface StartCallback {
        public void call(WebService var1);
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(File file) {
            return true;
        }

        @Generated
        public Boolean call(File file) {
            return this.doCall(file);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(String path) {
            return true;
        }

        @Generated
        public Boolean call(String path) {
            return this.doCall(path);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public final class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(Request request) {
            return true;
        }

        @Generated
        public Boolean call(Request request) {
            return this.doCall(request);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

