/*
 * Decompiled with CFR 0.152.
 */
package com.intellisrc.web;

import com.intellisrc.core.Config;
import com.intellisrc.core.Millis;
import com.intellisrc.groovy.FileStaticExt;
import com.intellisrc.groovy.StringExt;
import com.intellisrc.web.service.KeyStore;
import com.intellisrc.web.service.Request;
import com.intellisrc.web.tools.AccessLog;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.Inet4Address;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public abstract class WebServiceBase
implements GroovyObject {
    protected boolean initialized;
    protected boolean running;
    public Inet4Address address;
    public int port;
    public KeyStore ssl;
    public int timeout;
    public AccessLog logger;
    public boolean log;
    public final File logDir;
    protected File accessLogFile;
    protected File warnLogFile;
    protected File notFoundLogFile;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public WebServiceBase() {
        MetaClass metaClass;
        File file;
        File file2;
        File file3;
        File file4;
        boolean bl;
        AccessLog accessLog;
        int n;
        int n2;
        Inet4Address inet4Address;
        boolean bl2;
        boolean bl3;
        this.initialized = bl3 = false;
        this.running = bl2 = false;
        this.address = inet4Address = StringExt.toInet4Address((String)"0.0.0.0");
        this.port = n2 = 80;
        Object var5_5 = null;
        this.ssl = IndyInterface.bootstrap("cast", "()", 0, var5_5);
        this.timeout = n = Millis.getMIN_10();
        this.logger = accessLog = new AccessLog();
        this.log = bl = Config.any.get("web.log", false);
        this.logDir = file4 = Config.any.getFile("web.log.dir", FileStaticExt.get(null, (Object[])new Object[]{Config.any.get("log.path", "log")}));
        this.accessLogFile = file3 = Config.any.getFile("web.log.access", FileStaticExt.get(null, (Object[])new Object[]{this.logDir, "access.log"}));
        this.warnLogFile = file2 = Config.any.getFile("web.log.warn", FileStaticExt.get(null, (Object[])new Object[]{this.logDir, "warn.log"}));
        this.notFoundLogFile = file = Config.any.getFile("web.log.notfound", FileStaticExt.get(null, (Object[])new Object[]{this.logDir, "notfound.log"}));
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean isSecure() {
        KeyStore keyStore = this.ssl;
        return DefaultTypeTransformation.booleanUnbox(keyStore != null ? Boolean.valueOf(keyStore.isValid()) : null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStarted() {
        return this.running;
    }

    public boolean isStarting() {
        return this.initialized;
    }

    public boolean isStopping() {
        return !this.running;
    }

    public boolean isStopped() {
        return !this.running;
    }

    public boolean isFailed() {
        return this.initialized && !this.running;
    }

    public void setAccessLog(Object path) {
        Object object = path;
        File file = (object == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, object)) != false ? (path instanceof String && !((String)path).contains("/") ? FileStaticExt.get(null, (Object[])new Object[]{this.logDir, path}) : FileStaticExt.get(null, (Object[])new Object[]{path})) : null;
        this.accessLogFile = IndyInterface.bootstrap("cast", "()", 0, file);
    }

    public void setWarnLog(Object path) {
        Object object = path;
        File file = (object == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, object)) != false ? (path instanceof String && !((String)path).contains("/") ? FileStaticExt.get(null, (Object[])new Object[]{this.logDir, path}) : FileStaticExt.get(null, (Object[])new Object[]{path})) : null;
        this.warnLogFile = IndyInterface.bootstrap("cast", "()", 0, file);
    }

    public void setNotFoundLog(Object path) {
        Object object = path;
        File file = (object == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, object)) != false ? (path instanceof String && !((String)path).contains("/") ? FileStaticExt.get(null, (Object[])new Object[]{this.logDir, path}) : FileStaticExt.get(null, (Object[])new Object[]{path})) : null;
        this.notFoundLogFile = IndyInterface.bootstrap("cast", "()", 0, file);
    }

    public void logAccess(Request request) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)this.accessLogFile)) {
            this.logger.access(this.accessLogFile, request);
        }
    }

    public void logWarn(Request request, int code) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)this.warnLogFile)) {
            this.logger.warn(this.warnLogFile, request, code);
        }
    }

    public void logNotFound(Request request) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)this.notFoundLogFile)) {
            this.logger.notFound(this.notFoundLogFile, request);
        }
    }

    public void logLogin(File logFile, Request request) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)logFile)) {
            this.logger.logged(logFile, request);
        }
    }

    public void logFailLogin(File logFile, Request request) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)logFile)) {
            this.logger.failed(logFile, request);
        }
    }

    public void logLogout(File logFile, Request request) {
        if (this.log && DefaultTypeTransformation.booleanUnbox((Object)logFile)) {
            this.logger.logged(logFile, request, true);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != WebServiceBase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

