/*
 * Decompiled with CFR 0.152.
 */
package com.intellisrc.web.protocols;

import com.intellisrc.web.WebService;
import com.intellisrc.web.protocols.HttpProtocol;
import groovy.lang.MetaClass;
import java.lang.invoke.MethodHandles;
import java.security.Provider;
import java.security.Security;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class Http
extends HttpProtocol {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public Http(WebService server) {
        super(server);
    }

    @Override
    public void init() {
        if (this.getServer().isSecure()) {
            Security.insertProviderAt((Provider)new OpenSSLProvider(), 1);
        }
    }

    @Override
    public AbstractNetworkConnector prepareConnector() {
        WebService webService = this.getServer();
        if ((webService == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, webService)) == false) {
            throw InvokerHelper.createAssertError((Object)"this.getServer()", (Object)"Server was not specified");
        }
        return new ServerConnector(this.getServer().getServer(), this.getSSLContextFactory(), new ConnectionFactory[]{this.getConnectionFactory(this.createHttpConfiguration())});
    }

    @Override
    public SslContextFactory.Server getSSLContextFactory() {
        SslContextFactory.Server sslContextFactory = null;
        if (this.getServer().isSecure()) {
            sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setEndpointIdentificationAlgorithm("https");
            sslContextFactory.setKeyStorePath(this.getServer().ssl.getFile().getAbsolutePath());
            if (this.getServer().ssl.getPassword() != null) {
                sslContextFactory.setKeyStorePassword(DefaultGroovyMethods.toString((char[])this.getServer().ssl.getPassword()));
            }
            sslContextFactory.setUseCipherSuitesOrder(true);
        }
        return sslContextFactory;
    }

    @Override
    public HttpConnectionFactory getConnectionFactory(HttpConfiguration httpConfiguration) {
        if (this.getServer().isSecure()) {
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniHostCheck(this.isCheckSNIHostname());
            src.setSniRequired(this.isSniRequired());
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)src);
            httpConfiguration.setSecurePort(this.getServer().port);
        }
        return new HttpConnectionFactory(httpConfiguration);
    }

    public HttpConfiguration createHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSendServerVersion(false);
        if (this.isTrustForwardHeaders()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return httpConfig;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Http.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

