/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.parser;

import com.intersult.parser.NonTerminal;
import com.intersult.parser.ParseNode;
import com.intersult.parser.Parser;
import com.intersult.parser.Parsers;
import com.intersult.parser.Scanner;

public class ChoiceParser
extends Parser {
    private String[] choices;

    public ChoiceParser(Parsers parsers, String name, String ... choices) {
        super(parsers, name);
        this.choices = choices;
    }

    @Override
    public ParseNode parse(Scanner scanner) {
        int position = scanner.position;
        for (int i = 0; i < this.choices.length; ++i) {
            String parser = this.choices[i];
            ParseNode child = this.parse(parser, scanner);
            if (child != null) {
                if (this.name() == null || this.name().charAt(0) == '_') {
                    return child;
                }
                return new NonTerminal((Parser)this, child);
            }
            scanner.position(position);
        }
        scanner.error(this, position);
        return null;
    }

    @Override
    public String toString() {
        String result = this.name() + " := ";
        for (int i = 0; i < this.choices.length; ++i) {
            if (i > 0) {
                result = result + " | ";
            }
            result = result + "\"" + this.choices[i] + "\"";
        }
        return result;
    }
}

