/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.parser;

import com.intersult.parser.ChoiceParser;
import com.intersult.parser.DelimiterRepetitionParser;
import com.intersult.parser.EmptyParser;
import com.intersult.parser.EndParser;
import com.intersult.parser.IdentityParser;
import com.intersult.parser.NegateSymbolParser;
import com.intersult.parser.NonTerminal;
import com.intersult.parser.OptionalParser;
import com.intersult.parser.ParseException;
import com.intersult.parser.ParseNode;
import com.intersult.parser.Parser;
import com.intersult.parser.RepetitionParser;
import com.intersult.parser.Scanner;
import com.intersult.parser.SequenceParser;
import com.intersult.parser.StartSymbolParser;
import com.intersult.parser.StopParser;
import com.intersult.parser.StringParser;
import com.intersult.parser.SymbolParser;
import com.intersult.parser.Terminal;
import com.intersult.parser.TerminalParser;
import java.util.HashMap;

public class Parsers
implements Cloneable {
    private static Parsers global = new Parsers();
    private HashMap<String, Parser> parsers = new HashMap();
    private static boolean useCache = true;
    private int depth = 0;
    private boolean debug;
    public long count = 0L;
    public long hit = 0L;

    public Parsers() {
        new SymbolParser(this, "lower-symbol", "abcdefghijklmnopqrstuvwxyz");
        new SymbolParser(this, "upper-symbol", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        new SymbolParser(this, "letters", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        new StartSymbolParser(this, "symbol", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_");
        new NegateSymbolParser(this, "string", "", 0);
        new StopParser(this, "comment-literal", "*/");
        new SequenceParser(this, "comment-string", "/*", "comment-literal", "*/");
        new NegateSymbolParser(this, "quote-literal", "\"", 0);
        new SequenceParser(this, "quote-string", "\"", "quote-literal", "\"");
        new NegateSymbolParser(this, "apos-literal", "'", 0);
        new SequenceParser(this, "apos-string", "'", "apos-literal", "'");
        new SymbolParser(this, "integer", "1234567890");
        new SymbolParser(this, "space", " \t\r\n");
        new SymbolParser(this, "white-space", " \t\r\n", 0);
        new SequenceParser(this, "comma", "white-space", ",", "white-space");
        new SequenceParser(this, "semicolon", "white-space", ";", "white-space");
        new SequenceParser(this, "dot", "white-space", ".", "white-space");
        new SequenceParser(this, "apos", "'");
        new SequenceParser(this, "quote", "\"");
        new EndParser(this);
        new EmptyParser(this);
        new SequenceParser(this, "parser-quote", "white-space", "quote-string");
        new SequenceParser(this, "parser-apos", "white-space", "apos-string");
        new SequenceParser(this, "parser-symbol", "white-space", "symbol");
        new ChoiceParser(this, "parser-element", "parser-symbol", "parser-quote", "parser-apos");
        new ChoiceParser(this, "choice-element", "sequence-parser", "parser-element");
        new SequenceParser(this, "choice-operator", "white-space", "|");
        new DelimiterRepetitionParser(this, "choice-parser", "choice-element", "choice-operator", 2);
        new SequenceParser(this, "sequence-expression", "white-space", "(", "parser-expression", "white-space", ")");
        new ChoiceParser(this, "sequence-element", "repetition-parser", "sequence-expression", "parser-element");
        new SequenceParser(this, "sequence-operator", "white-space", "+");
        new DelimiterRepetitionParser(this, "sequence-parser", "sequence-element", "sequence-operator", 2);
        new SequenceParser(this, "repetition-expression", "white-space", "(", "parser-expression", "white-space", ")");
        new ChoiceParser(this, "repetition-element", "repetition-expression", "parser-element");
        new SequenceParser(this, "delimiter-repetition-parser", "repetition-element", "white-space", "#", "integer", "repetition-element");
        new SequenceParser(this, "optional-parser", "repetition-element", "white-space", "?");
        new SequenceParser(this, "simple-repetition-parser", "repetition-element", "white-space", "!");
        new ChoiceParser(this, "repetition-parser", "simple-repetition-parser", "optional-parser", "delimiter-repetition-parser");
        new ChoiceParser(this, "parser-expression", "choice-parser", "sequence-parser", "repetition-parser", "parser-element");
        new SequenceParser(this, "terminal-parser-expression", "parser-expression", "white-space", ".");
        new ChoiceParser(this, "parser", "terminal-parser-expression", "parser-expression");
        new SequenceParser(this, "parser-definition", "parser-symbol", "white-space", ":=", "white-space", "parser");
        new DelimiterRepetitionParser(this, "parser-set", "parser-definition", "semicolon", 1);
        new SequenceParser(this, "parser-parser", "parser-set", "eof");
        try {
            this.create("number := ('+' | '-')? + integer.");
            this.create("float := ('+' | '-')? + integer + '.' + integer?.");
            this.create("qualifier := symbol #1 '.'.");
            this.create("code-space := white-space #0 comment-string.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Parsers(HashMap<String, Parser> parsers) {
        this.parsers = parsers;
    }

    public static Parsers getGlobal() {
        return global;
    }

    public long getCount() {
        return this.count;
    }

    public long getHit() {
        return this.hit;
    }

    public void resetCount() {
        this.hit = 0L;
        this.count = 0L;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Parsers clone() {
        return new Parsers(new HashMap<String, Parser>(this.parsers));
    }

    public void put(Parser parser) {
        this.parsers.put(parser.name(), parser);
    }

    public Parser get(String name) {
        Parser parser = this.parsers.get(name);
        if (parser == null) {
            parser = new StringParser(this, name);
        }
        return parser;
    }

    public void remove(String name) {
        this.parsers.remove(name);
    }

    public Parser create(String metaExpression) throws ParseException {
        Scanner scanner = new Scanner(metaExpression);
        Parser parser = this.get("parser-parser");
        ParseNode tree = parser.parse(scanner);
        if (tree == null) {
            throw new ParseException(scanner.error());
        }
        return this.get(this.compile(tree));
    }

    public ParseNode parse(String parser, String input) throws ParseException {
        Scanner scanner = new Scanner(input);
        ParseNode node = this.parse(parser, scanner);
        if (node == null) {
            throw new ParseException(scanner.error());
        }
        return node;
    }

    public ParseNode parse(String parser, Scanner scanner) {
        ++this.count;
        if (useCache && scanner.cacheContains(parser)) {
            ++this.hit;
            ParseNode node = scanner.cacheGet(parser);
            if (this.debug) {
                System.out.println(this.indent(this.depth) + parser + ":" + scanner.position + " <cache " + (node == null ? "false" : "true") + ">");
            }
            if (node != null) {
                scanner.position += node.length;
            }
            return node;
        }
        if (this.debug) {
            System.out.println(this.indent(this.depth) + parser + ":" + scanner.position);
        }
        int startPosition = scanner.position;
        if (this.debug) {
            ++this.depth;
        }
        if (useCache) {
            scanner.cachePut(parser, startPosition, null);
        }
        Parser p = this.get(parser);
        ParseNode node = p.parse(scanner);
        if (useCache) {
            scanner.cachePut(parser, startPosition, node);
        }
        if (this.debug) {
            --this.depth;
        }
        return node;
    }

    public String compile(ParseNode node) {
        String name = node.parser().name();
        if (name.equals("parser-quote") || name.equals("parser-apos") || name.equals("quote-string") || name.equals("apos-string") || name.equals("parse-literal")) {
            return this.compile(((NonTerminal)node).get(1));
        }
        if (name.equals("choice-expression") || name.equals("sequence-expression") || name.equals("repetition-expression")) {
            return this.compile(((NonTerminal)node).get(2));
        }
        if (name.equals("terminal-parser-expression")) {
            return this.compileTerminalParserExpression((NonTerminal)node);
        }
        if (name.equals("quote-literal") || name.equals("apos-literal")) {
            return this.compileLiteral((Terminal)node);
        }
        if (name.equals("parser-set")) {
            return this.compileParserSet((NonTerminal)node);
        }
        if (name.equals("parser-definition")) {
            return this.compileParserDefinition((NonTerminal)node);
        }
        if (name.equals("choice-parser")) {
            return this.compileChoiceParser((NonTerminal)node);
        }
        if (name.equals("sequence-parser")) {
            return this.compileSequenceParser((NonTerminal)node);
        }
        if (name.equals("optional-parser")) {
            return this.compileOptionalParser((NonTerminal)node);
        }
        if (name.equals("simple-repetition-parser")) {
            return this.compileRepetitionParser((NonTerminal)node);
        }
        if (name.equals("delimiter-repetition-parser")) {
            return this.compileDelimiterRepetitionParser((NonTerminal)node);
        }
        if (name.equals("parser-symbol")) {
            return Parsers.parseSymbol((NonTerminal)node);
        }
        return this.compile(((NonTerminal)node).get(0));
    }

    public String compileParserSet(NonTerminal node) {
        String[] list = new String[node.count()];
        for (int i = 0; i < node.count(); i += 2) {
            list[i] = this.compile(node.get(i));
        }
        return list[0];
    }

    public String compileParserDefinition(NonTerminal node) {
        String name = Parsers.parseSymbol((NonTerminal)node.get(0));
        String child = this.compile(node.get(4));
        if (child.charAt(0) != '_') {
            name = new IdentityParser(this, name, child).name();
        } else {
            this.get(child).rename(name);
        }
        return name;
    }

    public String compileLiteral(Terminal node) {
        return this.get(node.value()).name();
    }

    public static String parseSymbol(NonTerminal node) {
        Terminal symbol = (Terminal)node.get(1);
        return symbol.value();
    }

    public String compileChoiceParser(NonTerminal parser) {
        String[] list = new String[parser.count() + 1 >> 1];
        for (int i = 0; i < parser.count(); i += 2) {
            list[i >> 1] = this.compile(parser.get(i));
        }
        return new ChoiceParser(this, Parser.generateId(), list).name();
    }

    public String compileSequenceParser(NonTerminal parser) {
        String[] list = new String[parser.count() + 1 >> 1];
        for (int i = 0; i < parser.count(); i += 2) {
            list[i >> 1] = this.compile(parser.get(i));
        }
        return new SequenceParser(this, Parser.generateId(), list).name();
    }

    public String compileOptionalParser(NonTerminal parser) {
        String argument = this.compile(parser.get(0));
        return new OptionalParser(this, Parser.generateId(), argument).name();
    }

    public String compileRepetitionParser(NonTerminal parser) {
        String argument = this.compile(parser.get(0));
        return new RepetitionParser(this, Parser.generateId(), argument).name();
    }

    public String compileDelimiterRepetitionParser(NonTerminal parser) {
        String repetition = this.compile(parser.get(0));
        int minRepeat = Integer.parseInt(((Terminal)parser.get(3)).value());
        String delimiter = this.compile(parser.get(4));
        return new DelimiterRepetitionParser(this, Parser.generateId(), repetition, delimiter, minRepeat).name();
    }

    public String compileTerminalParserExpression(NonTerminal parser) {
        String terminal = this.compile(parser.get(0));
        return new TerminalParser(this, Parser.generateId(), terminal).name();
    }

    public String indent(int size) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            buffer.append("| ");
        }
        return buffer.toString();
    }
}

