/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose;

import com.inventiosystems.docker_compose.HasCommand;
import com.inventiosystems.docker_compose.down.DockerComposeDown;
import com.inventiosystems.docker_compose.options.DockerComposeOptions;
import com.inventiosystems.docker_compose.rm.DockerComposeRemove;
import com.inventiosystems.docker_compose.start.DockerComposeStart;
import com.inventiosystems.docker_compose.stop.DockerComposeStop;
import com.inventiosystems.docker_compose.up.DockerComposeUp;

public class DockerComposeClient
implements HasCommand {
    private static final String COMMAND = "docker-compose";
    private static final String FILE = " --file %s";
    private static final String HELP = " --help";
    private static final String VERSION = " --version";
    private String currentCommand = "docker-compose";

    public DockerComposeClient file(String fileName) {
        this.currentCommand = this.currentCommand + String.format(FILE, fileName);
        return this;
    }

    public String help() {
        return "docker-compose --help";
    }

    public String version() {
        return "docker-compose --version";
    }

    public DockerComposeOptions projectName(String projectName) {
        return new DockerComposeOptions(this.currentCommand).projectName(projectName);
    }

    public DockerComposeOptions verbose() {
        return new DockerComposeOptions(this.currentCommand).verbose();
    }

    public DockerComposeOptions compatibility() {
        return new DockerComposeOptions(this.currentCommand).compatibility();
    }

    public DockerComposeDown down() {
        return new DockerComposeDown(this.currentCommand);
    }

    public DockerComposeRemove remove() {
        return new DockerComposeRemove(this.currentCommand);
    }

    public DockerComposeStart start() {
        return new DockerComposeStart(this.currentCommand);
    }

    public DockerComposeStop stop() {
        return new DockerComposeStop(this.currentCommand);
    }

    public DockerComposeUp up() {
        return new DockerComposeUp(this.currentCommand);
    }

    @Override
    public String command() {
        return this.currentCommand;
    }
}

