/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose;

import com.inventiosystems.docker_compose.HasCommand;
import java.io.File;
import java.io.IOException;

public class DockerComposeDriver {
    private File workingDirectory;

    public DockerComposeDriver initialize() {
        return this;
    }

    public DockerComposeDriver initialize(File directory) {
        this.workingDirectory = directory;
        return this.initialize();
    }

    public int execute(HasCommand commandProvider) {
        String command = commandProvider.command();
        return this.execute(command);
    }

    public int execute(String command) {
        ProcessBuilder processBuilder = DockerComposeDriver.isWindows() ? new ProcessBuilder("cmd.exe", "/c") : new ProcessBuilder("bash", "-c");
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
        }
        System.out.println(command);
        processBuilder.command().add(command);
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            return process.waitFor();
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }
}

