/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.common;

import com.inventiosystems.docker_compose.schema.common.Compose;
import com.inventiosystems.docker_compose.schema.common.Service;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;

public class ComposeGraphHelper {
    public static Map<Integer, Map<String, Service>> calculateServiceGraph(Compose compose) {
        if (Objects.isNull(compose)) {
            return new HashMap<Integer, Map<String, Service>>();
        }
        if (!compose.getServices().isPresent()) {
            return new HashMap<Integer, Map<String, Service>>();
        }
        Map<String, Service> stringServiceMap = compose.getServices().get();
        DirectedAcyclicGraph serviceGraph = new DirectedAcyclicGraph(DefaultEdge.class);
        stringServiceMap.keySet().forEach(arg_0 -> ((DirectedAcyclicGraph)serviceGraph).addVertex(arg_0));
        stringServiceMap.entrySet().forEach(service -> ((Service)service.getValue()).getDependsOn().ifPresent(strings -> strings.forEach(dependentsName -> serviceGraph.addEdge((Object)((String)service.getKey()), dependentsName))));
        int groupCount = 0;
        HashMap<Integer, Map<String, Service>> orderedServiceMap = new HashMap<Integer, Map<String, Service>>();
        for (String serviceName : serviceGraph) {
            Service currentService = stringServiceMap.get(serviceName);
            HashMap<String, Service> services = (HashMap<String, Service>)orderedServiceMap.get(groupCount);
            if (currentService.getDependsOn().isPresent() && CollectionUtils.isNotEmpty((Collection)currentService.getDependsOn().get())) {
                if (MapUtils.isEmpty(services)) {
                    services = new HashMap();
                }
                if (Objects.nonNull(services.get(serviceName))) {
                    ++groupCount;
                    services = new HashMap();
                }
                services.put(serviceName, currentService);
                orderedServiceMap.put(groupCount, services);
                continue;
            }
            if (MapUtils.isEmpty((Map)services)) {
                services = new HashMap<String, Service>();
            }
            services.put(serviceName, currentService);
            orderedServiceMap.put(groupCount, services);
        }
        return orderedServiceMap;
    }
}

