/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.options;

import com.inventiosystems.docker_compose.down.DockerComposeDown;
import com.inventiosystems.docker_compose.start.DockerComposeStart;
import com.inventiosystems.docker_compose.stop.DockerComposeStop;
import com.inventiosystems.docker_compose.up.DockerComposeUp;

public class DockerComposeOptions {
    private static final String COMPATIBILITY = " --compatibility";
    private static final String PROJECT_NAME = "--project-name %s";
    private static final String VERBOSE = " --verbose";
    private String currentCommand;

    public DockerComposeOptions(String existingCommand) {
        this.currentCommand = existingCommand;
    }

    public DockerComposeOptions projectName(String projectName) {
        this.currentCommand = this.currentCommand + String.format(PROJECT_NAME, projectName);
        return this;
    }

    public DockerComposeOptions verbose() {
        this.currentCommand = this.currentCommand + VERBOSE;
        return this;
    }

    public DockerComposeOptions compatibility() {
        this.currentCommand = this.currentCommand + COMPATIBILITY;
        return this;
    }

    public DockerComposeDown down() {
        return new DockerComposeDown(this.currentCommand);
    }

    public DockerComposeStart start() {
        return new DockerComposeStart(this.currentCommand);
    }

    public DockerComposeStop stop() {
        return new DockerComposeStop(this.currentCommand);
    }

    public DockerComposeUp up() {
        return new DockerComposeUp(this.currentCommand);
    }
}

