/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.schema.v3_7;

import com.inventiosystems.docker_compose.schema.common.Compose;
import com.inventiosystems.docker_compose.schema.common.Image;
import com.inventiosystems.docker_compose.schema.common.Port;
import com.inventiosystems.docker_compose.schema.common.Service;
import com.inventiosystems.docker_compose.schema.v3_7.Compose37;
import com.inventiosystems.docker_compose.schema.v3_7.Service37;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DockerComposeTransformer {
    public static Compose transform(Compose37 composeV37) {
        Map<String, Service> services = DockerComposeTransformer.transformComposeV37Service(composeV37.getServices());
        return new Compose(composeV37.getVersion(), services);
    }

    private static Map<String, Service> transformComposeV37Service(Map<String, Service37> services) {
        return services.entrySet().stream().map(entry -> {
            Service37 service37 = (Service37)entry.getValue();
            Image image = DockerComposeTransformer.extractImage(service37.getImage());
            List<Port> ports = DockerComposeTransformer.extractPorts(service37.getPorts());
            List<String> dependsOn = DockerComposeTransformer.extractDependsOn(service37.getDepends_on());
            Service right = new Service(image, ports, dependsOn);
            return ImmutablePair.of((Object)((String)entry.getKey()), (Object)right);
        }).collect(HashMap::new, (map, pair) -> map.put((String)pair.getKey(), (Service)pair.getValue()), Map::putAll);
    }

    private static List<String> extractDependsOn(List<String> depends_on) {
        if (CollectionUtils.isEmpty(depends_on)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(depends_on);
    }

    private static List<Port> extractPorts(List<String> ports) {
        if (CollectionUtils.isEmpty(ports)) {
            return Collections.emptyList();
        }
        return ports.stream().map(DockerComposeTransformer::extractPort).collect(Collectors.toList());
    }

    private static Port extractPort(String portString) {
        if (StringUtils.isBlank((CharSequence)portString)) {
            throw new IllegalArgumentException("The port string may not be blank");
        }
        List<String> strings = Arrays.asList(portString.split(":"));
        if (CollectionUtils.isEmpty(strings)) {
            throw new IllegalArgumentException("Could not extract any ports");
        }
        String source = strings.get(0);
        String target = strings.size() > 1 ? strings.get(1) : "";
        return new Port(source, target);
    }

    private static Image extractImage(String image) {
        List<String> strings = Arrays.asList(image.split(":"));
        if (CollectionUtils.isEmpty(strings)) {
            throw new IllegalStateException("Could not extract version");
        }
        return new Image(strings.get(0), strings.get(1));
    }
}

