/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.start;

import com.inventiosystems.docker_compose.HasCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DockerComposeStart {
    private static final String COMMAND = "start";
    private static final String HELP = "--help";
    private String currentCommand;

    public DockerComposeStart(String existingCommand) {
        this.currentCommand = existingCommand + " " + COMMAND;
    }

    public DockerComposeStartServices withService(String serviceName) {
        return new DockerComposeStartServices(this.currentCommand).withServices(serviceName);
    }

    public DockerComposeStartServices withServices(String ... serviceNames) {
        return new DockerComposeStartServices(this.currentCommand).withServices(serviceNames);
    }

    public DockerComposeStartServices withServices(Set<String> serviceNames) {
        return new DockerComposeStartServices(this.currentCommand).withServices(serviceNames);
    }

    public String help() {
        this.currentCommand = this.currentCommand + " " + HELP;
        return this.currentCommand;
    }

    public class DockerComposeStartServices
    implements HasCommand {
        private final String currentCommand;
        private final Set<String> services;

        public DockerComposeStartServices(String currentCommand) {
            this.currentCommand = currentCommand;
            this.services = new HashSet<String>();
        }

        public DockerComposeStartServices withServices(String ... services) {
            this.services.addAll(new HashSet<String>(Arrays.asList(services)));
            return this;
        }

        public DockerComposeStartServices withServices(Set<String> services) {
            this.services.addAll(services);
            return this;
        }

        @Override
        public String command() {
            String finalCommand = this.currentCommand;
            if (!this.services.isEmpty()) {
                for (String serviceName : this.services) {
                    finalCommand = finalCommand + " " + serviceName;
                }
            }
            return finalCommand;
        }
    }
}

