/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.stop;

import com.inventiosystems.docker_compose.HasCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DockerComposeStop
implements HasCommand {
    private static final String COMMAND = "stop";
    private final Set<String> services = new HashSet<String>();
    private String currentCommand;

    public DockerComposeStop(String existingCommand) {
        this.currentCommand = existingCommand + " " + COMMAND;
    }

    public DockerComposeStop withService(String serviceName) {
        this.services.add(serviceName);
        return this;
    }

    public DockerComposeStop withServices(String ... serviceNames) {
        this.services.addAll(new HashSet<String>(Arrays.asList(serviceNames)));
        return this;
    }

    public DockerComposeStop withServices(Set<String> serviceNames) {
        this.services.addAll(serviceNames);
        return this;
    }

    @Override
    public String command() {
        String finalCommand = this.currentCommand;
        if (!this.services.isEmpty()) {
            for (String serviceName : this.services) {
                finalCommand = finalCommand + " " + serviceName;
            }
        }
        return finalCommand;
    }
}

