/*
 * Decompiled with CFR 0.152.
 */
package com.inventiosystems.docker_compose.up;

import com.inventiosystems.docker_compose.HasCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DockerComposeUp
implements HasCommand {
    private static final String COMMAND = "up";
    private static final String DETACH = " --detach";
    private final Set<String> services = new HashSet<String>();
    private String currentCommand;

    public DockerComposeUp(String existingCommand) {
        this.currentCommand = existingCommand + " " + COMMAND;
    }

    public DockerComposeUp detach() {
        this.currentCommand = this.currentCommand + DETACH;
        return this;
    }

    public DockerComposeUp withService(String serviceName) {
        this.services.add(serviceName);
        return this;
    }

    public DockerComposeUp withServices(String ... serviceNames) {
        this.services.addAll(new HashSet<String>(Arrays.asList(serviceNames)));
        return this;
    }

    public DockerComposeUp withServices(Set<String> serviceNames) {
        this.services.addAll(serviceNames);
        return this;
    }

    @Override
    public String command() {
        String finalCommand = this.currentCommand;
        if (!this.services.isEmpty()) {
            for (String serviceName : this.services) {
                finalCommand = finalCommand + " " + serviceName;
            }
        }
        return finalCommand;
    }
}

