/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client;

import com.jacobmountain.graphql.client.FileWriter;
import com.jacobmountain.graphql.client.PojoBuilder;
import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.jacobmountain.graphql.client.visitor.MethodDetailsVisitor;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.NamedNode;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTOGenerator {
    private static final Logger log = LoggerFactory.getLogger(DTOGenerator.class);
    private final FileWriter filer;
    private final TypeMapper typeMapper;
    private final Map<String, PojoBuilder> types = new HashMap<String, PojoBuilder>();
    private final String packageName;

    public DTOGenerator(String packageName, FileWriter filer, TypeMapper typeMapper) {
        this.packageName = packageName;
        this.filer = filer;
        this.typeMapper = typeMapper;
    }

    public void generate(Collection<TypeDefinition> types) {
        types.forEach(this::generateDTO);
        this.types.values().forEach(this.filer::write);
    }

    public void generateArgumentDTOs(Element client) {
        client.getEnclosedElements().stream().map(method -> method.accept(new MethodDetailsVisitor(null), this.typeMapper)).filter(MethodDetails::hasParameters).map(details -> {
            String name = details.getArgumentClassname();
            PojoBuilder builder = PojoBuilder.newType(name, this.packageName);
            details.getParameters().forEach(variable -> {
                String field = variable.getName();
                if (variable.getAnnotation() != null) {
                    field = variable.getAnnotation().value();
                }
                builder.withField(variable.getType(), field);
            });
            return builder;
        }).filter(this.detectArgumentNameCollisions()).peek(PojoBuilder::finalise).forEach(this.filer::write);
    }

    private Predicate<PojoBuilder> detectArgumentNameCollisions() {
        HashSet names = new HashSet();
        return builder -> {
            boolean collision;
            String fqdn = builder.getFQDN();
            boolean bl = collision = !names.add(fqdn);
            if (collision) {
                log.error("Argument class name collision detected: {}", (Object)fqdn);
            }
            return !collision;
        };
    }

    private void generateDTO(TypeDefinition<?> td) {
        PojoBuilder pojo = this.builder(td);
        if (pojo == null) {
            return;
        }
        td.getChildren().stream().filter(it -> it instanceof NamedNode).filter(it -> !((NamedNode)it).getName().startsWith("_")).forEach(it -> {
            if (it instanceof FieldDefinition) {
                FieldDefinition named = (FieldDefinition)it;
                pojo.withField(this.typeMapper.getType(named.getType()), named.getName());
            }
        });
        if (td instanceof InputObjectTypeDefinition) {
            InputObjectTypeDefinition inputObjectTypeDefinition = (InputObjectTypeDefinition)td;
            inputObjectTypeDefinition.getInputValueDefinitions().forEach(it -> pojo.withField(this.typeMapper.getType(it.getType()), it.getName()));
        } else if (td instanceof EnumTypeDefinition) {
            EnumTypeDefinition enumTypeDefinition = (EnumTypeDefinition)td;
            enumTypeDefinition.getEnumValueDefinitions().forEach(pojo::withEnumValue);
        }
        this.types.put(td.getName(), pojo);
        pojo.finalise();
    }

    private PojoBuilder builder(TypeDefinition<?> td) {
        if (td instanceof InterfaceTypeDefinition) {
            return PojoBuilder.newInterface(td.getName(), this.packageName);
        }
        if (td instanceof ObjectTypeDefinition) {
            PojoBuilder builder = PojoBuilder.newType(td.getName(), this.packageName);
            ObjectTypeDefinition otd = (ObjectTypeDefinition)td;
            otd.getImplements().forEach(supertype -> {
                builder.implement(((TypeName)supertype).getName());
                this.types.get(((NamedNode)supertype).getName()).withSubType(td.getName());
            });
            return builder;
        }
        if (td instanceof InputObjectTypeDefinition) {
            return PojoBuilder.newInput(td.getName(), this.packageName);
        }
        if (td instanceof EnumTypeDefinition) {
            return PojoBuilder.newEnum(td.getName(), this.packageName);
        }
        if (td instanceof UnionTypeDefinition) {
            UnionTypeDefinition utd = (UnionTypeDefinition)td;
            PojoBuilder builder = PojoBuilder.newUnion(td.getName(), this.packageName);
            utd.getMemberTypes().forEach(supertype -> {
                String member = ((TypeName)supertype).getName();
                builder.withSubType(member);
                this.types.get(member).implement(td.getName());
            });
            return builder;
        }
        log.info("{}", td);
        log.info("Unexpected type definition {}", td.getClass());
        return null;
    }
}

