/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.utils;

import com.jacobmountain.graphql.client.exceptions.QueryTypeNotFoundException;
import graphql.GraphQLError;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final TypeDefinitionRegistry registry;
    private final ObjectTypeDefinition query;
    private final ObjectTypeDefinition mutation;
    private final ObjectTypeDefinition subscription;

    public Schema(File file) {
        this(new SchemaParser().parse(file));
    }

    public Schema(String gql) {
        this(new SchemaParser().parse(gql));
    }

    private Schema(TypeDefinitionRegistry registry) {
        this.registry = registry;
        this.query = this.getSchemaDefinition("query").orElseThrow(QueryTypeNotFoundException::new);
        this.mutation = this.getSchemaDefinition("mutation").orElse(null);
        this.subscription = this.getSchemaDefinition("subscription").orElse(null);
    }

    private Optional<ObjectTypeDefinition> getSchemaDefinition(String name) {
        return ((SchemaDefinition)this.registry.schemaDefinition().get()).getOperationTypeDefinitions().stream().filter(it -> name.equals(it.getName())).findFirst().flatMap(it -> this.getTypeDefinition(it.getTypeName().getName())).map(it -> (ObjectTypeDefinition)it);
    }

    public Optional<TypeDefinition> getTypeDefinition(String name) {
        return this.registry.getType(name);
    }

    public Optional<FieldDefinition> findField(String field) {
        return this.optionals(this.findField(this.query, field), () -> this.findField(this.mutation, field), () -> this.findField(this.subscription, field));
    }

    @SafeVarargs
    private final <T> Optional<T> optionals(Optional<T> first, Supplier<Optional<T>> ... later) {
        if (first.isPresent()) {
            return first;
        }
        if (later.length == 0) {
            return Optional.empty();
        }
        Optional<T> head = later[0].get();
        return this.optionals(head, Arrays.copyOfRange(later, 1, later.length));
    }

    public Optional<FieldDefinition> findField(ObjectTypeDefinition parent, String field) {
        return Optional.ofNullable(parent).map(ObjectTypeDefinition::getFieldDefinitions).orElseGet(ArrayList::new).stream().filter(it -> it.getName().equals(field)).findAny();
    }

    public Optional<FieldDefinition> findField(InterfaceTypeDefinition parent, String field) {
        return parent.getFieldDefinitions().stream().filter(it -> it.getName().equals(field)).findAny();
    }

    public String getQueryTypeName() {
        return this.query.getName();
    }

    public Optional<String> getMutationTypeName() {
        return Optional.ofNullable(this.mutation).map(ObjectTypeDefinition::getName);
    }

    public Optional<String> getSubscriptionTypeName() {
        return Optional.ofNullable(this.subscription).map(ObjectTypeDefinition::getName);
    }

    public Stream<String> getTypesImplementing(TypeDefinition<?> typeDefinition) {
        if (!(typeDefinition instanceof InterfaceTypeDefinition)) {
            return Stream.empty();
        }
        return this.types().values().stream().filter(it -> it instanceof ObjectTypeDefinition).map(it -> (ObjectTypeDefinition)it).filter(it -> it.getImplements().stream().anyMatch(ty -> ((TypeName)ty).getName().equals(typeDefinition.getName()))).map(impl -> impl.getName());
    }

    public ObjectTypeDefinition getQuery() {
        return this.query;
    }

    public ObjectTypeDefinition getMutation() {
        return this.mutation;
    }

    public ObjectTypeDefinition getSubscription() {
        return this.subscription;
    }

    public TypeDefinitionRegistry merge(TypeDefinitionRegistry typeRegistry) throws SchemaProblem {
        return this.registry.merge(typeRegistry);
    }

    public Optional<GraphQLError> addAll(Collection<SDLDefinition> definitions) {
        return this.registry.addAll(definitions);
    }

    public Optional<GraphQLError> add(SDLDefinition definition) {
        return this.registry.add(definition);
    }

    public void remove(SDLDefinition definition) {
        this.registry.remove(definition);
    }

    public void remove(String key, SDLDefinition definition) {
        this.registry.remove(key, definition);
    }

    public Map<String, TypeDefinition> types() {
        return this.registry.types();
    }

    public Map<String, ScalarTypeDefinition> scalars() {
        return this.registry.scalars();
    }

    public Map<String, List<ObjectTypeExtensionDefinition>> objectTypeExtensions() {
        return this.registry.objectTypeExtensions();
    }

    public Map<String, List<InterfaceTypeExtensionDefinition>> interfaceTypeExtensions() {
        return this.registry.interfaceTypeExtensions();
    }

    public Map<String, List<UnionTypeExtensionDefinition>> unionTypeExtensions() {
        return this.registry.unionTypeExtensions();
    }

    public Map<String, List<EnumTypeExtensionDefinition>> enumTypeExtensions() {
        return this.registry.enumTypeExtensions();
    }

    public Map<String, List<ScalarTypeExtensionDefinition>> scalarTypeExtensions() {
        return this.registry.scalarTypeExtensions();
    }

    public Map<String, List<InputObjectTypeExtensionDefinition>> inputObjectTypeExtensions() {
        return this.registry.inputObjectTypeExtensions();
    }

    public Optional<SchemaDefinition> schemaDefinition() {
        return this.registry.schemaDefinition();
    }

    public List<SchemaExtensionDefinition> getSchemaExtensionDefinitions() {
        return this.registry.getSchemaExtensionDefinitions();
    }

    public Optional<DirectiveDefinition> getDirectiveDefinition(String directiveName) {
        return this.registry.getDirectiveDefinition(directiveName);
    }

    public Map<String, DirectiveDefinition> getDirectiveDefinitions() {
        return this.registry.getDirectiveDefinitions();
    }

    public boolean hasType(TypeName typeName) {
        return this.registry.hasType(typeName);
    }

    public Optional<TypeDefinition> getType(Type type) {
        return this.registry.getType(type);
    }

    public <T extends TypeDefinition> Optional<T> getType(Type type, Class<T> ofType) {
        return this.registry.getType(type, ofType);
    }

    public Optional<TypeDefinition> getType(String typeName) {
        return this.registry.getType(typeName);
    }

    public <T extends TypeDefinition> Optional<T> getType(String typeName, Class<T> ofType) {
        return this.registry.getType(typeName, ofType);
    }

    public boolean isInterfaceOrUnion(Type type) {
        return this.registry.isInterfaceOrUnion(type);
    }

    public boolean isObjectType(Type type) {
        return this.registry.isObjectType(type);
    }

    public <T extends TypeDefinition> List<T> getTypes(Class<T> targetClass) {
        return this.registry.getTypes(targetClass);
    }

    public <T extends TypeDefinition> Map<String, T> getTypesMap(Class<T> targetClass) {
        return this.registry.getTypesMap(targetClass);
    }

    public List<ImplementingTypeDefinition> getAllImplementationsOf(InterfaceTypeDefinition targetInterface) {
        return this.registry.getAllImplementationsOf(targetInterface);
    }

    public List<ObjectTypeDefinition> getImplementationsOf(InterfaceTypeDefinition targetInterface) {
        return this.registry.getImplementationsOf(targetInterface);
    }

    public boolean isPossibleType(Type abstractType, Type possibleObjectType) {
        return this.registry.isPossibleType(abstractType, possibleObjectType);
    }

    public boolean isSubTypeOf(Type maybeSubType, Type superType) {
        return this.registry.isSubTypeOf(maybeSubType, superType);
    }
}

