/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.visitor;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.annotations.GraphQLArgument;
import com.jacobmountain.graphql.client.annotations.GraphQLMutation;
import com.jacobmountain.graphql.client.annotations.GraphQLQuery;
import com.jacobmountain.graphql.client.annotations.GraphQLSubscription;
import com.jacobmountain.graphql.client.exceptions.MissingAnnotationException;
import com.jacobmountain.graphql.client.utils.OptionalUtils;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.jacobmountain.graphql.client.visitor.Parameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.NonNullType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDetailsVisitor
extends ElementKindVisitor8<MethodDetails, TypeMapper> {
    private static final Logger log = LoggerFactory.getLogger(MethodDetailsVisitor.class);
    private final Schema schema;

    public MethodDetailsVisitor(Schema registry) {
        this.schema = registry;
    }

    @Override
    public MethodDetails visitExecutableAsMethod(ExecutableElement e, TypeMapper typeMapper) {
        return OptionalUtils.first(this.getQueryDetails(e, typeMapper), () -> this.getMutationDetails(e, typeMapper), () -> this.getSubscriptionDetails(e, typeMapper)).orElseThrow(() -> new MissingAnnotationException("@GraphQLClient methods require @GraphQLQuery, @GraphQLMutation, or @GraphQLSubscription annotations"));
    }

    private Optional<MethodDetails> getQueryDetails(ExecutableElement e, TypeMapper typeMapper) {
        return Optional.ofNullable(e.getAnnotation(GraphQLQuery.class)).map(annotation -> MethodDetails.builder().methodName(e.getSimpleName().toString()).requestName(annotation.name()).returnType(typeMapper.defaultPackage(TypeName.get((TypeMirror)e.getReturnType()))).field(annotation.value()).mutation(false).subscription(false).parameters(this.getParameters(e, typeMapper, annotation.value())).build());
    }

    private Optional<MethodDetails> getMutationDetails(ExecutableElement e, TypeMapper typeMapper) {
        return Optional.ofNullable(e.getAnnotation(GraphQLMutation.class)).map(annotation -> MethodDetails.builder().methodName(e.getSimpleName().toString()).requestName(annotation.name()).returnType(typeMapper.defaultPackage(TypeName.get((TypeMirror)e.getReturnType()))).field(annotation.value()).mutation(true).subscription(false).parameters(this.getParameters(e, typeMapper, annotation.value())).build());
    }

    private Optional<MethodDetails> getSubscriptionDetails(ExecutableElement e, TypeMapper typeMapper) {
        return Optional.ofNullable(e.getAnnotation(GraphQLSubscription.class)).map(annotation -> MethodDetails.builder().methodName(e.getSimpleName().toString()).requestName(annotation.name()).returnType(typeMapper.defaultPackage(TypeName.get((TypeMirror)e.getReturnType()))).field(annotation.value()).mutation(false).subscription(true).parameters(this.getParameters(e, typeMapper, annotation.value())).build());
    }

    private List<Parameter> getParameters(ExecutableElement e, TypeMapper typeMapper, String root) {
        return e.getParameters().stream().map(parameter -> {
            String className = parameter.getSimpleName().toString();
            return Parameter.builder().type(typeMapper.defaultPackage(ClassName.get((TypeMirror)parameter.asType()))).name(className).annotation(parameter.getAnnotation(GraphQLArgument.class)).nullable(this.isNullableArg(root, className)).build();
        }).collect(Collectors.toList());
    }

    private boolean isNullableArg(String field, String arg) {
        if (this.schema == null) {
            return true;
        }
        Optional<FieldDefinition> type = this.schema.findField(field);
        if (!type.isPresent()) {
            return true;
        }
        InputValueDefinition definition = type.get().getInputValueDefinitions().stream().filter(it -> StringUtils.equals(it.getName(), arg)).findFirst().orElse(null);
        return definition == null || !definition.getType().getClass().equals(NonNullType.class);
    }
}

