/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client;

import com.jacobmountain.graphql.client.annotations.GraphQLClient;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger log = LoggerFactory.getLogger(TypeMapper.class);
    private static final Map<String, com.squareup.javapoet.TypeName> SCALARS = new HashMap<String, com.squareup.javapoet.TypeName>();
    private final Map<String, com.squareup.javapoet.TypeName> scalars;
    private final String packageName;

    public TypeMapper(String packageName, GraphQLClient.Scalar ... scalars) {
        Map<String, com.squareup.javapoet.TypeName> scalarMap = Stream.of(scalars).collect(Collectors.toMap(GraphQLClient.Scalar::from, TypeMapper::getTypeName));
        this.scalars = new HashMap<String, com.squareup.javapoet.TypeName>(SCALARS);
        this.scalars.putAll(scalarMap);
        this.packageName = packageName;
    }

    private static com.squareup.javapoet.TypeName getTypeName(GraphQLClient.Scalar annotation) {
        try {
            return ClassName.get((Class)annotation.to());
        }
        catch (MirroredTypeException mte) {
            return ClassName.get((TypeMirror)mte.getTypeMirror());
        }
    }

    public com.squareup.javapoet.TypeName getType(Type<?> type) {
        if (type instanceof ListType) {
            String unwrapped = TypeMapper.unwrap(type);
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (com.squareup.javapoet.TypeName[])new com.squareup.javapoet.TypeName[]{this.getType(unwrapped)});
        }
        if (type instanceof NonNullType) {
            return this.getType(((NonNullType)type).getType());
        }
        String unwrapped = TypeMapper.unwrap(type);
        return this.getType(unwrapped);
    }

    public com.squareup.javapoet.TypeName defaultPackage(com.squareup.javapoet.TypeName typeName) {
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            if (StringUtils.isEmpty(className.packageName())) {
                return ClassName.get((String)this.packageName, (String)className.simpleName(), (String[])new String[0]);
            }
        } else if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedType = (ParameterizedTypeName)typeName;
            return ParameterizedTypeName.get((ClassName)((ClassName)this.defaultPackage((com.squareup.javapoet.TypeName)parameterizedType.rawType)), (com.squareup.javapoet.TypeName[])((com.squareup.javapoet.TypeName[])parameterizedType.typeArguments.stream().map(this::defaultPackage).toArray(com.squareup.javapoet.TypeName[]::new)));
        }
        return typeName;
    }

    public com.squareup.javapoet.TypeName getType(String name) {
        return this.scalars.getOrDefault(name, (com.squareup.javapoet.TypeName)ClassName.get((String)this.packageName, (String)name, (String[])new String[0]));
    }

    public static String unwrap(Type<?> type) {
        if (type instanceof ListType) {
            return TypeMapper.unwrap(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return TypeMapper.unwrap(((NonNullType)type).getType());
        }
        return ((TypeName)type).getName();
    }

    static {
        SCALARS.put("Int", com.squareup.javapoet.TypeName.INT.box());
        SCALARS.put("int", com.squareup.javapoet.TypeName.INT);
        SCALARS.put("ID", com.squareup.javapoet.TypeName.INT.box());
        SCALARS.put("String", (com.squareup.javapoet.TypeName)ClassName.get(String.class));
        SCALARS.put("BigDecimal", (com.squareup.javapoet.TypeName)ClassName.get(BigDecimal.class));
    }
}

