/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.query;

import com.jacobmountain.graphql.client.annotations.GraphQLField;
import com.jacobmountain.graphql.client.exceptions.FieldNotFoundException;
import com.jacobmountain.graphql.client.query.FieldFilter;
import com.jacobmountain.graphql.client.query.QueryContext;
import com.jacobmountain.graphql.client.query.filters.AllNonNullArgsFieldFilter;
import com.jacobmountain.graphql.client.query.filters.MaxDepthFieldFilter;
import com.jacobmountain.graphql.client.query.filters.SelectionFieldFilter;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import graphql.com.google.common.collect.Streams;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    private final Schema schema;

    public QueryGenerator(Schema registry) {
        this.schema = registry;
    }

    public QueryBuilder query() {
        return new QueryBuilder("query");
    }

    public QueryBuilder mutation() {
        return new QueryBuilder("mutation");
    }

    public QueryBuilder subscription() {
        return new QueryBuilder("subscription");
    }

    private String doGenerateQuery(String request, String field, String type, Set<String> params, List<FieldFilter> filters) {
        FieldDefinition definition = this.schema.findField(field).orElseThrow(FieldNotFoundException.create(field));
        HashSet<String> args = new HashSet<String>();
        String inner = this.generateQueryRec(field, new QueryContext(1, definition, params, new HashSet<String>()), args, filters).orElseThrow(RuntimeException::new);
        String collect = String.join((CharSequence)", ", args);
        if (!args.isEmpty()) {
            collect = "(" + collect + ")";
        }
        return this.generateQueryName(request, type, field) + collect + " { " + inner + " } ";
    }

    private String unwrap(Type<?> type) {
        if (type instanceof ListType) {
            return this.unwrap(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.unwrap(((NonNullType)type).getType());
        }
        return ((TypeName)type).getName();
    }

    private String generateQueryName(String request, String type, String field) {
        if (StringUtils.isEmpty(request)) {
            request = StringUtils.capitalize(field);
        }
        return type + " " + request;
    }

    private Optional<String> generateQueryRec(String alias, QueryContext context, Set<String> argumentCollector, List<FieldFilter> filters) {
        String type = this.unwrap(context.getFieldDefinition().getType());
        TypeDefinition typeDefinition = this.schema.getTypeDefinition(type).orElse(null);
        if (!filters.stream().allMatch(fi -> fi.shouldAddField(context))) {
            return Optional.empty();
        }
        String args = this.generateFieldArgs(context.getFieldDefinition(), context.getParams(), argumentCollector);
        if (Objects.isNull(typeDefinition) || typeDefinition.getChildren().isEmpty() || typeDefinition instanceof EnumTypeDefinition) {
            return Optional.of(alias + args);
        }
        HashSet visited = new HashSet();
        List children = Streams.concat((Stream[])new Stream[]{this.schema.getChildren(typeDefinition).peek(it -> visited.add(it.getName())).filter(it -> context.getVisited().add(it.getName())).map(definition -> this.generateQueryRec(definition.getName(), context.withType((FieldDefinition)definition).increment(), argumentCollector, filters)).filter(Optional::isPresent).map(Optional::get), this.schema.getTypesImplementing(typeDefinition).map(interfac -> this.generateQueryRec((String)interfac, context.withType(new FieldDefinition(interfac, (Type)new TypeName(interfac))).withVisited(visited), argumentCollector, filters)).filter(Optional::isPresent).map(Optional::get).map(query -> "... on " + query)}).collect(Collectors.toList());
        if (children.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(alias + args + " { " + String.join((CharSequence)" ", children) + " __typename }");
    }

    private String generateFieldArgs(FieldDefinition field, Set<String> params, Set<String> argsCollector) {
        List args = field.getInputValueDefinitions();
        HashSet<String> finalParams = new HashSet<String>(params);
        String collect = args.stream().filter(o -> finalParams.remove(o.getName())).peek(arg -> {
            boolean nonNull = arg.getType() instanceof NonNullType;
            String type = this.unwrap(arg.getType());
            argsCollector.add("$" + arg.getName() + ": " + type + (nonNull ? "!" : ""));
        }).map(arg -> arg.getName() + ": $" + arg.getName()).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty(collect)) {
            return "";
        }
        return "(" + collect + ")";
    }

    public class QueryBuilder {
        private final String type;
        private final List<FieldFilter> filters = new ArrayList<FieldFilter>();

        QueryBuilder(String type) {
            this.type = type;
        }

        public QueryBuilder maxDepth(int maxDepth) {
            this.filters.add(new MaxDepthFieldFilter(maxDepth));
            return this;
        }

        public QueryBuilder select(List<GraphQLField> selections) {
            this.filters.add(new SelectionFieldFilter(selections));
            return this;
        }

        public String build(String request, String field, Set<String> params) {
            this.filters.add(new AllNonNullArgsFieldFilter());
            return QueryGenerator.this.doGenerateQuery(request, field, this.type, params, this.filters);
        }
    }
}

