/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.ReactiveFetcher;
import com.jacobmountain.graphql.client.ReactiveSubscriber;
import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.modules.AbstractQueryStage;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;

public class ReactiveQueryStage
extends AbstractQueryStage {
    public ReactiveQueryStage(Schema schema, TypeMapper typeMapper, String dtoPackageName) {
        super(schema, typeMapper, dtoPackageName);
    }

    private TypeName getFetcherTypeName() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ReactiveFetcher.class), (TypeName[])new TypeName[]{this.query, this.mutation, TypeVariableName.get((String)"Error")});
    }

    private TypeName getSubscriberTypeName() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ReactiveSubscriber.class), (TypeName[])new TypeName[]{this.subscription, TypeVariableName.get((String)"Error")});
    }

    @Override
    public List<AbstractStage.MemberVariable> getMemberVariables(ClientDetails details) {
        ArrayList<AbstractStage.MemberVariable> vars = new ArrayList<AbstractStage.MemberVariable>();
        if (details.requiresFetcher()) {
            vars.add(AbstractStage.MemberVariable.builder().name("fetcher").type(this.getFetcherTypeName()).build());
        }
        if (details.requiresSubscriber()) {
            vars.add(AbstractStage.MemberVariable.builder().name("subscriber").type(this.getSubscriberTypeName()).build());
        }
        return vars;
    }

    @Override
    public List<CodeBlock> assemble(ClientDetails client, MethodDetails method) {
        String member = method.isSubscription() ? "subscriber" : "fetcher";
        return Collections.singletonList(CodeBlock.builder().add("$T thing = ", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Publisher.class), (TypeName[])new TypeName[]{this.getReturnTypeName(method)})}).add("$L.$L", new Object[]{member, this.getMethod(method)}).add(this.generateQueryCode(method.getRequestName(), client, method)).build());
    }
}

